/*
 * Decompiled with CFR 0.152.
 */
package bloop.integrations.gradle.tasks;

import bloop.config.Config;
import bloop.config.package$;
import bloop.integrations.gradle.BloopParameters;
import bloop.integrations.gradle.model.BloopConverter;
import bloop.integrations.gradle.syntax$;
import bloop.integrations.gradle.tasks.PluginUtils;
import bloop.integrations.gradle.tasks.TaskLogging;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskAction;
import scala.Function1;
import scala.MatchError;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005]a\u0001B\u0006\r\u0001UAQA\n\u0001\u0005\u0002\u001dBq!\u000b\u0001C\u0002\u0013\u0005#\u0006\u0003\u0004/\u0001\u0001\u0006Ia\u000b\u0005\b_\u0001\u0011\r\u0011\"\u00031\u0011\u0019)\u0004\u0001)A\u0005c!9a\u0007\u0001b\u0001\n\u00139\u0004B\u0002 \u0001A\u0003%\u0001\bC\u0003@\u0001\u0011\u0005\u0001\tC\u0003N\u0001\u0011\u0005\u0001\tC\u0003O\u0001\u0011%qJ\u0001\tCY>|\u0007/\u00138ti\u0006dG\u000eV1tW*\u0011QBD\u0001\u0006i\u0006\u001c8n\u001d\u0006\u0003\u001fA\taa\u001a:bI2,'BA\t\u0013\u00031Ig\u000e^3he\u0006$\u0018n\u001c8t\u0015\u0005\u0019\u0012!\u00022m_>\u00048\u0001A\n\u0005\u0001Yy2\u0005\u0005\u0002\u0018;5\t\u0001D\u0003\u0002\u001a5\u0005\u0019\u0011\r]5\u000b\u0005=Y\"\"\u0001\u000f\u0002\u0007=\u0014x-\u0003\u0002\u001f1\tYA)\u001a4bk2$H+Y:l!\t\u0001\u0013%D\u0001\r\u0013\t\u0011CBA\u0006QYV<\u0017N\\+uS2\u001c\bC\u0001\u0011%\u0013\t)CBA\u0006UCN\\Gj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001)!\t\u0001\u0003!A\u0004qe>TWm\u0019;\u0016\u0003-\u0002\"a\u0006\u0017\n\u00055B\"a\u0002)s_*,7\r^\u0001\taJ|'.Z2uA\u0005Q\u0001/\u0019:b[\u0016$XM]:\u0016\u0003E\u0002\"AM\u001a\u000e\u00039I!\u0001\u000e\b\u0003\u001f\tcwn\u001c9QCJ\fW.\u001a;feN\f1\u0002]1sC6,G/\u001a:tA\u0005I1m\u001c8wKJ$XM]\u000b\u0002qA\u0011\u0011\bP\u0007\u0002u)\u00111HD\u0001\u0006[>$W\r\\\u0005\u0003{i\u0012aB\u00117p_B\u001cuN\u001c<feR,'/\u0001\u0006d_:4XM\u001d;fe\u0002\n1A];o)\u0005\t\u0005C\u0001\"F\u001b\u0005\u0019%\"\u0001#\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001b%\u0001B+oSRD#\u0001\u0003%\u0011\u0005%[U\"\u0001&\u000b\u00055A\u0012B\u0001'K\u0005)!\u0016m]6BGRLwN\\\u0001\u000feVt'\t\\8paBcWoZ5o\u0003i9WM\\3sCR,'\t\\8pa\u000e{gNZ5hkJ\fG/[8o)\u001d\t\u0005+X<}\u0003\u001bAQ!\u0015\u0006A\u0002I\u000b1\u0002\u001d:pU\u0016\u001cGOT1nKB\u00111K\u0017\b\u0003)b\u0003\"!V\"\u000e\u0003YS!a\u0016\u000b\u0002\rq\u0012xn\u001c;?\u0013\tI6)\u0001\u0004Qe\u0016$WMZ\u0005\u00037r\u0013aa\u0015;sS:<'BA-D\u0011\u0015q&\u00021\u0001`\u0003M\u0001(o\u001c6fGR$U\r]3oI\u0016t7-[3t!\r\u0001W\r\u001b\b\u0003C\u000et!!\u00162\n\u0003\u0011K!\u0001Z\"\u0002\u000fA\f7m[1hK&\u0011am\u001a\u0002\u0005\u0019&\u001cHO\u0003\u0002e\u0007B\u0011\u0011\u000e\u001e\b\u0003UJt!a[9\u000f\u00051\u0004hBA7p\u001d\t)f.C\u0001\u0014\u0013\t\t\"#\u0003\u0002\u0010!%\u00111HD\u0005\u0003gj\naB\u00117p_B\u001cuN\u001c<feR,'/\u0003\u0002vm\na1k\\;sG\u0016\u001cV\r\u001e#fa*\u00111O\u000f\u0005\u0006q*\u0001\r!_\u0001\ng>,(oY3TKR\u0004\"!\u0013>\n\u0005mT%!C*pkJ\u001cWmU3u\u0011\u0015i(\u00021\u0001\u007f\u0003%!\u0018M]4fi\u0012K'\u000fE\u0002\u0000\u0003\u0013i!!!\u0001\u000b\t\u0005\r\u0011QA\u0001\u0003S>T!!a\u0002\u0002\t)\fg/Y\u0005\u0005\u0003\u0017\t\tA\u0001\u0003GS2,\u0007bBA\b\u0015\u0001\u0007\u0011\u0011C\u0001\n[\u0006tG-\u0019;pef\u00042AQA\n\u0013\r\t)b\u0011\u0002\b\u0005>|G.Z1o\u0001")
public class BloopInstallTask
extends DefaultTask
implements PluginUtils,
TaskLogging {
    private final Project project;
    private final BloopParameters parameters;
    private final BloopConverter converter;

    @Override
    public void debug(String msg) {
        TaskLogging.debug$(this, msg);
    }

    @Override
    public void info(String msg) {
        TaskLogging.info$(this, msg);
    }

    @Override
    public boolean canRunBloop() {
        return PluginUtils.canRunBloop$(this);
    }

    @Override
    public Project project() {
        return this.project;
    }

    private BloopParameters parameters() {
        return this.parameters;
    }

    private BloopConverter converter() {
        return this.converter;
    }

    @TaskAction
    public void run() {
        if (this.canRunBloop()) {
            this.runBloopPlugin();
        } else {
            this.info(new StringBuilder(60).append("Ignoring 'bloopInstall' on non-Scala and non-Java project '").append(this.project().getName()).append("'").toString());
        }
    }

    public void runBloopPlugin() {
        Object object;
        File targetDir = this.parameters().targetDir();
        this.info(new StringBuilder(34).append("Generating Bloop configuration to ").append(targetDir.getAbsolutePath()).toString());
        if (!targetDir.exists()) {
            this.debug(new StringBuilder(26).append("Creating target directory ").append(targetDir).toString());
            object = Files.createDirectory(targetDir.toPath(), new FileAttribute[0]);
        } else {
            object = BoxedUnit.UNIT;
        }
        SourceSet mainSourceSet = syntax$.MODULE$.ProjectExtension(this.project()).getSourceSet("main");
        Set otherSourceSets = (Set)syntax$.MODULE$.ProjectExtension(this.project()).allSourceSets().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BloopInstallTask.$anonfun$runBloopPlugin$1(x$1)));
        String mainProjectName = this.converter().getProjectName(this.project(), mainSourceSet);
        this.generateBloopConfiguration(mainProjectName, (List<BloopConverter.SourceSetDep>)Nil$.MODULE$, mainSourceSet, targetDir, true);
        .colon.colon strictDependencies = new .colon.colon((Object)new BloopConverter.SourceSetDep(mainProjectName, this.converter().getClassesDir(targetDir, this.project(), mainSourceSet)), (List)Nil$.MODULE$);
        otherSourceSets.foreach(arg_0 -> BloopInstallTask.$anonfun$runBloopPlugin$2$adapted(this, (List)strictDependencies, targetDir, arg_0));
    }

    private void generateBloopConfiguration(String projectName, List<BloopConverter.SourceSetDep> projectDependencies, SourceSet sourceSet, File targetDir, boolean mandatory) {
        File targetFile = syntax$.MODULE$.FileExtension(targetDir).$div(new StringBuilder(5).append(projectName).append(".json").toString());
        this.info(new StringBuilder(10).append("Generated ").append(targetFile.getAbsolutePath()).toString());
        boolean bl = false;
        Failure failure = null;
        Try<Config.File> try_ = this.converter().toBloopConfig(projectDependencies, this.project(), sourceSet, targetDir);
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            Throwable reason = failure.exception();
            if (mandatory) {
                throw reason;
            }
        }
        if (bl) {
            Throwable reason = failure.exception();
            this.info(new StringBuilder(20).append("Skipping ").append(this.project().getName()).append("/").append(sourceSet.getName()).append(" because: ").append(reason).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Success) {
            Success success = (Success)try_;
            Config.File bloopConfig = (Config.File)success.value();
            package$.MODULE$.write(bloopConfig, targetFile.toPath());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(try_);
        }
    }

    public static final /* synthetic */ boolean $anonfun$runBloopPlugin$1(SourceSet x$1) {
        String string = x$1.getName();
        String string2 = "main";
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ void $anonfun$runBloopPlugin$2(BloopInstallTask $this, List strictDependencies$1, File targetDir$1, SourceSet sourceSet) {
        String projectName = $this.converter().getProjectName($this.project(), sourceSet);
        $this.generateBloopConfiguration(projectName, (List<BloopConverter.SourceSetDep>)strictDependencies$1, sourceSet, targetDir$1, false);
    }

    public BloopInstallTask() {
        PluginUtils.$init$(this);
        TaskLogging.$init$(this);
        this.project = this.getProject();
        this.parameters = (BloopParameters)syntax$.MODULE$.ProjectExtension(this.project()).getExtension(ClassTag$.MODULE$.apply(BloopParameters.class));
        this.converter = new BloopConverter(this.parameters());
    }

    public static final /* synthetic */ Object $anonfun$runBloopPlugin$2$adapted(BloopInstallTask $this, List strictDependencies$1, File targetDir$1, SourceSet sourceSet) {
        BloopInstallTask.$anonfun$runBloopPlugin$2($this, strictDependencies$1, targetDir$1, sourceSet);
        return BoxedUnit.UNIT;
    }
}

