/*
 * Decompiled with CFR 0.152.
 */
package bloop.integrations.gradle.tasks;

import bloop.config.Config;
import bloop.config.package$;
import bloop.integrations.gradle.BloopParameters;
import bloop.integrations.gradle.BloopParametersExtension;
import bloop.integrations.gradle.model.BloopConverter;
import bloop.integrations.gradle.syntax$;
import bloop.integrations.gradle.tasks.PluginUtils;
import bloop.integrations.gradle.tasks.TaskLogging;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskAction;
import scala.Function1;
import scala.MatchError;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005Ea\u0001B\u0005\u000b\u0001MAQ\u0001\n\u0001\u0005\u0002\u0015Bqa\n\u0001C\u0002\u0013\u0005\u0003\u0006\u0003\u0004-\u0001\u0001\u0006I!\u000b\u0005\b[\u0001\u0011\r\u0011\"\u0003/\u0011\u0019\u0019\u0004\u0001)A\u0005_!)A\u0007\u0001C\u0001k!)!\t\u0001C\u0001k!)1\t\u0001C\u0005\t\n\u0001\"\t\\8pa&s7\u000f^1mYR\u000b7o\u001b\u0006\u0003\u00171\tQ\u0001^1tWNT!!\u0004\b\u0002\r\u001d\u0014\u0018\r\u001a7f\u0015\ty\u0001#\u0001\u0007j]R,wM]1uS>t7OC\u0001\u0012\u0003\u0015\u0011Gn\\8q\u0007\u0001\u0019B\u0001\u0001\u000b\u001eCA\u0011QcG\u0007\u0002-)\u0011q\u0003G\u0001\u0004CBL'BA\u0007\u001a\u0015\u0005Q\u0012aA8sO&\u0011AD\u0006\u0002\f\t\u00164\u0017-\u001e7u)\u0006\u001c8\u000e\u0005\u0002\u001f?5\t!\"\u0003\u0002!\u0015\tY\u0001\u000b\\;hS:,F/\u001b7t!\tq\"%\u0003\u0002$\u0015\tYA+Y:l\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\ta\u0005\u0005\u0002\u001f\u0001\u00059\u0001O]8kK\u000e$X#A\u0015\u0011\u0005UQ\u0013BA\u0016\u0017\u0005\u001d\u0001&o\u001c6fGR\f\u0001\u0002\u001d:pU\u0016\u001cG\u000fI\u0001\nKb$XM\\:j_:,\u0012a\f\t\u0003aEj\u0011\u0001D\u0005\u0003e1\u0011\u0001D\u00117p_B\u0004\u0016M]1nKR,'o]#yi\u0016t7/[8o\u0003))\u0007\u0010^3og&|g\u000eI\u0001\u0004eVtG#\u0001\u001c\u0011\u0005]RT\"\u0001\u001d\u000b\u0003e\nQa]2bY\u0006L!a\u000f\u001d\u0003\tUs\u0017\u000e\u001e\u0015\u0003\ru\u0002\"A\u0010!\u000e\u0003}R!a\u0003\f\n\u0005\u0005{$A\u0003+bg.\f5\r^5p]\u0006q!/\u001e8CY>|\u0007\u000f\u00157vO&t\u0017AG4f]\u0016\u0014\u0018\r^3CY>|\u0007oQ8oM&<WO]1uS>tG\u0003\u0003\u001cF%:\u001cX0a\u0002\t\u000b\u0019C\u0001\u0019A$\u0002\u0017A\u0014xN[3di:\u000bW.\u001a\t\u0003\u0011>s!!S'\u0011\u0005)CT\"A&\u000b\u00051\u0013\u0012A\u0002\u001fs_>$h(\u0003\u0002Oq\u00051\u0001K]3eK\u001aL!\u0001U)\u0003\rM#(/\u001b8h\u0015\tq\u0005\bC\u0003T\u0011\u0001\u0007A+A\nqe>TWm\u0019;EKB,g\u000eZ3oG&,7\u000fE\u0002V5vs!A\u0016-\u000f\u0005);\u0016\"A\u001d\n\u0005eC\u0014a\u00029bG.\fw-Z\u0005\u00037r\u0013A\u0001T5ti*\u0011\u0011\f\u000f\t\u0003=.t!a\u00185\u000f\u0005\u00014gBA1f\u001d\t\u0011GM\u0004\u0002KG&\t\u0011#\u0003\u0002\u0010!%\u0011QBD\u0005\u0003O2\tQ!\\8eK2L!!\u001b6\u0002\u001d\tcwn\u001c9D_:4XM\u001d;fe*\u0011q\rD\u0005\u0003Y6\u0014AbU8ve\u000e,7+\u001a;EKBT!!\u001b6\t\u000b=D\u0001\u0019\u00019\u0002\u0013M|WO]2f'\u0016$\bC\u0001 r\u0013\t\u0011xHA\u0005T_V\u00148-Z*fi\")A\u000f\u0003a\u0001k\u0006IA/\u0019:hKR$\u0015N\u001d\t\u0003mnl\u0011a\u001e\u0006\u0003qf\f!![8\u000b\u0003i\fAA[1wC&\u0011Ap\u001e\u0002\u0005\r&dW\rC\u0003\u007f\u0011\u0001\u0007q0A\u0005d_:4XM\u001d;feB!\u0011\u0011AA\u0002\u001b\u0005Q\u0017bAA\u0003U\nq!\t\\8pa\u000e{gN^3si\u0016\u0014\bbBA\u0005\u0011\u0001\u0007\u00111B\u0001\n[\u0006tG-\u0019;pef\u00042aNA\u0007\u0013\r\ty\u0001\u000f\u0002\b\u0005>|G.Z1o\u0001")
public class BloopInstallTask
extends DefaultTask
implements PluginUtils,
TaskLogging {
    private final Project project;
    private final BloopParametersExtension extension;

    @Override
    public void debug(String msg) {
        TaskLogging.debug$(this, msg);
    }

    @Override
    public void info(String msg) {
        TaskLogging.info$(this, msg);
    }

    @Override
    public boolean canRunBloop() {
        return PluginUtils.canRunBloop$(this);
    }

    @Override
    public Project project() {
        return this.project;
    }

    private BloopParametersExtension extension() {
        return this.extension;
    }

    @TaskAction
    public void run() {
        if (this.canRunBloop()) {
            this.runBloopPlugin();
        } else {
            this.info(new StringBuilder(60).append("Ignoring 'bloopInstall' on non-Scala and non-Java project '").append(this.project().getName()).append("'").toString());
        }
    }

    public void runBloopPlugin() {
        Object object;
        BloopParameters parameters = this.extension().createParameters();
        BloopConverter converter = new BloopConverter(parameters);
        File targetDir = parameters.targetDir();
        this.info(new StringBuilder(34).append("Generating Bloop configuration to ").append(targetDir.getAbsolutePath()).toString());
        if (!targetDir.exists()) {
            this.debug(new StringBuilder(26).append("Creating target directory ").append(targetDir).toString());
            object = Files.createDirectory(targetDir.toPath(), new FileAttribute[0]);
        } else {
            object = BoxedUnit.UNIT;
        }
        SourceSet mainSourceSet = syntax$.MODULE$.ProjectExtension(this.project()).getSourceSet("main");
        Set otherSourceSets = (Set)syntax$.MODULE$.ProjectExtension(this.project()).allSourceSets().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BloopInstallTask.$anonfun$runBloopPlugin$1(x$1)));
        String mainProjectName = converter.getProjectName(this.project(), mainSourceSet);
        this.generateBloopConfiguration(mainProjectName, (List<BloopConverter.SourceSetDep>)Nil$.MODULE$, mainSourceSet, targetDir, converter, true);
        .colon.colon strictDependencies = new .colon.colon((Object)new BloopConverter.SourceSetDep(mainProjectName, converter.getClassesDir(targetDir, this.project(), mainSourceSet)), (List)Nil$.MODULE$);
        otherSourceSets.foreach(arg_0 -> BloopInstallTask.$anonfun$runBloopPlugin$2$adapted(this, converter, (List)strictDependencies, targetDir, arg_0));
    }

    private void generateBloopConfiguration(String projectName, List<BloopConverter.SourceSetDep> projectDependencies, SourceSet sourceSet, File targetDir, BloopConverter converter, boolean mandatory) {
        File targetFile = syntax$.MODULE$.FileExtension(targetDir).$div(new StringBuilder(5).append(projectName).append(".json").toString());
        this.info(new StringBuilder(10).append("Generated ").append(targetFile.getAbsolutePath()).toString());
        boolean bl = false;
        Failure failure = null;
        Try<Config.File> try_ = converter.toBloopConfig(projectDependencies, this.project(), sourceSet, targetDir);
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            Throwable reason = failure.exception();
            if (mandatory) {
                throw reason;
            }
        }
        if (bl) {
            Throwable reason = failure.exception();
            this.info(new StringBuilder(20).append("Skipping ").append(this.project().getName()).append("/").append(sourceSet.getName()).append(" because: ").append(reason).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Success) {
            Success success = (Success)try_;
            Config.File bloopConfig = (Config.File)success.value();
            package$.MODULE$.write(bloopConfig, targetFile.toPath());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(try_);
        }
    }

    public static final /* synthetic */ boolean $anonfun$runBloopPlugin$1(SourceSet x$1) {
        String string = x$1.getName();
        String string2 = "main";
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ void $anonfun$runBloopPlugin$2(BloopInstallTask $this, BloopConverter converter$1, List strictDependencies$1, File targetDir$1, SourceSet sourceSet) {
        String projectName = converter$1.getProjectName($this.project(), sourceSet);
        $this.generateBloopConfiguration(projectName, (List<BloopConverter.SourceSetDep>)strictDependencies$1, sourceSet, targetDir$1, converter$1, false);
    }

    public BloopInstallTask() {
        PluginUtils.$init$(this);
        TaskLogging.$init$(this);
        this.project = this.getProject();
        this.extension = (BloopParametersExtension)syntax$.MODULE$.ProjectExtension(this.project()).getExtension(ClassTag$.MODULE$.apply(BloopParametersExtension.class));
    }

    public static final /* synthetic */ Object $anonfun$runBloopPlugin$2$adapted(BloopInstallTask $this, BloopConverter converter$1, List strictDependencies$1, File targetDir$1, SourceSet sourceSet) {
        BloopInstallTask.$anonfun$runBloopPlugin$2($this, converter$1, strictDependencies$1, targetDir$1, sourceSet);
        return BoxedUnit.UNIT;
    }
}

