/*
 * Decompiled with CFR 0.152.
 */
package bloop.integrations.gradle.tasks;

import bloop.config.Config;
import bloop.config.package$;
import bloop.integrations.gradle.BloopParameters;
import bloop.integrations.gradle.model.BloopConverter;
import bloop.integrations.gradle.syntax$;
import bloop.integrations.gradle.tasks.PluginUtils;
import bloop.integrations.gradle.tasks.TaskLogging;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskAction;
import scala.Function1;
import scala.MatchError;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005]a\u0001B\u0001\u0003\u0001-\u0011\u0001C\u00117p_BLen\u001d;bY2$\u0016m]6\u000b\u0005\r!\u0011!\u0002;bg.\u001c(BA\u0003\u0007\u0003\u00199'/\u00193mK*\u0011q\u0001C\u0001\rS:$Xm\u001a:bi&|gn\u001d\u0006\u0002\u0013\u0005)!\r\\8pa\u000e\u00011\u0003\u0002\u0001\r+e\u0001\"!D\n\u000e\u00039Q!a\u0004\t\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u0006#)\t!#A\u0002pe\u001eL!\u0001\u0006\b\u0003\u0017\u0011+g-Y;miR\u000b7o\u001b\t\u0003-]i\u0011AA\u0005\u00031\t\u00111\u0002\u00157vO&tW\u000b^5mgB\u0011aCG\u0005\u00037\t\u00111\u0002V1tW2{wmZ5oO\")Q\u0004\u0001C\u0001=\u00051A(\u001b8jiz\"\u0012a\b\t\u0003-\u0001Aq!\t\u0001C\u0002\u0013\u0005#%A\u0004qe>TWm\u0019;\u0016\u0003\r\u0002\"!\u0004\u0013\n\u0005\u0015r!a\u0002)s_*,7\r\u001e\u0005\u0007O\u0001\u0001\u000b\u0011B\u0012\u0002\u0011A\u0014xN[3di\u0002Bq!\u000b\u0001C\u0002\u0013%!&\u0001\u0006qCJ\fW.\u001a;feN,\u0012a\u000b\t\u0003Y5j\u0011\u0001B\u0005\u0003]\u0011\u0011qB\u00117p_B\u0004\u0016M]1nKR,'o\u001d\u0005\u0007a\u0001\u0001\u000b\u0011B\u0016\u0002\u0017A\f'/Y7fi\u0016\u00148\u000f\t\u0005\be\u0001\u0011\r\u0011\"\u00034\u0003%\u0019wN\u001c<feR,'/F\u00015!\t)\u0004(D\u00017\u0015\t9D!A\u0003n_\u0012,G.\u0003\u0002:m\tq!\t\\8pa\u000e{gN^3si\u0016\u0014\bBB\u001e\u0001A\u0003%A'\u0001\u0006d_:4XM\u001d;fe\u0002BQ!\u0010\u0001\u0005\u0002y\n1A];o)\u0005y\u0004C\u0001!D\u001b\u0005\t%\"\u0001\"\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\u000b%\u0001B+oSRD#\u0001\u0010$\u0011\u0005\u001dKU\"\u0001%\u000b\u0005\rq\u0011B\u0001&I\u0005)!\u0016m]6BGRLwN\u001c\u0005\u0006\u0019\u0002!\tAP\u0001\u000feVt'\t\\8paBcWoZ5o\u0011\u0015q\u0005\u0001\"\u0003P\u0003i9WM\\3sCR,'\t\\8pa\u000e{gNZ5hkJ\fG/[8o)\u001dy\u0004+X<}\u0003\u001bAQ!U'A\u0002I\u000b1\u0002\u001d:pU\u0016\u001cGOT1nKB\u00111K\u0017\b\u0003)b\u0003\"!V!\u000e\u0003YS!a\u0016\u0006\u0002\rq\u0012xn\u001c;?\u0013\tI\u0016)\u0001\u0004Qe\u0016$WMZ\u0005\u00037r\u0013aa\u0015;sS:<'BA-B\u0011\u0015qV\n1\u0001`\u0003M\u0001(o\u001c6fGR$U\r]3oI\u0016t7-[3t!\r\u0001W\r\u001b\b\u0003C\u000et!!\u00162\n\u0003\tK!\u0001Z!\u0002\u000fA\f7m[1hK&\u0011am\u001a\u0002\u0005\u0019&\u001cHO\u0003\u0002e\u0003B\u0011\u0011\u000e\u001e\b\u0003UJt!a[9\u000f\u00051\u0004hBA7p\u001d\t)f.C\u0001\n\u0013\t9\u0001\"\u0003\u0002\u0006\r%\u0011q\u0007B\u0005\u0003gZ\naB\u00117p_B\u001cuN\u001c<feR,'/\u0003\u0002vm\na1k\\;sG\u0016\u001cV\r\u001e#fa*\u00111O\u000e\u0005\u0006q6\u0003\r!_\u0001\ng>,(oY3TKR\u0004\"a\u0012>\n\u0005mD%!C*pkJ\u001cWmU3u\u0011\u0015iX\n1\u0001\u007f\u0003%!\u0018M]4fi\u0012K'\u000fE\u0002\u0000\u0003\u0013i!!!\u0001\u000b\t\u0005\r\u0011QA\u0001\u0003S>T!!a\u0002\u0002\t)\fg/Y\u0005\u0005\u0003\u0017\t\tA\u0001\u0003GS2,\u0007bBA\b\u001b\u0002\u0007\u0011\u0011C\u0001\n[\u0006tG-\u0019;pef\u00042\u0001QA\n\u0013\r\t)\"\u0011\u0002\b\u0005>|G.Z1o\u0001")
public class BloopInstallTask
extends DefaultTask
implements PluginUtils,
TaskLogging {
    private final Project project;
    private final BloopParameters parameters;
    private final BloopConverter converter;

    @Override
    public void debug(String msg) {
        TaskLogging.debug$(this, msg);
    }

    @Override
    public void info(String msg) {
        TaskLogging.info$(this, msg);
    }

    @Override
    public boolean canRunBloop() {
        return PluginUtils.canRunBloop$(this);
    }

    @Override
    public Project project() {
        return this.project;
    }

    private BloopParameters parameters() {
        return this.parameters;
    }

    private BloopConverter converter() {
        return this.converter;
    }

    @TaskAction
    public void run() {
        if (this.canRunBloop()) {
            this.runBloopPlugin();
        } else {
            this.info(new StringBuilder(60).append("Ignoring 'bloopInstall' on non-Scala and non-Java project '").append(this.project().getName()).append("'").toString());
        }
    }

    public void runBloopPlugin() {
        Object object;
        File targetDir = this.parameters().targetDir();
        this.info(new StringBuilder(34).append("Generating Bloop configuration to ").append(targetDir.getAbsolutePath()).toString());
        if (!targetDir.exists()) {
            this.debug(new StringBuilder(26).append("Creating target directory ").append(targetDir).toString());
            object = Files.createDirectory(targetDir.toPath(), new FileAttribute[0]);
        } else {
            object = BoxedUnit.UNIT;
        }
        SourceSet mainSourceSet = syntax$.MODULE$.ProjectExtension(this.project()).getSourceSet(this.parameters().mainSourceSet());
        Set otherSourceSets = (Set)syntax$.MODULE$.ProjectExtension(this.project()).allSourceSets().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BloopInstallTask.$anonfun$runBloopPlugin$1(this, x$1)));
        String mainProjectName = this.converter().getProjectName(this.project(), mainSourceSet);
        this.generateBloopConfiguration(mainProjectName, (List<BloopConverter.SourceSetDep>)Nil$.MODULE$, mainSourceSet, targetDir, true);
        otherSourceSets.foreach((Function1 & Serializable & scala.Serializable)sourceSet -> {
            BloopInstallTask.$anonfun$runBloopPlugin$2(this, targetDir, mainSourceSet, mainProjectName, sourceSet);
            return BoxedUnit.UNIT;
        });
    }

    private void generateBloopConfiguration(String projectName, List<BloopConverter.SourceSetDep> projectDependencies, SourceSet sourceSet, File targetDir, boolean mandatory) {
        File targetFile = syntax$.MODULE$.FileExtension(targetDir).$div(new StringBuilder(5).append(projectName).append(".json").toString());
        this.info(new StringBuilder(10).append("Generated ").append(targetFile.getAbsolutePath()).toString());
        boolean bl = false;
        Failure failure = null;
        Try<Config.File> try_ = this.converter().toBloopConfig(projectDependencies, this.project(), sourceSet, targetDir);
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            Throwable reason = failure.exception();
            if (mandatory) {
                throw reason;
            }
        }
        if (bl) {
            Throwable reason = failure.exception();
            this.info(new StringBuilder(20).append("Skipping ").append(this.project().getName()).append("/").append(sourceSet.getName()).append(" because: ").append(reason).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Success) {
            Success success = (Success)try_;
            Config.File bloopConfig = (Config.File)success.value();
            package$.MODULE$.write(bloopConfig, targetFile.toPath());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(try_);
        }
    }

    public static final /* synthetic */ boolean $anonfun$runBloopPlugin$1(BloopInstallTask $this, SourceSet x$1) {
        String string = x$1.getName();
        String string2 = $this.parameters().mainSourceSet();
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ void $anonfun$runBloopPlugin$2(BloopInstallTask $this, File targetDir$1, SourceSet mainSourceSet$1, String mainProjectName$1, SourceSet sourceSet) {
        String projectName = $this.converter().getProjectName($this.project(), sourceSet);
        $this.generateBloopConfiguration(projectName, (List<BloopConverter.SourceSetDep>)new .colon.colon((Object)new BloopConverter.SourceSetDep(mainProjectName$1, $this.converter().getClassesDir($this.project(), mainSourceSet$1)), (List)Nil$.MODULE$), sourceSet, targetDir$1, false);
    }

    public BloopInstallTask() {
        PluginUtils.$init$(this);
        TaskLogging.$init$(this);
        this.project = this.getProject();
        this.parameters = (BloopParameters)syntax$.MODULE$.ProjectExtension(this.project()).getExtension(ClassTag$.MODULE$.apply(BloopParameters.class));
        this.converter = new BloopConverter(this.parameters());
    }
}

