/*
 * Decompiled with CFR 0.152.
 */
package libdaemonjvm;

import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import libdaemonjvm.LockFiles;
import libdaemonjvm.SocketPaths;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.math.Ordering;
import scala.util.Properties$;

public final class LockFiles$
implements scala.Serializable {
    public static LockFiles$ MODULE$;
    private final Set<PosixFilePermission> forbiddenPermissions;

    static {
        new LockFiles$();
    }

    private Set<PosixFilePermission> forbiddenPermissions() {
        return this.forbiddenPermissions;
    }

    public LockFiles under(Path dir) {
        return this.under(dir, true);
    }

    public LockFiles under(Path dir, boolean addPipePrefix) {
        return this.under(dir, addPipePrefix, true);
    }

    public LockFiles under(Path dir, boolean addPipePrefix, boolean checkPermissions) {
        Set perms;
        Set invalid;
        if (checkPermissions && !Properties$.MODULE$.isWin() && (invalid = (Set)(perms = ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(Files.getPosixFilePermissions(dir, new LinkOption[0])).asScala()).toSet()).intersect(this.forbiddenPermissions())).nonEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(25).append(dir).append(" has invalid permissions ").append(((TraversableOnce)((TraversableOnce)invalid.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.name(), Set$.MODULE$.canBuildFrom())).toVector().sorted((Ordering)Ordering.String$.MODULE$)).mkString(", ")).toString());
        }
        return new LockFiles(dir.resolve("lock"), dir.resolve("pid"), new SocketPaths(dir.resolve("socket")));
    }

    public LockFiles apply(Path lockFile, Path pidFile, SocketPaths socketPaths) {
        return new LockFiles(lockFile, pidFile, socketPaths);
    }

    public Option<Tuple3<Path, Path, SocketPaths>> unapply(LockFiles x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)x$0.lockFile(), (Object)x$0.pidFile(), (Object)x$0.socketPaths()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private LockFiles$() {
        MODULE$ = this;
        this.forbiddenPermissions = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PosixFilePermission[]{PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_WRITE, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_READ, PosixFilePermission.OTHERS_WRITE, PosixFilePermission.OTHERS_EXECUTE}));
    }
}

