/*
 * Decompiled with CFR 0.152.
 */
package libdaemonjvm.server;

import java.io.Serializable;
import java.nio.channels.ServerSocketChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import libdaemonjvm.LockFiles;
import libdaemonjvm.internal.LockProcess;
import libdaemonjvm.internal.LockProcess$;
import libdaemonjvm.internal.SocketFile$;
import libdaemonjvm.internal.SocketHandler$;
import libdaemonjvm.server.LockError;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.StringOps$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichChar$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class Lock$
implements Serializable {
    public static final Lock$ MODULE$ = new Lock$();

    private Lock$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Lock$.class);
    }

    public <T> Either<LockError, T> tryAcquire(LockFiles files, Function1<ServerSocketChannel, T> startListening) {
        return this.tryAcquire(files, LockProcess$.MODULE$.default(), () -> this.tryAcquire$$anonfun$1(files, startListening));
    }

    public <T> Either<LockError, T> tryAcquire(LockFiles files, LockProcess proc, Function0<T> setup) {
        return this.pidSocketFilesFound$1(files) ? this.ifFiles$1(files, proc, setup, false) : files.withLock(() -> this.tryAcquire$$anonfun$2(files, proc, setup));
    }

    private final Object tryAcquire$$anonfun$1(LockFiles files$1, Function1 startListening$1) {
        ServerSocketChannel socket = SocketHandler$.MODULE$.server(files$1.socketPaths());
        return startListening$1.apply((Object)socket);
    }

    private final Either unsafeWritePidAndSetup$1(LockFiles files$2, LockProcess proc$1, Function0 setup$1) {
        int pid = proc$1.pid();
        Files.write(files$2.pidFile(), BoxesRunTime.boxToInteger((int)pid).toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        return package$.MODULE$.Right().apply(setup$1.apply());
    }

    private final Either delete$1(Path file) {
        Object object;
        if (Files.exists(file, new LinkOption[0])) {
            Files.delete(file);
            object = Files.exists(file, new LinkOption[0]) ? package$.MODULE$.Left().apply((Object)new LockError.CannotDeleteFile(file, null)) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        } else {
            object = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        }
        return object;
    }

    private final Either unsafeCleanUpAndSetup$4(LockFiles files$3, LockProcess proc$2, Function0 setup$2) {
        return this.delete$1(files$3.socketPaths().path()).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = x$12;
            return this.delete$1(files$3.pidFile()).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = x$1;
                return this.unsafeWritePidAndSetup$1(files$3, proc$2, setup$2).map((Function1 & Serializable)t -> t);
            });
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Either ifProcessRunning$1(LockFiles files$5, int pid) {
        LockError lockError;
        Either<Throwable, BoxedUnit> either = SocketFile$.MODULE$.canConnect(files$5.socketPaths());
        if (either instanceof Left) {
            Throwable e = (Throwable)((Left)either).value();
            lockError = new LockError.ZombieFound(pid, e);
        } else {
            if (!(either instanceof Right)) throw new MatchError(either);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            Object object = ((Right)either).value();
            if (boxedUnit != null ? !boxedUnit.equals(object) : object != null) throw new MatchError(either);
            lockError = new LockError.AlreadyRunning(pid);
        }
        LockError.ZombieFound err = lockError;
        return package$.MODULE$.Left().apply((Object)err);
    }

    private final /* synthetic */ boolean $anonfun$1(char _$1) {
        return RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(_$1));
    }

    private final /* synthetic */ Option $anonfun$2(LockFiles files$7, LockProcess proc$5, int pid) {
        return proc$5.isRunning(pid) ? Some$.MODULE$.apply((Object)this.ifProcessRunning$1(files$7, pid)) : None$.MODULE$;
    }

    private final Either ifFiles$2$$anonfun$1$$anonfun$1(LockFiles files$12, LockProcess proc$9, Function0 setup$7) {
        return this.unsafeCleanUpAndSetup$4(files$12, proc$9, setup$7);
    }

    private final Either ifFiles$3$$anonfun$2(LockFiles files$8, LockProcess proc$6, Function0 setup$5, boolean hasLock$1) {
        return hasLock$1 ? this.unsafeCleanUpAndSetup$4(files$8, proc$6, setup$5) : files$8.withLock(() -> this.ifFiles$2$$anonfun$1$$anonfun$1(files$8, proc$6, setup$5));
    }

    private final Either ifFiles$1(LockFiles files$6, LockProcess proc$4, Function0 setup$4, boolean hasLock) {
        byte[] b = Files.readAllBytes(files$6.pidFile());
        String s = new String(b, StandardCharsets.UTF_8).trim();
        None$ pidOpt = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(s)) && StringOps$.MODULE$.forall$extension(Predef$.MODULE$.augmentString(s), (Function1 & Serializable)_$1 -> this.$anonfun$1(BoxesRunTime.unboxToChar((Object)_$1))) ? Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(s)))) : None$.MODULE$;
        Option maybeRes = pidOpt.flatMap((Function1 & Serializable)pid -> this.$anonfun$2(files$6, proc$4, BoxesRunTime.unboxToInt((Object)pid)));
        return (Either)maybeRes.getOrElse(() -> this.ifFiles$3$$anonfun$2(files$6, proc$4, setup$4, hasLock));
    }

    private final boolean pidSocketFilesFound$1(LockFiles files$9) {
        return Files.exists(files$9.pidFile(), new LinkOption[0]) && (SocketHandler$.MODULE$.usesWindowsPipe() || Files.exists(files$9.socketPaths().path(), new LinkOption[0]));
    }

    private final Either tryAcquire$$anonfun$2(LockFiles files$13, LockProcess proc$10, Function0 setup$8) {
        return this.pidSocketFilesFound$1(files$13) ? this.ifFiles$1(files$13, proc$10, setup$8, true) : this.unsafeCleanUpAndSetup$4(files$13, proc$10, setup$8);
    }
}

