/*
 * Decompiled with CFR 0.152.
 */
package libdaemonjvm.server;

import java.nio.file.Path;
import libdaemonjvm.server.LockError$;
import libdaemonjvm.server.LockError$FatalError$;
import libdaemonjvm.server.LockError$Locked$;
import libdaemonjvm.server.LockError$RecoverableError$;

public abstract class LockError
extends Exception {
    public static Throwable $lessinit$greater$default$2() {
        return LockError$.MODULE$.$lessinit$greater$default$2();
    }

    public LockError(String message, Throwable cause) {
        super(message, cause);
    }

    public static final class AlreadyRunning
    extends FatalError {
        private final int pid;

        public AlreadyRunning(int pid) {
            this.pid = pid;
            super(new StringBuilder(30).append("Daemon already running (PID: ").append(pid).append(")").toString(), LockError$FatalError$.MODULE$.$lessinit$greater$default$2());
        }

        public int pid() {
            return this.pid;
        }
    }

    public static final class CannotDeleteFile
    extends FatalError {
        private final Path file;

        public CannotDeleteFile(Path file, Throwable cause) {
            this.file = file;
            super(new StringBuilder(14).append("Cannot delete ").append(file).toString(), cause);
        }

        public Path file() {
            return this.file;
        }
    }

    public static abstract class FatalError
    extends LockError {
        public static Throwable $lessinit$greater$default$2() {
            return LockError$FatalError$.MODULE$.$lessinit$greater$default$2();
        }

        public FatalError(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static final class Locked
    extends RecoverableError {
        private final Path file;

        public static Throwable $lessinit$greater$default$2() {
            return LockError$Locked$.MODULE$.$lessinit$greater$default$2();
        }

        public Locked(Path file, Throwable cause) {
            this.file = file;
            super(new StringBuilder(15).append(file).append(" already locked").toString(), cause);
        }

        public Path file() {
            return this.file;
        }
    }

    public static abstract class RecoverableError
    extends LockError {
        public static Throwable $lessinit$greater$default$2() {
            return LockError$RecoverableError$.MODULE$.$lessinit$greater$default$2();
        }

        public RecoverableError(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static final class ZombieFound
    extends RecoverableError {
        private final int pid;
        private final Throwable connectionError;

        public ZombieFound(int pid, Throwable connectionError) {
            this.pid = pid;
            this.connectionError = connectionError;
            super(new StringBuilder(26).append("Cannot connect to process ").append(pid).toString(), connectionError);
        }

        public int pid() {
            return this.pid;
        }

        public Throwable connectionError() {
            return this.connectionError;
        }
    }
}

