/*
 * Decompiled with CFR 0.152.
 */
package scala_maven;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.Toolchain;
import scala_maven.FileUtils;
import scala_maven.ScalaContinuousCompileMojo;

public class ExtendedScalaContinuousCompileMojo
extends ScalaContinuousCompileMojo {
    public MavenProject getProject() {
        return this.project;
    }

    public String getScalaVersion() throws Exception {
        return super.findScalaVersion().toString();
    }

    public List<String> getScalacArgs() throws Exception {
        return super.getScalaOptions();
    }

    public List<String> getJavacArgs() throws Exception {
        return super.getJavacOptions();
    }

    public List<File> getCompileSourceDirectories() throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>(this.project.getCompileSourceRoots());
        arrayList.add(FileUtils.pathOf((File)this.mainSourceDir, (boolean)this.useCanonicalPath));
        return this.normalize(arrayList);
    }

    public List<File> getTestSourceDirectories() throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>(this.project.getTestCompileSourceRoots());
        arrayList.add(FileUtils.pathOf((File)this.testSourceDir, (boolean)this.useCanonicalPath));
        return this.normalize(arrayList);
    }

    public File getCompileOutputDir() throws Exception {
        this.mainOutputDir = FileUtils.fileOf((File)this.mainOutputDir, (boolean)this.useCanonicalPath);
        if (!this.mainOutputDir.exists()) {
            this.mainOutputDir.mkdirs();
        }
        return this.mainOutputDir;
    }

    public File getTestOutputDir() throws Exception {
        this.testOutputDir = FileUtils.fileOf((File)this.testOutputDir, (boolean)this.useCanonicalPath);
        if (!this.testOutputDir.exists()) {
            this.testOutputDir.mkdirs();
        }
        return this.testOutputDir;
    }

    public Boolean getFork() {
        return this.fork;
    }

    public File getCompileAnalysisCacheFile() throws Exception {
        return FileUtils.fileOf((File)this.analysisCacheFile, (boolean)this.useCanonicalPath);
    }

    public File getTestAnalysisCacheFile() throws Exception {
        return FileUtils.fileOf((File)this.testAnalysisCacheFile, (boolean)this.useCanonicalPath);
    }

    public File getJavaHome() throws Exception {
        Object object = null;
        Toolchain toolchain = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session);
        if (toolchain != null) {
            object = toolchain.findTool("java");
        }
        if (toolchain == null || object == null) {
            object = System.getProperty("java.home");
            if (object == null && (object = System.getenv("JAVA_HOME")) == null) {
                throw new IllegalStateException("Couldn't locate java, try setting JAVA_HOME environment variable.");
            }
            object = (String)object + File.separator + "bin" + File.separator + "java";
        }
        return new File((String)object);
    }
}

