/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.nailgun;

import com.martiansoftware.nailgun.CommandContext;
import com.martiansoftware.nailgun.NGClientDisconnectReason;
import com.martiansoftware.nailgun.NGClientListener;
import com.martiansoftware.nailgun.NGHeartbeatListener;
import com.martiansoftware.nailgun.NGOutputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NGCommunicator
implements Closeable {
    private static final Logger LOG = Logger.getLogger(NGCommunicator.class.getName());
    private final ExecutorService orchestratorExecutor;
    private final ExecutorService readExecutor;
    private final Socket socket;
    private final DataInputStream in;
    private final DataOutputStream out;
    private final Object readLock = new Object();
    private final Object writeLock = new Object();
    private final Object orchestratorEvent = new Object();
    private boolean shutdown = false;
    private InputStream stdin = null;
    private boolean eof = false;
    private boolean closed = false;
    private boolean inClosed = false;
    private boolean outClosed = false;
    private boolean isExited = false;
    private int remaining = 0;
    private AtomicBoolean clientConnected = new AtomicBoolean(true);
    private final Set<NGClientListener> clientListeners = new HashSet<NGClientListener>();
    private final Set<NGHeartbeatListener> heartbeatListeners = new HashSet<NGHeartbeatListener>();
    private static final long TERMINATION_TIMEOUT_MS = 1000L;
    private final int heartbeatTimeoutMillis;

    NGCommunicator(Socket socket, int n) throws IOException {
        this.heartbeatTimeoutMillis = n;
        this.socket = socket;
        this.in = new DataInputStream(socket.getInputStream());
        this.out = new DataOutputStream(socket.getOutputStream());
        Thread thread = Thread.currentThread();
        final class NamedThreadFactory
        implements ThreadFactory {
            private final String threadName;

            public NamedThreadFactory(String string) {
                this.threadName = string;
            }

            @Override
            public Thread newThread(Runnable runnable) {
                SecurityManager securityManager = System.getSecurityManager();
                ThreadGroup threadGroup = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
                Thread thread = new Thread(threadGroup, runnable, this.threadName, 0L);
                if (thread.isDaemon()) {
                    thread.setDaemon(false);
                }
                if (thread.getPriority() != 10) {
                    thread.setPriority(10);
                }
                return thread;
            }
        }
        this.orchestratorExecutor = Executors.newSingleThreadExecutor(new NamedThreadFactory(thread.getName() + " (NGCommunicator orchestrator)"));
        this.readExecutor = Executors.newSingleThreadExecutor(new NamedThreadFactory(thread.getName() + " (NGCommunicator reader)"));
    }

    CommandContext readCommandContext() throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Properties properties = new Properties();
        String string = null;
        String string2 = null;
        while (string2 == null) {
            int n = this.in.readInt();
            byte by = this.in.readByte();
            byte[] byArray = new byte[n];
            this.in.readFully(byArray);
            String string3 = new String(byArray, "UTF-8");
            switch (by) {
                case 65: {
                    arrayList.add(string3);
                    break;
                }
                case 69: {
                    int n2 = string3.indexOf(61);
                    if (n2 <= 0) break;
                    properties.setProperty(string3.substring(0, n2), string3.substring(n2 + 1));
                    break;
                }
                case 67: {
                    string2 = string3;
                    break;
                }
                case 68: {
                    string = string3;
                    break;
                }
            }
        }
        this.startBackgroundReceive();
        return new CommandContext(string2, string, properties, arrayList);
    }

    private void startBackgroundReceive() {
        long l = this.heartbeatTimeoutMillis + this.heartbeatTimeoutMillis / 10;
        this.orchestratorExecutor.submit(() -> {
            NGClientDisconnectReason nGClientDisconnectReason = NGClientDisconnectReason.INTERNAL_ERROR;
            try {
                LOG.log(Level.FINE, "Orchestrator thread started");
                while (true) {
                    Future<Byte> future;
                    Object object = this.orchestratorEvent;
                    synchronized (object) {
                        if (this.shutdown) {
                            break;
                        }
                        future = this.readExecutor.submit(() -> {
                            try {
                                return this.readChunk();
                            }
                            catch (IOException iOException) {
                                throw new ExecutionException(iOException);
                            }
                        });
                    }
                    byte by = future.get(l, TimeUnit.MILLISECONDS);
                    if (by != 72) continue;
                    this.notifyHeartbeat();
                }
            }
            catch (InterruptedException interruptedException) {
                LOG.log(Level.WARNING, "NGCommunicator orchestrator was interrupted", interruptedException);
            }
            catch (ExecutionException executionException) {
                Throwable throwable = NGCommunicator.getCause(executionException);
                if (throwable instanceof EOFException) {
                    LOG.log(Level.FINE, "Socket is disconnected");
                    nGClientDisconnectReason = NGClientDisconnectReason.SOCKET_ERROR;
                } else if (throwable instanceof SocketTimeoutException) {
                    nGClientDisconnectReason = NGClientDisconnectReason.SOCKET_TIMEOUT;
                    LOG.log(Level.WARNING, "Nailgun client socket timed out after " + this.heartbeatTimeoutMillis + " ms", throwable);
                } else {
                    LOG.log(Level.WARNING, "Nailgun client read future raised an exception", throwable);
                }
            }
            catch (TimeoutException timeoutException) {
                nGClientDisconnectReason = NGClientDisconnectReason.HEARTBEAT;
                LOG.log(Level.WARNING, "Nailgun client read future timed out after " + l + " ms", timeoutException);
            }
            catch (Throwable throwable) {
                LOG.log(Level.WARNING, "Nailgun orchestrator gets an exception ", throwable);
            }
            LOG.log(Level.FINE, "Nailgun client disconnected");
            this.clientConnected.set(false);
            this.setEof();
            this.waitTerminationAndNotifyClients(nGClientDisconnectReason);
            LOG.log(Level.FINE, "Orchestrator thread finished");
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitTerminationAndNotifyClients(NGClientDisconnectReason nGClientDisconnectReason) {
        while (true) {
            ArrayList<NGClientListener> arrayList = new ArrayList<NGClientListener>();
            Object object = this.orchestratorEvent;
            synchronized (object) {
                if (this.shutdown) {
                    nGClientDisconnectReason = NGClientDisconnectReason.SESSION_SHUTDOWN;
                }
                if (!this.clientListeners.isEmpty()) {
                    arrayList.addAll(this.clientListeners);
                    this.clientListeners.clear();
                }
            }
            for (NGClientListener nGClientListener : arrayList) {
                nGClientListener.clientDisconnected(nGClientDisconnectReason);
            }
            object = this.orchestratorEvent;
            synchronized (object) {
                if (!this.clientListeners.isEmpty()) {
                    continue;
                }
                if (this.shutdown) {
                    return;
                }
                try {
                    this.orchestratorEvent.wait();
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        }
    }

    private static Throwable getCause(Throwable throwable) {
        Throwable throwable2 = throwable.getCause();
        if (throwable2 == null) {
            return throwable;
        }
        if (throwable2 instanceof ExecutionException) {
            return NGCommunicator.getCause(throwable2);
        }
        return throwable2;
    }

    void exit(int n) {
        if (this.isExited) {
            return;
        }
        try {
            this.stopIn();
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, "Unable to close socket for reading while sending final exit code", iOException);
        }
        try (PrintStream printStream = new PrintStream(new NGOutputStream(this, 88));){
            printStream.println(n);
        }
        this.isExited = true;
        try {
            this.stopOut();
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, "Unable to close socket for writing while sending final exit code", iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopIn() throws IOException {
        if (this.inClosed) {
            return;
        }
        this.inClosed = true;
        LOG.log(Level.FINE, "Shutting down socket for input");
        this.setEof();
        Object object = this.orchestratorEvent;
        synchronized (object) {
            this.shutdown = true;
            this.orchestratorEvent.notifyAll();
        }
        this.socket.shutdownInput();
    }

    private void stopOut() throws IOException {
        if (this.outClosed) {
            return;
        }
        this.outClosed = true;
        LOG.log(Level.FINE, "Shutting down socket for output");
        this.socket.shutdownOutput();
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.stopIn();
        this.stopOut();
        this.in.close();
        this.out.close();
        NGCommunicator.terminateExecutor(this.readExecutor, "read");
        NGCommunicator.terminateExecutor(this.orchestratorExecutor, "orchestrator");
        this.socket.close();
    }

    private static void terminateExecutor(ExecutorService executorService, String string) {
        boolean bl;
        LOG.log(Level.FINE, "Shutting down {0} ExecutorService", string);
        executorService.shutdown();
        try {
            bl = executorService.awaitTermination(1000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            LOG.log(Level.WARNING, "Interruption is signaled in close(), terminating a thread forcefully");
            executorService.shutdownNow();
            return;
        }
        if (!bl) {
            LOG.log(Level.WARNING, "{0} thread did not unblock on a signal within timeout and will be forcefully terminated", string);
            executorService.shutdownNow();
        }
    }

    private InputStream readPayload(InputStream inputStream, int n) throws IOException {
        int n2;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; i += n2) {
            n2 = inputStream.read(byArray, i, n - i);
            if (n2 >= 0) continue;
            throw new EOFException("stdin EOF before payload read.");
        }
        return new ByteArrayInputStream(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte readChunk() throws IOException {
        try {
            return this.readChunkImpl();
        }
        catch (SocketException socketException) {
            Object object = this.orchestratorEvent;
            synchronized (object) {
                if (this.shutdown) {
                    EOFException eOFException = new EOFException("NGCommunicator is shutting down");
                    eOFException.initCause(socketException);
                    throw eOFException;
                }
            }
            throw socketException;
        }
    }

    private byte readChunkImpl() throws IOException {
        int n = this.in.readInt();
        byte by = this.in.readByte();
        switch (by) {
            case 48: {
                LOG.log(Level.FINEST, "Got stdin chunk, len {0}", n);
                InputStream inputStream = this.readPayload(this.in, n);
                this.setInput(inputStream, n);
                break;
            }
            case 46: {
                LOG.log(Level.FINEST, "Got stdin closed chunk");
                this.setEof();
                break;
            }
            case 72: {
                LOG.log(Level.FINEST, "Got client heartbeat");
                break;
            }
            default: {
                LOG.log(Level.WARNING, "Unknown chunk type: {0}", Character.valueOf((char)by));
                throw new IOException("Unknown stream type: " + (char)by);
            }
        }
        return by;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInput(InputStream inputStream, int n) throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            if (this.remaining != 0) {
                throw new IOException("Data received before stdin stream was emptied");
            }
            this.stdin = inputStream;
            this.remaining = n;
            this.readLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEof() {
        Object object = this.readLock;
        synchronized (object) {
            this.eof = true;
            this.readLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int receive(byte[] byArray, int n, int n2) throws IOException, InterruptedException {
        Object object = this.readLock;
        synchronized (object) {
            if (this.remaining > 0) {
                int n3 = Math.min(this.remaining, n2);
                int n4 = this.stdin.read(byArray, n, n3);
                this.remaining -= n4;
                return n4;
            }
            if (this.eof) {
                return -1;
            }
        }
        this.sendSendInput();
        object = this.readLock;
        synchronized (object) {
            if (this.remaining == 0 && !this.eof) {
                this.readLock.wait();
            }
            return this.receive(byArray, n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void send(byte by, byte[] byArray, int n, int n2) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            this.out.writeInt(n2);
            this.out.writeByte(by);
            this.out.write(byArray, n, n2);
        }
        this.out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendSendInput() throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            this.out.writeInt(0);
            this.out.writeByte(83);
        }
        this.out.flush();
    }

    boolean isClientConnected() {
        return this.clientConnected.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int available() {
        Object object = this.readLock;
        synchronized (object) {
            return this.remaining;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addClientListener(NGClientListener nGClientListener) {
        Object object = this.orchestratorEvent;
        synchronized (object) {
            this.clientListeners.add(nGClientListener);
            this.orchestratorEvent.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeClientListener(NGClientListener nGClientListener) {
        Object object = this.orchestratorEvent;
        synchronized (object) {
            this.clientListeners.remove(nGClientListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAllClientListeners() {
        Object object = this.orchestratorEvent;
        synchronized (object) {
            this.clientListeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addHeartbeatListener(NGHeartbeatListener nGHeartbeatListener) {
        Set<NGHeartbeatListener> set = this.heartbeatListeners;
        synchronized (set) {
            this.heartbeatListeners.add(nGHeartbeatListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeHeartbeatListener(NGHeartbeatListener nGHeartbeatListener) {
        Set<NGHeartbeatListener> set = this.heartbeatListeners;
        synchronized (set) {
            this.heartbeatListeners.remove(nGHeartbeatListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyHeartbeat() {
        ArrayList<NGHeartbeatListener> arrayList;
        Set<NGHeartbeatListener> set = this.heartbeatListeners;
        synchronized (set) {
            if (this.heartbeatListeners.isEmpty()) {
                return;
            }
            arrayList = new ArrayList<NGHeartbeatListener>(this.heartbeatListeners);
        }
        for (NGHeartbeatListener nGHeartbeatListener : arrayList) {
            nGHeartbeatListener.heartbeatReceived();
        }
    }
}

