/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.nailgun.examples;

import com.martiansoftware.nailgun.NGContext;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class Hash {
    private static final char[] HEXCHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private static Set getCryptoImpls(String serviceType) {
        TreeSet<String> result = new TreeSet<String>();
        Provider[] providers = Security.getProviders();
        for (int i = 0; i < providers.length; ++i) {
            Set<Object> keys = providers[i].keySet();
            for (String string : keys) {
                String string2 = string.split(" ")[0];
                if (string2.startsWith(serviceType + ".")) {
                    result.add(string2.substring(serviceType.length() + 1));
                    continue;
                }
                if (!string2.startsWith("Alg.Alias." + serviceType + ".")) continue;
                result.add(string2.substring(serviceType.length() + 11));
            }
        }
        return result;
    }

    public static void nailMain(NGContext context) throws NoSuchAlgorithmException, IOException {
        String[] args = context.getArgs();
        if (args.length == 0) {
            Set algs = Hash.getCryptoImpls("MessageDigest");
            Iterator i = algs.iterator();
            while (i.hasNext()) {
                context.out.println(i.next());
            }
        } else {
            MessageDigest md = MessageDigest.getInstance(args[0]);
            byte[] b = new byte[1024];
            int bytesRead = context.in.read(b);
            while (bytesRead != -1) {
                md.update(b, 0, bytesRead);
                bytesRead = System.in.read(b);
            }
            byte[] result = md.digest();
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < result.length; ++i) {
                buf.append(HEXCHARS[result[i] >> 4 & 0xF]);
                buf.append(HEXCHARS[result[i] & 0xF]);
            }
            context.out.println(buf);
        }
    }
}

