/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.nailgun;

import com.martiansoftware.nailgun.NGClientListener;
import com.martiansoftware.nailgun.NGExitException;
import com.martiansoftware.nailgun.NGHeartbeatListener;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NGInputStream
extends FilterInputStream
implements Closeable {
    private static final Logger LOG = Logger.getLogger(NGInputStream.class.getName());
    private final ExecutorService orchestratorExecutor;
    private final ExecutorService readExecutor;
    private final DataInputStream din;
    private InputStream stdin = null;
    private boolean eof = false;
    private long remaining = 0L;
    private byte[] oneByteBuffer = null;
    private final DataOutputStream out;
    private boolean started = false;
    private long lastReadTime = System.currentTimeMillis();
    private final Future readFuture;
    private final Set clientListeners = new HashSet();
    private final Set heartbeatListeners = new HashSet();
    private final int heartbeatTimeoutMillis;

    public NGInputStream(InputStream inputStream, DataOutputStream dataOutputStream, PrintStream printStream, int n) {
        super(inputStream);
        this.din = (DataInputStream)this.in;
        this.out = dataOutputStream;
        this.heartbeatTimeoutMillis = n;
        Thread thread = Thread.currentThread();
        final class NamedThreadFactory
        implements ThreadFactory {
            private final String threadName;

            public NamedThreadFactory(String string) {
                this.threadName = string;
            }

            @Override
            public Thread newThread(Runnable runnable) {
                SecurityManager securityManager = System.getSecurityManager();
                ThreadGroup threadGroup = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
                Thread thread = new Thread(threadGroup, runnable, this.threadName, 0L);
                if (thread.isDaemon()) {
                    thread.setDaemon(false);
                }
                if (thread.getPriority() != 10) {
                    thread.setPriority(10);
                }
                return thread;
            }
        }
        this.orchestratorExecutor = Executors.newSingleThreadExecutor(new NamedThreadFactory(thread.getName() + " (NGInputStream orchestrator)"));
        this.readExecutor = Executors.newSingleThreadExecutor(new NamedThreadFactory(thread.getName() + " (NGInputStream reader)"));
        this.readFuture = this.orchestratorExecutor.submit(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 5[CATCHBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    private synchronized void notifyClientListener(NGClientListener nGClientListener) throws InterruptedException {
        try {
            nGClientListener.clientDisconnected();
        }
        catch (NGExitException nGExitException) {
            throw new InterruptedException(nGExitException.getMessage());
        }
    }

    private synchronized void notifyClientListener(NGClientListener nGClientListener, Thread thread) {
        try {
            this.notifyClientListener(nGClientListener);
        }
        catch (InterruptedException interruptedException) {
            thread.interrupt();
        }
    }

    private synchronized void notifyClientListeners(PrintStream printStream, Thread thread) {
        if (!this.eof) {
            printStream.println(thread.getName() + " disconnected");
            Iterator iterator = this.clientListeners.iterator();
            while (iterator.hasNext()) {
                this.notifyClientListener((NGClientListener)iterator.next(), thread);
            }
        }
        this.clientListeners.clear();
    }

    @Override
    public synchronized void close() {
        this.readEof();
        this.readFuture.cancel(true);
        this.readExecutor.shutdownNow();
        this.orchestratorExecutor.shutdownNow();
    }

    private InputStream readPayload(InputStream inputStream, int n) throws IOException {
        int n2;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; i += n2) {
            n2 = inputStream.read(byArray, i, n - i);
            if (n2 >= 0) continue;
            throw new IOException("stdin EOF before payload read.");
        }
        return new ByteArrayInputStream(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readChunk() throws IOException {
        DataInputStream dataInputStream = this.din;
        synchronized (dataInputStream) {
            int n = this.din.readInt();
            byte by = this.din.readByte();
            long l = System.currentTimeMillis();
            NGInputStream nGInputStream = this;
            synchronized (nGInputStream) {
                long l2 = l - this.lastReadTime;
                this.lastReadTime = l;
                switch (by) {
                    case 48: {
                        if (this.remaining != 0L) {
                            throw new IOException("Data received before stdin stream was emptied");
                        }
                        LOG.log(Level.FINEST, "Got stdin chunk, len %d", n);
                        this.remaining = n;
                        this.stdin = this.readPayload(this.in, n);
                        this.notify();
                        break;
                    }
                    case 46: {
                        LOG.log(Level.FINEST, "Got stdin closed chunk");
                        this.readEof();
                        break;
                    }
                    case 72: {
                        LOG.log(Level.FINEST, "Got client heartbeat");
                        Iterator iterator = this.heartbeatListeners.iterator();
                        while (iterator.hasNext()) {
                            ((NGHeartbeatListener)iterator.next()).heartbeatReceived(l2);
                        }
                        break;
                    }
                    default: {
                        LOG.log(Level.WARNING, "Unknown chunk type: %c", Character.valueOf((char)by));
                        throw new IOException("Unknown stream type: " + (char)by);
                    }
                }
            }
        }
    }

    private synchronized void readEof() {
        this.eof = true;
        this.notifyAll();
    }

    @Override
    public synchronized int available() throws IOException {
        if (this.eof) {
            return 0;
        }
        if (this.stdin == null) {
            return 0;
        }
        return this.stdin.available();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.oneByteBuffer == null) {
            this.oneByteBuffer = new byte[1];
        }
        return this.read(this.oneByteBuffer, 0, 1) == -1 ? -1 : this.oneByteBuffer[0];
    }

    @Override
    public synchronized int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        if (!this.started) {
            this.sendSendInput();
        }
        this.waitForChunk();
        if (this.eof) {
            return -1;
        }
        int n3 = Math.min((int)this.remaining, n2);
        int n4 = this.stdin.read(byArray, n, n3);
        this.remaining -= (long)n4;
        if (this.remaining == 0L) {
            this.sendSendInput();
        }
        return n4;
    }

    private synchronized void waitForChunk() throws IOException {
        try {
            if (!this.eof && this.remaining == 0L) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void sendSendInput() throws IOException {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.writeInt(0);
            this.out.writeByte(83);
        }
        this.out.flush();
        this.started = true;
    }

    public synchronized boolean isClientConnected() {
        long l = System.currentTimeMillis() - this.lastReadTime;
        return l < (long)this.heartbeatTimeoutMillis;
    }

    public synchronized void addClientListener(NGClientListener nGClientListener) {
        if (!this.readFuture.isDone()) {
            this.clientListeners.add(nGClientListener);
        } else {
            try {
                this.notifyClientListener(nGClientListener);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public synchronized void removeClientListener(NGClientListener nGClientListener) {
        this.clientListeners.remove(nGClientListener);
    }

    public synchronized void addHeartbeatListener(NGHeartbeatListener nGHeartbeatListener) {
        if (!this.readFuture.isDone()) {
            this.heartbeatListeners.add(nGHeartbeatListener);
        }
    }

    public synchronized void removeHeartbeatListener(NGHeartbeatListener nGHeartbeatListener) {
        this.heartbeatListeners.remove(nGHeartbeatListener);
    }

    private /* synthetic */ void lambda$null$0() {
        try {
            this.readChunk();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

