/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.nailgun;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class NGOutputStream
extends DataOutputStream {
    private final Object lock;
    private byte streamCode;
    private boolean closed = false;

    public NGOutputStream(OutputStream outputStream, byte by) {
        super(outputStream);
        this.lock = outputStream;
        this.streamCode = by;
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.throwIfClosed();
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(int n) throws IOException {
        this.throwIfClosed();
        byte[] byArray = new byte[]{(byte)n};
        this.write(byArray, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.throwIfClosed();
        Object object = this.lock;
        synchronized (object) {
            this.writeInt(n2);
            this.writeByte(this.streamCode);
            this.out.write(byArray, n, n2);
        }
        this.flush();
    }

    @Override
    public void close() throws IOException {
        this.throwIfClosed();
        this.closed = true;
        super.flush();
    }

    @Override
    public void flush() throws IOException {
        this.throwIfClosed();
        super.flush();
    }

    private void throwIfClosed() throws IOException {
        if (this.closed) {
            throw new IOException();
        }
    }
}

