/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.nailgun;

import com.martiansoftware.nailgun.Alias;
import com.martiansoftware.nailgun.NGContext;
import com.martiansoftware.nailgun.NGExitException;
import com.martiansoftware.nailgun.NGInputStream;
import com.martiansoftware.nailgun.NGOutputStream;
import com.martiansoftware.nailgun.NGSecurityManager;
import com.martiansoftware.nailgun.NGServer;
import com.martiansoftware.nailgun.NGSessionPool;
import com.martiansoftware.nailgun.NonStaticNail;
import com.martiansoftware.nailgun.ThreadLocalInputStream;
import com.martiansoftware.nailgun.ThreadLocalPrintStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NGSession
extends Thread {
    private static final Logger LOG = Logger.getLogger(NGSession.class.getName());
    private final NGServer server;
    private final NGSessionPool sessionPool;
    private final Object lock = new Object();
    private Socket nextSocket = null;
    private boolean done = false;
    private final long instanceNumber;
    private final int heartbeatTimeoutMillis;
    private static AtomicLong instanceCounter = new AtomicLong(0L);
    private static final Class[] mainSignature = new Class[]{String[].class};
    private static final Class[] nailMainSignature = new Class[]{NGContext.class};
    public static volatile ClassLoader classLoader = null;

    NGSession(NGSessionPool nGSessionPool, NGServer nGServer) {
        this.sessionPool = nGSessionPool;
        this.server = nGServer;
        this.heartbeatTimeoutMillis = nGServer.getHeartbeatTimeout();
        this.instanceNumber = instanceCounter.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        Object object = this.lock;
        synchronized (object) {
            this.done = true;
            this.nextSocket = null;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Socket socket) {
        Object object = this.lock;
        synchronized (object) {
            this.nextSocket = socket;
            this.lock.notify();
        }
        Thread.yield();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Socket nextSocket() {
        Socket socket = null;
        Object object = this.lock;
        synchronized (object) {
            socket = this.nextSocket;
            while (!this.done && socket == null) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    this.done = true;
                }
                socket = this.nextSocket;
            }
            this.nextSocket = null;
        }
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.updateThreadName(null);
        LOG.log(Level.FINE, "Waiting for first client to connect");
        Socket socket = this.nextSocket();
        while (socket != null) {
            block41: {
                LOG.log(Level.FINE, "Client connected");
                try {
                    Object object;
                    Object object2;
                    Object object3;
                    DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
                    DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
                    ArrayList<String> arrayList = new ArrayList<String>();
                    Properties properties = new Properties();
                    String string = null;
                    String string2 = null;
                    while (string2 == null) {
                        int n = dataInputStream.readInt();
                        byte by = dataInputStream.readByte();
                        object3 = new byte[n];
                        dataInputStream.readFully((byte[])object3);
                        object2 = new String((byte[])object3, "UTF-8");
                        switch (by) {
                            case 65: {
                                arrayList.add((String)object2);
                                break;
                            }
                            case 69: {
                                int n2 = ((String)object2).indexOf(61);
                                if (n2 > 0) {
                                    properties.setProperty(((String)object2).substring(0, n2), ((String)object2).substring(n2 + 1));
                                }
                                object = ((String)object2).substring(0, n2);
                                break;
                            }
                            case 67: {
                                string2 = object2;
                                break;
                            }
                            case 68: {
                                string = object2;
                                break;
                            }
                        }
                    }
                    String string3 = socket.getInetAddress() != null ? socket.getInetAddress().getHostAddress() + ": " + string2 : string2;
                    this.updateThreadName(string3);
                    InputStream inputStream = null;
                    object3 = null;
                    object2 = null;
                    PrintStream printStream = null;
                    try {
                        inputStream = new NGInputStream(dataInputStream, dataOutputStream, this.server.out, this.heartbeatTimeoutMillis);
                        object3 = new PrintStream(new NGOutputStream(dataOutputStream, 49));
                        object2 = new PrintStream(new NGOutputStream(dataOutputStream, 50));
                        printStream = new PrintStream(new NGOutputStream(dataOutputStream, 88));
                        ((ThreadLocalInputStream)System.in).init(inputStream);
                        ((ThreadLocalPrintStream)System.out).init((PrintStream)object3);
                        ((ThreadLocalPrintStream)System.err).init((PrintStream)object2);
                        try {
                            object = this.server.getAliasManager().getAlias(string2);
                            Class<Object> clazz = null;
                            clazz = object != null ? ((Alias)object).getAliasedClass() : (this.server.allowsNailsByClassName() ? Class.forName(string2, true, classLoader) : this.server.getDefaultNailClass());
                            Object[] objectArray = new Object[1];
                            Method method = null;
                            String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
                            boolean bl = true;
                            Class<?>[] classArray = clazz.getInterfaces();
                            for (int i = 0; i < classArray.length; ++i) {
                                if (!classArray[i].equals(NonStaticNail.class)) continue;
                                bl = false;
                                break;
                            }
                            if (!bl) {
                                method = clazz.getMethod("nailMain", String[].class);
                                objectArray[0] = stringArray;
                            } else {
                                try {
                                    method = clazz.getMethod("nailMain", nailMainSignature);
                                    NGContext nGContext = new NGContext();
                                    nGContext.setArgs(stringArray);
                                    nGContext.in = inputStream;
                                    nGContext.out = object3;
                                    nGContext.err = object2;
                                    nGContext.setCommand(string2);
                                    nGContext.setExitStream(printStream);
                                    nGContext.setNGServer(this.server);
                                    nGContext.setEnv(properties);
                                    nGContext.setInetAddress(socket.getInetAddress());
                                    nGContext.setPort(socket.getPort());
                                    nGContext.setWorkingDirectory(string);
                                    objectArray[0] = nGContext;
                                }
                                catch (NoSuchMethodException noSuchMethodException) {
                                    // empty catch block
                                }
                                if (method == null) {
                                    method = clazz.getMethod("main", mainSignature);
                                    objectArray[0] = stringArray;
                                }
                            }
                            if (method == null) break block41;
                            this.server.nailStarted(clazz);
                            NGSecurityManager.setExit(printStream);
                            try {
                                if (bl) {
                                    method.invoke(null, objectArray);
                                } else {
                                    method.invoke(clazz.newInstance(), objectArray);
                                }
                            }
                            catch (InvocationTargetException invocationTargetException) {
                                throw invocationTargetException.getCause();
                            }
                            catch (InstantiationException instantiationException) {
                                throw instantiationException;
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                throw illegalAccessException;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                this.server.nailFinished(clazz);
                            }
                            printStream.println(0);
                        }
                        catch (NGExitException nGExitException) {
                            LOG.log(Level.INFO, "Server cleanly exited with status " + nGExitException.getStatus(), nGExitException);
                            inputStream.close();
                            printStream.println(nGExitException.getStatus());
                            this.server.out.println(Thread.currentThread().getName() + " exited with status " + nGExitException.getStatus());
                        }
                        catch (Throwable throwable) {
                            LOG.log(Level.INFO, "Server unexpectedly exited with unhandled exception", throwable);
                            inputStream.close();
                            throwable.printStackTrace();
                            printStream.println(899);
                        }
                    }
                    finally {
                        LOG.log(Level.FINE, "Tearing down client socket");
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (object3 != null) {
                            ((PrintStream)object3).close();
                        }
                        if (object2 != null) {
                            ((PrintStream)object2).close();
                        }
                        if (printStream != null) {
                            printStream.close();
                        }
                        LOG.log(Level.FINE, "Flushing client socket");
                        dataOutputStream.flush();
                        try {
                            socket.shutdownInput();
                            socket.shutdownOutput();
                        }
                        catch (IOException iOException) {
                            LOG.log(Level.FINE, "Error shutting down socket I/O (this is expected if the client disconnected already)", iOException);
                        }
                        LOG.log(Level.FINE, "Closing client socket");
                        socket.close();
                        LOG.log(Level.FINE, "Finished tearing down client socket");
                    }
                }
                catch (Throwable throwable) {
                    LOG.log(Level.WARNING, "Internal error in session", throwable);
                    throwable.printStackTrace();
                }
            }
            ((ThreadLocalInputStream)System.in).init(null);
            ((ThreadLocalPrintStream)System.out).init(null);
            ((ThreadLocalPrintStream)System.err).init(null);
            this.updateThreadName(null);
            this.sessionPool.give(this);
            LOG.log(Level.FINE, "Waiting for next client to connect");
            socket = this.nextSocket();
        }
        LOG.log(Level.INFO, "NGSession shutting down");
    }

    private void updateThreadName(String string) {
        this.setName("NGSession " + this.instanceNumber + ": " + (string == null ? "(idle)" : string));
    }

    static {
        classLoader = NGSession.class.getClassLoader();
    }
}

