/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.nailgun;

import com.martiansoftware.nailgun.Alias;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

public class AliasManager {
    private Map aliases = new HashMap();

    public AliasManager() {
        Properties properties = new Properties();
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        try (InputStream inputStream = classLoader.getResourceAsStream("com/martiansoftware/nailgun/builtins/builtins.properties");){
            properties.load(inputStream);
            this.loadFromProperties(properties);
        }
        catch (IOException iOException) {
            System.err.println("Unable to load builtins.properties: " + iOException.getMessage());
        }
    }

    public void loadFromProperties(Properties properties) {
        for (String string : properties.keySet()) {
            if (string.endsWith(".desc")) continue;
            try {
                Class<?> clazz = Class.forName(properties.getProperty(string));
                String string2 = properties.getProperty(string + ".desc", "");
                this.addAlias(new Alias(string, string2, clazz));
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("Unable to locate class " + properties.getProperty(string));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAlias(Alias alias) {
        Map map = this.aliases;
        synchronized (map) {
            this.aliases.put(alias.getName(), alias);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getAliases() {
        TreeSet treeSet = new TreeSet();
        Map map = this.aliases;
        synchronized (map) {
            treeSet.addAll(this.aliases.values());
        }
        return treeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAlias(String string) {
        Map map = this.aliases;
        synchronized (map) {
            this.aliases.remove(string);
        }
    }

    public Alias getAlias(String string) {
        return (Alias)this.aliases.get(string);
    }
}

