/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.nailgun;

import com.martiansoftware.nailgun.NGClientListener;
import com.martiansoftware.nailgun.NGCommunicator;
import com.martiansoftware.nailgun.NGHeartbeatListener;
import com.martiansoftware.nailgun.NGServer;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Properties;

public class NGContext {
    private Properties remoteEnvironment = null;
    private InetAddress remoteHost = null;
    private int remotePort = 0;
    private String[] args = null;
    private PrintStream exitStream = null;
    private NGServer server = null;
    private String command = null;
    private String workingDirectory = null;
    public InputStream in = null;
    public PrintStream out = null;
    public PrintStream err = null;
    private NGCommunicator communicator = null;

    public void setExitStream(PrintStream printStream) {
        this.exitStream = printStream;
    }

    public void setCommunicator(NGCommunicator nGCommunicator) {
        this.communicator = nGCommunicator;
    }

    public NGCommunicator getCommunicator() {
        return this.communicator;
    }

    public void setPort(int n) {
        this.remotePort = n;
    }

    public void setCommand(String string) {
        this.command = string;
    }

    public String getCommand() {
        return this.command;
    }

    void setWorkingDirectory(String string) {
        this.workingDirectory = string;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    void setEnv(Properties properties) {
        this.remoteEnvironment = properties;
    }

    void setInetAddress(InetAddress inetAddress) {
        this.remoteHost = inetAddress;
    }

    public void setArgs(String[] stringArray) {
        this.args = stringArray;
    }

    void setNGServer(NGServer nGServer) {
        this.server = nGServer;
    }

    public Properties getEnv() {
        return this.remoteEnvironment;
    }

    public String getFileSeparator() {
        return this.remoteEnvironment.getProperty("NAILGUN_FILESEPARATOR");
    }

    public String getPathSeparator() {
        return this.remoteEnvironment.getProperty("NAILGUN_PATHSEPARATOR");
    }

    public InetAddress getInetAddress() {
        return this.remoteHost;
    }

    public String[] getArgs() {
        return this.args;
    }

    public NGServer getNGServer() {
        return this.server;
    }

    public void exit(int n) {
        this.exitStream.println(n);
    }

    public int getPort() {
        return this.remotePort;
    }

    public void assertLoopbackClient() {
        if (!this.getInetAddress().isLoopbackAddress()) {
            throw new SecurityException("Client is not at loopback address.");
        }
    }

    public void assertLocalClient() {
        NetworkInterface networkInterface = null;
        try {
            networkInterface = NetworkInterface.getByInetAddress(this.getInetAddress());
        }
        catch (SocketException socketException) {
            throw new SecurityException("Unable to determine if client is local.  Assuming he isn't.");
        }
        if (networkInterface == null && !this.getInetAddress().isLoopbackAddress()) {
            throw new SecurityException("Client is not local.");
        }
    }

    public boolean isClientConnected() {
        return this.communicator.isClientConnected();
    }

    public void addClientListener(NGClientListener nGClientListener) {
        this.communicator.addClientListener(nGClientListener);
    }

    public void removeClientListener(NGClientListener nGClientListener) {
        this.communicator.removeClientListener(nGClientListener);
    }

    public void removeAllClientListeners() {
        this.communicator.removeAllClientListeners();
    }

    public void addHeartbeatListener(NGHeartbeatListener nGHeartbeatListener) {
        this.communicator.addHeartbeatListener(nGHeartbeatListener);
    }

    public void removeHeartbeatListener(NGHeartbeatListener nGHeartbeatListener) {
        this.communicator.removeHeartbeatListener(nGHeartbeatListener);
    }
}

