/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.nailgun;

import com.martiansoftware.nailgun.Alias;
import com.martiansoftware.nailgun.NGCommunicator;
import com.martiansoftware.nailgun.NGContext;
import com.martiansoftware.nailgun.NGExitException;
import com.martiansoftware.nailgun.NGInputStream;
import com.martiansoftware.nailgun.NGOutputStream;
import com.martiansoftware.nailgun.NGSecurityManager;
import com.martiansoftware.nailgun.NGServer;
import com.martiansoftware.nailgun.NGSessionPool;
import com.martiansoftware.nailgun.NonStaticNail;
import com.martiansoftware.nailgun.ThreadLocalInputStream;
import com.martiansoftware.nailgun.ThreadLocalPrintStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NGSession
extends Thread {
    private static final Logger LOG = Logger.getLogger(NGSession.class.getName());
    private final NGServer server;
    private final NGSessionPool sessionPool;
    private final Object lock = new Object();
    private Socket nextSocket = null;
    private boolean done = false;
    private final long instanceNumber;
    private final int heartbeatTimeoutMillis;
    private static AtomicLong instanceCounter = new AtomicLong(0L);
    private static final Class[] mainSignature = new Class[]{String[].class};
    private static final Class[] nailMainSignature = new Class[]{NGContext.class};
    public static volatile ClassLoader classLoader = null;

    NGSession(NGSessionPool nGSessionPool, NGServer nGServer) {
        this.sessionPool = nGSessionPool;
        this.server = nGServer;
        this.heartbeatTimeoutMillis = nGServer.getHeartbeatTimeout();
        this.instanceNumber = instanceCounter.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        Object object = this.lock;
        synchronized (object) {
            this.done = true;
            this.nextSocket = null;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Socket socket) {
        Object object = this.lock;
        synchronized (object) {
            this.nextSocket = socket;
            this.lock.notify();
        }
        Thread.yield();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Socket nextSocket() {
        Socket socket;
        Object object = this.lock;
        synchronized (object) {
            socket = this.nextSocket;
            while (!this.done && socket == null) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    this.done = true;
                }
                socket = this.nextSocket;
            }
            this.nextSocket = null;
        }
        if (socket != null) {
            try {
                socket.setSoTimeout(this.heartbeatTimeoutMillis);
            }
            catch (SocketException socketException) {
                return null;
            }
        }
        return socket;
    }

    @Override
    public void run() {
        this.updateThreadName(null);
        LOG.log(Level.FINE, "Waiting for first client to connect");
        Socket socket = this.nextSocket();
        while (socket != null) {
            block115: {
                LOG.log(Level.FINE, "Client connected");
                try (DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
                     DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());){
                    Object object;
                    Object object2;
                    ArrayList<String> arrayList = new ArrayList<String>();
                    Properties properties = new Properties();
                    String string = null;
                    String string2 = null;
                    while (string2 == null) {
                        int n = dataInputStream.readInt();
                        byte by = dataInputStream.readByte();
                        object2 = new byte[n];
                        dataInputStream.readFully((byte[])object2);
                        object = new String((byte[])object2, "UTF-8");
                        switch (by) {
                            case 65: {
                                arrayList.add((String)object);
                                break;
                            }
                            case 69: {
                                int n2 = ((String)object).indexOf(61);
                                if (n2 <= 0) break;
                                properties.setProperty(((String)object).substring(0, n2), ((String)object).substring(n2 + 1));
                                break;
                            }
                            case 67: {
                                string2 = object;
                                break;
                            }
                            case 68: {
                                string = object;
                                break;
                            }
                        }
                    }
                    String string3 = socket.getInetAddress() != null ? socket.getInetAddress().getHostAddress() + ": " + string2 : string2;
                    this.updateThreadName(string3);
                    NGCommunicator nGCommunicator = new NGCommunicator(dataInputStream, dataOutputStream, this.heartbeatTimeoutMillis);
                    object2 = null;
                    try {
                        object = new NGInputStream(nGCommunicator);
                        Throwable throwable = null;
                        try (PrintStream printStream = new PrintStream(new NGOutputStream(nGCommunicator, 49));
                             PrintStream printStream2 = new PrintStream(new NGOutputStream(nGCommunicator, 50));
                             PrintStream printStream3 = new PrintStream(new NGOutputStream(nGCommunicator, 88));){
                            ((ThreadLocalInputStream)System.in).init((InputStream)object);
                            ((ThreadLocalPrintStream)System.out).init(printStream);
                            ((ThreadLocalPrintStream)System.err).init(printStream2);
                            try {
                                Alias alias = this.server.getAliasManager().getAlias(string2);
                                Class<Object> clazz = null;
                                clazz = alias != null ? alias.getAliasedClass() : (this.server.allowsNailsByClassName() ? Class.forName(string2, true, classLoader) : this.server.getDefaultNailClass());
                                Object[] objectArray = new Object[1];
                                Method method = null;
                                String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
                                boolean bl = true;
                                Class<?>[] classArray = clazz.getInterfaces();
                                for (int i = 0; i < classArray.length; ++i) {
                                    if (!classArray[i].equals(NonStaticNail.class)) continue;
                                    bl = false;
                                    break;
                                }
                                if (!bl) {
                                    method = clazz.getMethod("nailMain", String[].class);
                                    objectArray[0] = stringArray;
                                } else {
                                    try {
                                        method = clazz.getMethod("nailMain", nailMainSignature);
                                        NGContext nGContext = new NGContext();
                                        nGContext.setArgs(stringArray);
                                        nGContext.in = object;
                                        nGContext.out = printStream;
                                        nGContext.err = printStream2;
                                        nGContext.setCommand(string2);
                                        nGContext.setExitStream(printStream3);
                                        nGContext.setNGServer(this.server);
                                        nGContext.setCommunicator(nGCommunicator);
                                        nGContext.setEnv(properties);
                                        nGContext.setInetAddress(socket.getInetAddress());
                                        nGContext.setPort(socket.getPort());
                                        nGContext.setWorkingDirectory(string);
                                        objectArray[0] = nGContext;
                                    }
                                    catch (NoSuchMethodException noSuchMethodException) {
                                        // empty catch block
                                    }
                                    if (method == null) {
                                        method = clazz.getMethod("main", mainSignature);
                                        objectArray[0] = stringArray;
                                    }
                                }
                                if (method == null) break block115;
                                this.server.nailStarted(clazz);
                                NGSecurityManager.setExit(printStream3);
                                try {
                                    if (bl) {
                                        method.invoke(null, objectArray);
                                    } else {
                                        method.invoke(clazz.newInstance(), objectArray);
                                    }
                                }
                                catch (InvocationTargetException invocationTargetException) {
                                    throw invocationTargetException.getCause();
                                }
                                catch (InstantiationException instantiationException) {
                                    throw instantiationException;
                                }
                                catch (IllegalAccessException illegalAccessException) {
                                    throw illegalAccessException;
                                }
                                catch (Throwable throwable2) {
                                    throw throwable2;
                                }
                                finally {
                                    this.server.nailFinished(clazz);
                                }
                                printStream3.println(0);
                            }
                            catch (NGExitException nGExitException) {
                                LOG.log(Level.INFO, "Server cleanly exited with status {0}", nGExitException.getStatus());
                                printStream3.println(nGExitException.getStatus());
                                this.server.out.println(Thread.currentThread().getName() + " exited with status " + nGExitException.getStatus());
                            }
                            catch (Throwable throwable3) {
                                LOG.log(Level.INFO, "Server unexpectedly exited with unhandled exception", throwable3);
                                throwable3.printStackTrace();
                                printStream3.println(899);
                            }
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (object != null) {
                                if (throwable != null) {
                                    try {
                                        ((InputStream)object).close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    ((InputStream)object).close();
                                }
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        object2 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (nGCommunicator != null) {
                            if (object2 != null) {
                                try {
                                    nGCommunicator.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object2).addSuppressed(throwable);
                                }
                            } else {
                                nGCommunicator.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    LOG.log(Level.WARNING, "Internal error in session", throwable);
                    throwable.printStackTrace();
                }
            }
            ((ThreadLocalInputStream)System.in).init(null);
            ((ThreadLocalPrintStream)System.out).init(null);
            ((ThreadLocalPrintStream)System.err).init(null);
            this.updateThreadName(null);
            this.sessionPool.give(this);
            LOG.log(Level.FINE, "Closing client socket");
            try {
                socket.close();
            }
            catch (Throwable throwable) {
                LOG.log(Level.WARNING, "Internal error closing socket", throwable);
            }
            LOG.log(Level.FINE, "Waiting for next client to connect");
            socket = this.nextSocket();
        }
        LOG.log(Level.INFO, "NGSession shutting down");
    }

    private void updateThreadName(String string) {
        this.setName("NGSession " + this.instanceNumber + ": " + (string == null ? "(idle)" : string));
    }

    static {
        classLoader = NGSession.class.getClassLoader();
    }
}

