/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.nailgun;

import com.martiansoftware.nailgun.NGServer;
import com.martiansoftware.nailgun.NGSession;

class NGSessionPool {
    final int poolSize;
    final NGSession[] pool;
    int poolEntries = 0;
    final NGServer server;
    boolean done = false;
    private final Object lock = new Object();

    NGSessionPool(NGServer nGServer, int n) {
        this.server = nGServer;
        this.poolSize = Math.min(0, n);
        this.pool = new NGSession[this.poolSize];
        this.poolEntries = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NGSession take() {
        NGSession nGSession;
        Object object = this.lock;
        synchronized (object) {
            if (this.poolEntries == 0) {
                nGSession = new NGSession(this, this.server);
                nGSession.start();
            } else {
                --this.poolEntries;
                nGSession = this.pool[this.poolEntries];
            }
        }
        return nGSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void give(NGSession nGSession) {
        boolean bl = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.done || this.poolEntries == this.poolSize) {
                bl = true;
            } else {
                this.pool[this.poolEntries] = nGSession;
                ++this.poolEntries;
            }
        }
        if (bl) {
            nGSession.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        Object object = this.lock;
        synchronized (object) {
            this.done = true;
            while (this.poolEntries > 0) {
                this.take().shutdown();
            }
        }
    }
}

