/*
 * Decompiled with CFR 0.152.
 */
package bloop.shaded.io.circe;

import bloop.shaded.cats.Show;
import bloop.shaded.cats.Show$;
import bloop.shaded.cats.kernel.Eq;
import bloop.shaded.cats.package$;
import bloop.shaded.io.circe.Json;
import bloop.shaded.io.circe.Json$;
import bloop.shaded.io.circe.Json$JNull$;
import bloop.shaded.io.circe.JsonBigDecimal;
import bloop.shaded.io.circe.JsonBiggerDecimal;
import bloop.shaded.io.circe.JsonDouble;
import bloop.shaded.io.circe.JsonFloat;
import bloop.shaded.io.circe.JsonLong;
import bloop.shaded.io.circe.JsonNumber;
import bloop.shaded.io.circe.JsonObject;
import bloop.shaded.io.circe.JsonObject$;
import bloop.shaded.io.circe.numbers.BiggerDecimal$;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Vector;
import scala.math.BigDecimal;
import scala.math.BigInt;

public final class Json$
implements Serializable {
    public static final Json$ MODULE$;
    private final Json Null;
    private final Json True;
    private final Json False;
    private final Eq<Json> eqJson;
    private final Show<Json> showJson;

    static {
        new Json$();
    }

    public final Json Null() {
        return this.Null;
    }

    public final Json True() {
        return this.True;
    }

    public final Json False() {
        return this.False;
    }

    public final Json obj(Seq<Tuple2<String, Json>> fields2) {
        return this.fromFields((Iterable<Tuple2<String, Json>>)fields2);
    }

    public final Json arr(Seq<Json> values2) {
        return this.fromValues((Iterable<Json>)values2);
    }

    public final Json fromFields(Iterable<Tuple2<String, Json>> fields2) {
        return new Json.JObject(JsonObject$.MODULE$.fromIterable(fields2));
    }

    public final Json fromValues(Iterable<Json> values2) {
        return new Json.JArray((Vector<Json>)values2.toVector());
    }

    public final Json fromJsonObject(JsonObject value2) {
        return new Json.JObject(value2);
    }

    public final Json fromJsonNumber(JsonNumber value2) {
        return new Json.JNumber(value2);
    }

    public final Json fromString(String value2) {
        return new Json.JString(value2);
    }

    public final Json fromBoolean(boolean value2) {
        return value2 ? this.True() : this.False();
    }

    public final Json fromInt(int value2) {
        return new Json.JNumber(new JsonLong(value2));
    }

    public final Json fromLong(long value2) {
        return new Json.JNumber(new JsonLong(value2));
    }

    public final Option<Json> fromDouble(double value2) {
        return this.isReal(value2) ? new Some((Object)new Json.JNumber(new JsonDouble(value2))) : None$.MODULE$;
    }

    public final Option<Json> fromFloat(float value2) {
        return this.isReal(value2) ? new Some((Object)new Json.JNumber(new JsonFloat(value2))) : None$.MODULE$;
    }

    public final Json fromDoubleOrNull(double value2) {
        return this.isReal(value2) ? new Json.JNumber(new JsonDouble(value2)) : this.Null();
    }

    public final Json fromFloatOrNull(float value2) {
        return this.isReal(value2) ? new Json.JNumber(new JsonFloat(value2)) : this.Null();
    }

    public final Json fromDoubleOrString(double value2) {
        return this.isReal(value2) ? new Json.JNumber(new JsonDouble(value2)) : this.fromString(Double.toString(value2));
    }

    public final Json fromFloatOrString(float value2) {
        return this.isReal(value2) ? new Json.JNumber(new JsonFloat(value2)) : this.fromString(Float.toString(value2));
    }

    public final Json fromBigInt(BigInt value2) {
        return new Json.JNumber(new JsonBiggerDecimal(BiggerDecimal$.MODULE$.fromBigInteger(value2.underlying())));
    }

    public final Json fromBigDecimal(BigDecimal value2) {
        return new Json.JNumber(new JsonBigDecimal(value2.underlying()));
    }

    private boolean isReal(double value2) {
        return !Double.isNaN(value2) && !Double.isInfinite(value2);
    }

    private boolean isReal(float value2) {
        return !Float.isNaN(value2) && !Float.isInfinite(value2);
    }

    public final boolean io$circe$Json$$arrayEq(Seq<Json> x, Seq<Json> y) {
        Iterator it0 = x.iterator();
        Iterator it1 = y.iterator();
        while (it0.hasNext() && it1.hasNext()) {
            if (!this.eqJson().neqv((Json)it0.next(), (Json)it1.next())) continue;
            return false;
        }
        return it0.hasNext() == it1.hasNext();
    }

    public final Eq<Json> eqJson() {
        return this.eqJson;
    }

    public final Show<Json> showJson() {
        return this.showJson;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Json$() {
        MODULE$ = this;
        this.Null = Json$JNull$.MODULE$;
        this.True = new Json.JBoolean(true);
        this.False = new Json.JBoolean(false);
        this.eqJson = package$.MODULE$.Eq().instance(new anonfun.1());
        this.showJson = Show$.MODULE$.fromToString();
    }
}

