/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.scala.debugadapter.sbtplugin.internal;

import ch.epfl.scala.debugadapter.sbtplugin.internal.ForkConfiguration;
import ch.epfl.scala.debugadapter.sbtplugin.internal.FrameworkWrapper;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import sbt.testing.AnnotatedFingerprint;
import sbt.testing.Event;
import sbt.testing.EventHandler;
import sbt.testing.Fingerprint;
import sbt.testing.Framework;
import sbt.testing.Logger;
import sbt.testing.Runner;
import sbt.testing.SubclassFingerprint;
import sbt.testing.Task;
import sbt.testing.TaskDef;

public final class ForkMain {
    public static void main(String[] stringArray) throws Exception {
        ClassLoader classLoader = new Run().getClass().getClassLoader();
        try {
            ForkMain.main(stringArray, classLoader);
        }
        finally {
            System.exit(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray, ClassLoader classLoader) throws Exception {
        Socket socket = new Socket(InetAddress.getByName(null), (int)Integer.valueOf(stringArray[0]));
        try (ObjectInputStream objectInputStream = new ObjectInputStream(socket.getInputStream());){
            new Run().run(objectInputStream, classLoader);
        }
    }

    private static final class Run {
        private Run() {
        }

        private void run(ObjectInputStream objectInputStream, ClassLoader classLoader) {
            try {
                this.runTests(objectInputStream, classLoader);
            }
            catch (RunAborted runAborted) {
                this.internalError(runAborted);
            }
            catch (Throwable throwable) {
                try {
                    this.logError("Uncaught exception when running tests: " + throwable.toString());
                }
                catch (Throwable throwable2) {
                    this.internalError(throwable2);
                }
            }
        }

        private boolean matches(Fingerprint fingerprint, Fingerprint fingerprint2) {
            if (fingerprint instanceof SubclassFingerprint && fingerprint2 instanceof SubclassFingerprint) {
                SubclassFingerprint subclassFingerprint = (SubclassFingerprint)fingerprint;
                SubclassFingerprint subclassFingerprint2 = (SubclassFingerprint)fingerprint2;
                return subclassFingerprint.isModule() == subclassFingerprint2.isModule() && subclassFingerprint.superclassName().equals(subclassFingerprint2.superclassName());
            }
            if (fingerprint instanceof AnnotatedFingerprint && fingerprint2 instanceof AnnotatedFingerprint) {
                AnnotatedFingerprint annotatedFingerprint = (AnnotatedFingerprint)fingerprint;
                AnnotatedFingerprint annotatedFingerprint2 = (AnnotatedFingerprint)fingerprint2;
                return annotatedFingerprint.isModule() == annotatedFingerprint2.isModule() && annotatedFingerprint.annotationName().equals(annotatedFingerprint2.annotationName());
            }
            return false;
        }

        private void logDebug(String string) {
        }

        private void logInfo(String string) {
            System.out.println("[INFO] " + string);
        }

        private void logWarn(String string) {
            System.out.println("[WARN] " + string);
        }

        private void logError(String string) {
            System.err.println("[ERROR] " + string);
        }

        private Logger logger(final boolean bl) {
            return new Logger(){

                public boolean ansiCodesSupported() {
                    return bl;
                }

                public void error(String string) {
                    this.logError(string);
                }

                public void warn(String string) {
                    this.logWarn(string);
                }

                public void info(String string) {
                    this.logInfo(string);
                }

                public void debug(String string) {
                    this.logDebug(string);
                }

                public void trace(Throwable throwable) {
                    this.logDebug(throwable.getMessage());
                }
            };
        }

        private ExecutorService executorService(ForkConfiguration forkConfiguration) {
            if (forkConfiguration.isParallel()) {
                int n = Runtime.getRuntime().availableProcessors();
                this.logDebug("Create a test executor with a thread pool of " + n + " threads.");
                return Executors.newFixedThreadPool(n);
            }
            this.logDebug("Create a single-thread test executor");
            return Executors.newSingleThreadExecutor();
        }

        /*
         * WARNING - void declaration
         */
        private void runTests(ObjectInputStream objectInputStream, ClassLoader classLoader) throws Exception {
            ForkConfiguration forkConfiguration = (ForkConfiguration)objectInputStream.readObject();
            ExecutorService executorService = this.executorService(forkConfiguration);
            TaskDef[] taskDefArray = (TaskDef[])objectInputStream.readObject();
            int n = objectInputStream.readInt();
            Logger[] loggerArray = new Logger[]{this.logger(forkConfiguration.isAnsiCodesSupported())};
            for (int i = 0; i < n; ++i) {
                void var16_21;
                Object object;
                String[] stringArray = (String[])objectInputStream.readObject();
                String[] stringArray2 = (String[])objectInputStream.readObject();
                String[] stringArray3 = (String[])objectInputStream.readObject();
                Framework framework = null;
                for (String string : stringArray) {
                    try {
                        object = Class.forName(string).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        if (object instanceof Framework) {
                            framework = (Framework)object;
                            break;
                        }
                        framework = new FrameworkWrapper((org.scalatools.testing.Framework)object);
                        break;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        this.logDebug("Framework implementation '" + string + "' not present.");
                    }
                }
                if (framework == null) continue;
                LinkedHashSet linkedHashSet = new LinkedHashSet();
                Runner runner = framework.fingerprints();
                int n2 = ((Fingerprint[])runner).length;
                boolean bl = false;
                while (var16_21 < n2) {
                    object = runner[var16_21];
                    for (TaskDef taskDef : taskDefArray) {
                        if (!this.matches((Fingerprint)object, taskDef.fingerprint())) continue;
                        linkedHashSet.add(new TaskDef(taskDef.fullyQualifiedName(), taskDef.fingerprint(), taskDef.explicitlySpecified(), taskDef.selectors()));
                    }
                    ++var16_21;
                }
                runner = framework.runner(stringArray2, stringArray3, classLoader);
                Task[] taskArray = runner.tasks(linkedHashSet.toArray(new TaskDef[linkedHashSet.size()]));
                this.logDebug("Runner for " + framework.getClass().getName() + " produced " + taskArray.length + " initial tasks for " + linkedHashSet.size() + " tests.");
                Thread thread = new Thread(() -> ((Runner)runner).done());
                Runtime.getRuntime().addShutdownHook(thread);
                this.runTestTasks(executorService, taskArray, loggerArray);
                runner.done();
                Runtime.getRuntime().removeShutdownHook(thread);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void runTestTasks(ExecutorService executorService, Task[] taskArray, Logger[] loggerArray) {
            if (taskArray.length > 0) {
                void future;
                ArrayList<Future<Task[]>> arrayList = new ArrayList<Future<Task[]>>();
                Object arrayList2 = taskArray;
                int n = ((Task[])arrayList2).length;
                boolean bl = false;
                while (future < n) {
                    Task exception = arrayList2[future];
                    arrayList.add(this.runTest(executorService, exception, loggerArray));
                    ++future;
                }
                arrayList2 = new ArrayList();
                for (Future future2 : arrayList) {
                    try {
                        arrayList2.addAll(Arrays.asList((Object[])future2.get()));
                    }
                    catch (Exception exception) {
                        this.logError("Failed to execute task " + future2);
                    }
                }
                this.runTestTasks(executorService, arrayList2.toArray(new Task[arrayList2.size()]), loggerArray);
            }
        }

        private Future<Task[]> runTest(ExecutorService executorService, Task task, Logger[] loggerArray) {
            return executorService.submit(() -> {
                Task[] taskArray;
                TaskDef taskDef = task.taskDef();
                try {
                    EventHandler eventHandler = new EventHandler(){

                        public void handle(Event event) {
                        }
                    };
                    this.logDebug("  Running " + taskDef);
                    taskArray = task.execute(eventHandler, loggerArray);
                }
                catch (Throwable throwable) {
                    taskArray = new Task[]{};
                }
                return taskArray;
            });
        }

        private void internalError(Throwable throwable) {
            System.err.println("Internal error when running tests: " + throwable.toString());
        }

        class RunAborted
        extends RuntimeException {
            RunAborted(Exception exception) {
                super(exception);
            }
        }
    }
}

