/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.scala.sbt.release;

import bintray.BintrayPlugin;
import bintry.Licenses$;
import ch.epfl.scala.sbt.release.ReleaseEarlyPlugin$;
import com.jsuereth.sbtpgp.PgpKeys$;
import sbt.Keys$;
import sbt.librarymanagement.ModuleID;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;

public final class Feedback$ {
    public static Feedback$ MODULE$;
    private final String prefix;
    private final String OnlyCI;
    private final String BintrayInconsistentGpgState;
    private final String SonatypeInconsistentGpgState;
    private final String LogFetchPgpCredentials;
    private final String LogAddSonatypeCredentials;
    private final String forceValidLicense;
    private final String missingBintrayCredentials;
    private final String missingSonatypeCredentials;
    private final String RecommendedScope;
    private final String missingVcsUrl;
    private final String missingDevelopers;
    private final String UnrecognisedPublisher;
    private final String bypassSnapshotSettingKey;
    private final String fixRequirementErrors;

    static {
        new Feedback$();
    }

    private String prefix() {
        return this.prefix;
    }

    private String bold(String toEmbolden) {
        return new StringBuilder(8).append("\u001b[1m").append(toEmbolden).append("\u001b[0m").toString();
    }

    public String OnlyCI() {
        return this.OnlyCI;
    }

    public String skipRelease(String projectName) {
        return new StringBuilder(53).append(this.prefix()).append("Skip release for ").append(projectName).append(" because `publishArtifact` is false.").toString();
    }

    public String skipBintrayCredentialsCheck(String projectName) {
        return new StringBuilder(83).append(this.prefix()).append("Skip check of bintray credentials for ").append(projectName).append(" because underlying publisher is not bintray.").toString();
    }

    public String skipSonatypeCredentialsCheck(String projectName) {
        return new StringBuilder(40).append(this.prefix()).append("Skip check of sonatype credentials for ").append(projectName).append(".").toString();
    }

    public String skipInstantRelease(String projectName, String version) {
        return new StringBuilder(69).append(this.prefix()).append("Skip instant release of ").append(projectName).append(" for version ").append(version).append(". Instant releases are disabled.").toString();
    }

    public String logCheckRequirements(String projectName) {
        return new StringBuilder(27).append(this.prefix()).append("Checking requirements for ").append(projectName).append(".").toString();
    }

    public String logCheckSnapshots(String projectName) {
        return new StringBuilder(37).append(this.prefix()).append("Checking snapshots dependencies for ").append(projectName).append(".").toString();
    }

    public String logValidatePom(String projectName) {
        return new StringBuilder(26).append(this.prefix()).append("Validating POM files for ").append(projectName).append(".").toString();
    }

    public String logSyncToMaven(String projectName) {
        return new StringBuilder(38).append(this.prefix()).append("Syncing ").append(projectName).append("'s artifacts to Maven Central.").toString();
    }

    public String logReleaseEarly(String projectName) {
        return new StringBuilder(31).append(this.prefix()).append("Executing release process for ").append(projectName).append(".").toString();
    }

    public String logReleaseSonatype(String projectName) {
        return new StringBuilder(23).append(this.prefix()).append("Releasing ").append(projectName).append(" to Sonatype.").toString();
    }

    public String logReleaseBintray(String projectName) {
        return new StringBuilder(22).append(this.prefix()).append("Releasing ").append(projectName).append(" to Bintray.").toString();
    }

    public String logResolvingModule(String projectID) {
        return new StringBuilder(46).append(this.prefix()).append("Checking that ").append(projectID).append(" has not already been published.").toString();
    }

    public String logAlreadyPublishedModule(String projectName, String projectID) {
        return new StringBuilder(72).append(this.prefix()).append("Skip release of ").append(projectName).append(" because artifact matching project id '").append(projectID).append("' already exists.").toString();
    }

    public String BintrayInconsistentGpgState() {
        return this.BintrayInconsistentGpgState;
    }

    public String SonatypeInconsistentGpgState() {
        return this.SonatypeInconsistentGpgState;
    }

    public String LogFetchPgpCredentials() {
        return this.LogFetchPgpCredentials;
    }

    public String LogAddSonatypeCredentials() {
        return this.LogAddSonatypeCredentials;
    }

    public String forceValidLicense() {
        return this.forceValidLicense;
    }

    public String missingBintrayCredentials() {
        return this.missingBintrayCredentials;
    }

    public String missingSonatypeCredentials() {
        return this.missingSonatypeCredentials;
    }

    public String RecommendedScope() {
        return this.RecommendedScope;
    }

    public String missingVcsUrl() {
        return this.missingVcsUrl;
    }

    public String missingDevelopers() {
        return this.missingDevelopers;
    }

    public String UnrecognisedPublisher() {
        return this.UnrecognisedPublisher;
    }

    public String unsupportedSnapshot(String version) {
        return new StringBuilder(59).append("{").append(this.prefix()).append("}Detected snapshot version: ").append(version).append(". SNAPSHOTs are not supported.").toString();
    }

    public String skipSyncToMaven(String projectName) {
        return new StringBuilder(44).append(this.prefix()).append("Skipping Maven Central synchronization for ").append(projectName).append(".").toString();
    }

    private String bypassSnapshotSettingKey() {
        return this.bypassSnapshotSettingKey;
    }

    public String detectedSnapshotsDependencies(Seq<ModuleID> deps) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(235).append("\n      |Aborting release process. Snapshot dependencies have been detected:\n      |").append(deps.mkString("\t", "\n", "")).append("\n      |\n      |Releasing artifacts that depend on snapshots produce non-deterministic behaviour.\n      |You can disable this check by enabling `").append(this.bypassSnapshotSettingKey()).append("`.\n    ").toString())).stripMargin();
    }

    public String fixRequirementErrors() {
        return this.fixRequirementErrors;
    }

    private Feedback$() {
        MODULE$ = this;
        this.prefix = new StringBuilder(28).append("\u001b[34m").append("sbt-release-early: ").append("\u001b[0m").toString();
        this.OnlyCI = "The release task was not run inside the CI.";
        this.BintrayInconsistentGpgState = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(212).append(this.prefix()).append("Inconsistent configuration breaks bintray releases of stable versions:\n       |  1. `").append(ReleaseEarlyPlugin$.MODULE$.autoImport().releaseEarlyNoGpg().key().label()).append(" := true` and\n       |  2. `").append(ReleaseEarlyPlugin$.MODULE$.autoImport().releaseEarlyEnableSyncToMaven().key().label()).append(" := true`\n       |\n       |If you ignore gpg completely, you cannot release to Maven Central.\n     ").toString())).stripMargin();
        this.SonatypeInconsistentGpgState = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(196).append(this.prefix()).append("Inconsistent configuration breaks any sonatype release.\n      |\n      |When Sonatype is used as the publisher, `").append(ReleaseEarlyPlugin$.MODULE$.autoImport().releaseEarlyNoGpg().key().label()).append("` cannot be\n      |set to false because Maven Central requires signed releases.\n    ").toString())).stripMargin();
        this.LogFetchPgpCredentials = new StringBuilder(50).append(this.prefix()).append("Trying to fetch `").append(PgpKeys$.MODULE$.pgpPassphrase().key().label()).append(" in Global` from the environment.").toString();
        this.LogAddSonatypeCredentials = new StringBuilder(62).append(this.prefix()).append("Adding sonatype credentials to `").append(Keys$.MODULE$.credentials().key().label()).append("` caught from the environment.").toString();
        this.forceValidLicense = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(106).append("\n      |Maven Central requires your POM files to use a valid license id.\n      |Valid licenses are: ").append(Licenses$.MODULE$.Names()).append(".\n    ").toString())).stripMargin().trim();
        this.missingBintrayCredentials = new StringOps(Predef$.MODULE$.augmentString("\n      |Bintray credentials are missing. Aborting.\n      |Make sure that:\n      |  1. The bintray credentials file exists as required by `sbt-bintray`.\n      |  2. The value of `bintrayCredentialsFile` points to the correct file.\n    ")).stripMargin().trim();
        this.missingSonatypeCredentials = new StringOps(Predef$.MODULE$.augmentString("\n      |Sonatype credentials are missing. Make sure that:\n      |  1. System properties (sona.user and sona.pass) are available; or\n      |  2. Environment variables (SONA_USER and SONA_PASS) are set.\n      |\n      |Otherwise they cannot be fetched programmatically.\n    ")).stripMargin().trim();
        this.RecommendedScope = new StringBuilder(51).append("The recommended scope for either of these keys is ").append(this.bold("`ThisBuild`")).append(".").toString();
        this.missingVcsUrl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(323).append("\n      |The vcs url information is missing. Make sure that:\n      |  * The key `").append(Keys$.MODULE$.scmInfo().key().label()).append("` is defined and correctly scoped; or\n      |  * The key `").append(Keys$.MODULE$.pomExtra().key().label()).append("` does contain the scm url xml node; or\n      |  * The key `").append(BintrayPlugin.autoImport$.MODULE$.bintrayVcsUrl().key().label()).append("` is defined and correctly scoped.\n      |\n      |Use `inspect` to check the scopes of your current definitions.\n      |").append(this.RecommendedScope()).append("\n    ").toString())).stripMargin();
        this.missingDevelopers = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(248).append("\n      |The developers information is missing. Make sure that:\n      |  * The key `").append(Keys$.MODULE$.developers().key()).append("` is defined; or\n      |  * The key `").append(Keys$.MODULE$.pomExtra().key()).append("` contains the `developers` xml node.\n      |\n      |Use `inspect` to check the scopes of your current definitions.\n      |").append(this.RecommendedScope()).append("\n    ").toString())).stripMargin();
        this.UnrecognisedPublisher = new StringBuilder(55).append("{").append(this.prefix()).append("}The publisher backend selected in `").append(ReleaseEarlyPlugin$.MODULE$.autoImport().releaseEarlyWith().key().label()).append("` is unrecognised.").toString();
        this.bypassSnapshotSettingKey = ReleaseEarlyPlugin$.MODULE$.autoImport().releaseEarlyBypassSnapshotCheck().key().label();
        this.fixRequirementErrors = new StringBuilder(53).append(this.prefix()).append("Found errors that need to be fixed before proceeding.").toString();
    }
}

