/*
 * Decompiled with CFR 0.152.
 */
package migrate;

import migrate.interfaces.Lib;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class Messages$ {
    public static Messages$ MODULE$;

    static {
        new Messages$();
    }

    public String welcomeMigration() {
        return "We are going to migrate your project to scala 3";
    }

    public String welcomePrepareMigration() {
        return "We are going to fix some syntax incompatibilities";
    }

    public String notScala213(String scalaVersion, String projectId) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(210).append("\n       |\n       |Error:\n       |\n       |you project must be in 2.13 and not in ").append(scalaVersion).append("\n       |please change the scalaVersion following this command\n       |set ").append(projectId).append(" / scalaVersion := \"2.13.5\"\n       |\n       |\n       |").toString())).stripMargin();
    }

    public String successOfMigration(String projectId, String scala3) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(221).append("|\n        |\n        |").append(projectId).append(" project has successfully been migrated to scala ").append(scala3).append("\n        |You can now commit the change!\n        |You can also execute the compile command:\n        |\n        |").append(projectId).append(" / compile\n        |\n        |\n        |").toString())).stripMargin();
    }

    public String errorMesssageMigration() {
        return new StringOps(Predef$.MODULE$.augmentString("|\n        |\n        |Migration has failed!\n        |\n        |\n        |")).stripMargin();
    }

    public String successMessagePrepareMigration(String projectId, String scala3) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(239).append("|\n        |\n        |We fixed the syntax of this ").append(projectId).append(" to be compatible with ").append(scala3).append("\n        |You can now commit the change!\n        |You can also execute the next command to try to migrate to ").append(scala3).append("\n        |\n        |migrate ").append(projectId).append("\n        |\n        |\n        |").toString())).stripMargin();
    }

    public String errorMessagePrepareMigration(String projectId, Throwable ex) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(98).append("|\n        |\n        |Failed fixing the syntax for ").append(projectId).append(" project\n        |").append(ex.getMessage()).append("\n        |\n        |\n        |").toString())).stripMargin();
    }

    public String migrationScalacOptionsStarting(String projectId) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(69).append("|\n        |\n        |Starting to migrate ScalacOptions for ").append(projectId).append("\n        |").toString())).stripMargin();
    }

    public Option<String> notParsed(Seq<String> s) {
        return s.nonEmpty() ? new Some((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(123).append("|\n               |We were not able to parse the following ScalacOptions:\n               |").append(this.format(s)).append("\n               |\n               |").toString())).stripMargin()) : None$.MODULE$;
    }

    public Option<String> specificToScala2(Seq<String> s) {
        return s.nonEmpty() ? new Some((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(160).append("|\n               |The Following scalacOptions are specific to scala 2 and don't have an equivalent in Scala 3\n               |").append(this.format(s)).append("\n               |\n               |").toString())).stripMargin()) : None$.MODULE$;
    }

    public String migrated(Seq<String> s) {
        return s.nonEmpty() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(147).append("|\n          |You can update your scalacOptions for Scala 3 with the following settings.\n          |").append(this.format(s)).append("\n          |\n          |\n          |\n          |").toString())).stripMargin() : new StringOps(Predef$.MODULE$.augmentString("|\n         |The ScalacOptions for Scala 3 is empty. \n         |\n         |\n         |\n         |")).stripMargin();
    }

    public String migrateLibsStarting(String projectId) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(71).append("|\n        |\n        |Starting to migrate libDependencies for ").append(projectId).append("\n        |").toString())).stripMargin();
    }

    public String notMigratedLibs(Seq<Lib> libs) {
        Tuple2 tuple2 = libs.partition((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isCompilerPlugin()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq compilerPlugins = (Seq)tuple2._1();
        Seq others = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)compilerPlugins, (Object)others);
        Tuple2 tuple23 = tuple22;
        Seq compilerPlugins2 = (Seq)tuple23._1();
        Seq others2 = (Seq)tuple23._2();
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(251).append("|\n        |The following compiler plugins are not supported in scala 3\n        |").append(((TraversableOnce)compilerPlugins2.map((Function1 & java.io.Serializable & Serializable)x$3 -> x$3.toString(), Seq$.MODULE$.canBuildFrom())).mkString("\n")).append("\n        |\n        |\n        |The following list of libs cannot be migrated.\n        |Please check the migration guide for more information. \n        |").append(((TraversableOnce)others2.map((Function1 & java.io.Serializable & Serializable)x$4 -> x$4.toString(), Seq$.MODULE$.canBuildFrom())).mkString("\n")).append("\n        |\n        |").toString())).stripMargin();
    }

    public String migratedLib(Map<Lib, Seq<Lib>> libs) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(135).append("|\n        |\n        |You can update your libs with the following versions: \n        |\n        |").append(this.format(libs)).append("\n        |\n        |\n        |\n        |").toString())).stripMargin();
    }

    private String format(Map<Lib, Seq<Lib>> libs) {
        return ((TraversableOnce)libs.map((Function1 & java.io.Serializable & Serializable)l -> MODULE$.format((Tuple2<Lib, Seq<Lib>>)l), Iterable$.MODULE$.canBuildFrom())).mkString("\n");
    }

    private String format(Tuple2<Lib, Seq<Lib>> l) {
        return new StringBuilder(6).append("\"").append(l._1()).append("\" -> ").append(((TraversableOnce)l._2()).mkString("\"", "\", ", "\"")).toString();
    }

    private String format(Seq<String> l) {
        return l.mkString("Seq(\n\"", "\",\n\"", "\"\n)");
    }

    private Messages$() {
        MODULE$ = this;
    }
}

