/*
 * Decompiled with CFR 0.152.
 */
package migrate;

import java.io.Serializable;
import migrate.ScalaMigratePlugin$;
import migrate.interfaces.Lib;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class Messages$ {
    public static Messages$ MODULE$;
    private final String warnMessageScalacOption;

    static {
        new Messages$();
    }

    public String welcomeMigration(String projectD) {
        return new StringBuilder(49).append("\u001b[1m").append("We are going to migrate your project ").append(projectD).append(" to ").append(ScalaMigratePlugin$.MODULE$.scala3Version()).append("\u001b[0m").toString();
    }

    public String welcomePrepareMigration(String projectD) {
        return new StringBuilder(61).append("\u001b[1m").append("We are going to fix some syntax incompatibilities on ").append(projectD).append("\u001b[0m").toString();
    }

    public String notScala213(String scalaVersion, String projectId) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(210).append("\n       |\n       |Error:\n       |\n       |you project must be in 2.13 and not in ").append(scalaVersion).append("\n       |please change the scalaVersion following this command\n       |set ").append(projectId).append(" / scalaVersion := \"2.13.5\"\n       |\n       |\n       |").toString())).stripMargin();
    }

    public String successOfMigration(String projectId, String scala3) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(221).append("|\n        |\n        |").append(projectId).append(" project has successfully been migrated to scala ").append(scala3).append("\n        |You can now commit the change!\n        |You can also execute the compile command:\n        |\n        |").append(projectId).append(" / compile\n        |\n        |\n        |").toString())).stripMargin();
    }

    public String errorMesssageMigration() {
        return new StringOps(Predef$.MODULE$.augmentString("|\n        |\n        |Migration has failed!\n        |\n        |\n        |")).stripMargin();
    }

    public String successMessagePrepareMigration(String projectId, String scala3) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(238).append("|\n        |The syntax incompatibilities have been fixed on the project ").append(projectId).append("\n        |You can now commit the change!\n        |You can also execute the next command to try to migrate to ").append(scala3).append("\n        |\n        |migrate ").append(projectId).append("\n        |\n        |\n        |").toString())).stripMargin();
    }

    public String errorMessagePrepareMigration(String projectId, Throwable ex) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(98).append("|\n        |\n        |Failed fixing the syntax for ").append(projectId).append(" project\n        |").append(ex.getMessage()).append("\n        |\n        |\n        |").toString())).stripMargin();
    }

    public String migrationScalacOptionsStarting(String projectId) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(71).append("|\n        |").append("\u001b[1m").append("Starting to migrate the scalacOptions for ").append(projectId).append("\u001b[0m").append("\n        |").toString())).stripMargin();
    }

    public String warnMessageScalacOption() {
        return this.warnMessageScalacOption;
    }

    public Option<String> notParsed(Seq<String> s) {
        return s.nonEmpty() ? new Some((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(123).append("|\n               |We were not able to parse the following ScalacOptions:\n               |").append(this.formatScalacOptions(s)).append("\n               |\n               |").toString())).stripMargin()) : None$.MODULE$;
    }

    public String scalacOptionsMessage(Seq<String> removed, Map<String, String> renamed, Seq<String> scala3cOptions, Seq<String> pluginsOption) {
        String removedSign = new StringBuilder(14).append("\u001b[1m").append("\u001b[31m").append("X").append("\u001b[0m").toString();
        String sameSign = new StringBuilder(14).append("\u001b[1m").append("\u001b[36m").append("\u2714").append("\u001b[0m").toString();
        String renamedSign = new StringBuilder(20).append("\u001b[1m").append("\u001b[34m").append("Renamed").append("\u001b[0m").toString();
        return new StringBuilder(0).append(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(331).append("\n       |").append(removedSign).append("         ").append("\u001b[31m").append(": The following scalacOption is specific to Scala 2 and doesn't have an equivalent in Scala 3").append("\u001b[0m").append("\n       |").append(renamedSign).append("   ").append("\u001b[34m").append(": The following scalacOption has been renamed in Scala3").append("\u001b[0m").append("\n       |").append(sameSign).append("         ").append("\u001b[36m").append(": The following scalacOption is a valid Scala 3 option").append("\u001b[0m").append("\n       |\n       |").append(Messages$.formatRemoved$1(removed, removedSign)).append("\n       |").append(Messages$.formatRenamed$1(renamed)).append("\n       |").append(Messages$.formatScala3cOptions$1(scala3cOptions, sameSign)).append("\n       |\n       |").toString())).stripMargin()).append(Messages$.pluginSettingsMessage$1(pluginsOption, sameSign)).toString();
    }

    public String migrateLibsStarting(String projectId) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(79).append("|\n        |\n        |").append("\u001b[1m").append("Starting to migrate libDependencies for ").append(projectId).append("\u001b[0m").append("\n        |").toString())).stripMargin();
    }

    public String notMigratedLibs(Seq<Lib> libs) {
        Tuple2 tuple2 = libs.partition((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isCompilerPlugin()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq compilerPlugins = (Seq)tuple2._1();
        Seq others = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)compilerPlugins, (Object)others);
        Tuple2 tuple23 = tuple22;
        Seq compilerPlugins2 = (Seq)tuple23._1();
        Seq others2 = (Seq)tuple23._2();
        String messageCompilerPlugin = compilerPlugins2.nonEmpty() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(222).append("|\n          |").append("\u001b[33m").append("The following compiler plugins are not supported in scala ").append(ScalaMigratePlugin$.MODULE$.scala3Version()).append("\u001b[0m").append("\n          |").append("\u001b[33m").append("You need to find alternatives. Please check the migration guide for more information.").append("\u001b[0m").append("\n          |\n          |").append(((TraversableOnce)compilerPlugins2.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toString(), Seq$.MODULE$.canBuildFrom())).mkString("\n")).append("\n          |").toString())).stripMargin() : "";
        String messageOtherLibs = others2.nonEmpty() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(194).append("\n           |").append("\u001b[33m").append("The following list of libs cannot be migrated as they contain Macros and are not yet").append("\u001b[0m").append("\n           |").append("\u001b[33m").append("published for ").append(ScalaMigratePlugin$.MODULE$.scala3Version()).append("\u001b[0m").append("\n           |\n           |").append(((TraversableOnce)others2.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.toString(), Seq$.MODULE$.canBuildFrom())).mkString("\n")).append("\n           |\n           |").toString())).stripMargin() : "";
        return new StringBuilder(0).append(messageCompilerPlugin).append(messageOtherLibs).toString();
    }

    public String compilerPluginWithScalacOption(Map<Lib, String> plugins) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(227).append("\n       |The following compiler plugins are not supported in scala ").append(ScalaMigratePlugin$.MODULE$.scala3Version()).append("\n       |but there is an equivalent scalacOption that can replace it.\n       |Add these scalacOptions to your ScalacOptions:\n       |\n       |").append(this.formatCompilerPlugins(plugins)).append("\n       |\n       |").toString())).stripMargin();
    }

    public String migratedLib(Map<Lib, Seq<Lib>> libs) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(142).append("|\n        |\n        |").append("\u001b[1m").append("You can update your libs with the following versions:").append("\u001b[0m").append("\n        |\n        |").append(this.formatLibs(libs)).append("\n        |\n        |\n        |\n        |").toString())).stripMargin();
    }

    private String formatCompilerPlugins(Map<Lib, String> l) {
        return ((TraversableOnce)l.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Lib l = (Lib)tuple2._1();
            String scalacOption = (String)tuple2._2();
            String string = MODULE$.format(l, (Seq<String>)((Seq)new .colon.colon((Object)scalacOption, (List)Nil$.MODULE$)));
            return string;
        }, Iterable$.MODULE$.canBuildFrom())).mkString("\n");
    }

    private String formatLibs(Map<Lib, Seq<Lib>> libs) {
        return ((TraversableOnce)libs.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Lib initial = (Lib)tuple2._1();
            Seq migrated = (Seq)tuple2._2();
            String string = MODULE$.format(initial, (Seq<String>)((Seq)migrated.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.toString(), Seq$.MODULE$.canBuildFrom())));
            return string;
        }, Iterable$.MODULE$.canBuildFrom())).mkString("\n");
    }

    private String format(Lib initial, Seq<String> migrated) {
        return new StringBuilder(15).append("\"").append(initial).append("\" -> ").append("\u001b[32m").append(migrated.mkString(", ")).append("\u001b[0m").toString();
    }

    private String formatScalacOptions(Seq<String> l) {
        return l.mkString("Seq(\n\"", "\",\n\"", "\"\n)");
    }

    private static final String formatRemoved$1(Seq removed$1, String removedSign$1) {
        return ((TraversableOnce)removed$1.map((Function1 & Serializable & scala.Serializable)r -> new StringBuilder(6).append("\"").append((String)r).append("\" -> ").append(removedSign$1).toString(), Seq$.MODULE$.canBuildFrom())).mkString("\n");
    }

    private static final String formatRenamed$1(Map renamed$1) {
        return ((TraversableOnce)renamed$1.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String initial = (String)tuple2._1();
            String renamed = (String)tuple2._2();
            String string = new StringBuilder(22).append("\"").append(initial).append("\" -> ").append("\u001b[1m").append("\u001b[34m").append("\"").append(renamed).append("\"").append("\u001b[34m").toString();
            return string;
        }, Iterable$.MODULE$.canBuildFrom())).mkString("\n");
    }

    private static final String formatScala3cOptions$1(Seq s, String sameSign$1) {
        return ((TraversableOnce)s.map((Function1 & Serializable & scala.Serializable)r -> new StringBuilder(6).append("\"").append((String)r).append("\" -> ").append(sameSign$1).toString(), Seq$.MODULE$.canBuildFrom())).mkString("\n");
    }

    private static final String pluginSettingsMessage$1(Seq pluginsOption$1, String sameSign$1) {
        return pluginsOption$1.isEmpty() ? "" : new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(359).append("|\n            |").append("\u001b[1m").append("The following scalacOption are specific to compiler plugins, usually added through `compilerPlugin` or `addCompilerPlugin`.").append("\u001b[0m").append("\n            |In the previous step `migrate-libs`, you should have removed/fixed compiler plugins and for the remaining plugins and settings, they can be kept as they are.\n            |\n            |").append(Messages$.formatScala3cOptions$1(pluginsOption$1, sameSign$1)).append("\n            |").toString())).stripMargin();
    }

    private Messages$() {
        MODULE$ = this;
        this.warnMessageScalacOption = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(180).append("|").append("\u001b[33m").append("Some scalacOptions are set by sbt plugins and don't need to be modified, removed or added.").append("\u001b[0m").append("\n        |").append("\u001b[33m").append("The sbt plugin should adapt its own scalacOptions for Scala 3").append("\u001b[0m").toString())).stripMargin();
    }
}

