/*
 * Decompiled with CFR 0.152.
 */
package migrate;

import java.io.Serializable;
import migrate.ScalaMigratePlugin$;
import migrate.interfaces.Lib;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;

public final class Messages$ {
    public static Messages$ MODULE$;
    private final String warnMessageScalacOption;

    static {
        new Messages$();
    }

    public String welcomeMigration(String projectD) {
        return new StringBuilder(49).append("\u001b[1m").append("We are going to migrate your project ").append(projectD).append(" to ").append(ScalaMigratePlugin$.MODULE$.scala3Version()).append("\u001b[0m").toString();
    }

    public String welcomeMigrateSyntax(String projectD) {
        return new StringBuilder(61).append("\u001b[1m").append("We are going to fix some syntax incompatibilities on ").append(projectD).append("\u001b[0m").toString();
    }

    public String notScala213(String scalaVersion, String projectId) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(226).append("\n       |\n       |Error:\n       |\n       |you project must be in 2.13 and not in ").append(scalaVersion).append("\n       |please change the scalaVersion following this command\n       |set LocalProject(\"").append(projectId).append("\") / scalaVersion := \"2.13.5\"\n       |\n       |\n       |").toString())).stripMargin();
    }

    public String successOfMigration(String projectId, String scala3) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(221).append("|\n        |\n        |").append(projectId).append(" project has successfully been migrated to scala ").append(scala3).append("\n        |You can now commit the change!\n        |You can also execute the compile command:\n        |\n        |").append(projectId).append(" / compile\n        |\n        |\n        |").toString())).stripMargin();
    }

    public String errorMesssageMigration(Option<Throwable> exceptionOpt) {
        String exceptionError = (String)exceptionOpt.map((Function1 & Serializable & scala.Serializable)error -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(38).append("|because of ").append(error.getMessage()).append("\n                        |").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])error.getStackTrace())).mkString("\n")).toString())).stripMargin()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(71).append("|\n        |\n        |Migration has failed\n        |").append(exceptionError).append("\n        |\n        |").toString())).stripMargin();
    }

    public String successMessageMigrateSyntax(String projectId, String scala3) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(238).append("|\n        |The syntax incompatibilities have been fixed on the project ").append(projectId).append("\n        |You can now commit the change!\n        |You can also execute the next command to try to migrate to ").append(scala3).append("\n        |\n        |migrate ").append(projectId).append("\n        |\n        |\n        |").toString())).stripMargin();
    }

    public String errorMessageMigrateSyntax(String projectId, Throwable ex) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(108).append("|\n        |\n        |Failed fixing the syntax for ").append(projectId).append(" project\n        |").append(ex.getMessage()).append("\n        |").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ex.getStackTrace())).mkString("\n")).append("\n        |\n        |\n        |").toString())).stripMargin();
    }

    public String migrationScalacOptionsStarting(String projectId) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(71).append("|\n        |").append("\u001b[1m").append("Starting to migrate the scalacOptions for ").append(projectId).append("\u001b[0m").append("\n        |").toString())).stripMargin();
    }

    public String warnMessageScalacOption() {
        return this.warnMessageScalacOption;
    }

    public Option<String> notParsed(Seq<String> s) {
        return s.nonEmpty() ? new Some((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(123).append("|\n               |We were not able to parse the following ScalacOptions:\n               |").append(this.formatScalacOptions(s)).append("\n               |\n               |").toString())).stripMargin()) : None$.MODULE$;
    }

    public String scalacOptionsMessage(Seq<String> removed, Map<String, String> renamed, Seq<String> scala3cOptions, Seq<String> pluginsOption) {
        String removedSign = new StringBuilder(14).append("\u001b[1m").append("\u001b[31m").append("X").append("\u001b[0m").toString();
        String sameSign = new StringBuilder(18).append("\u001b[1m").append("\u001b[36m").append("Valid").append("\u001b[0m").toString();
        String renamedSign = new StringBuilder(20).append("\u001b[1m").append("\u001b[34m").append("Renamed").append("\u001b[0m").toString();
        int spacesHelp = this.computeLongestValue((Seq<String>)((Seq)new .colon.colon((Object)removedSign, (List)new .colon.colon((Object)sameSign, (List)new .colon.colon((Object)renamedSign, (List)Nil$.MODULE$)))));
        int spaceScalacOption = this.computeLongestValue((Seq<String>)((Seq)((TraversableLike)removed.$plus$plus((GenTraversableOnce)renamed.keys(), Seq$.MODULE$.canBuildFrom())).$plus$plus(scala3cOptions, Seq$.MODULE$.canBuildFrom())));
        String help = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(312).append("\n                  |").append(this.formatValueWithSpace(removedSign, spacesHelp)).append(" ").append("\u001b[31m").append(": The following scalacOption is specific to Scala 2 and doesn't have an equivalent in Scala 3").append("\u001b[0m").append("\n                  |").append(this.formatValueWithSpace(renamedSign, spacesHelp)).append(" ").append("\u001b[34m").append(": The following scalacOption has been renamed in Scala3").append("\u001b[0m").append("\n                  |").append(this.formatValueWithSpace(sameSign, spacesHelp)).append(" ").append("\u001b[36m").append(": The following scalacOption is a valid Scala 3 option").append("\u001b[0m").append("\n                  |").toString())).stripMargin();
        return ((TraversableOnce)((TraversableLike)new .colon.colon((Object)help, (List)new .colon.colon((Object)Messages$.formatRemoved$1(spaceScalacOption, removed, removedSign), (List)new .colon.colon((Object)Messages$.formatRenamed$1(spaceScalacOption, renamed), (List)new .colon.colon((Object)Messages$.formatScala3cOptions$1(scala3cOptions, spaceScalacOption, sameSign), (List)new .colon.colon((Object)this.pluginSettingsMessage$1(pluginsOption, sameSign), (List)Nil$.MODULE$)))))).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isEmpty()))).mkString("\n");
    }

    public String migrateLibsStarting(String projectId) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(79).append("|\n        |\n        |").append("\u001b[1m").append("Starting to migrate libDependencies for ").append(projectId).append("\u001b[0m").append("\n        |").toString())).stripMargin();
    }

    public String messageForLibs(Seq<Lib> notMigrated, Seq<Lib> validLibs, Map<Lib, Seq<Lib>> toUpdate, Map<Lib, String> compilerPluginsWithScalacOption) {
        String removedSign = new StringBuilder(14).append("\u001b[1m").append("\u001b[31m").append("X").append("\u001b[0m").toString();
        String validSign = new StringBuilder(18).append("\u001b[1m").append("\u001b[36m").append("Valid").append("\u001b[0m").toString();
        String toBeUpdated = new StringBuilder(26).append("\u001b[1m").append("\u001b[34m").append("To be updated").append("\u001b[0m").toString();
        String commentMacro = new StringBuilder(58).append("\u001b[1m").append("\u001b[33m").append("Contains Macros and is not yet published for ").append(ScalaMigratePlugin$.MODULE$.scala3Version()).append("\u001b[0m").toString();
        String commentCompilerPlugin = new StringBuilder(98).append("\u001b[1m").append("\u001b[33m").append("Scala 2 compiler plugins are not supported in scala ").append(ScalaMigratePlugin$.MODULE$.scala3Version()).append(". You need to find an alternative").append("\u001b[0m").toString();
        String commentCompilerWithScalacOption = new StringBuilder(93).append("\u001b[1m").append("\u001b[33m").append("This compiler plugin has a scalacOption equivalent. Add it to your scalacOptions").append("\u001b[0m").toString();
        int spacesForLib = this.computeLongestValue((Seq<String>)((Seq)((TraversableLike)((TraversableLike)((TraversableLike)notMigrated.$plus$plus(validLibs, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)toUpdate.keys(), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)compilerPluginsWithScalacOption.keys(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toString(), Seq$.MODULE$.canBuildFrom())));
        Seq notMigratedWithComments = (Seq)notMigrated.map((Function1 & Serializable & scala.Serializable)lib -> lib.isCompilerPlugin() ? new Tuple2(lib, (Object)commentCompilerPlugin) : new Tuple2(lib, (Object)commentMacro), Seq$.MODULE$.canBuildFrom());
        int spacesForHelp = this.computeLongestValue((Seq<String>)((Seq)new .colon.colon((Object)removedSign, (List)new .colon.colon((Object)validSign, (List)new .colon.colon((Object)toBeUpdated, (List)Nil$.MODULE$)))));
        String help = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(222).append("\n                  |").append(this.formatValueWithSpace(removedSign, spacesForHelp)).append(" ").append("\u001b[31m").append(": Cannot be updated to scala 3").append("\u001b[0m").append("\n                  |").append(this.formatValueWithSpace(validSign, spacesForHelp)).append(" ").append("\u001b[36m").append(": Already a valid version for Scala 3").append("\u001b[0m").append("\n                  |").append(this.formatValueWithSpace(toBeUpdated, spacesForHelp)).append(" ").append("\u001b[34m").append(": Need to be updated to the following version").append("\u001b[0m").append("\n                  |").toString())).stripMargin();
        return ((TraversableOnce)((TraversableLike)new .colon.colon((Object)help, (List)new .colon.colon((Object)Messages$.formatNotMigrated$1(notMigratedWithComments, spacesForLib, removedSign), (List)new .colon.colon((Object)Messages$.formatValid$1(validLibs, spacesForLib, validSign), (List)new .colon.colon((Object)this.formatLibs(toUpdate, spacesForLib), (List)new .colon.colon((Object)Messages$.formatCompilerPlugins$1(compilerPluginsWithScalacOption, spacesForLib, commentCompilerWithScalacOption), (List)Nil$.MODULE$)))))).filterNot((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isEmpty()))).mkString("\n");
    }

    public int computeLongestValue(Seq<String> values) {
        return values.isEmpty() ? 0 : ((String)values.maxBy((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.length()), (Ordering)Ordering.Int$.MODULE$)).length();
    }

    public String formatValueWithSpace(String value, int longestValue) {
        String numberOfSpaces = new StringOps(Predef$.MODULE$.augmentString(" ")).$times(longestValue - value.length());
        return new StringBuilder(0).append(value).append(numberOfSpaces).toString();
    }

    private String formatLibs(Map<Lib, Seq<Lib>> libs, int longestValue) {
        return ((TraversableOnce)libs.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Lib initial = (Lib)tuple2._1();
            Seq migrated = (Seq)tuple2._2();
            String string = MODULE$.format(initial, (Seq<String>)((Seq)migrated.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.toString(), Seq$.MODULE$.canBuildFrom())), longestValue);
            return string;
        }, Iterable$.MODULE$.canBuildFrom())).mkString("\n");
    }

    private String format(Lib initial, Seq<String> migrated, int longestValue) {
        String numberOfSpaces = new StringOps(Predef$.MODULE$.augmentString(" ")).$times(longestValue - initial.toString().length());
        return new StringBuilder(13).append(initial).append(numberOfSpaces).append(" -> ").append("\u001b[32m").append(migrated.mkString(", ")).append("\u001b[0m").toString();
    }

    private String formatScalacOptions(Seq<String> l) {
        return l.mkString("Seq(\n\"", "\",\n\"", "\"\n)");
    }

    private static final String formatRemoved$1(int longest, Seq removed$1, String removedSign$1) {
        return ((TraversableOnce)removed$1.map((Function1 & Serializable & scala.Serializable)r -> new StringBuilder(4).append(MODULE$.formatValueWithSpace((String)r, longest)).append(" -> ").append(removedSign$1).toString(), Seq$.MODULE$.canBuildFrom())).mkString("\n");
    }

    private static final String formatRenamed$1(int longest, Map renamed$1) {
        return ((TraversableOnce)renamed$1.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String initial = (String)tuple2._1();
            String renamed = (String)tuple2._2();
            String string = new StringBuilder(18).append(MODULE$.formatValueWithSpace(initial, longest)).append(" -> ").append("\u001b[1m").append("\u001b[34m").append(renamed).append("\u001b[34m").toString();
            return string;
        }, Iterable$.MODULE$.canBuildFrom())).mkString("\n");
    }

    private static final String formatScala3cOptions$1(Seq s, int spaces, String sameSign$1) {
        return ((TraversableOnce)s.map((Function1 & Serializable & scala.Serializable)r -> new StringBuilder(4).append(MODULE$.formatValueWithSpace((String)r, spaces)).append(" -> ").append(sameSign$1).toString(), Seq$.MODULE$.canBuildFrom())).mkString("\n");
    }

    private final String pluginSettingsMessage$1(Seq pluginsOption$1, String sameSign$1) {
        String string;
        if (pluginsOption$1.isEmpty()) {
            string = "";
        } else {
            int longestValue = this.computeLongestValue((Seq<String>)pluginsOption$1);
            string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(359).append("|\n            |").append("\u001b[1m").append("The following scalacOption are specific to compiler plugins, usually added through `compilerPlugin` or `addCompilerPlugin`.").append("\u001b[0m").append("\n            |In the previous step `migrate-libs`, you should have removed/fixed compiler plugins and for the remaining plugins and settings, they can be kept as they are.\n            |\n            |").append(Messages$.formatScala3cOptions$1(pluginsOption$1, longestValue, sameSign$1)).append("\n            |").toString())).stripMargin();
        }
        return string;
    }

    private static final String formatCompilerPlugins$1(Map compilerPluginsWithScalacOption$1, int spacesForLib$1, String commentCompilerWithScalacOption$1) {
        return ((TraversableOnce)compilerPluginsWithScalacOption$1.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Lib l = (Lib)tuple2._1();
            String scalacOption = (String)tuple2._2();
            String string = new StringBuilder(3).append(MODULE$.format(l, (Seq<String>)((Seq)new .colon.colon((Object)scalacOption, (List)Nil$.MODULE$)), spacesForLib$1)).append(" : ").append(commentCompilerWithScalacOption$1).toString();
            return string;
        }, Iterable$.MODULE$.canBuildFrom())).mkString("\n");
    }

    private static final String formatNotMigrated$1(Seq notMigratedWithComments$1, int spacesForLib$1, String removedSign$2) {
        return ((TraversableOnce)notMigratedWithComments$1.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Lib lib = (Lib)tuple2._1();
            String comment = (String)tuple2._2();
            String string = new StringBuilder(7).append(MODULE$.formatValueWithSpace(lib.toString(), spacesForLib$1)).append(" -> ").append(removedSign$2).append(" : ").append(comment).toString();
            return string;
        }, Seq$.MODULE$.canBuildFrom())).mkString("\n");
    }

    private static final String formatValid$1(Seq validLibs$1, int spacesForLib$1, String validSign$1) {
        return ((TraversableOnce)validLibs$1.map((Function1 & Serializable & scala.Serializable)lib -> new StringBuilder(4).append(MODULE$.formatValueWithSpace(lib.toString(), spacesForLib$1)).append(" -> ").append(validSign$1).toString(), Seq$.MODULE$.canBuildFrom())).mkString("\n");
    }

    private Messages$() {
        MODULE$ = this;
        this.warnMessageScalacOption = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(180).append("|").append("\u001b[33m").append("Some scalacOptions are set by sbt plugins and don't need to be modified, removed or added.").append("\u001b[0m").append("\n        |").append("\u001b[33m").append("The sbt plugin should adapt its own scalacOptions for Scala 3").append("\u001b[0m").toString())).stripMargin();
    }
}

