/*
 * Decompiled with CFR 0.152.
 */
package migrate;

import coursier.core.Authentication;
import coursier.core.Authentication$;
import coursier.core.Repository;
import java.io.Serializable;
import lmcoursier.CoursierConfiguration;
import lmcoursier.internal.ResolutionParams$;
import migrate.Messages$;
import migrate.ScalaMigratePlugin$;
import migrate.interfaces.Migrate;
import migrate.internal.CrossCompatibleLibrary;
import migrate.internal.IncompatibleLibrary;
import migrate.internal.InitialLib;
import migrate.internal.InitialLib$;
import migrate.internal.IntegratedPlugin;
import migrate.internal.LibraryMigration$;
import migrate.internal.MigratedLib;
import migrate.internal.Resolvers$;
import migrate.internal.UnclassifiedLibrary;
import migrate.internal.UpdatedVersion;
import migrate.internal.ValidLibrary;
import sbt.Def$;
import sbt.Keys$;
import sbt.ResolvedProject;
import sbt.Scoped;
import sbt.Task;
import sbt.internal.util.AList$;
import sbt.internal.util.Init;
import sbt.internal.util.ManagedLogger;
import sbt.internal.util.MessageOnlyException;
import sbt.librarymanagement.ModuleID;
import sbt.librarymanagement.Resolver;
import sbt.package$;
import sbt.std.FullInstance$;
import sbt.std.TaskStreams;
import sbt.util.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector$;
import scala.runtime.BoxedUnit;

public final class LibsMigration$ {
    public static LibsMigration$ MODULE$;
    private final Init.Initialize<Task<BoxedUnit>> internalImpl;

    static {
        new LibsMigration$();
    }

    public Init.Initialize<Task<BoxedUnit>> internalImpl() {
        return this.internalImpl;
    }

    private String startingMessage(String projectId) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(95).append("|\n        |").append("\u001b[1m").append("Starting migration of libraries and compiler plugins in project '").append(projectId).append("'").append("\u001b[0m").append("\n        |").toString())).stripMargin();
    }

    private String validMessage(Seq<MigratedLib> validLibs) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(63).append("|\n        |").append("\u001b[32m").append("\u001b[1m").append("Valid dependencies:").append("\u001b[0m").append("\n        |").append(((TraversableOnce)validLibs.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.formatted(), Seq$.MODULE$.canBuildFrom())).mkString("\n")).append("\n        |").toString())).stripMargin();
    }

    private String updatedVersionsMessage(Seq<MigratedLib> updatedVersions) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(63).append("|\n        |").append("\u001b[33m").append("\u001b[1m").append("Versions to update:").append("\u001b[0m").append("\n        |").append(((TraversableOnce)updatedVersions.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.formatted(), Seq$.MODULE$.canBuildFrom())).mkString("\n")).append("\n        |").toString())).stripMargin();
    }

    private String crossCompatibleMessage(Seq<MigratedLib> crossCompatible) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(65).append("|\n        |").append("\u001b[33m").append("\u001b[1m").append("For Scala 3 use 2.13:").append("\u001b[0m").append("\n        |").append(((TraversableOnce)crossCompatible.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.formatted(), Seq$.MODULE$.canBuildFrom())).mkString("\n")).append("\n        |").toString())).stripMargin();
    }

    private String integratedPluginMessage(Seq<MigratedLib> compilerPlugins) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(72).append("|\n        |").append("\u001b[33m").append("\u001b[1m").append("Integrated compiler plugins:").append("\u001b[0m").append("\n        |").append(((TraversableOnce)compilerPlugins.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.formatted(), Seq$.MODULE$.canBuildFrom())).mkString("\n")).append("\n        |").toString())).stripMargin();
    }

    private String unclassifiedMessage(Seq<MigratedLib> unclassifiedLibraries) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(67).append("|\n        |").append("\u001b[33m").append("\u001b[1m").append("Unclassified Libraries:").append("\u001b[0m").append("\n        |").append(((TraversableOnce)unclassifiedLibraries.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.formatted(), Seq$.MODULE$.canBuildFrom())).mkString("\n")).append("\n        |").toString())).stripMargin();
    }

    private String incompatibleMessage(Seq<MigratedLib> incompatibleLibraries) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(67).append("|\n        |").append("\u001b[31m").append("\u001b[1m").append("Incompatible Libraries:").append("\u001b[0m").append("\n        |").append(((TraversableOnce)incompatibleLibraries.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.formatted(), Seq$.MODULE$.canBuildFrom())).mkString("\n")).append("\n        |").toString())).stripMargin();
    }

    private Seq<Repository> getCoursierRepositories(CoursierConfiguration conf, Logger log) {
        Map ivyProperties = ResolutionParams$.MODULE$.defaultIvyProperties(conf.ivyHome());
        Map authenticationByRepositoryId = conf.authenticationByRepositoryId().toMap(Predef$.MODULE$.$conforms());
        return (Seq)conf.resolvers().flatMap((Function1 & Serializable & scala.Serializable)resolver -> Option$.MODULE$.option2Iterable(Resolvers$.MODULE$.repository((Resolver)resolver, (Map<String, String>)ivyProperties, log, (Option<Authentication>)authenticationByRepositoryId.get((Object)resolver.name()).map((Function1 & Serializable & scala.Serializable)authentication -> MODULE$.toCoursier((lmcoursier.definitions.Authentication)authentication)), (Seq<ClassLoader>)((Seq)Nil$.MODULE$))), Vector$.MODULE$.canBuildFrom());
    }

    private Authentication toCoursier(lmcoursier.definitions.Authentication authentication) {
        return Authentication$.MODULE$.apply(authentication.user(), authentication.password()).withOptional(authentication.optional()).withRealmOpt(authentication.realmOpt()).withHttpHeaders(authentication.headers()).withHttpsOnly(authentication.httpsOnly()).withPassOnRedirect(authentication.passOnRedirect());
    }

    public static final /* synthetic */ void $anonfun$internalImpl$1(Tuple5 $p$macro$6) {
        Seq incompatibleLibraries;
        Seq unclassifiedLibraries;
        Seq integratedPlugins;
        Seq crossCompatibleLibs;
        Seq updatedVersions;
        CoursierConfiguration coursierConfiguration = (CoursierConfiguration)$p$macro$6._1();
        Seq seq = (Seq)$p$macro$6._2();
        String string = (String)$p$macro$6._3();
        ResolvedProject resolvedProject = (ResolvedProject)$p$macro$6._4();
        TaskStreams taskStreams = (TaskStreams)$p$macro$6._5();
        ManagedLogger log = taskStreams.log();
        String projectId = resolvedProject.id();
        String scalaVersion = string;
        Seq libraryDependencies = seq;
        CoursierConfiguration csrConfig = coursierConfiguration;
        if (!scalaVersion.startsWith("2.13.") && !scalaVersion.startsWith("3.")) {
            throw new MessageOnlyException(Messages$.MODULE$.notScala213(scalaVersion, projectId));
        }
        log.info((Function0 & Serializable & scala.Serializable)() -> MODULE$.startingMessage(projectId));
        Seq<Repository> repositories = MODULE$.getCoursierRepositories(csrConfig, (Logger)log);
        Migrate migrateAPI = ScalaMigratePlugin$.MODULE$.getMigrateInstance((Logger)log);
        Seq<MigratedLib> migrated = LibraryMigration$.MODULE$.migrateLibs((Seq<InitialLib>)((Seq)libraryDependencies.map((Function1 & Serializable & scala.Serializable)lib -> InitialLib$.MODULE$.apply((ModuleID)lib), Seq$.MODULE$.canBuildFrom())), repositories);
        Seq validLibs = (Seq)migrated.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends MigratedLib, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof ValidLibrary) {
                    ValidLibrary validLibrary = (ValidLibrary)A1;
                    return (B1)validLibrary;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(MigratedLib x1) {
                MigratedLib migratedLib = x1;
                return migratedLib instanceof ValidLibrary;
            }
        }, Seq$.MODULE$.canBuildFrom());
        if (validLibs.nonEmpty()) {
            log.info((Function0 & Serializable & scala.Serializable)() -> MODULE$.validMessage((Seq<MigratedLib>)validLibs));
        }
        if ((updatedVersions = (Seq)migrated.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends MigratedLib, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                if (A1 instanceof UpdatedVersion) {
                    UpdatedVersion updatedVersion = (UpdatedVersion)A1;
                    return (B1)updatedVersion;
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(MigratedLib x2) {
                MigratedLib migratedLib = x2;
                return migratedLib instanceof UpdatedVersion;
            }
        }, Seq$.MODULE$.canBuildFrom())).nonEmpty()) {
            log.warn((Function0 & Serializable & scala.Serializable)() -> MODULE$.updatedVersionsMessage((Seq<MigratedLib>)updatedVersions));
        }
        if ((crossCompatibleLibs = (Seq)migrated.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends MigratedLib, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                A1 A1 = x3;
                if (A1 instanceof CrossCompatibleLibrary) {
                    CrossCompatibleLibrary crossCompatibleLibrary = (CrossCompatibleLibrary)A1;
                    return (B1)crossCompatibleLibrary;
                }
                return (B1)function1.apply(x3);
            }

            public final boolean isDefinedAt(MigratedLib x3) {
                MigratedLib migratedLib = x3;
                return migratedLib instanceof CrossCompatibleLibrary;
            }
        }, Seq$.MODULE$.canBuildFrom())).nonEmpty()) {
            log.warn((Function0 & Serializable & scala.Serializable)() -> MODULE$.crossCompatibleMessage((Seq<MigratedLib>)crossCompatibleLibs));
        }
        if ((integratedPlugins = (Seq)migrated.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends MigratedLib, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                A1 A1 = x4;
                if (A1 instanceof IntegratedPlugin) {
                    IntegratedPlugin integratedPlugin = (IntegratedPlugin)A1;
                    return (B1)integratedPlugin;
                }
                return (B1)function1.apply(x4);
            }

            public final boolean isDefinedAt(MigratedLib x4) {
                MigratedLib migratedLib = x4;
                return migratedLib instanceof IntegratedPlugin;
            }
        }, Seq$.MODULE$.canBuildFrom())).nonEmpty()) {
            log.warn((Function0 & Serializable & scala.Serializable)() -> MODULE$.integratedPluginMessage((Seq<MigratedLib>)integratedPlugins));
        }
        if ((unclassifiedLibraries = (Seq)migrated.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends MigratedLib, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                A1 A1 = x5;
                if (A1 instanceof UnclassifiedLibrary) {
                    UnclassifiedLibrary unclassifiedLibrary = (UnclassifiedLibrary)A1;
                    return (B1)unclassifiedLibrary;
                }
                return (B1)function1.apply(x5);
            }

            public final boolean isDefinedAt(MigratedLib x5) {
                MigratedLib migratedLib = x5;
                return migratedLib instanceof UnclassifiedLibrary;
            }
        }, Seq$.MODULE$.canBuildFrom())).nonEmpty()) {
            log.warn((Function0 & Serializable & scala.Serializable)() -> MODULE$.unclassifiedMessage((Seq<MigratedLib>)unclassifiedLibraries));
        }
        if ((incompatibleLibraries = (Seq)migrated.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends MigratedLib, B1> B1 applyOrElse(A1 x6, Function1<A1, B1> function1) {
                A1 A1 = x6;
                if (A1 instanceof IncompatibleLibrary) {
                    IncompatibleLibrary incompatibleLibrary = (IncompatibleLibrary)A1;
                    return (B1)incompatibleLibrary;
                }
                return (B1)function1.apply(x6);
            }

            public final boolean isDefinedAt(MigratedLib x6) {
                MigratedLib migratedLib = x6;
                return migratedLib instanceof IncompatibleLibrary;
            }
        }, Seq$.MODULE$.canBuildFrom())).nonEmpty()) {
            log.error((Function0 & Serializable & scala.Serializable)() -> MODULE$.incompatibleMessage((Seq<MigratedLib>)incompatibleLibraries));
        }
        log.info((Function0 & Serializable & scala.Serializable)() -> "\n");
    }

    private LibsMigration$() {
        MODULE$ = this;
        this.internalImpl = (Init.Initialize)FullInstance$.MODULE$.app((Object)new Tuple5(package$.MODULE$.sbtSlashSyntaxRichScopeFromScoped((Scoped)Keys$.MODULE$.updateClassifiers()).$div((Scoped.ScopingSetting)Keys$.MODULE$.csrConfiguration()), (Object)Def$.MODULE$.toITask((Init.Initialize)Keys$.MODULE$.libraryDependencies()), (Object)Def$.MODULE$.toITask((Init.Initialize)Keys$.MODULE$.scalaVersion()), (Object)Def$.MODULE$.toITask((Init.Initialize)Keys$.MODULE$.thisProject()), (Object)Keys$.MODULE$.streams()), (Function1 & Serializable & scala.Serializable)$p$macro$6 -> {
            LibsMigration$.$anonfun$internalImpl$1($p$macro$6);
            return BoxedUnit.UNIT;
        }, AList$.MODULE$.tuple5());
    }
}

