/*
 * Decompiled with CFR 0.152.
 */
package migrate.internal;

import coursier.core.Repository;
import java.io.Serializable;
import migrate.BuildInfo$;
import migrate.internal.CoursierHelper$;
import migrate.internal.CrossCompatibleLibrary;
import migrate.internal.IncompatibleLibrary;
import migrate.internal.InitialLib;
import migrate.internal.InitialLib$;
import migrate.internal.IntegratedPlugin;
import migrate.internal.MigratedLib;
import migrate.internal.UnclassifiedLibrary;
import migrate.internal.UpdatedVersion;
import migrate.internal.ValidLibrary;
import sbt.librarymanagement.Binary;
import sbt.librarymanagement.Binary$;
import sbt.librarymanagement.Constant;
import sbt.librarymanagement.CrossVersion;
import sbt.librarymanagement.CrossVersion$;
import sbt.librarymanagement.Disabled$;
import sbt.librarymanagement.For2_13Use3;
import sbt.librarymanagement.For3Use2_13;
import sbt.librarymanagement.Full;
import sbt.librarymanagement.Patch;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class LibraryMigration$ {
    public static LibraryMigration$ MODULE$;

    static {
        new LibraryMigration$();
    }

    public Seq<MigratedLib> migrateLibs(Seq<InitialLib> libs, Seq<Repository> repositories) {
        Seq filteredLibs = (Seq)libs.filterNot((Function1 & Serializable & scala.Serializable)l -> BoxesRunTime.boxToBoolean((boolean)LibraryMigration$.$anonfun$migrateLibs$1(l)));
        return (Seq)filteredLibs.map((Function1 & Serializable & scala.Serializable)x$1 -> MODULE$.migrateLib((InitialLib)x$1, repositories), Seq$.MODULE$.canBuildFrom());
    }

    public MigratedLib migrateLib(InitialLib lib, Seq<Repository> repositories) {
        if (lib.isCompilerPlugin()) {
            return this.migrateCompilerPlugin(lib, repositories);
        }
        return this.migrateRegularLib(lib, repositories);
    }

    public MigratedLib migrateRegularLib(InitialLib lib, Seq<Repository> repositories) {
        String FullBinaryVersion = "2\\.13\\..*";
        boolean bl = false;
        Constant constant = null;
        CrossVersion crossVersion = lib.crossVersion();
        if (Disabled$.MODULE$.equals(crossVersion)) {
            return this.tryParseBinaryVersionAndMigrate(lib, repositories);
        }
        if (crossVersion instanceof For2_13Use3) {
            return new ValidLibrary(lib);
        }
        if (crossVersion instanceof For3Use2_13) {
            return new ValidLibrary(lib);
        }
        if (crossVersion instanceof Binary) {
            return this.migrateBinaryVersion(lib, repositories);
        }
        if (crossVersion instanceof Full) {
            return this.migrateFullCrossVersion(lib, repositories);
        }
        if (crossVersion instanceof Patch) {
            return this.migrateFullCrossVersion(lib, repositories);
        }
        if (crossVersion instanceof Constant) {
            bl = true;
            constant = (Constant)crossVersion;
            String string = constant.value();
            String string2 = "2.13";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                Binary x$1 = Binary$.MODULE$.apply("", "");
                String x$2 = lib.copy$default$1();
                String x$3 = lib.copy$default$2();
                String x$4 = lib.copy$default$3();
                Option<String> x$5 = lib.copy$default$5();
                return this.migrateBinaryVersion(lib.copy(x$2, x$3, x$4, (CrossVersion)x$1, x$5), repositories);
            }
        }
        if (bl && constant.value().matches("2\\.13\\..*")) {
            Binary x$6 = Binary$.MODULE$.apply("", "");
            String x$7 = lib.copy$default$1();
            String x$8 = lib.copy$default$2();
            String x$9 = lib.copy$default$3();
            Option<String> x$10 = lib.copy$default$5();
            return this.migrateFullCrossVersion(lib.copy(x$7, x$8, x$9, (CrossVersion)x$6, x$10), repositories);
        }
        if (bl) {
            return new UnclassifiedLibrary(lib, new StringBuilder(25).append("Unsupported CrossVersion.").append(constant).toString());
        }
        throw new MatchError((Object)crossVersion);
    }

    private MigratedLib tryParseBinaryVersionAndMigrate(InitialLib lib, Seq<Repository> repositories) {
        Regex FullBinaryVersion = new StringOps(Predef$.MODULE$.augmentString("2\\.13\\..*")).r();
        List list = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])lib.name().split("_"))).toList();
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            String name = (String)colon2.head();
            List list2 = colon2.tl$access$1();
            if (list2 instanceof .colon.colon) {
                .colon.colon colon3 = (.colon.colon)list2;
                String suffix = (String)colon3.head();
                List list3 = colon3.tl$access$1();
                if (Nil$.MODULE$.equals(list3)) {
                    String string = suffix;
                    if ("2.13".equals(string)) {
                        String x$1 = name;
                        Binary x$2 = CrossVersion$.MODULE$.Binary().apply("", "");
                        String x$3 = lib.copy$default$1();
                        String x$4 = lib.copy$default$3();
                        Option<String> x$5 = lib.copy$default$5();
                        InitialLib newLib = lib.copy(x$3, x$1, x$4, (CrossVersion)x$2, x$5);
                        return this.migrateBinaryVersion(newLib, repositories);
                    }
                    Option option = FullBinaryVersion.unapplySeq((CharSequence)string);
                    if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                        String x$6 = name;
                        Full x$7 = CrossVersion$.MODULE$.Full().apply("", "");
                        String x$8 = lib.copy$default$1();
                        String x$9 = lib.copy$default$3();
                        Option<String> x$10 = lib.copy$default$5();
                        InitialLib newLib = lib.copy(x$8, x$6, x$9, (CrossVersion)x$7, x$10);
                        return this.migrateFullCrossVersion(newLib, repositories);
                    }
                    return new ValidLibrary(lib);
                }
            }
        }
        return new ValidLibrary(lib);
    }

    private MigratedLib migrateBinaryVersion(InitialLib lib, Seq<Repository> repositories) {
        if (CoursierHelper$.MODULE$.isCompatible(lib, "3", repositories)) {
            return new ValidLibrary(lib);
        }
        List list = CoursierHelper$.MODULE$.findNewerVersions(lib, "3", repositories).toList();
        if (Nil$.MODULE$.equals(list)) {
            if (lib.isCompilerPlugin()) {
                return new IncompatibleLibrary(lib, "Compiler Plugin");
            }
            if (InitialLib$.MODULE$.macroLibraries().contains((Object)new Tuple2((Object)lib.organization(), (Object)lib.name()))) {
                return new IncompatibleLibrary(lib, "Macro Library");
            }
            return new CrossCompatibleLibrary(lib);
        }
        return new UpdatedVersion(lib, (Seq<String>)list);
    }

    private MigratedLib migrateFullCrossVersion(InitialLib lib, Seq<Repository> repositories) {
        Seq<String> seq = CoursierHelper$.MODULE$.findNewerVersions(lib, BuildInfo$.MODULE$.scala3Version(), repositories);
        if (Nil$.MODULE$.equals(seq)) {
            String reason = lib.isCompilerPlugin() ? "Compiler plugin" : "Full cross-version";
            return new IncompatibleLibrary(lib, reason);
        }
        return new UpdatedVersion(lib, seq);
    }

    private MigratedLib migrateCompilerPlugin(InitialLib lib, Seq<Repository> repositories) {
        Tuple2 tuple2 = new Tuple2((Object)lib.organization(), (Object)lib.name());
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            String string2 = (String)tuple2._2();
            if ("org.typelevel".equals(string) && "kind-projector".equals(string2)) {
                return new IntegratedPlugin(lib, "-Ykind-projector");
            }
        }
        if (tuple2 != null) {
            return this.migrateRegularLib(lib, repositories);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$migrateLibs$1(InitialLib l) {
        return InitialLib$.MODULE$.migrationFilter().contains((Object)new Tuple2((Object)l.organization(), (Object)l.name()));
    }

    private LibraryMigration$() {
        MODULE$ = this;
    }
}

