/*
 * Decompiled with CFR 0.152.
 */
package scalafix.internal.sbt;

import coursierapi.Repository;
import java.io.PrintStream;
import java.net.URI;
import java.util.List;
import sbt.librarymanagement.ModuleID;
import sbt.package$;
import sbt.util.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scalafix.interfaces.Scalafix;
import scalafix.interfaces.ScalafixArguments;
import scalafix.interfaces.ScalafixMainCallback;
import scalafix.internal.sbt.Arg;
import scalafix.internal.sbt.LoggingOutputStream$;
import scalafix.internal.sbt.ScalafixInterface;
import scalafix.internal.sbt.ScalafixLogger;

public final class ScalafixInterface$ {
    public static ScalafixInterface$ MODULE$;

    static {
        new ScalafixInterface$();
    }

    public Function0<ScalafixInterface> fromToolClasspath(String scalafixBinaryScalaVersion, Seq<ModuleID> scalafixDependencies, Seq<Repository> scalafixCustomResolvers, Logger logger) {
        return new ScalafixInterface.LazyValue<ScalafixInterface>((Function0 & java.io.Serializable & Serializable)() -> {
            if (scalafixBinaryScalaVersion.startsWith("3")) {
                logger.error((Function0 & java.io.Serializable & Serializable)() -> "To use Scalafix on Scala 3 projects, you must unset `scalafixBinaryScalaVersion`. Rules such as ExplicitResultTypes requiring the project version to match the Scalafix version are unsupported for the moment.");
            } else {
                String string = scalafixBinaryScalaVersion;
                String string2 = "2.11";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    logger.error((Function0 & java.io.Serializable & Serializable)() -> "Scala 2.11 is no longer supported. Please downgrade to the final version supporting it: sbt-scalafix 0.10.4.");
                }
            }
            ScalafixLogger callback = new ScalafixLogger(logger);
            ScalafixArguments scalafixArguments = Scalafix.fetchAndClassloadInstance((String)scalafixBinaryScalaVersion, (List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(scalafixCustomResolvers).asJava())).newArguments().withMainCallback((ScalafixMainCallback)callback);
            PrintStream printStream = new PrintStream(LoggingOutputStream$.MODULE$.apply(logger, package$.MODULE$.Level().Info()));
            return new ScalafixInterface(scalafixArguments, (Seq<Arg>)Nil$.MODULE$).withArgs((Seq<Arg>)Predef$.MODULE$.wrapRefArray((Object[])new Arg[]{new Arg.PrintStream(printStream), new Arg.ToolClasspath((Seq<URI>)Nil$.MODULE$, scalafixDependencies, scalafixCustomResolvers)}));
        });
    }

    public Logger fromToolClasspath$default$4() {
        return package$.MODULE$.ConsoleLogger().apply(System.out);
    }

    private ScalafixInterface$() {
        MODULE$ = this;
    }
}

