/*
 * Decompiled with CFR 0.152.
 */
package scalafix.internal.sbt;

import coursierapi.Credentials;
import coursierapi.IvyRepository;
import coursierapi.Repository;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.file.Paths;
import sbt.librarymanagement.FileRepository;
import sbt.librarymanagement.MavenRepository;
import sbt.librarymanagement.Patterns;
import sbt.librarymanagement.RawRepository;
import sbt.librarymanagement.Resolver;
import sbt.librarymanagement.URLRepository;
import sbt.util.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scalafix.internal.sbt.CoursierRepoResolvers$IBiblioRepository$;

public final class CoursierRepoResolvers$ {
    public static CoursierRepoResolvers$ MODULE$;

    static {
        new CoursierRepoResolvers$();
    }

    private Option<String> mavenCompatibleBaseOpt(Patterns patterns) {
        if (patterns.isMavenCompatible()) {
            String baseIvyPattern = CoursierRepoResolvers$.basePattern$1((String)patterns.ivyPatterns().head());
            String baseArtifactPattern = CoursierRepoResolvers$.basePattern$1((String)patterns.artifactPatterns().head());
            String string = baseIvyPattern;
            String string2 = baseArtifactPattern;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return new Some((Object)baseIvyPattern);
            }
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    private Option<coursierapi.MavenRepository> mavenRepositoryOpt(String root, Logger log, Map<String, Credentials> credentialsByHost) {
        None$ none$;
        try {
            URI rootURI = URI.create(root);
            String root0 = root.endsWith("/") ? root : new StringBuilder(1).append(root).append("/").toString();
            coursierapi.MavenRepository mavenRepository = coursierapi.MavenRepository.of((String)root0);
            none$ = new Some(credentialsByHost.get((Object)rootURI.getHost()).fold((Function0 & java.io.Serializable & Serializable)() -> mavenRepository, (Function1 & java.io.Serializable & Serializable)x$1 -> mavenRepository.withCredentials(x$1)));
        }
        catch (MalformedURLException e) {
            log.warn((Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(49).append("Error parsing Maven repository base ").append(root).append(Option$.MODULE$.apply((Object)e.getMessage()).fold((Function0 & java.io.Serializable & Serializable)() -> "", (Function1 & java.io.Serializable & Serializable)x$1 -> new StringBuilder(3).append(" (").append((String)x$1).append(")").toString())).append(", ignoring it").toString());
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private String pathToUriString(String path) {
        int stopAtIdx = new StringOps(Predef$.MODULE$.augmentString(path)).indexWhere((Function1 & java.io.Serializable & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)CoursierRepoResolvers$.$anonfun$pathToUriString$1(BoxesRunTime.unboxToChar((Object)c))));
        if (stopAtIdx > 0) {
            Tuple2 tuple2 = new StringOps(Predef$.MODULE$.augmentString(path)).splitAt(stopAtIdx);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String pathPart = (String)tuple2._1();
            String patternPart = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)pathPart, (Object)patternPart);
            String pathPart2 = (String)tuple22._1();
            String patternPart2 = (String)tuple22._2();
            return new StringBuilder(0).append(Paths.get(pathPart2, new String[0]).toUri().toASCIIString()).append(patternPart2).toString();
        }
        if (stopAtIdx == 0) {
            return new StringBuilder(7).append("file://").append(path).toString();
        }
        return Paths.get(path, new String[0]).toUri().toASCIIString();
    }

    public Option<Repository> repository(Resolver resolver, Logger log, Map<String, Credentials> credentialsByHost) {
        Option<Patterns> option;
        URLRepository uRLRepository;
        FileRepository fileRepository;
        Resolver resolver2 = resolver;
        if (resolver2 instanceof MavenRepository) {
            MavenRepository mavenRepository = (MavenRepository)resolver2;
            return this.mavenRepositoryOpt(mavenRepository.root(), log, credentialsByHost);
        }
        if (resolver2 instanceof FileRepository && (fileRepository = (FileRepository)resolver2).patterns().ivyPatterns().lengthCompare(1) == 0 && fileRepository.patterns().artifactPatterns().lengthCompare(1) == 0) {
            Option<String> mavenCompatibleBaseOpt0 = this.mavenCompatibleBaseOpt(fileRepository.patterns());
            Option<String> option2 = mavenCompatibleBaseOpt0;
            if (None$.MODULE$.equals(option2)) {
                IvyRepository repo = IvyRepository.of((String)this.pathToUriString((String)fileRepository.patterns().artifactPatterns().head())).withMetadataPattern(this.pathToUriString((String)fileRepository.patterns().ivyPatterns().head())).withDropInfoAttributes(true);
                return new Some((Object)repo);
            }
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                String mavenCompatibleBase = (String)some.value();
                return this.mavenRepositoryOpt(this.pathToUriString(mavenCompatibleBase), log, credentialsByHost);
            }
            throw new MatchError(option2);
        }
        if (resolver2 instanceof URLRepository && this.scalafix$internal$sbt$CoursierRepoResolvers$$patternMatchGuard((uRLRepository = (URLRepository)resolver2).patterns())) {
            return this.parseMavenCompatResolver(log, uRLRepository.patterns(), credentialsByHost);
        }
        if (resolver2 instanceof RawRepository) {
            RawRepository rawRepository = (RawRepository)resolver2;
            String string = rawRepository.name();
            String string2 = "inter-project";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return None$.MODULE$;
            }
        }
        if (!(option = CoursierRepoResolvers$IBiblioRepository$.MODULE$.unapply(resolver2)).isEmpty()) {
            Patterns p = (Patterns)option.get();
            return this.parseMavenCompatResolver(log, p, credentialsByHost);
        }
        log.warn((Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(37).append("Unrecognized repository ").append(resolver2.name()).append(", ignoring it").toString());
        return None$.MODULE$;
    }

    public boolean scalafix$internal$sbt$CoursierRepoResolvers$$patternMatchGuard(Patterns patterns) {
        return patterns.ivyPatterns().lengthCompare(1) == 0 && patterns.artifactPatterns().lengthCompare(1) == 0;
    }

    private Option<Repository> parseMavenCompatResolver(Logger log, Patterns patterns, Map<String, Credentials> credentialsByHost) {
        Option<String> mavenCompatibleBaseOpt0 = this.mavenCompatibleBaseOpt(patterns);
        Option<String> option = mavenCompatibleBaseOpt0;
        if (None$.MODULE$.equals(option)) {
            IvyRepository repo = IvyRepository.of((String)this.pathToUriString((String)patterns.artifactPatterns().head())).withMetadataPattern(this.pathToUriString((String)patterns.ivyPatterns().head())).withDropInfoAttributes(true);
            return new Some((Object)repo);
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            String mavenCompatibleBase = (String)some.value();
            return this.mavenRepositoryOpt(mavenCompatibleBase, log, credentialsByHost);
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ boolean $anonfun$mavenCompatibleBaseOpt$1(char c) {
        return c != '[' && c != '(';
    }

    private static final String basePattern$1(String pattern) {
        return (String)new StringOps(Predef$.MODULE$.augmentString(pattern)).takeWhile((Function1 & java.io.Serializable & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)CoursierRepoResolvers$.$anonfun$mavenCompatibleBaseOpt$1(BoxesRunTime.unboxToChar((Object)c))));
    }

    public static final /* synthetic */ boolean $anonfun$pathToUriString$1(char c) {
        return c == '[' || c == '$' || c == '(';
    }

    private CoursierRepoResolvers$() {
        MODULE$ = this;
    }
}

