/*
 * Decompiled with CFR 0.152.
 */
package scalafix.internal.sbt;

import sbt.util.Logger;
import scala.Function0;
import scala.MatchError;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scalafix.interfaces.ScalafixDiagnostic;
import scalafix.interfaces.ScalafixLintID;
import scalafix.interfaces.ScalafixMainCallback;
import scalafix.interfaces.ScalafixPosition;
import scalafix.interfaces.ScalafixSeverity;

@ScalaSignature(bytes="\u0006\u000113A!\u0001\u0002\u0001\u0013\tq1kY1mC\u001aL\u0007\u0010T8hO\u0016\u0014(BA\u0002\u0005\u0003\r\u0019(\r\u001e\u0006\u0003\u000b\u0019\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0002\u000f\u0005A1oY1mC\u001aL\u0007p\u0001\u0001\u0014\u0007\u0001Q!\u0003\u0005\u0002\f!5\tAB\u0003\u0002\u000e\u001d\u0005!A.\u00198h\u0015\u0005y\u0011\u0001\u00026bm\u0006L!!\u0005\u0007\u0003\r=\u0013'.Z2u!\t\u0019b#D\u0001\u0015\u0015\t)b!\u0001\u0006j]R,'OZ1dKNL!a\u0006\u000b\u0003)M\u001b\u0017\r\\1gSbl\u0015-\u001b8DC2d'-Y2l\u0011!I\u0002A!A!\u0002\u0013Q\u0012A\u00027pO\u001e,'\u000f\u0005\u0002\u001cI9\u0011A$\t\b\u0003;\u0001j\u0011A\b\u0006\u0003?!\ta\u0001\u0010:p_Rt\u0014\"A\u0002\n\u0005\t\u001a\u0013a\u00029bG.\fw-\u001a\u0006\u0002\u0007%\u0011QE\n\u0002\u0007\u0019><w-\u001a:\n\u0005\u001d\u001a#AB%na>\u0014H\u000fC\u0003*\u0001\u0011\u0005!&\u0001\u0004=S:LGO\u0010\u000b\u0003W5\u0002\"\u0001\f\u0001\u000e\u0003\tAQ!\u0007\u0015A\u0002iAQa\f\u0001\u0005\u0002A\nABZ;mYN#(/\u001b8h\u0013\u0012#\"!M\u001e\u0011\u0005IBdBA\u001a7!\tiBGC\u00016\u0003\u0015\u00198-\u00197b\u0013\t9D'\u0001\u0004Qe\u0016$WMZ\u0005\u0003si\u0012aa\u0015;sS:<'BA\u001c5\u0011\u0015ad\u00061\u0001>\u0003\u0019a\u0017N\u001c;J\tB\u00111CP\u0005\u0003\u007fQ\u0011abU2bY\u00064\u0017\u000e\u001f'j]RLE\tC\u0003B\u0001\u0011\u0005#)\u0001\tsKB|'\u000f\u001e#jC\u001etwn\u001d;jGR\u00111i\u0012\t\u0003\t\u0016k\u0011\u0001N\u0005\u0003\rR\u0012A!\u00168ji\")\u0001\n\u0011a\u0001\u0013\u0006QA-[1h]>\u001cH/[2\u0011\u0005MQ\u0015BA&\u0015\u0005I\u00196-\u00197bM&DH)[1h]>\u001cH/[2")
public class ScalafixLogger
implements ScalafixMainCallback {
    private final Logger logger;

    public String fullStringID(ScalafixLintID lintID) {
        return lintID.categoryID().isEmpty() ? lintID.ruleName() : (lintID.ruleName().isEmpty() ? lintID.categoryID() : new StringBuilder(1).append(lintID.ruleName()).append(".").append(lintID.categoryID()).toString());
    }

    public void reportDiagnostic(ScalafixDiagnostic diagnostic) {
        ScalafixSeverity scalafixSeverity = diagnostic.severity();
        if (ScalafixSeverity.INFO.equals(scalafixSeverity)) {
            this.logger.info((Function0 & java.io.Serializable & Serializable)() -> this.formatMessage$1(diagnostic));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ScalafixSeverity.WARNING.equals(scalafixSeverity)) {
            this.logger.warn((Function0 & java.io.Serializable & Serializable)() -> this.formatMessage$1(diagnostic));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ScalafixSeverity.ERROR.equals(scalafixSeverity)) {
            this.logger.error((Function0 & java.io.Serializable & Serializable)() -> this.formatMessage$1(diagnostic));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)scalafixSeverity);
        }
    }

    private final String formatMessage$1(ScalafixDiagnostic diagnostic$1) {
        String string;
        String string2;
        if (diagnostic$1.lintID().isPresent()) {
            String id = this.fullStringID((ScalafixLintID)diagnostic$1.lintID().get());
            string2 = new StringBuilder(3).append("[").append(id).append("] ").toString();
        } else {
            string2 = "";
        }
        String prefix = string2;
        String message = new StringBuilder(0).append(prefix).append(diagnostic$1.message()).toString();
        if (diagnostic$1.position().isPresent()) {
            String severity = diagnostic$1.severity().toString().toLowerCase();
            string = ((ScalafixPosition)diagnostic$1.position().get()).formatMessage(severity, message);
        } else {
            string = message;
        }
        return string;
    }

    public ScalafixLogger(Logger logger) {
        this.logger = logger;
    }
}

