/*
 * Decompiled with CFR 0.152.
 */
package scalafix.internal.sbt;

import sbt.util.Logger;
import scala.Function0;
import scala.MatchError;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scalafix.interfaces.ScalafixDiagnostic;
import scalafix.interfaces.ScalafixLintID;
import scalafix.interfaces.ScalafixMainCallback;
import scalafix.interfaces.ScalafixPosition;
import scalafix.interfaces.ScalafixSeverity;

@ScalaSignature(bytes="\u0006\u000113A!\u0002\u0004\u0001\u001b!AA\u0004\u0001B\u0001B\u0003%Q\u0004C\u0003,\u0001\u0011\u0005A\u0006C\u00031\u0001\u0011\u0005\u0011\u0007C\u0003B\u0001\u0011\u0005#I\u0001\bTG\u0006d\u0017MZ5y\u0019><w-\u001a:\u000b\u0005\u001dA\u0011aA:ci*\u0011\u0011BC\u0001\tS:$XM\u001d8bY*\t1\"\u0001\u0005tG\u0006d\u0017MZ5y\u0007\u0001\u00192\u0001\u0001\b\u0017!\tyA#D\u0001\u0011\u0015\t\t\"#\u0001\u0003mC:<'\"A\n\u0002\t)\fg/Y\u0005\u0003+A\u0011aa\u00142kK\u000e$\bCA\f\u001b\u001b\u0005A\"BA\r\u000b\u0003)Ig\u000e^3sM\u0006\u001cWm]\u0005\u00037a\u0011AcU2bY\u00064\u0017\u000e_'bS:\u001c\u0015\r\u001c7cC\u000e\\\u0017A\u00027pO\u001e,'\u000f\u0005\u0002\u001fO9\u0011q\u0004\n\b\u0003A\rj\u0011!\t\u0006\u0003E1\ta\u0001\u0010:p_Rt\u0014\"A\u0004\n\u0005\u00152\u0013a\u00029bG.\fw-\u001a\u0006\u0002\u000f%\u0011\u0001&\u000b\u0002\u0007\u0019><w-\u001a:\n\u0005)2#AB%na>\u0014H/\u0001\u0004=S:LGO\u0010\u000b\u0003[=\u0002\"A\f\u0001\u000e\u0003\u0019AQ\u0001\b\u0002A\u0002u\tABZ;mYN#(/\u001b8h\u0013\u0012#\"A\r\u001f\u0011\u0005MJdB\u0001\u001b8!\t\u0001SGC\u00017\u0003\u0015\u00198-\u00197b\u0013\tAT'\u0001\u0004Qe\u0016$WMZ\u0005\u0003um\u0012aa\u0015;sS:<'B\u0001\u001d6\u0011\u0015i4\u00011\u0001?\u0003\u0019a\u0017N\u001c;J\tB\u0011qcP\u0005\u0003\u0001b\u0011abU2bY\u00064\u0017\u000e\u001f'j]RLE)\u0001\tsKB|'\u000f\u001e#jC\u001etwn\u001d;jGR\u00111i\u0012\t\u0003\t\u0016k\u0011!N\u0005\u0003\rV\u0012A!\u00168ji\")\u0001\n\u0002a\u0001\u0013\u0006QA-[1h]>\u001cH/[2\u0011\u0005]Q\u0015BA&\u0019\u0005I\u00196-\u00197bM&DH)[1h]>\u001cH/[2")
public class ScalafixLogger
implements ScalafixMainCallback {
    private final Logger logger;

    public String fullStringID(ScalafixLintID lintID) {
        return lintID.categoryID().isEmpty() ? lintID.ruleName() : (lintID.ruleName().isEmpty() ? lintID.categoryID() : new StringBuilder(1).append(lintID.ruleName()).append(".").append(lintID.categoryID()).toString());
    }

    public void reportDiagnostic(ScalafixDiagnostic diagnostic) {
        ScalafixSeverity scalafixSeverity = diagnostic.severity();
        if (ScalafixSeverity.INFO.equals(scalafixSeverity)) {
            this.logger.info((Function0 & java.io.Serializable & Serializable)() -> this.formatMessage$1(diagnostic));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ScalafixSeverity.WARNING.equals(scalafixSeverity)) {
            this.logger.warn((Function0 & java.io.Serializable & Serializable)() -> this.formatMessage$1(diagnostic));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ScalafixSeverity.ERROR.equals(scalafixSeverity)) {
            this.logger.error((Function0 & java.io.Serializable & Serializable)() -> this.formatMessage$1(diagnostic));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)scalafixSeverity);
        }
    }

    private final String formatMessage$1(ScalafixDiagnostic diagnostic$1) {
        String string;
        String string2;
        if (diagnostic$1.lintID().isPresent()) {
            String id = this.fullStringID((ScalafixLintID)diagnostic$1.lintID().get());
            string2 = new StringBuilder(3).append("[").append(id).append("] ").toString();
        } else {
            string2 = "";
        }
        String prefix = string2;
        String message = new StringBuilder(0).append(prefix).append(diagnostic$1.message()).toString();
        if (diagnostic$1.position().isPresent()) {
            String severity = diagnostic$1.severity().toString().toLowerCase();
            string = ((ScalafixPosition)diagnostic$1.position().get()).formatMessage(severity, message);
        } else {
            string = message;
        }
        return string;
    }

    public ScalafixLogger(Logger logger) {
        this.logger = logger;
    }
}

