/*
 * Decompiled with CFR 0.152.
 */
package scalafix.internal.sbt;

import sbt.util.Logger;
import scala.MatchError;
import scalafix.interfaces.ScalafixDiagnostic;
import scalafix.interfaces.ScalafixLintID;
import scalafix.interfaces.ScalafixMainCallback;
import scalafix.interfaces.ScalafixPosition;
import scalafix.interfaces.ScalafixSeverity;

public class ScalafixLogger
implements ScalafixMainCallback {
    private final Logger logger;

    public ScalafixLogger(Logger logger) {
        this.logger = logger;
    }

    public String fullStringID(ScalafixLintID lintID) {
        if (lintID.categoryID().isEmpty()) {
            return lintID.ruleName();
        }
        if (lintID.ruleName().isEmpty()) {
            return lintID.categoryID();
        }
        return new StringBuilder(1).append(lintID.ruleName()).append(".").append(lintID.categoryID()).toString();
    }

    public void reportDiagnostic(ScalafixDiagnostic diagnostic) {
        ScalafixSeverity scalafixSeverity = diagnostic.severity();
        ScalafixSeverity scalafixSeverity2 = ScalafixSeverity.INFO;
        ScalafixSeverity scalafixSeverity3 = scalafixSeverity;
        if (!(scalafixSeverity2 != null ? !scalafixSeverity2.equals(scalafixSeverity3) : scalafixSeverity3 != null)) {
            this.logger.info(() -> this.reportDiagnostic$$anonfun$1(diagnostic));
            return;
        }
        ScalafixSeverity scalafixSeverity4 = ScalafixSeverity.WARNING;
        ScalafixSeverity scalafixSeverity5 = scalafixSeverity;
        if (!(scalafixSeverity4 != null ? !scalafixSeverity4.equals(scalafixSeverity5) : scalafixSeverity5 != null)) {
            this.logger.warn(() -> this.reportDiagnostic$$anonfun$2(diagnostic));
            return;
        }
        ScalafixSeverity scalafixSeverity6 = ScalafixSeverity.ERROR;
        ScalafixSeverity scalafixSeverity7 = scalafixSeverity;
        if (!(scalafixSeverity6 != null ? !scalafixSeverity6.equals(scalafixSeverity7) : scalafixSeverity7 != null)) {
            this.logger.error(() -> this.reportDiagnostic$$anonfun$3(diagnostic));
            return;
        }
        throw new MatchError((Object)scalafixSeverity);
    }

    private final String formatMessage$1(ScalafixDiagnostic diagnostic$1) {
        String string;
        if (diagnostic$1.lintID().isPresent()) {
            String id = this.fullStringID((ScalafixLintID)diagnostic$1.lintID().get());
            string = new StringBuilder(3).append("[").append(id).append("] ").toString();
        } else {
            string = "";
        }
        String prefix = string;
        String message = new StringBuilder(0).append(prefix).append(diagnostic$1.message()).toString();
        if (diagnostic$1.position().isPresent()) {
            String severity = diagnostic$1.severity().toString().toLowerCase();
            return ((ScalafixPosition)diagnostic$1.position().get()).formatMessage(severity, message);
        }
        return message;
    }

    private final String reportDiagnostic$$anonfun$1(ScalafixDiagnostic diagnostic$2) {
        return this.formatMessage$1(diagnostic$2);
    }

    private final String reportDiagnostic$$anonfun$2(ScalafixDiagnostic diagnostic$3) {
        return this.formatMessage$1(diagnostic$3);
    }

    private final String reportDiagnostic$$anonfun$3(ScalafixDiagnostic diagnostic$4) {
        return this.formatMessage$1(diagnostic$4);
    }
}

