/*
 * Decompiled with CFR 0.152.
 */
package scalafix.internal.sbt;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.GitDateFormatter;
import scala.Function1;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.util.Try$;

public class JGitCompletion {
    private final List<String> branchesAndTags;
    private final GitDateFormatter dateFormatter;
    private final List<Tuple2<String, String>> last20Commits;

    public JGitCompletion(Path cwd) {
        Nil$ nil$;
        Nil$ nil$2;
        boolean isGitRepository = RepositoryCache.FileKey.isGitRepository((File)cwd.resolve(".git").toFile(), (FS)FS.DETECTED);
        if (isGitRepository) {
            FileRepositoryBuilder builder = new FileRepositoryBuilder();
            Repository repo = ((FileRepositoryBuilder)builder.readEnvironment().setWorkTree(cwd.toFile())).build();
            Buffer refList = CollectionConverters$.MODULE$.ListHasAsScala(repo.getRefDatabase().getRefsByPrefix("")).asScala();
            nil$2 = ((IterableOnceOps)refList.map((Function1 & Serializable)ref -> Repository.shortenRefName((String)ref.getName()))).toList();
        } else {
            nil$2 = package$.MODULE$.Nil();
        }
        this.branchesAndTags = nil$2;
        this.dateFormatter = new GitDateFormatter(GitDateFormatter.Format.RELATIVE);
        if (isGitRepository) {
            FileRepositoryBuilder builder = new FileRepositoryBuilder();
            Repository repo = ((FileRepositoryBuilder)builder.readEnvironment().setWorkTree(cwd.toFile())).build();
            Git git = new Git(repo);
            List refs0 = (List)Try$.MODULE$.apply(() -> JGitCompletion.$anonfun$1(git)).getOrElse(JGitCompletion::$anonfun$2);
            nil$ = refs0;
        } else {
            nil$ = package$.MODULE$.Nil();
        }
        Nil$ refs = nil$;
        this.last20Commits = refs.map(arg_0 -> this.$init$$$anonfun$2((List)refs, arg_0));
    }

    public List<String> branchesAndTags() {
        return this.branchesAndTags;
    }

    public List<Tuple2<String, String>> last20Commits() {
        return this.last20Commits;
    }

    private static final List $anonfun$1(Git git$1) {
        return CollectionConverters$.MODULE$.IterableHasAsScala(git$1.log().setMaxCount(20).call()).asScala().toList();
    }

    private static final List $anonfun$2() {
        return package$.MODULE$.Nil();
    }

    private final /* synthetic */ Tuple2 $init$$$anonfun$2(List refs$1, RevCommit ref) {
        String relativeCommitTime = this.dateFormatter.formatDate(((RevCommit)refs$1.head()).getCommitterIdent());
        String abrev = ref.abbreviate(8).name();
        String string = ref.getShortMessage();
        return Tuple2$.MODULE$.apply((Object)new StringBuilder(7).append(abrev).append(" -- ").append(string).append(" (").append(relativeCommitTime).append(")").toString(), (Object)abrev);
    }
}

