/*
 * Decompiled with CFR 0.152.
 */
package scalajsbundler.util;

import com.google.common.jimfs.Jimfs;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import sbt.internal.util.Attributed;
import sbt.io.FileFilter;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.generic.Growable;
import scala.collection.immutable.List;
import scala.collection.mutable.Builder;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ScalaJSNativeLibraries$ {
    public static ScalaJSNativeLibraries$ MODULE$;

    static {
        new ScalaJSNativeLibraries$();
    }

    public Seq<Tuple2<String, Path>> apply(Seq<Attributed<File>> fullClasspath) {
        return this.collectFromClasspath(fullClasspath, (FileFilter)sbt.package$.MODULE$.globFilter("*.js"), (Function1 & java.io.Serializable & Serializable)jar -> MODULE$.jsFilesInJar((File)jar), (Function2 & java.io.Serializable & Serializable)(f, relPath) -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(relPath), (Object)f.toPath()));
    }

    private <T> Seq<T> collectFromClasspath(Seq<Attributed<File>> cp, FileFilter filter, Function1<File, Seq<T>> collectJar, Function2<File, String, T> collectFile) {
        Builder results = Seq$.MODULE$.newBuilder();
        sbt.package$.MODULE$.Attributed().data(cp).withFilter((Function1 & java.io.Serializable & Serializable)cpEntry -> BoxesRunTime.boxToBoolean((boolean)cpEntry.exists())).foreach((Function1 & java.io.Serializable & Serializable)cpEntry -> {
            Growable growable;
            if (cpEntry.isFile() && cpEntry.getName().endsWith(".jar")) {
                growable = results.$plus$plus$eq((TraversableOnce)collectJar.apply(cpEntry));
            } else if (cpEntry.isDirectory()) {
                sbt.package$.MODULE$.Path().selectSubpaths(cpEntry, filter).withFilter((Function1 & java.io.Serializable & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ScalaJSNativeLibraries$.$anonfun$collectFromClasspath$3(check$ifrefutable$1))).foreach((Function1 & java.io.Serializable & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    File file = (File)tuple2._1();
                    String relPath0 = (String)tuple2._2();
                    String relPath = relPath0.replace(File.separatorChar, '/');
                    Builder builder = results.$plus$eq(collectFile.apply((Object)file, (Object)relPath));
                    return builder;
                });
                growable = BoxedUnit.UNIT;
            } else {
                throw new IllegalArgumentException(new StringBuilder(25).append("Illegal classpath entry: ").append(cpEntry.getPath()).toString());
            }
            return growable;
        });
        return (Seq)results.result();
    }

    private List<Tuple2<String, Path>> jsFilesInJar(File jar) {
        return this.jarListEntries(jar, (Function1<String, Object>)(Function1 & java.io.Serializable & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.endsWith(".js")));
    }

    private <T> List<Tuple2<String, Path>> jarListEntries(File jar, Function1<String, Object> p) {
        List list;
        String jarPath = jar.getPath();
        FileSystem memFileSystem = Jimfs.newFileSystem();
        try (ZipInputStream stream = new ZipInputStream(new BufferedInputStream(new FileInputStream(jar)));){
            byte[] buf = new byte[4096];
            list = package$.MODULE$.Iterator().continually((Function0 & java.io.Serializable & Serializable)() -> stream.getNextEntry()).takeWhile((Function1 & java.io.Serializable & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ScalaJSNativeLibraries$.$anonfun$jarListEntries$2(x$3))).filter((Function1 & java.io.Serializable & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ScalaJSNativeLibraries$.$anonfun$jarListEntries$3(p, e))).map((Function1 & java.io.Serializable & Serializable)e -> this.makeVF$1((ZipEntry)e, memFileSystem, jarPath, stream, buf)).toList();
        }
        return list;
    }

    public static final /* synthetic */ boolean $anonfun$collectFromClasspath$3(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    private final void readAll$1(OutputStream out, ZipInputStream stream$1, byte[] buf$1) {
        int read;
        while ((read = stream$1.read(buf$1)) != -1) {
            out.write(buf$1, 0, read);
        }
    }

    private final Tuple2 makeVF$1(ZipEntry e, FileSystem memFileSystem$1, String jarPath$1, ZipInputStream stream$1, byte[] buf$1) {
        Tuple2 tuple2;
        long size = e.getSize();
        try (ByteArrayOutputStream out = 0L <= size && size <= Integer.MAX_VALUE ? new ByteArrayOutputStream((int)size) : new ByteArrayOutputStream();){
            this.readAll$1(out, stream$1, buf$1);
            String relName = e.getName();
            Path path = memFileSystem$1.getPath(new StringBuilder(1).append(jarPath$1).append("/").append(relName).toString(), new String[0]);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.write(path, out.toByteArray(), new OpenOption[0]);
            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)relName), (Object)path);
        }
        return tuple2;
    }

    public static final /* synthetic */ boolean $anonfun$jarListEntries$2(ZipEntry x$3) {
        return x$3 != null;
    }

    public static final /* synthetic */ boolean $anonfun$jarListEntries$3(Function1 p$1, ZipEntry e) {
        return BoxesRunTime.unboxToBoolean((Object)p$1.apply((Object)e.getName()));
    }

    private ScalaJSNativeLibraries$() {
        MODULE$ = this;
    }
}

