/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.scala.debugadapter.internal.evaluator;

import ch.epfl.scala.debugadapter.internal.evaluator.EvaluatorContext;
import ch.epfl.scala.debugadapter.internal.evaluator.ExpressionCompiler;
import ch.epfl.scala.debugadapter.internal.evaluator.JdiArray;
import ch.epfl.scala.debugadapter.internal.evaluator.JdiArray$;
import ch.epfl.scala.debugadapter.internal.evaluator.JdiClassLoader;
import ch.epfl.scala.debugadapter.internal.evaluator.JdiClassLoader$;
import ch.epfl.scala.debugadapter.internal.evaluator.JdiClassObject;
import ch.epfl.scala.debugadapter.internal.evaluator.JdiPrimitive$;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.ISourceLookUpProvider;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.Field;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.LongValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StackFrame;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005Uc!B\u0005\u000b\u000111\u0002\u0002\u0003\u000f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0010\t\u00119\u0002!\u0011!Q\u0001\n=BQa\r\u0001\u0005\u0002QBQ\u0001\u000f\u0001\u0005\u0002eBQ\u0001\u001b\u0001\u0005\n%Dq!a\u0001\u0001\t\u0013\t)\u0001C\u0004\u0002*\u0001!I!a\u000b\t\u000f\u0005}\u0002\u0001\"\u0003\u0002B\t\u0019R\t\u001f9sKN\u001c\u0018n\u001c8Fm\u0006dW/\u0019;pe*\u00111\u0002D\u0001\nKZ\fG.^1u_JT!!\u0004\b\u0002\u0011%tG/\u001a:oC2T!a\u0004\t\u0002\u0019\u0011,'-^4bI\u0006\u0004H/\u001a:\u000b\u0005E\u0011\u0012!B:dC2\f'BA\n\u0015\u0003\u0011)\u0007O\u001a7\u000b\u0003U\t!a\u00195\u0014\u0005\u00019\u0002C\u0001\r\u001b\u001b\u0005I\"\"A\t\n\u0005mI\"AB!osJ+g-\u0001\u000bt_V\u00148-\u001a'p_.,\u0006\u000f\u0015:pm&$WM]\u0002\u0001!\tyB&D\u0001!\u0015\t\t#%A\u0004bI\u0006\u0004H/\u001a:\u000b\u0005\r\"\u0013\u0001B2pe\u0016T!!\n\u0014\u0002\u000b\u0011,'-^4\u000b\u0005\u001dB\u0013\u0001\u00026bm\u0006T!!\u000b\u0016\u0002\u00135L7M]8t_\u001a$(\"A\u0016\u0002\u0007\r|W.\u0003\u0002.A\t)\u0012jU8ve\u000e,Gj\\8l+B\u0004&o\u001c<jI\u0016\u0014\u0018AE3yaJ,7o]5p]\u000e{W\u000e]5mKJ\u0004\"\u0001M\u0019\u000e\u0003)I!A\r\u0006\u0003%\u0015C\bO]3tg&|gnQ8na&dWM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007U2t\u0007\u0005\u00021\u0001!)Ad\u0001a\u0001=!)af\u0001a\u0001_\u0005AQM^1mk\u0006$X\r\u0006\u0003;#z\u001bGCA\u001eM!\ra$\tR\u0007\u0002{)\u0011ahP\u0001\u000bG>t7-\u001e:sK:$(B\u0001!B\u0003\u0011)H/\u001b7\u000b\u0003\u001dJ!aQ\u001f\u0003#\r{W\u000e\u001d7fi\u0006\u0014G.\u001a$viV\u0014X\r\u0005\u0002F\u00156\taI\u0003\u0002H\u0011\u0006\u0019!\u000eZ5\u000b\u0005%S\u0013aA:v]&\u00111J\u0012\u0002\u0006-\u0006dW/\u001a\u0005\u0006\u001b\u0012\u0001\rAT\u0001\rI\u0016\u0014WoZ\"p]R,\u0007\u0010\u001e\t\u0003?=K!\u0001\u0015\u0011\u0003)%#UMY;h\u0003\u0012\f\u0007\u000f^3s\u0007>tG/\u001a=u\u0011\u0015\u0011F\u00011\u0001T\u0003))\u0007\u0010\u001d:fgNLwN\u001c\t\u0003)ns!!V-\u0011\u0005YKR\"A,\u000b\u0005ak\u0012A\u0002\u001fs_>$h(\u0003\u0002[3\u00051\u0001K]3eK\u001aL!\u0001X/\u0003\rM#(/\u001b8h\u0015\tQ\u0016\u0004C\u0003`\t\u0001\u0007\u0001-\u0001\u0004uQJ,\u0017\r\u001a\t\u0003\u000b\u0006L!A\u0019$\u0003\u001fQC'/Z1e%\u00164WM]3oG\u0016DQ\u0001\u001a\u0003A\u0002\u0015\fQA\u001a:b[\u0016\u0004\"!\u00124\n\u0005\u001d4%AC*uC\u000e\\gI]1nK\u0006\u0019Bn\\1e\u000bb\u0004(/Z:tS>t7\t\\1tgR!!\u000e];\u0000!\rA2.\\\u0005\u0003Yf\u0011aa\u00149uS>t\u0007C\u0001\u0019o\u0013\ty'B\u0001\bKI&\u001cE.Y:t\u001f\nTWm\u0019;\t\u000bE,\u0001\u0019\u0001:\u0002\u000f\r|g\u000e^3yiB\u0011\u0001g]\u0005\u0003i*\u0011\u0001#\u0012<bYV\fGo\u001c:D_:$X\r\u001f;\t\u000bY,\u0001\u0019A<\u0002\u001b\u0015D\bO]3tg&|g\u000eR5s!\tAX0D\u0001z\u0015\tQ80\u0001\u0003gS2,'B\u0001?B\u0003\rq\u0017n\\\u0005\u0003}f\u0014A\u0001U1uQ\"1\u0011\u0011A\u0003A\u0002M\u000ba\"\u001a=qe\u0016\u001c8/[8o\rF\u001cg.A\u000bfqR\u0014\u0018m\u0019;WC2,Xm]!oI:\u000bW.Z:\u0015\t\u0005\u001d\u0011q\u0005\t\b1\u0005%\u0011QBA\u0013\u0013\r\tY!\u0007\u0002\u0007)V\u0004H.\u001a\u001a\u0011\r\u0005=\u0011\u0011DA\u0010\u001d\u0011\t\t\"!\u0006\u000f\u0007Y\u000b\u0019\"C\u0001\u0012\u0013\r\t9\"G\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tY\"!\b\u0003\t1K7\u000f\u001e\u0006\u0004\u0003/I\u0002cA#\u0002\"%\u0019\u00111\u0005$\u0003\u001fM#(/\u001b8h%\u00164WM]3oG\u0016\u0004R!a\u0004\u0002\u001a\u0011CQ!\u001d\u0004A\u0002I\fqBZ5oI\u000ec\u0017m]:M_\u0006$WM\u001d\u000b\u0005\u0003[\t)\u0004\u0005\u0003\u0019W\u0006=\u0002cA#\u00022%\u0019\u00111\u0007$\u0003)\rc\u0017m]:M_\u0006$WM\u001d*fM\u0016\u0014XM\\2f\u0011\u001d\t9d\u0002a\u0001\u0003s\t!A^7\u0011\u0007\u0015\u000bY$C\u0002\u0002>\u0019\u0013aBV5siV\fG.T1dQ&tW-A\u0006c_bLeMT3fI\u0016$G\u0003CA\"\u0003\u000b\nI%a\u0015\u0011\u0007aYG\t\u0003\u0004\u0002H!\u0001\r\u0001R\u0001\u0006m\u0006dW/\u001a\u0005\b\u0003\u0017B\u0001\u0019AA'\u0003-\u0019G.Y:t\u0019>\fG-\u001a:\u0011\u0007A\ny%C\u0002\u0002R)\u0011aB\u00133j\u00072\f7o\u001d'pC\u0012,'\u000fC\u0003`\u0011\u0001\u0007\u0001\r")
public class ExpressionEvaluator {
    private final ISourceLookUpProvider sourceLookUpProvider;
    private final ExpressionCompiler expressionCompiler;

    public CompletableFuture<Value> evaluate(String expression, ThreadReference thread, StackFrame frame, IDebugAdapterContext debugContext) {
        CompletableFuture<Value> completableFuture;
        VirtualMachine vm = thread.virtualMachine();
        Location location = frame.location();
        String sourcePath = location.sourcePath();
        int breakpointLine = location.lineNumber();
        String fqcn = location.declaringType().name();
        String uri = this.sourceLookUpProvider.getSourceFileURI(fqcn, sourcePath);
        String content = this.sourceLookUpProvider.getSourceContents(uri);
        Path expressionDir = Files.createTempDirectory("expr-eval", new FileAttribute[0]);
        String expressionId = UUID.randomUUID().toString().replace("-", "");
        String expressionClassName = new StringBuilder(10).append("Expression").append(expressionId).toString();
        String valuesByNameIdentName = new StringBuilder(12).append("valuesByName").append(expressionId).toString();
        String expressionFqcn = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fqcn.split("\\."))).dropRight(1))).$colon$plus((Object)expressionClassName, ClassTag$.MODULE$.apply(String.class)))).mkString(".");
        try {
            Option result;
            ObjectRef error = ObjectRef.create((Object)None$.MODULE$);
            Option option = result = this.findClassLoader(vm).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> JdiClassLoader$.MODULE$.apply((ClassLoaderReference)x$1, thread)).map((Function1 & Serializable & scala.Serializable)classLoader -> {
                EvaluatorContext context = new EvaluatorContext(thread, frame, vm, (JdiClassLoader)classLoader);
                Tuple2<List<StringReference>, List<Value>> tuple2 = this.extractValuesAndNames(context);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                List names = (List)tuple2._1();
                List values = (List)tuple2._2();
                Tuple3 tuple3 = new Tuple3(tuple2, (Object)names, (Object)values);
                Tuple3 tuple32 = tuple3;
                Tuple2 x$5 = (Tuple2)tuple32._1();
                List names2 = (List)tuple32._2();
                List values2 = (List)tuple32._3();
                return new Tuple3(classLoader, (Object)context, (Object)x$5);
            }).flatMap((Function1 & Serializable & scala.Serializable)x$11 -> {
                Tuple2 tuple2;
                EvaluatorContext context;
                JdiClassLoader classLoader;
                block3: {
                    Tuple3 tuple3;
                    block2: {
                        tuple3 = x$11;
                        if (tuple3 == null) break block2;
                        classLoader = (JdiClassLoader)tuple3._1();
                        context = (EvaluatorContext)tuple3._2();
                        tuple2 = (Tuple2)tuple3._3();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple3);
                }
                List names = (List)tuple2._1();
                List values = (List)tuple2._2();
                Option option = classLoader.loadClass("java.lang.System").flatMap((Function1 & Serializable & scala.Serializable)systemClass -> systemClass.invokeStatic("getProperty", (List<Value>)new .colon.colon((Object)vm.mirrorOf("java.class.path"), (List)Nil$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toString()).map((Function1 & Serializable & scala.Serializable)x$3 -> (String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(x$3)).drop(1))).dropRight(1)).map((Function1 & Serializable & scala.Serializable)classPath -> {
                    String expressionClassPath = expressionDir.toUri().toString();
                    boolean compiledSuccessfully = $this.expressionCompiler.compile(expressionDir, expressionClassName, valuesByNameIdentName, (String)classPath, content, breakpointLine, expression, (Set<String>)((TraversableOnce)names.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.value(), List$.MODULE$.canBuildFrom())).toSet(), errorMessage -> {
                        error$1.elem = new Some(errorMessage);
                    }, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(5)).seconds());
                    return new Tuple3(classPath, (Object)expressionClassPath, (Object)BoxesRunTime.boxToBoolean((boolean)compiledSuccessfully));
                }).flatMap((Function1 & Serializable & scala.Serializable)x$10 -> {
                    Tuple3 tuple3 = x$10;
                    if (tuple3 == null) {
                        throw new MatchError((Object)tuple3);
                    }
                    boolean compiledSuccessfully = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
                    Option option = (compiledSuccessfully ? new Some((Object)BoxedUnit.UNIT) : None$.MODULE$).flatMap((Function1 & Serializable & scala.Serializable)_ -> this.loadExpressionClass(context, expressionDir, expressionFqcn).flatMap((Function1 & Serializable & scala.Serializable)expressionClass -> expressionClass.newInstance((List<Value>)Nil$.MODULE$).flatMap((Function1 & Serializable & scala.Serializable)expression -> JdiArray$.MODULE$.apply("java.lang.String", names.size(), classLoader, thread).flatMap((Function1 & Serializable & scala.Serializable)namesArray -> JdiArray$.MODULE$.apply("java.lang.Object", values.size(), classLoader, thread).map((Function1 & Serializable & scala.Serializable)valuesArray -> {
                        Option<BoxedUnit> x$7 = namesArray.setValues((List<Value>)names);
                        Option<BoxedUnit> x$8 = valuesArray.setValues((List<Value>)values);
                        return new Tuple3(valuesArray, x$7, x$8);
                    }).flatMap((Function1 & Serializable & scala.Serializable)x$9 -> {
                        Tuple3 tuple3 = x$9;
                        if (tuple3 == null) {
                            throw new MatchError((Object)tuple3);
                        }
                        JdiArray valuesArray = (JdiArray)tuple3._1();
                        Option option = expression.invoke("evaluate", (List<Value>)new .colon.colon((Object)namesArray.reference(), (List)new .colon.colon((Object)valuesArray.reference(), (List)Nil$.MODULE$))).map((Function1 & Serializable & scala.Serializable)result -> result);
                        return option;
                    })))));
                    return option;
                }));
                return option;
            });
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    Option option2 = (Option)error.elem;
                    if (option2 instanceof Some) {
                        Some some = (Some)option2;
                        String message = (String)some.value();
                        throw new Exception(message);
                    }
                    if (None$.MODULE$.equals(option2)) {
                        throw new Exception("Unable to evaluate the expression");
                    }
                    throw new MatchError((Object)option2);
                }
                throw new MatchError((Object)option);
            }
            Some some = (Some)option;
            Value value = (Value)some.value();
            CompletableFuture<Value> completableFuture2 = CompletableFuture.completedFuture(value);
            completableFuture = completableFuture2;
        }
        finally {
            debugContext.getStackFrameManager().reloadStackFrames(thread);
        }
        return completableFuture;
    }

    private Option<JdiClassObject> loadExpressionClass(EvaluatorContext context, Path expressionDir, String expressionFqcn) {
        String expressionClassPath = expressionDir.toUri().toString();
        return context.classLoader().loadClass("java.net.URL").flatMap((Function1 & Serializable & scala.Serializable)x$12 -> x$12.newInstance((List<Value>)new .colon.colon((Object)context.vm().mirrorOf(expressionClassPath), (List)Nil$.MODULE$))).flatMap((Function1 & Serializable & scala.Serializable)url -> JdiArray$.MODULE$.apply("java.net.URL", 1, context.classLoader(), context.thread()).flatMap((Function1 & Serializable & scala.Serializable)urls -> urls.setValue(0, url.reference()).flatMap((Function1 & Serializable & scala.Serializable)_ -> context.classLoader().loadClass("java.net.URLClassLoader").flatMap((Function1 & Serializable & scala.Serializable)x$13 -> x$13.newInstance((List<Value>)new .colon.colon((Object)urls.reference(), (List)Nil$.MODULE$))).map((Function1 & Serializable & scala.Serializable)x$14 -> (ClassLoaderReference)x$14.reference()).flatMap((Function1 & Serializable & scala.Serializable)x$15 -> JdiClassLoader$.MODULE$.apply((ClassLoaderReference)x$15, context.thread())).flatMap((Function1 & Serializable & scala.Serializable)urlClassLoader -> urlClassLoader.loadClass(expressionFqcn).map((Function1 & Serializable & scala.Serializable)expressionClass -> expressionClass)))));
    }

    private Tuple2<List<StringReference>, List<Value>> extractValuesAndNames(EvaluatorContext context) {
        Option thisObjectOpt = Option$.MODULE$.apply((Object)context.frame().thisObject());
        Tuple2 tuple2 = this.extractVariablesFromFrame$1(context);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List variableNames = (List)tuple2._1();
        List variableValues = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)variableNames, (Object)variableValues);
        Tuple2 tuple23 = tuple22;
        List variableNames2 = (List)tuple23._1();
        List variableValues2 = (List)tuple23._2();
        Tuple2 tuple24 = this.extractFieldsFromThisObject$1(thisObjectOpt, context);
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        List fieldNames = (List)tuple24._1();
        List fieldValues = (List)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)fieldNames, (Object)fieldValues);
        Tuple2 tuple26 = tuple25;
        List fieldNames2 = (List)tuple26._1();
        List fieldValues2 = (List)tuple26._2();
        Option thisObjectName = thisObjectOpt.map((Function1 & Serializable & scala.Serializable)x$20 -> context.vm().mirrorOf("$this"));
        List names = (List)((List)variableNames2.$plus$plus((GenTraversableOnce)fieldNames2, List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)thisObjectName.toList(), List$.MODULE$.canBuildFrom());
        List values = (List)((List)variableValues2.$plus$plus((GenTraversableOnce)fieldValues2, List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)thisObjectOpt.toList(), List$.MODULE$.canBuildFrom());
        return new Tuple2((Object)names, (Object)values);
    }

    private Option<ClassLoaderReference> findClassLoader(VirtualMachine vm) {
        return ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(vm.allClasses()).asScala()).find((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)ExpressionEvaluator.$anonfun$findClassLoader$1(x$21))).map((Function1 & Serializable & scala.Serializable)x$22 -> x$22.classLoader());
    }

    private Option<Value> boxIfNeeded(Value value, JdiClassLoader classLoader, ThreadReference thread) {
        Option option;
        Value value2 = value;
        if (value2 instanceof BooleanValue) {
            BooleanValue booleanValue = (BooleanValue)value2;
            option = JdiPrimitive$.MODULE$.boxed(BoxesRunTime.boxToBoolean((boolean)booleanValue.value()), classLoader, thread).map((Function1 & Serializable & scala.Serializable)x$23 -> x$23.reference());
        } else if (value2 instanceof CharValue) {
            CharValue charValue = (CharValue)value2;
            option = JdiPrimitive$.MODULE$.boxed(BoxesRunTime.boxToCharacter((char)charValue.value()), classLoader, thread).map((Function1 & Serializable & scala.Serializable)x$24 -> x$24.reference());
        } else if (value2 instanceof DoubleValue) {
            DoubleValue doubleValue = (DoubleValue)value2;
            option = JdiPrimitive$.MODULE$.boxed(BoxesRunTime.boxToDouble((double)doubleValue.value()), classLoader, thread).map((Function1 & Serializable & scala.Serializable)x$25 -> x$25.reference());
        } else if (value2 instanceof FloatValue) {
            FloatValue floatValue = (FloatValue)value2;
            option = JdiPrimitive$.MODULE$.boxed(BoxesRunTime.boxToFloat((float)floatValue.value()), classLoader, thread).map((Function1 & Serializable & scala.Serializable)x$26 -> x$26.reference());
        } else if (value2 instanceof IntegerValue) {
            IntegerValue integerValue = (IntegerValue)value2;
            option = JdiPrimitive$.MODULE$.boxed(BoxesRunTime.boxToInteger((int)integerValue.value()), classLoader, thread).map((Function1 & Serializable & scala.Serializable)x$27 -> x$27.reference());
        } else if (value2 instanceof LongValue) {
            LongValue longValue = (LongValue)value2;
            option = JdiPrimitive$.MODULE$.boxed(BoxesRunTime.boxToLong((long)longValue.value()), classLoader, thread).map((Function1 & Serializable & scala.Serializable)x$28 -> x$28.reference());
        } else if (value2 instanceof ShortValue) {
            ShortValue shortValue = (ShortValue)value2;
            option = JdiPrimitive$.MODULE$.boxed(BoxesRunTime.boxToShort((short)shortValue.value()), classLoader, thread).map((Function1 & Serializable & scala.Serializable)x$29 -> x$29.reference());
        } else {
            option = new Some((Object)value2);
        }
        return option;
    }

    private final Tuple2 extractVariablesFromFrame$1(EvaluatorContext context$3) {
        List variables = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(context$3.frame().visibleVariables()).asScala()).toList();
        List variableNames = (List)((List)variables.map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.name(), List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$1 -> context$3.vm().mirrorOf((String)x$1), List$.MODULE$.canBuildFrom());
        List variableValues = (List)((List)variables.map((Function1 & Serializable & scala.Serializable)x$1 -> context$3.frame().getValue((LocalVariable)x$1), List$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)value -> Option$.MODULE$.option2Iterable(this.boxIfNeeded((Value)value, context$3.classLoader(), context$3.thread())), List$.MODULE$.canBuildFrom());
        return new Tuple2((Object)variableNames, (Object)variableValues);
    }

    private final Tuple2 extractFieldsFromThisObject$1(Option thisObjectOpt$1, EvaluatorContext context$3) {
        return (Tuple2)thisObjectOpt$1.map((Function1 & Serializable & scala.Serializable)thisObject -> {
            List fields = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(thisObject.referenceType().fields()).asScala()).toList();
            List fieldNames = (List)((List)fields.map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.name(), List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$1 -> context$3.vm().mirrorOf((String)x$1), List$.MODULE$.canBuildFrom());
            List fieldValues = (List)((List)fields.map((Function1 & Serializable & scala.Serializable)field -> thisObject.getValue((Field)field), List$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)value -> Option$.MODULE$.option2Iterable(this.boxIfNeeded((Value)value, context$3.classLoader(), context$3.thread())), List$.MODULE$.canBuildFrom());
            return new Tuple2((Object)fieldNames, (Object)fieldValues);
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Tuple2((Object)Nil$.MODULE$, (Object)Nil$.MODULE$));
    }

    public static final /* synthetic */ boolean $anonfun$findClassLoader$1(ReferenceType x$21) {
        return x$21.classLoader() != null;
    }

    public ExpressionEvaluator(ISourceLookUpProvider sourceLookUpProvider, ExpressionCompiler expressionCompiler) {
        this.sourceLookUpProvider = sourceLookUpProvider;
        this.expressionCompiler = expressionCompiler;
    }
}

