/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.scala.debugadapter.internal;

import ch.epfl.scala.debugadapter.CancelableFuture;
import ch.epfl.scala.debugadapter.DebuggeeRunner;
import ch.epfl.scala.debugadapter.Logger;
import ch.epfl.scala.debugadapter.internal.DebugSession$;
import ch.epfl.scala.debugadapter.internal.DebugSession$Disconnected$;
import ch.epfl.scala.debugadapter.internal.DebugSession$Listener$;
import ch.epfl.scala.debugadapter.internal.DebugSession$Ready$;
import ch.epfl.scala.debugadapter.internal.DebugSession$Restarted$;
import ch.epfl.scala.debugadapter.internal.DebugSession$Stopped$;
import ch.epfl.scala.debugadapter.internal.DebugSession$Terminated$;
import ch.epfl.scala.debugadapter.internal.LoggingAdapter;
import ch.epfl.scala.debugadapter.internal.Scheduler$;
import ch.epfl.scala.debugadapter.internal.Synchronized;
import com.microsoft.java.debug.core.adapter.IProviderContext;
import com.microsoft.java.debug.core.adapter.ProtocolServer;
import com.microsoft.java.debug.core.protocol.Events;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeoutException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0011%ca\u0002@\u0000\u0005\u0005\r\u00111\u0003\u0005\u000b\u0003k\u0001!\u0011!Q\u0001\n\u0005e\u0002BCA$\u0001\t\u0005\t\u0015!\u0003\u0002J!Q\u0011\u0011\u000b\u0001\u0003\u0002\u0003\u0006I!a\u0015\t\u0015\u0005e\u0003A!A!\u0002\u0013\tY\u0006\u0003\u0006\u0002b\u0001\u0011\t\u0011)A\u0005\u0003GB!\"a\u001b\u0001\u0005\u0003\u0005\u000b\u0011BA7\u0011)\t9\b\u0001B\u0001B\u0003%\u0011\u0011\u0010\u0005\u000b\u0003\u0013\u0003!\u0011!Q\u0001\f\u0005-\u0005bBAJ\u0001\u0011%\u0011QS\u0003\u0007\u0003W\u0003A!!,\t\u0013\u0005M\u0006A1A\u0005\n\u0005U\u0006\u0002CAf\u0001\u0001\u0006I!a.\t\u0013\u00055\u0007A1A\u0005\n\u0005=\u0007\u0002CAo\u0001\u0001\u0006I!!5\t\u0013\u0005}\u0007A1A\u0005\n\u0005\u0005\b\u0002CAv\u0001\u0001\u0006I!a9\t\u0013\u00055\bA1A\u0005\n\u0005=\u0007\u0002CAx\u0001\u0001\u0006I!!5\t\u0013\u0005E\bA1A\u0005\n\u0005M\b\u0002CBV\u0001\u0001\u0006I!!>\t\u0013\r5\u0006A1A\u0005\n\r=\u0006\u0002CB]\u0001\u0001\u0006Ia!-\t\u0013\rm\u0006\u0001\"\u0001\u0002\u0004\ru\u0006\"CB`\u0001\u0011\u0005\u00111ABa\u0011%\u0019I\r\u0001C\u0001\u0003\u0007\u0019Y\rC\u0004\u0004N\u0002!\taa4\t\u000f\rM\u0007\u0001\"\u0001\u0004L\"91Q\u001b\u0001\u0005R\r]\u0007bBBn\u0001\u0011E3Q\u001c\u0005\b\u0007G\u0004A\u0011KBs\u0011\u001d\u0019Y\u0010\u0001C\u0005\u0007{Dqaa@\u0001\t\u0013!\taB\u0004\u0005\u001a\u0001AI\u0001b\u0007\u0007\u000f\u0011u\u0001\u0001#\u0003\u0005 !9\u00111\u0013\u0012\u0005\u0002\u0011\u001d\u0002b\u0002C\u0015E\u0011\u0005A1\u0006\u0005\b\t_\u0011C\u0011\u0001C\u0019\u0011\u001d!9D\tC\u0001\tsAa\u0002\"\u0010\u0001!\u0003\r\t\u0011!C\u0005\t\u007f!9eB\u0005\u0002|~D\t!a\u0001\u0002~\u001aAap E\u0001\u0003\u0007\ty\u0010C\u0004\u0002\u0014&\"\tAa\u0002\u0007\u0013\t%\u0011\u0006%A\u0012\"\t-qa\u0002BGS!\u0015%1\u000f\u0004\b\u0005[J\u0003R\u0011B8\u0011\u001d\t\u0019*\fC\u0001\u0005cB\u0011Ba\n.\u0003\u0003%\tE!\u000b\t\u0013\t]R&!A\u0005\u0002\te\u0002\"\u0003B\u001e[\u0005\u0005I\u0011\u0001B;\u0011%\u0011I%LA\u0001\n\u0003\u0012Y\u0005C\u0005\u0003V5\n\t\u0011\"\u0001\u0003z!I!1L\u0017\u0002\u0002\u0013\u0005#Q\f\u0005\n\u0005?j\u0013\u0011!C!\u0005CB\u0011Ba\u0019.\u0003\u0003%IA!\u001a\b\u000f\t=\u0015\u0006#\"\u0003&\u00199!qB\u0015\t\u0006\nE\u0001bBAJq\u0011\u0005!1\u0005\u0005\n\u0005OA\u0014\u0011!C!\u0005SA\u0011Ba\u000e9\u0003\u0003%\tA!\u000f\t\u0013\tm\u0002(!A\u0005\u0002\tu\u0002\"\u0003B%q\u0005\u0005I\u0011\tB&\u0011%\u0011)\u0006OA\u0001\n\u0003\u00119\u0006C\u0005\u0003\\a\n\t\u0011\"\u0011\u0003^!I!q\f\u001d\u0002\u0002\u0013\u0005#\u0011\r\u0005\n\u0005GB\u0014\u0011!C\u0005\u0005K:qA!%*\u0011\u000b\u0013\u0019IB\u0004\u0003~%B)Ia \t\u000f\u0005M5\t\"\u0001\u0003\u0002\"I!qE\"\u0002\u0002\u0013\u0005#\u0011\u0006\u0005\n\u0005o\u0019\u0015\u0011!C\u0001\u0005sA\u0011Ba\u000fD\u0003\u0003%\tA!\"\t\u0013\t%3)!A\u0005B\t-\u0003\"\u0003B+\u0007\u0006\u0005I\u0011\u0001BE\u0011%\u0011YfQA\u0001\n\u0003\u0012i\u0006C\u0005\u0003`\r\u000b\t\u0011\"\u0011\u0003b!I!1M\"\u0002\u0002\u0013%!Q\r\u0004\n\u0005'K\u0003\u0013aI\u0011\u0005+;qA!@*\u0011\u000b\u0013\tKB\u0004\u0003\u001a&B)Ia'\t\u000f\u0005Mu\n\"\u0001\u0003 \"I!qE(\u0002\u0002\u0013\u0005#\u0011\u0006\u0005\n\u0005oy\u0015\u0011!C\u0001\u0005sA\u0011Ba\u000fP\u0003\u0003%\tAa)\t\u0013\t%s*!A\u0005B\t-\u0003\"\u0003B+\u001f\u0006\u0005I\u0011\u0001BT\u0011%\u0011YfTA\u0001\n\u0003\u0012i\u0006C\u0005\u0003`=\u000b\t\u0011\"\u0011\u0003b!I!1M(\u0002\u0002\u0013%!Q\r\u0004\u0007\u0005WK#I!,\t\u0015\t=\u0016L!f\u0001\n\u0003\u0011\t\f\u0003\u0006\u0003:f\u0013\t\u0012)A\u0005\u0005gCq!a%Z\t\u0003\u0011Y\fC\u0005\u0003Bf\u000b\t\u0011\"\u0001\u0003D\"I!qY-\u0012\u0002\u0013\u0005!\u0011\u001a\u0005\n\u0005OI\u0016\u0011!C!\u0005SA\u0011Ba\u000eZ\u0003\u0003%\tA!\u000f\t\u0013\tm\u0012,!A\u0005\u0002\t}\u0007\"\u0003B%3\u0006\u0005I\u0011\tB&\u0011%\u0011)&WA\u0001\n\u0003\u0011\u0019\u000fC\u0005\u0003\\e\u000b\t\u0011\"\u0011\u0003^!I!qL-\u0002\u0002\u0013\u0005#\u0011\r\u0005\n\u0005OL\u0016\u0011!C!\u0005S<\u0011Ba@*\u0003\u0003E\ta!\u0001\u0007\u0013\t-\u0016&!A\t\u0002\r\r\u0001bBAJQ\u0012\u00051\u0011\u0003\u0005\n\u0005?B\u0017\u0011!C#\u0005CB\u0011ba\u0005i\u0003\u0003%\ti!\u0006\t\u0013\re\u0001.!A\u0005\u0002\u000em\u0001\"\u0003B2Q\u0006\u0005I\u0011\u0002B3\u000f\u001d\u00199#\u000bEC\u0005g4qA!<*\u0011\u000b\u0013y\u000fC\u0004\u0002\u0014>$\tA!=\t\u0013\t\u001dr.!A\u0005B\t%\u0002\"\u0003B\u001c_\u0006\u0005I\u0011\u0001B\u001d\u0011%\u0011Yd\\A\u0001\n\u0003\u0011)\u0010C\u0005\u0003J=\f\t\u0011\"\u0011\u0003L!I!QK8\u0002\u0002\u0013\u0005!\u0011 \u0005\n\u00057z\u0017\u0011!C!\u0005;B\u0011Ba\u0018p\u0003\u0003%\tE!\u0019\t\u0013\t\rt.!A\u0005\n\t\u0015\u0004bBB\nS\u0011\u00051\u0011\u0006\u0005\b\u0007sIC\u0011BB\u001e\u0011\u001d\u00199%\u000bC\u0005\u0007\u0013Bqaa!*\t\u0013\u0019)\tC\u0004\u0004$&\"Ia!*\u0003\u0019\u0011+'-^4TKN\u001c\u0018n\u001c8\u000b\t\u0005\u0005\u00111A\u0001\tS:$XM\u001d8bY*!\u0011QAA\u0004\u00031!WMY;hC\u0012\f\u0007\u000f^3s\u0015\u0011\tI!a\u0003\u0002\u000bM\u001c\u0017\r\\1\u000b\t\u00055\u0011qB\u0001\u0005KB4GN\u0003\u0002\u0002\u0012\u0005\u00111\r[\n\u0004\u0001\u0005U\u0001\u0003BA\f\u0003ci!!!\u0007\u000b\t\u0005m\u0011QD\u0001\bC\u0012\f\u0007\u000f^3s\u0015\u0011\ty\"!\t\u0002\t\r|'/\u001a\u0006\u0005\u0003G\t)#A\u0003eK\n,xM\u0003\u0003\u0002(\u0005%\u0012\u0001\u00026bm\u0006TA!a\u000b\u0002.\u0005IQ.[2s_N|g\r\u001e\u0006\u0003\u0003_\t1aY8n\u0013\u0011\t\u0019$!\u0007\u0003\u001dA\u0013x\u000e^8d_2\u001cVM\u001d<fe\u000611o\\2lKR\u001c\u0001\u0001\u0005\u0003\u0002<\u0005\rSBAA\u001f\u0015\u0011\ty$!\u0011\u0002\u00079,GO\u0003\u0002\u0002(%!\u0011QIA\u001f\u0005\u0019\u0019vnY6fi\u00061!/\u001e8oKJ\u0004B!a\u0013\u0002N5\u0011\u00111A\u0005\u0005\u0003\u001f\n\u0019A\u0001\bEK\n,xmZ3f%Vtg.\u001a:\u0002\u000f\r|g\u000e^3yiB!\u0011qCA+\u0013\u0011\t9&!\u0007\u0003!%\u0003&o\u001c<jI\u0016\u00148i\u001c8uKb$\u0018A\u00027pO\u001e,'\u000f\u0005\u0003\u0002L\u0005u\u0013\u0002BA0\u0003\u0007\u0011a\u0001T8hO\u0016\u0014\u0018A\u00047pO\u001eLgnZ!eCB$XM\u001d\t\u0005\u0003K\n9'D\u0001\u0000\u0013\r\tIg \u0002\u000f\u0019><w-\u001b8h\u0003\u0012\f\u0007\u000f^3s\u0003%\tW\u000f^8DY>\u001cX\r\u0005\u0003\u0002p\u0005MTBAA9\u0015\t\tI!\u0003\u0003\u0002v\u0005E$a\u0002\"p_2,\u0017M\\\u0001\fOJ\f7-\u001a)fe&|G\r\u0005\u0003\u0002|\u0005\u0015UBAA?\u0015\u0011\ty(!!\u0002\u0011\u0011,(/\u0019;j_:TA!a!\u0002r\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005\u001d\u0015Q\u0010\u0002\t\tV\u0014\u0018\r^5p]\u0006\u0001R\r_3dkRLwN\\\"p]R,\u0007\u0010\u001e\t\u0005\u0003\u001b\u000by)\u0004\u0002\u0002\u0002&!\u0011\u0011SAA\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH/\u0001\u0004=S:LGO\u0010\u000b\u0011\u0003/\u000bi*a(\u0002\"\u0006\r\u0016QUAT\u0003S#B!!'\u0002\u001cB\u0019\u0011Q\r\u0001\t\u000f\u0005%\u0015\u0002q\u0001\u0002\f\"9\u0011QG\u0005A\u0002\u0005e\u0002bBA$\u0013\u0001\u0007\u0011\u0011\n\u0005\b\u0003#J\u0001\u0019AA*\u0011\u001d\tI&\u0003a\u0001\u00037Bq!!\u0019\n\u0001\u0004\t\u0019\u0007C\u0004\u0002l%\u0001\r!!\u001c\t\u000f\u0005]\u0014\u00021\u0001\u0002z\tAA*Y;oG\"LE\r\u0005\u0003\u0002p\u0005=\u0016\u0002BAY\u0003c\u00121!\u00138u\u0003Aa\u0017-\u001e8dQ\u0016$'+Z9vKN$8/\u0006\u0002\u00028B1\u0011\u0011XAb\u0003\u000fl!!a/\u000b\t\u0005u\u0016qX\u0001\b[V$\u0018M\u00197f\u0015\u0011\t\t-!\u001d\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002F\u0006m&aA*fiB\u0019\u0011\u0011\u001a\u0006\u000e\u0003\u0001\t\u0011\u0003\\1v]\u000eDW\r\u001a*fcV,7\u000f^:!\u0003=!XM]7j]\u0006$X\rZ#wK:$XCAAi!\u0019\ti)a5\u0002X&!\u0011Q[AA\u0005\u001d\u0001&o\\7jg\u0016\u0004B!a\u001c\u0002Z&!\u00111\\A9\u0005\u0011)f.\u001b;\u0002!Q,'/\\5oCR,G-\u0012<f]R\u0004\u0013a\u00043fEV<w-Z3BI\u0012\u0014Xm]:\u0016\u0005\u0005\r\bCBAG\u0003'\f)\u000f\u0005\u0003\u0002<\u0005\u001d\u0018\u0002BAu\u0003{\u0011\u0011#\u00138fiN{7m[3u\u0003\u0012$'/Z:t\u0003A!WMY;hO\u0016,\u0017\t\u001a3sKN\u001c\b%\u0001\u0005biR\f7\r[3e\u0003%\tG\u000f^1dQ\u0016$\u0007%A\tfq&$8\u000b^1ukN\u0004&o\\7jg\u0016,\"!!>\u0011\r\u00055\u00151[A|!\r\tIp\u000b\b\u0004\u0003KB\u0013\u0001\u0004#fEV<7+Z:tS>t\u0007cAA3SM\u0019\u0011F!\u0001\u0011\t\u0005=$1A\u0005\u0005\u0005\u000b\t\tH\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0003{\u0014!\"\u0012=jiN#\u0018\r^;t'\rY#\u0011A\u0015\u0005Waj3I\u0001\u0007ESN\u001cwN\u001c8fGR,GmE\u00059\u0005\u0003\u0011\u0019Ba\u0006\u0003\u001eA\u0019!QC\u0016\u000e\u0003%\u0002B!a\u001c\u0003\u001a%!!1DA9\u0005\u001d\u0001&o\u001c3vGR\u0004B!a\u001c\u0003 %!!\u0011EA9\u00051\u0019VM]5bY&T\u0018M\u00197f)\t\u0011)\u0003E\u0002\u0003\u0016a\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXC\u0001B\u0016!\u0011\u0011iCa\r\u000e\u0005\t=\"\u0002\u0002B\u0019\u0003\u0003\nA\u0001\\1oO&!!Q\u0007B\u0018\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011QV\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0011yD!\u0012\u0011\t\u0005=$\u0011I\u0005\u0005\u0005\u0007\n\tHA\u0002B]fD\u0011Ba\u0012=\u0003\u0003\u0005\r!!,\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011i\u0005\u0005\u0004\u0003P\tE#qH\u0007\u0003\u0003\u007fKAAa\u0015\u0002@\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\tiG!\u0017\t\u0013\t\u001dc(!AA\u0002\t}\u0012\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u00055\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\t-\u0012a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"Aa\u001a\u0011\t\t5\"\u0011N\u0005\u0005\u0005W\u0012yC\u0001\u0004PE*,7\r\u001e\u0002\n%\u0016\u001cH/\u0019:uK\u0012\u001c\u0012\"\fB\u0001\u0005'\u00119B!\b\u0015\u0005\tM\u0004c\u0001B\u000b[Q!!q\bB<\u0011%\u00119%MA\u0001\u0002\u0004\ti\u000b\u0006\u0003\u0002n\tm\u0004\"\u0003B$g\u0005\u0005\t\u0019\u0001B \u0005)!VM]7j]\u0006$X\rZ\n\n\u0007\n\u0005!1\u0003B\f\u0005;!\"Aa!\u0011\u0007\tU1\t\u0006\u0003\u0003@\t\u001d\u0005\"\u0003B$\u000f\u0006\u0005\t\u0019AAW)\u0011\tiGa#\t\u0013\t\u001d\u0013*!AA\u0002\t}\u0012!\u0003*fgR\f'\u000f^3e\u00031!\u0015n]2p]:,7\r^3e\u0003)!VM]7j]\u0006$X\r\u001a\u0002\u0006'R\fG/Z\n\u0004\u001b\n\u0005\u0011\u0006B'P3>\u0014QAU3bIf\u001c\u0012b\u0014B\u0001\u0005;\u00139B!\b\u0011\u0007\tUQ\n\u0006\u0002\u0003\"B\u0019!QC(\u0015\t\t}\"Q\u0015\u0005\n\u0005\u000f\u001a\u0016\u0011!a\u0001\u0003[#B!!\u001c\u0003*\"I!qI+\u0002\u0002\u0003\u0007!q\b\u0002\b'R\f'\u000f^3e'%I&\u0011\u0001BO\u0005/\u0011i\"\u0001\u0005eK\n,xmZ3f+\t\u0011\u0019\f\u0005\u0004\u0002L\tU\u0016q[\u0005\u0005\u0005o\u000b\u0019A\u0001\tDC:\u001cW\r\\1cY\u00164U\u000f^;sK\u0006IA-\u001a2vO\u001e,W\r\t\u000b\u0005\u0005{\u0013y\fE\u0002\u0003\u0016eCqAa,]\u0001\u0004\u0011\u0019,\u0001\u0003d_BLH\u0003\u0002B_\u0005\u000bD\u0011Ba,^!\u0003\u0005\rAa-\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!1\u001a\u0016\u0005\u0005g\u0013im\u000b\u0002\u0003PB!!\u0011\u001bBn\u001b\t\u0011\u0019N\u0003\u0003\u0003V\n]\u0017!C;oG\",7m[3e\u0015\u0011\u0011I.!\u001d\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003^\nM'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dKR!!q\bBq\u0011%\u00119%YA\u0001\u0002\u0004\ti\u000b\u0006\u0003\u0002n\t\u0015\b\"\u0003B$G\u0006\u0005\t\u0019\u0001B \u0003\u0019)\u0017/^1mgR!\u0011Q\u000eBv\u0011%\u00119EZA\u0001\u0002\u0004\u0011yDA\u0004Ti>\u0004\b/\u001a3\u0014\u0013=\u0014\tA!(\u0003\u0018\tuAC\u0001Bz!\r\u0011)b\u001c\u000b\u0005\u0005\u007f\u00119\u0010C\u0005\u0003HM\f\t\u00111\u0001\u0002.R!\u0011Q\u000eB~\u0011%\u00119%^A\u0001\u0002\u0004\u0011y$A\u0003SK\u0006$\u00170A\u0004Ti\u0006\u0014H/\u001a3\u0011\u0007\tU\u0001nE\u0003i\u0007\u000b\u0011i\u0002\u0005\u0005\u0004\b\r5!1\u0017B_\u001b\t\u0019IA\u0003\u0003\u0004\f\u0005E\u0014a\u0002:v]RLW.Z\u0005\u0005\u0007\u001f\u0019IAA\tBEN$(/Y2u\rVt7\r^5p]F\"\"a!\u0001\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\t\tu6q\u0003\u0005\b\u0005_[\u0007\u0019\u0001BZ\u0003\u001d)h.\u00199qYf$Ba!\b\u0004$A1\u0011qNB\u0010\u0005gKAa!\t\u0002r\t1q\n\u001d;j_:D\u0011b!\nm\u0003\u0003\u0005\rA!0\u0002\u0007a$\u0003'A\u0004Ti>\u0004\b/\u001a3\u0015\u0019\r-2qFB\u0019\u0007g\u0019)da\u000e\u0015\t\u0005e5Q\u0006\u0005\b\u0003\u0013K\b9AAF\u0011\u001d\t)$\u001fa\u0001\u0003sAq!a\u0012z\u0001\u0004\tI\u0005C\u0004\u0002Ze\u0004\r!a\u0017\t\u000f\u0005-\u0014\u00101\u0001\u0002n!9\u0011qO=A\u0002\u0005e\u0014\u0001\u00024pe.$B!a6\u0004>!91q\b>A\u0002\r\u0005\u0013!\u00014\u0011\r\u0005=41IAl\u0013\u0011\u0019)%!\u001d\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0014a\u0004;p\u0003R$\u0018m\u00195SKF,Xm\u001d;\u0015\r\r-31PB@!\u0011\u0019ie!\u001e\u000f\t\r=3q\u000e\b\u0005\u0007#\u001aYG\u0004\u0003\u0004T\r%d\u0002BB+\u0007OrAaa\u0016\u0004f9!1\u0011LB2\u001d\u0011\u0019Yf!\u0019\u000e\u0005\ru#\u0002BB0\u0003o\ta\u0001\u0010:p_Rt\u0014BAA\u0018\u0013\u0011\tY#!\f\n\t\u0005\u001d\u0012\u0011F\u0005\u0005\u0003G\t)#\u0003\u0003\u0002 \u0005\u0005\u0012\u0002BB7\u0003;\t\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0007c\u001a\u0019(\u0001\u0005NKN\u001c\u0018mZ3t\u0015\u0011\u0019i'!\b\n\t\r]4\u0011\u0010\u0002\b%\u0016\fX/Z:u\u0015\u0011\u0019\tha\u001d\t\u000f\ru4\u00101\u0001\u0002.\u0006\u00191/Z9\t\u000f\r\u00055\u00101\u0001\u0002f\u00069\u0011\r\u001a3sKN\u001c\u0018A\u00024bS2,G\r\u0006\u0004\u0004\b\u000e55\u0011\u0013\t\u0005\u0007\u001b\u001aI)\u0003\u0003\u0004\f\u000ee$\u0001\u0003*fgB|gn]3\t\u000f\r=E\u00101\u0001\u0004L\u00059!/Z9vKN$\bbBBJy\u0002\u00071QS\u0001\b[\u0016\u001c8/Y4f!\u0011\u00199ja(\u000f\t\re51\u0014\t\u0005\u00077\n\t(\u0003\u0003\u0004\u001e\u0006E\u0014A\u0002)sK\u0012,g-\u0003\u0003\u00036\r\u0005&\u0002BBO\u0003c\nQb\u001d5pk2$'+Z:uCJ$H\u0003BA7\u0007OCqa!+~\u0001\u0004\u0019Y%A\teSN\u001cwN\u001c8fGR\u0014V-];fgR\f!#\u001a=jiN#\u0018\r^;t!J|W.[:fA\u0005QA-\u001a2vON#\u0018\r^3\u0016\u0005\rE\u0006CBA3\u0007g\u001b9,C\u0002\u00046~\u0014AbU=oG\"\u0014xN\\5{K\u0012\u00042!!?N\u0003-!WMY;h'R\fG/\u001a\u0011\u0002\u0019\r,(O]3oiN#\u0018\r^3\u0016\u0005\r]\u0016!E4fi\u0012+'-^4fK\u0006#GM]3tgV\u001111\u0019\t\u0007\u0003\u001b\u001b)-!:\n\t\r\u001d\u0017\u0011\u0011\u0002\u0007\rV$XO]3\u0002\u000bM$\u0018M\u001d;\u0015\u0005\u0005]\u0017AC3ySR\u001cF/\u0019;vgV\u00111\u0011\u001b\t\u0007\u0003\u001b\u001b)-a>\u0002\u000b\rdwn]3\u0002\u001f\u0011L7\u000f]1uG\"\u0014V-];fgR$B!a6\u0004Z\"91q\u0012\u000fA\u0002\r-\u0013\u0001D:f]\u0012\u0014Vm\u001d9p]N,G\u0003BAl\u0007?Dqa!9\u001e\u0001\u0004\u00199)\u0001\u0005sKN\u0004xN\\:f\u0003%\u0019XM\u001c3Fm\u0016tG\u000f\u0006\u0003\u0002X\u000e\u001d\bbBBu=\u0001\u000711^\u0001\u0006KZ,g\u000e\u001e\t\u0005\u0007[\u001c)P\u0004\u0003\u0004p\u000eEXBAB:\u0013\u0011\u0019\u0019pa\u001d\u0002\r\u00153XM\u001c;t\u0013\u0011\u00199p!?\u0003\u0015\u0011+'-^4Fm\u0016tGO\u0003\u0003\u0004t\u000eM\u0014\u0001\u00028b[\u0016,\"a!&\u0002\u001d\r\fgnY3m!J|W.[:fgR!\u0011q\u001bC\u0002\u0011\u001d!)\u0001\ta\u0001\t\u000f\tQaY1vg\u0016\u0004B\u0001\"\u0003\u0005\u00149!A1\u0002C\b\u001d\u0011\u0019Y\u0006\"\u0004\n\u0005\u0005%\u0011\u0002\u0002C\t\u0003c\nq\u0001]1dW\u0006<W-\u0003\u0003\u0005\u0016\u0011]!!\u0003+ie><\u0018M\u00197f\u0015\u0011!\t\"!\u001d\u0002\u00111K7\u000f^3oKJ\u00042!!3#\u0005!a\u0015n\u001d;f]\u0016\u00148#\u0002\u0012\u0003\u0002\u0011\u0005\u0002\u0003BA&\tGIA\u0001\"\n\u0002\u0004\t\u0001B)\u001a2vO\u001e,W\rT5ti\u0016tWM\u001d\u000b\u0003\t7\t1b\u001c8MSN$XM\\5oOR!\u0011q\u001bC\u0017\u0011\u001d\u0019\t\t\na\u0001\u0003K\f1a\\;u)\u0011\t9\u000eb\r\t\u000f\u0011UR\u00051\u0001\u0004\u0016\u0006!A.\u001b8f\u0003\r)'O\u001d\u000b\u0005\u0003/$Y\u0004C\u0004\u00056\u0019\u0002\ra!&\u0002+M,\b/\u001a:%I&\u001c\b/\u0019;dQJ+\u0017/^3tiR!\u0011q\u001bC!\u0011%\u00119eJA\u0001\u0002\u0004!\u0019\u0005\u0005\u0003\u0005F\rUTBAB=\u0013\u0011\u0019).!\r")
public final class DebugSession
extends ProtocolServer {
    private volatile DebugSession$Listener$ Listener$module;
    private final Socket socket;
    private final DebuggeeRunner runner;
    private final Logger logger;
    private final LoggingAdapter loggingAdapter;
    private final boolean autoClose;
    private final Duration gracePeriod;
    private final ExecutionContext executionContext;
    private final Set<Object> launchedRequests;
    private final Promise<BoxedUnit> terminatedEvent;
    private final Promise<InetSocketAddress> ch$epfl$scala$debugadapter$internal$DebugSession$$debuggeeAddress;
    private final Promise<BoxedUnit> attached;
    private final Promise<ExitStatus> exitStatusPromise;
    private final Synchronized<State> debugState;

    public static DebugSession apply(Socket socket, DebuggeeRunner debuggeeRunner, Logger logger, boolean bl, Duration duration, ExecutionContext executionContext) {
        return DebugSession$.MODULE$.apply(socket, debuggeeRunner, logger, bl, duration, executionContext);
    }

    private DebugSession$Listener$ Listener() {
        if (this.Listener$module == null) {
            this.Listener$lzycompute$1();
        }
        return this.Listener$module;
    }

    private /* synthetic */ void super$dispatchRequest(Messages.Request x$1) {
        super.dispatchRequest(x$1);
    }

    private Set<Object> launchedRequests() {
        return this.launchedRequests;
    }

    private Promise<BoxedUnit> terminatedEvent() {
        return this.terminatedEvent;
    }

    public Promise<InetSocketAddress> ch$epfl$scala$debugadapter$internal$DebugSession$$debuggeeAddress() {
        return this.ch$epfl$scala$debugadapter$internal$DebugSession$$debuggeeAddress;
    }

    private Promise<BoxedUnit> attached() {
        return this.attached;
    }

    private Promise<ExitStatus> exitStatusPromise() {
        return this.exitStatusPromise;
    }

    private Synchronized<State> debugState() {
        return this.debugState;
    }

    public State currentState() {
        return this.debugState().value();
    }

    public Future<InetSocketAddress> getDebugeeAddress() {
        return this.ch$epfl$scala$debugadapter$internal$DebugSession$$debuggeeAddress().future();
    }

    public void start() {
        this.debugState().transform((Function1<State, State>)(Function1 & Serializable & scala.Serializable)x0$1 -> {
            State state;
            State state2 = x0$1;
            if (DebugSession$Ready$.MODULE$.equals(state2)) {
                DebugSession$.MODULE$.ch$epfl$scala$debugadapter$internal$DebugSession$$fork((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.run());
                CancelableFuture<BoxedUnit> debuggee = $this.runner.run(this.Listener());
                debuggee.future().onComplete((Function1 & Serializable & scala.Serializable)result -> {
                    result.failed().foreach((Function1 & Serializable & scala.Serializable)cause -> {
                        this.cancelPromises(cause);
                        return BoxedUnit.UNIT;
                    });
                    return this.terminatedEvent().future().map((Function1 & Serializable & scala.Serializable)x$1 -> {
                        DebugSession.$anonfun$start$5(this, x$1);
                        return BoxedUnit.UNIT;
                    }, $this.executionContext);
                }, $this.executionContext);
                state = new Started(debuggee);
            } else {
                state = state2;
            }
            return state;
        });
    }

    public Future<ExitStatus> exitStatus() {
        return this.exitStatusPromise().future();
    }

    public void close() {
        super.stop();
        this.loggingAdapter.onClosingSession();
        this.debugState().transform((Function1<State, State>)(Function1 & Serializable & scala.Serializable)x0$1 -> {
            DebugSession$Stopped$ debugSession$Stopped$;
            State state = x0$1;
            if (state instanceof Started) {
                Object object;
                Started started = (Started)state;
                CancelableFuture<BoxedUnit> debuggee = started.debuggee();
                this.cancelPromises(new CancellationException("Debug session closed"));
                debuggee.cancel();
                try {
                    object = Await$.MODULE$.result((Awaitable)this.terminatedEvent().future(), $this.gracePeriod);
                }
                catch (TimeoutException timeoutException) {
                    $this.logger.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(65).append("Communication with debuggee ").append(this.name()).append(" is frozen: missing terminated event.").toString());
                    object = BoxedUnit.UNIT;
                }
                debugSession$Stopped$ = DebugSession$Stopped$.MODULE$;
            } else {
                debugSession$Stopped$ = DebugSession$Stopped$.MODULE$;
            }
            return debugSession$Stopped$;
        });
        this.logger.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("closing connection with debugger ").append(this.name()).toString());
        this.socket.close();
        this.exitStatusPromise().trySuccess((Object)DebugSession$Terminated$.MODULE$);
    }

    public void dispatchRequest(Messages.Request request) {
        int requestId = request.seq;
        String string = request.command;
        if ("launch".equals(string)) {
            this.launchedRequests().add((Object)BoxesRunTime.boxToInteger((int)requestId));
            Scheduler$.MODULE$.timeout(this.ch$epfl$scala$debugadapter$internal$DebugSession$$debuggeeAddress(), this.gracePeriod).future().onComplete((Function1 & Serializable & scala.Serializable)x0$1 -> {
                DebugSession.$anonfun$dispatchRequest$1(this, requestId, request, x0$1);
                return BoxedUnit.UNIT;
            }, this.executionContext);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("configurationDone".equals(string)) {
            this.attached().future().onComplete((Function1 & Serializable & scala.Serializable)x0$2 -> {
                DebugSession.$anonfun$dispatchRequest$2(this, request, x0$2);
                return BoxedUnit.UNIT;
            }, this.executionContext);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("disconnect".equals(string)) {
            this.debugState().transform((Function1<State, State>)(Function1 & Serializable & scala.Serializable)x0$3 -> {
                DebugSession$Stopped$ debugSession$Stopped$;
                State state = x0$3;
                if (state instanceof Started) {
                    Started started = (Started)state;
                    CancelableFuture<BoxedUnit> debuggee = started.debuggee();
                    this.cancelPromises(new CancellationException("Client disconnected"));
                    this.exitStatusPromise().trySuccess((Object)(DebugSession$.MODULE$.ch$epfl$scala$debugadapter$internal$DebugSession$$shouldRestart(request) ? DebugSession$Restarted$.MODULE$ : DebugSession$Disconnected$.MODULE$));
                    this.super$dispatchRequest(request);
                    debuggee.cancel();
                    debugSession$Stopped$ = DebugSession$Stopped$.MODULE$;
                } else {
                    Messages.Response ack = new Messages.Response(request$1.seq, request$1.command, true);
                    this.sendResponse(ack);
                    debugSession$Stopped$ = DebugSession$Stopped$.MODULE$;
                }
                return debugSession$Stopped$;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            super.dispatchRequest(request);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void sendResponse(Messages.Response response) {
        int requestId = response.request_seq;
        boolean bl = false;
        String string = null;
        String string2 = response.command;
        if ("attach".equals(string2)) {
            bl = true;
            string = string2;
            if (this.launchedRequests().apply((Object)BoxesRunTime.boxToInteger((int)requestId))) {
                response.command = Requests.Command.LAUNCH.getName();
                this.attached().success((Object)BoxedUnit.UNIT);
                super.sendResponse(response);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (bl) {
            this.attached().success((Object)BoxedUnit.UNIT);
            super.sendResponse(response);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        super.sendResponse(response);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void sendEvent(Events.DebugEvent event) {
        try {
            super.sendEvent(event);
        }
        finally {
            String string = event.type;
            String string2 = "terminated";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                this.terminatedEvent().trySuccess((Object)BoxedUnit.UNIT);
            }
        }
    }

    private String name() {
        return this.runner.name();
    }

    private void cancelPromises(Throwable cause) {
        this.ch$epfl$scala$debugadapter$internal$DebugSession$$debuggeeAddress().tryFailure(cause);
        this.attached().tryFailure(cause);
    }

    private final void Listener$lzycompute$1() {
        DebugSession debugSession = this;
        synchronized (debugSession) {
            if (this.Listener$module == null) {
                this.Listener$module = new DebugSession$Listener$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$start$5(DebugSession $this, BoxedUnit x$1) {
        block0: {
            if (!$this.autoClose) break block0;
            $this.exitStatusPromise().trySuccess((Object)DebugSession$Terminated$.MODULE$);
            $this.close();
        }
    }

    public static final /* synthetic */ void $anonfun$dispatchRequest$1(DebugSession $this, int requestId$1, Messages.Request request$1, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            InetSocketAddress address = (InetSocketAddress)success.value();
            $this.super$dispatchRequest(DebugSession$.MODULE$.ch$epfl$scala$debugadapter$internal$DebugSession$$toAttachRequest(requestId$1, address));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            String cause = new StringBuilder(34).append("Could not start debuggee ").append($this.name()).append(" due to: ").append(exception.getMessage()).toString();
            $this.sendResponse(DebugSession$.MODULE$.ch$epfl$scala$debugadapter$internal$DebugSession$$failed(request$1, cause));
            $this.attached().tryFailure((Throwable)new IllegalStateException(cause));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public static final /* synthetic */ void $anonfun$dispatchRequest$2(DebugSession $this, Messages.Request request$1, Try x0$2) {
        Try try_ = x0$2;
        if (try_ instanceof Success) {
            $this.super$dispatchRequest(request$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            $this.sendResponse(DebugSession$.MODULE$.ch$epfl$scala$debugadapter$internal$DebugSession$$failed(request$1, exception.getMessage()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public DebugSession(Socket socket, DebuggeeRunner runner, IProviderContext context, Logger logger, LoggingAdapter loggingAdapter, boolean autoClose, Duration gracePeriod, ExecutionContext executionContext) {
        this.socket = socket;
        this.runner = runner;
        this.logger = logger;
        this.loggingAdapter = loggingAdapter;
        this.autoClose = autoClose;
        this.gracePeriod = gracePeriod;
        this.executionContext = executionContext;
        super(socket.getInputStream(), socket.getOutputStream(), context, loggingAdapter.factory());
        this.launchedRequests = Set$.MODULE$.empty();
        this.terminatedEvent = Promise$.MODULE$.apply();
        this.ch$epfl$scala$debugadapter$internal$DebugSession$$debuggeeAddress = Promise$.MODULE$.apply();
        this.attached = Promise$.MODULE$.apply();
        this.exitStatusPromise = Promise$.MODULE$.apply();
        this.debugState = new Synchronized<DebugSession$Ready$>(DebugSession$Ready$.MODULE$);
    }

    public static interface ExitStatus {
    }

    public static final class Started
    implements State,
    Product,
    scala.Serializable {
        private final CancelableFuture<BoxedUnit> debuggee;

        public CancelableFuture<BoxedUnit> debuggee() {
            return this.debuggee;
        }

        public Started copy(CancelableFuture<BoxedUnit> debuggee) {
            return new Started(debuggee);
        }

        public CancelableFuture<BoxedUnit> copy$default$1() {
            return this.debuggee();
        }

        public String productPrefix() {
            return "Started";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }
            }
            return this.debuggee();
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Started;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Started)) return false;
            boolean bl = true;
            if (!bl) return false;
            Started started = (Started)x$1;
            CancelableFuture<BoxedUnit> cancelableFuture = this.debuggee();
            CancelableFuture<BoxedUnit> cancelableFuture2 = started.debuggee();
            if (cancelableFuture != null) {
                if (!cancelableFuture.equals(cancelableFuture2)) return false;
                return true;
            }
            if (cancelableFuture2 == null) return true;
            return false;
        }

        public Started(CancelableFuture<BoxedUnit> debuggee) {
            this.debuggee = debuggee;
            Product.$init$((Product)this);
        }
    }

    public static interface State {
    }
}

