/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.scala.debugadapter.internal;

import ch.epfl.scala.debugadapter.ClassEntry;
import ch.epfl.scala.debugadapter.ClassSystem;
import ch.epfl.scala.debugadapter.SourceDirectory;
import ch.epfl.scala.debugadapter.SourceEntry;
import ch.epfl.scala.debugadapter.SourceJar;
import ch.epfl.scala.debugadapter.StandaloneSourceFile;
import ch.epfl.scala.debugadapter.internal.ClassEntryLookUp;
import ch.epfl.scala.debugadapter.internal.ClassFile;
import ch.epfl.scala.debugadapter.internal.IO$;
import ch.epfl.scala.debugadapter.internal.SourceFile;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.matching.Regex;
import scala.util.matching.Regex$;

public final class ClassEntryLookUp$ {
    public static ClassEntryLookUp$ MODULE$;

    static {
        new ClassEntryLookUp$();
    }

    private ClassEntryLookUp empty() {
        return new ClassEntryLookUp((Map<URI, SourceFile>)Predef$.MODULE$.Map().empty(), (Map<URI, Seq<ClassFile>>)Predef$.MODULE$.Map().empty(), (Map<String, SourceFile>)Predef$.MODULE$.Map().empty(), (Seq<ClassFile>)((Seq)Nil$.MODULE$), (Seq<ClassFile>)((Seq)Nil$.MODULE$));
    }

    public ClassEntryLookUp apply(ClassEntry entry2) {
        ClassEntryLookUp classEntryLookUp;
        Seq sourceFiles = (Seq)entry2.sourceEntries().flatMap((Function1 & Serializable & scala.Serializable)entry -> MODULE$.getAllSourceFiles((SourceEntry)entry), Seq$.MODULE$.canBuildFrom());
        if (sourceFiles.isEmpty()) {
            classEntryLookUp = this.empty();
        } else {
            Seq classFiles = (Seq)entry2.classSystems().flatMap((Function1 & Serializable & scala.Serializable)classSystem -> (Vector)classSystem.within((Function2 & Serializable & scala.Serializable)(fileSystem, root) -> MODULE$.readAllClassFiles((ClassSystem)classSystem, (FileSystem)fileSystem, (Path)root)), Seq$.MODULE$.canBuildFrom());
            Map sourceUriToSourceFile = ((TraversableOnce)sourceFiles.map((Function1 & Serializable & scala.Serializable)f -> new Tuple2((Object)f.uri(), f), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            Map sourceNameToSourceFile = sourceFiles.groupBy((Function1 & Serializable & scala.Serializable)f -> f.fileName());
            scala.collection.mutable.Map classNameToSourceFile = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            scala.collection.mutable.Map sourceUriToClassFiles = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            Buffer orphanClassFiles = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            Buffer missingSourceFileClassFiles = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            classFiles.foreach((Function1 & Serializable & scala.Serializable)classFile -> {
                ClassEntryLookUp$.$anonfun$apply$6(classNameToSourceFile, sourceUriToClassFiles, sourceNameToSourceFile, missingSourceFileClassFiles, orphanClassFiles, classFile);
                return BoxedUnit.UNIT;
            });
            classEntryLookUp = new ClassEntryLookUp((Map<URI, SourceFile>)sourceUriToSourceFile, (Map<URI, Seq<ClassFile>>)sourceUriToClassFiles.toMap(Predef$.MODULE$.$conforms()), (Map<String, SourceFile>)classNameToSourceFile.toMap(Predef$.MODULE$.$conforms()), (Seq<ClassFile>)missingSourceFileClassFiles, (Seq<ClassFile>)orphanClassFiles);
        }
        return classEntryLookUp;
    }

    private Seq<SourceFile> getAllSourceFiles(SourceEntry entry) {
        Seq seq;
        SourceEntry sourceEntry = entry;
        if (sourceEntry instanceof SourceJar) {
            SourceJar sourceJar = (SourceJar)sourceEntry;
            Path jar = sourceJar.jar();
            seq = (Seq)IO$.MODULE$.withinJarFile(jar, (Function1 & Serializable & scala.Serializable)fileSystem -> MODULE$.getAllSourceFiles(entry, (FileSystem)fileSystem, fileSystem.getPath("/", new String[0])).toVector());
        } else if (sourceEntry instanceof SourceDirectory) {
            SourceDirectory sourceDirectory = (SourceDirectory)sourceEntry;
            Path directory = sourceDirectory.directory();
            seq = this.getAllSourceFiles(entry, FileSystems.getDefault(), directory).toSeq();
        } else if (sourceEntry instanceof StandaloneSourceFile) {
            StandaloneSourceFile standaloneSourceFile = (StandaloneSourceFile)sourceEntry;
            Path absolutePath = standaloneSourceFile.absolutePath();
            String relativePath = standaloneSourceFile.relativePath();
            seq = (Seq)new .colon.colon((Object)new SourceFile(entry, relativePath, absolutePath.toUri()), (List)Nil$.MODULE$);
        } else {
            throw new MatchError((Object)sourceEntry);
        }
        return seq;
    }

    private Iterator<SourceFile> getAllSourceFiles(SourceEntry entry, FileSystem fileSystem, Path root) {
        Iterator iterator;
        if (Files.exists(root, new LinkOption[0])) {
            PathMatcher sourceMatcher = fileSystem.getPathMatcher("glob:**.{scala,java}");
            iterator = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(Files.walk(root, new FileVisitOption[0]).filter(x$1 -> sourceMatcher.matches((Path)x$1)).iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)path -> {
                String relativePath = ((Object)root.relativize((Path)path)).toString().replace('\\', '/');
                return new SourceFile(entry, relativePath, path.toUri());
            });
        } else {
            iterator = package$.MODULE$.Iterator().empty();
        }
        return iterator;
    }

    private Vector<ClassFile> readAllClassFiles(ClassSystem classSystem, FileSystem fileSystem, Path root) {
        Vector vector;
        if (Files.exists(root, new LinkOption[0])) {
            PathMatcher classMatcher = fileSystem.getPathMatcher("glob:**.class");
            vector = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(Files.walk(root, new FileVisitOption[0]).filter(x$1 -> classMatcher.matches((Path)x$1)).iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)path -> MODULE$.readClassFile(classSystem, root, (Path)path)).toVector();
        } else {
            vector = package$.MODULE$.Vector().empty();
        }
        return vector;
    }

    private ClassFile readClassFile(ClassSystem classSystem, Path root, Path path) {
        InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
        ClassReader reader = new ClassReader(inputStream);
        String fullyQualifiedName = reader.getClassName().replace('/', '.');
        ObjectRef sourceName = ObjectRef.create((Object)Option$.MODULE$.empty());
        ClassVisitor visitor = new ClassVisitor(sourceName){
            private final ObjectRef sourceName$1;

            public void visitSource(String source, String debug) {
                this.sourceName$1.elem = Option$.MODULE$.apply((Object)source);
            }
            {
                this.sourceName$1 = sourceName$1;
                super(589824);
            }
        };
        reader.accept(visitor, 0);
        Path relativePath = root.relativize(path);
        return new ClassFile(fullyQualifiedName, (Option<String>)((Option)sourceName.elem), ((Object)relativePath).toString(), classSystem);
    }

    private boolean findPackage(SourceFile sourceFile, String fullPackage) {
        Seq nestedPackages = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(fullPackage)).split('.'))).foldLeft((Object)Nil$.MODULE$, (Function2 & Serializable & scala.Serializable)(nestedParts, newPart) -> (Seq)((SeqLike)nestedParts.map((Function1 & Serializable & scala.Serializable)outer -> new StringBuilder(1).append((String)outer).append(".").append((String)newPart).toString(), Seq$.MODULE$.canBuildFrom())).$colon$plus(newPart, Seq$.MODULE$.canBuildFrom()));
        String sourceContent = this.ch$epfl$scala$debugadapter$internal$ClassEntryLookUp$$readSourceContent(sourceFile);
        return nestedPackages.exists((Function1 & Serializable & scala.Serializable)string -> BoxesRunTime.boxToBoolean((boolean)ClassEntryLookUp$.$anonfun$findPackage$3(sourceContent, string)));
    }

    public String ch$epfl$scala$debugadapter$internal$ClassEntryLookUp$$readSourceContent(SourceFile sourceFile) {
        return (String)this.withinSourceEntry(sourceFile.entry(), (Function1 & Serializable & scala.Serializable)root -> {
            Path sourcePath = root.resolve(sourceFile.relativePath());
            return new String(Files.readAllBytes(sourcePath));
        });
    }

    private <T> T withinSourceEntry(SourceEntry sourceEntry, Function1<Path, T> f) {
        Object object;
        SourceEntry sourceEntry2 = sourceEntry;
        if (sourceEntry2 instanceof SourceJar) {
            SourceJar sourceJar = (SourceJar)sourceEntry2;
            Path jar = sourceJar.jar();
            object = IO$.MODULE$.withinJarFile(jar, (Function1 & Serializable & scala.Serializable)fs -> f.apply((Object)fs.getPath("/", new String[0])));
        } else if (sourceEntry2 instanceof SourceDirectory) {
            SourceDirectory sourceDirectory = (SourceDirectory)sourceEntry2;
            Path dir = sourceDirectory.directory();
            object = f.apply((Object)dir);
        } else if (sourceEntry2 instanceof StandaloneSourceFile) {
            StandaloneSourceFile standaloneSourceFile = (StandaloneSourceFile)sourceEntry2;
            Path absolutePath = standaloneSourceFile.absolutePath();
            object = f.apply((Object)absolutePath.getParent());
        } else {
            throw new MatchError((Object)sourceEntry2);
        }
        return object;
    }

    private static final void recordSourceFile$1(SourceFile sourceFile, scala.collection.mutable.Map classNameToSourceFile$1, ClassFile classFile$2, scala.collection.mutable.Map sourceUriToClassFiles$1) {
        classNameToSourceFile$1.put((Object)classFile$2.fullyQualifiedName(), (Object)sourceFile);
        sourceUriToClassFiles$1.update((Object)sourceFile.uri(), ((SeqLike)sourceUriToClassFiles$1.getOrElse((Object)sourceFile.uri(), (Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$)).$colon$plus((Object)classFile$2, Seq$.MODULE$.canBuildFrom()));
    }

    public static final /* synthetic */ Option $anonfun$apply$8(Map sourceNameToSourceFile$1, String key) {
        return sourceNameToSourceFile$1.get((Object)key);
    }

    public static final /* synthetic */ Seq $anonfun$apply$9() {
        return (Seq)Nil$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$apply$10(ClassFile classFile$2, SourceFile f) {
        String string = f.folderPath();
        String string2 = classFile$2.folderPath();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$apply$11(SourceFile x$8) {
        return x$8.folderPath().contains("src/");
    }

    public static final /* synthetic */ boolean $anonfun$apply$12(ClassFile classFile$2, SourceFile f) {
        Object object = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])f.folderPath().split("src/"))).last();
        String string = classFile$2.fullPackageAsPath();
        return !(object != null ? !object.equals(string) : string != null);
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$apply$6(scala.collection.mutable.Map classNameToSourceFile$1, scala.collection.mutable.Map sourceUriToClassFiles$1, Map sourceNameToSourceFile$1, Buffer missingSourceFileClassFiles$1, Buffer orphanClassFiles$1, ClassFile classFile) {
        block3: {
            block6: {
                block7: {
                    block9: {
                        block10: {
                            block8: {
                                block5: {
                                    block4: {
                                        block2: {
                                            var10_6 = ((TraversableOnce)classFile.sourceName().flatMap((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$apply$8(scala.collection.immutable.Map java.lang.String ), (Ljava/lang/String;)Lscala/Option;)((Map)sourceNameToSourceFile$1)).getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$apply$9(), ()Lscala/collection/Seq;)())).toList();
                                            if (!Nil$.MODULE$.equals(var10_6)) break block2;
                                            missingSourceFileClassFiles$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ClassFile[]{classFile}));
                                            var6_7 = BoxedUnit.UNIT;
                                            break block3;
                                        }
                                        if (!(var10_6 instanceof .colon.colon)) break block4;
                                        var11_10 = (.colon.colon)var10_6;
                                        sourceFile = (SourceFile)var11_10.head();
                                        var13_12 = var11_10.tl$access$1();
                                        if (!Nil$.MODULE$.equals(var13_12)) break block4;
                                        ClassEntryLookUp$.recordSourceFile$1(sourceFile, classNameToSourceFile$1, classFile, sourceUriToClassFiles$1);
                                        var6_8 = BoxedUnit.UNIT;
                                        break block3;
                                    }
                                    if (!((var14_13 = var10_6.find((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$apply$10$adapted(ch.epfl.scala.debugadapter.internal.ClassFile ch.epfl.scala.debugadapter.internal.SourceFile ), (Lch/epfl/scala/debugadapter/internal/SourceFile;)Ljava/lang/Object;)((ClassFile)classFile))) instanceof Some)) break block5;
                                    var15_14 = (Some)var14_13;
                                    sourceFile = (SourceFile)var15_14.value();
                                    ClassEntryLookUp$.recordSourceFile$1(sourceFile, classNameToSourceFile$1, classFile, sourceUriToClassFiles$1);
                                    var7_16 = BoxedUnit.UNIT;
                                    break block6;
                                }
                                if (!None$.MODULE$.equals(var14_13)) break block7;
                                var17_18 = ((LinearSeqOptimized)var10_6.filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$apply$11$adapted(ch.epfl.scala.debugadapter.internal.SourceFile ), (Lch/epfl/scala/debugadapter/internal/SourceFile;)Ljava/lang/Object;)())).find((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$apply$12$adapted(ch.epfl.scala.debugadapter.internal.ClassFile ch.epfl.scala.debugadapter.internal.SourceFile ), (Lch/epfl/scala/debugadapter/internal/SourceFile;)Ljava/lang/Object;)((ClassFile)classFile));
                                if (!(var17_18 instanceof Some)) break block8;
                                var18_19 = (Some)var17_18;
                                sourceFile = (SourceFile)var18_19.value();
                                ClassEntryLookUp$.recordSourceFile$1(sourceFile, classNameToSourceFile$1, classFile, sourceUriToClassFiles$1);
                                var8_21 = BoxedUnit.UNIT;
                                break block9;
                            }
                            if (!None$.MODULE$.equals(var17_18)) break block10;
                            var20_23 = (List)var10_6.filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$apply$13$adapted(ch.epfl.scala.debugadapter.internal.ClassFile ch.epfl.scala.debugadapter.internal.SourceFile ), (Lch/epfl/scala/debugadapter/internal/SourceFile;)Ljava/lang/Object;)((ClassFile)classFile));
                            if (!(var20_23 instanceof .colon.colon)) ** GOTO lbl-1000
                            var21_24 = (.colon.colon)var20_23;
                            sourceFile = (SourceFile)var21_24.head();
                            var23_26 = var21_24.tl$access$1();
                            if (Nil$.MODULE$.equals(var23_26)) {
                                ClassEntryLookUp$.recordSourceFile$1(sourceFile, classNameToSourceFile$1, classFile, sourceUriToClassFiles$1);
                                var9_27 = BoxedUnit.UNIT;
                            } else lbl-1000:
                            // 2 sources

                            {
                                orphanClassFiles$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ClassFile[]{classFile}));
                                var9_28 = BoxedUnit.UNIT;
                            }
                            var8_22 = BoxedUnit.UNIT;
                            break block9;
                        }
                        throw new MatchError((Object)var17_18);
                    }
                    var7_17 = BoxedUnit.UNIT;
                    break block6;
                }
                throw new MatchError((Object)var14_13);
            }
            var6_9 = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ boolean $anonfun$findPackage$3(String sourceContent$1, String string) {
        String quotedPackage = Regex$.MODULE$.quote(string);
        Regex matcher = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(34).append("package\\s+(object\\s+)?").append(quotedPackage).append("(\\{|:|;|\\s+)").toString())).r();
        return matcher.findFirstIn((CharSequence)sourceContent$1).isDefined();
    }

    private ClassEntryLookUp$() {
        MODULE$ = this;
    }

    public static final /* synthetic */ Object $anonfun$apply$10$adapted(ClassFile classFile$2, SourceFile f) {
        return BoxesRunTime.boxToBoolean((boolean)ClassEntryLookUp$.$anonfun$apply$10(classFile$2, f));
    }

    public static final /* synthetic */ Object $anonfun$apply$11$adapted(SourceFile x$8) {
        return BoxesRunTime.boxToBoolean((boolean)ClassEntryLookUp$.$anonfun$apply$11(x$8));
    }

    public static final /* synthetic */ Object $anonfun$apply$12$adapted(ClassFile classFile$2, SourceFile f) {
        return BoxesRunTime.boxToBoolean((boolean)ClassEntryLookUp$.$anonfun$apply$12(classFile$2, f));
    }

    public static final /* synthetic */ Object $anonfun$apply$13$adapted(ClassFile classFile$2, SourceFile s) {
        return BoxesRunTime.boxToBoolean((boolean)ClassEntryLookUp$.MODULE$.findPackage(s, classFile$2.fullPackage()));
    }
}

