/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.scala.debugadapter.internal;

import ch.epfl.scala.debugadapter.CancelableFuture;
import ch.epfl.scala.debugadapter.DebuggeeRunner;
import ch.epfl.scala.debugadapter.Logger;
import ch.epfl.scala.debugadapter.internal.DebugSession$;
import ch.epfl.scala.debugadapter.internal.DebugSession$Disconnected$;
import ch.epfl.scala.debugadapter.internal.DebugSession$Listener$;
import ch.epfl.scala.debugadapter.internal.DebugSession$Ready$;
import ch.epfl.scala.debugadapter.internal.DebugSession$Restarted$;
import ch.epfl.scala.debugadapter.internal.DebugSession$Stopped$;
import ch.epfl.scala.debugadapter.internal.DebugSession$Terminated$;
import ch.epfl.scala.debugadapter.internal.LoggingAdapter;
import ch.epfl.scala.debugadapter.internal.Scheduler$;
import ch.epfl.scala.debugadapter.internal.Synchronized;
import com.microsoft.java.debug.core.adapter.IProviderContext;
import com.microsoft.java.debug.core.adapter.ProtocolServer;
import com.microsoft.java.debug.core.protocol.Events;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeoutException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0011}c\u0001C@\u0002\u0002\t\t)!!\u0006\t\u0015\u0005]\u0002A!A!\u0002\u0013\tY\u0004\u0003\u0006\u0002J\u0001\u0011\t\u0011)A\u0005\u0003\u0017B!\"a\u0015\u0001\u0005\u0003\u0005\u000b\u0011BA+\u0011)\tY\u0006\u0001B\u0001B\u0003%\u0011Q\f\u0005\u000b\u0003G\u0002!\u0011!Q\u0001\n\u0005\u0015\u0004BCA7\u0001\t\u0005\t\u0015!\u0003\u0002p!Q\u0011\u0011\u0010\u0001\u0003\u0002\u0003\u0006I!a\u001f\t\u0015\u0005-\u0005A!A!\u0002\u0017\ti\tC\u0004\u0002\u0016\u0002!I!a&\u0006\r\u00055\u0006\u0001BAX\u0011%\t)\f\u0001b\u0001\n\u0013\t9\f\u0003\u0005\u0002N\u0002\u0001\u000b\u0011BA]\u0011%\ty\r\u0001b\u0001\n\u0013\t\t\u000e\u0003\u0005\u0002`\u0002\u0001\u000b\u0011BAj\u0011%\t\t\u000f\u0001b\u0001\n\u0013\t\u0019\u000f\u0003\u0005\u0002n\u0002\u0001\u000b\u0011BAs\u0011%\ty\u000f\u0001b\u0001\n\u0013\t\t\u000e\u0003\u0005\u0002r\u0002\u0001\u000b\u0011BAj\u0011%\t\u0019\u0010\u0001b\u0001\n\u0013\t)\u0010\u0003\u0005\u0004.\u0002\u0001\u000b\u0011BA|\u0011%\u0019y\u000b\u0001b\u0001\n\u0013\u0019\t\f\u0003\u0005\u0004<\u0002\u0001\u000b\u0011BBZ\u0011%\u0019i\f\u0001C\u0001\u0003\u000b\u0019y\fC\u0005\u0004B\u0002!\t!!\u0002\u0004D\"I11\u001a\u0001\u0005\u0002\u0005\u00151Q\u001a\u0005\b\u0007\u001f\u0004A\u0011ABi\u0011\u001d\u0019)\u000e\u0001C\u0001\u0007\u001bDqaa6\u0001\t#\u001aI\u000eC\u0004\u0004^\u0002!\tfa8\t\u000f\r\u0015\b\u0001\"\u0015\u0004h\"91Q \u0001\u0005\n\r}\bb\u0002C\u0001\u0001\u0011%A1A\u0004\b\t7\u0001\u0001\u0012\u0002C\u000f\r\u001d!y\u0002\u0001E\u0005\tCAq!!&#\t\u0003!I\u0003C\u0004\u0005,\t\"\t\u0005\"\f\t\u000f\u0011E\"\u0005\"\u0011\u00054!9A\u0011\b\u0012\u0005B\u0011m\u0002b\u0002C E\u0011\u0005C\u0011\t\u0005\u000f\t'\u0002\u0001\u0013aA\u0001\u0002\u0013%AQ\u000bC/\u000f)\ti0!\u0001\t\u0002\u0005\u0015\u0011q \u0004\n\u007f\u0006\u0005\u0001\u0012AA\u0003\u0005\u0003Aq!!&+\t\u0003\u0011IAB\u0005\u0003\f)\u0002\n1%\t\u0003\u000e\u001d9!q\u0012\u0016\t\u0006\nUda\u0002B8U!\u0015%\u0011\u000f\u0005\b\u0003+sC\u0011\u0001B:\u0011%\u0011ICLA\u0001\n\u0003\u0012Y\u0003C\u0005\u0003:9\n\t\u0011\"\u0001\u0003<!I!Q\b\u0018\u0002\u0002\u0013\u0005!q\u000f\u0005\n\u0005\u0017r\u0013\u0011!C!\u0005\u001bB\u0011Ba\u0016/\u0003\u0003%\tAa\u001f\t\u0013\tuc&!A\u0005B\t}\u0003\"\u0003B1]\u0005\u0005I\u0011\tB2\u0011%\u0011)GLA\u0001\n\u0013\u00119gB\u0004\u0003\u0012*B)Ia\n\u0007\u000f\tE!\u0006#\"\u0003\u0014!9\u0011QS\u001d\u0005\u0002\t\u0015\u0002\"\u0003B\u0015s\u0005\u0005I\u0011\tB\u0016\u0011%\u0011I$OA\u0001\n\u0003\u0011Y\u0004C\u0005\u0003>e\n\t\u0011\"\u0001\u0003@!I!1J\u001d\u0002\u0002\u0013\u0005#Q\n\u0005\n\u0005/J\u0014\u0011!C\u0001\u00053B\u0011B!\u0018:\u0003\u0003%\tEa\u0018\t\u0013\t\u0005\u0014(!A\u0005B\t\r\u0004\"\u0003B3s\u0005\u0005I\u0011\u0002B4\u000f\u001d\u0011\u0019J\u000bEC\u0005\u000b3qAa +\u0011\u000b\u0013\t\tC\u0004\u0002\u0016\u0012#\tAa!\t\u0013\t%B)!A\u0005B\t-\u0002\"\u0003B\u001d\t\u0006\u0005I\u0011\u0001B\u001e\u0011%\u0011i\u0004RA\u0001\n\u0003\u00119\tC\u0005\u0003L\u0011\u000b\t\u0011\"\u0011\u0003N!I!q\u000b#\u0002\u0002\u0013\u0005!1\u0012\u0005\n\u0005;\"\u0015\u0011!C!\u0005?B\u0011B!\u0019E\u0003\u0003%\tEa\u0019\t\u0013\t\u0015D)!A\u0005\n\t\u001dd!\u0003BKUA\u0005\u0019\u0013\u0005BL\u000f\u001d\u0011yP\u000bEC\u0005G3qAa'+\u0011\u000b\u0013i\nC\u0004\u0002\u0016B#\tA!)\t\u0013\t%\u0002+!A\u0005B\t-\u0002\"\u0003B\u001d!\u0006\u0005I\u0011\u0001B\u001e\u0011%\u0011i\u0004UA\u0001\n\u0003\u0011)\u000bC\u0005\u0003LA\u000b\t\u0011\"\u0011\u0003N!I!q\u000b)\u0002\u0002\u0013\u0005!\u0011\u0016\u0005\n\u0005;\u0002\u0016\u0011!C!\u0005?B\u0011B!\u0019Q\u0003\u0003%\tEa\u0019\t\u0013\t\u0015\u0004+!A\u0005\n\t\u001ddA\u0002BWU\t\u0013y\u000b\u0003\u0006\u00032j\u0013)\u001a!C\u0001\u0005gC!Ba/[\u0005#\u0005\u000b\u0011\u0002B[\u0011\u001d\t)J\u0017C\u0001\u0005{C\u0011Ba1[\u0003\u0003%\tA!2\t\u0013\t%',%A\u0005\u0002\t-\u0007\"\u0003B\u00155\u0006\u0005I\u0011\tB\u0016\u0011%\u0011IDWA\u0001\n\u0003\u0011Y\u0004C\u0005\u0003>i\u000b\t\u0011\"\u0001\u0003b\"I!1\n.\u0002\u0002\u0013\u0005#Q\n\u0005\n\u0005/R\u0016\u0011!C\u0001\u0005KD\u0011B!\u0018[\u0003\u0003%\tEa\u0018\t\u0013\t\u0005$,!A\u0005B\t\r\u0004\"\u0003Bu5\u0006\u0005I\u0011\tBv\u000f%\u0019\tAKA\u0001\u0012\u0003\u0019\u0019AB\u0005\u0003.*\n\t\u0011#\u0001\u0004\u0006!9\u0011QS5\u0005\u0002\rM\u0001\"\u0003B1S\u0006\u0005IQ\tB2\u0011%\u0019)\"[A\u0001\n\u0003\u001b9\u0002C\u0005\u0004\u001c%\f\t\u0011\"!\u0004\u001e!I!QM5\u0002\u0002\u0013%!qM\u0004\b\u0007SQ\u0003R\u0011B{\r\u001d\u0011yO\u000bEC\u0005cDq!!&q\t\u0003\u0011\u0019\u0010C\u0005\u0003*A\f\t\u0011\"\u0011\u0003,!I!\u0011\b9\u0002\u0002\u0013\u0005!1\b\u0005\n\u0005{\u0001\u0018\u0011!C\u0001\u0005oD\u0011Ba\u0013q\u0003\u0003%\tE!\u0014\t\u0013\t]\u0003/!A\u0005\u0002\tm\b\"\u0003B/a\u0006\u0005I\u0011\tB0\u0011%\u0011\t\u0007]A\u0001\n\u0003\u0012\u0019\u0007C\u0005\u0003fA\f\t\u0011\"\u0003\u0003h!91Q\u0003\u0016\u0005\u0002\r-\u0002bBB\u001eU\u0011%1Q\b\u0005\b\u0007\u0013RC\u0011BB&\u0011\u001d\u0019)I\u000bC\u0005\u0007\u000fCqa!*+\t\u0013\u00199K\u0001\u0007EK\n,xmU3tg&|gN\u0003\u0003\u0002\u0004\u0005\u0015\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\t\u0005\u001d\u0011\u0011B\u0001\rI\u0016\u0014WoZ1eCB$XM\u001d\u0006\u0005\u0003\u0017\ti!A\u0003tG\u0006d\u0017M\u0003\u0003\u0002\u0010\u0005E\u0011\u0001B3qM2T!!a\u0005\u0002\u0005\rD7c\u0001\u0001\u0002\u0018A!\u0011\u0011DA\u001a\u001b\t\tYB\u0003\u0003\u0002\u001e\u0005}\u0011aB1eCB$XM\u001d\u0006\u0005\u0003C\t\u0019#\u0001\u0003d_J,'\u0002BA\u0013\u0003O\tQ\u0001Z3ck\u001eTA!!\u000b\u0002,\u0005!!.\u0019<b\u0015\u0011\ti#a\f\u0002\u00135L7M]8t_\u001a$(BAA\u0019\u0003\r\u0019w.\\\u0005\u0005\u0003k\tYB\u0001\bQe>$xnY8m'\u0016\u0014h/\u001a:\u0002\rM|7m[3u\u0007\u0001\u0001B!!\u0010\u0002F5\u0011\u0011q\b\u0006\u0005\u0003\u0003\n\u0019%A\u0002oKRT!!!\u000b\n\t\u0005\u001d\u0013q\b\u0002\u0007'>\u001c7.\u001a;\u0002\rI,hN\\3s!\u0011\ti%a\u0014\u000e\u0005\u0005\u0015\u0011\u0002BA)\u0003\u000b\u0011a\u0002R3ck\u001e<W-\u001a*v]:,'/A\u0004d_:$X\r\u001f;\u0011\t\u0005e\u0011qK\u0005\u0005\u00033\nYB\u0001\tJ!J|g/\u001b3fe\u000e{g\u000e^3yi\u00061An\\4hKJ\u0004B!!\u0014\u0002`%!\u0011\u0011MA\u0003\u0005\u0019aunZ4fe\u0006qAn\\4hS:<\u0017\tZ1qi\u0016\u0014\b\u0003BA4\u0003Sj!!!\u0001\n\t\u0005-\u0014\u0011\u0001\u0002\u000f\u0019><w-\u001b8h\u0003\u0012\f\u0007\u000f^3s\u0003%\tW\u000f^8DY>\u001cX\r\u0005\u0003\u0002r\u0005UTBAA:\u0015\t\tY!\u0003\u0003\u0002x\u0005M$a\u0002\"p_2,\u0017M\\\u0001\fOJ\f7-\u001a)fe&|G\r\u0005\u0003\u0002~\u0005\u001dUBAA@\u0015\u0011\t\t)a!\u0002\u0011\u0011,(/\u0019;j_:TA!!\"\u0002t\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005%\u0015q\u0010\u0002\t\tV\u0014\u0018\r^5p]\u0006\u0001R\r_3dkRLwN\\\"p]R,\u0007\u0010\u001e\t\u0005\u0003\u001f\u000b\t*\u0004\u0002\u0002\u0004&!\u00111SAB\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH/\u0001\u0004=S:LGO\u0010\u000b\u0011\u00033\u000by*!)\u0002$\u0006\u0015\u0016qUAU\u0003W#B!a'\u0002\u001eB\u0019\u0011q\r\u0001\t\u000f\u0005-\u0015\u0002q\u0001\u0002\u000e\"9\u0011qG\u0005A\u0002\u0005m\u0002bBA%\u0013\u0001\u0007\u00111\n\u0005\b\u0003'J\u0001\u0019AA+\u0011\u001d\tY&\u0003a\u0001\u0003;Bq!a\u0019\n\u0001\u0004\t)\u0007C\u0004\u0002n%\u0001\r!a\u001c\t\u000f\u0005e\u0014\u00021\u0001\u0002|\tAA*Y;oG\"LE\r\u0005\u0003\u0002r\u0005E\u0016\u0002BAZ\u0003g\u00121!\u00138u\u0003Aa\u0017-\u001e8dQ\u0016$'+Z9vKN$8/\u0006\u0002\u0002:B1\u00111XAc\u0003\u0013l!!!0\u000b\t\u0005}\u0016\u0011Y\u0001\b[V$\u0018M\u00197f\u0015\u0011\t\u0019-a\u001d\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002H\u0006u&aA*fiB\u0019\u00111\u001a\u0006\u000e\u0003\u0001\t\u0011\u0003\\1v]\u000eDW\r\u001a*fcV,7\u000f^:!\u0003=!XM]7j]\u0006$X\rZ#wK:$XCAAj!\u0019\ty)!6\u0002Z&!\u0011q[AB\u0005\u001d\u0001&o\\7jg\u0016\u0004B!!\u001d\u0002\\&!\u0011Q\\A:\u0005\u0011)f.\u001b;\u0002!Q,'/\\5oCR,G-\u0012<f]R\u0004\u0013a\u00043fEV<w-Z3BI\u0012\u0014Xm]:\u0016\u0005\u0005\u0015\bCBAH\u0003+\f9\u000f\u0005\u0003\u0002>\u0005%\u0018\u0002BAv\u0003\u007f\u0011\u0011#\u00138fiN{7m[3u\u0003\u0012$'/Z:t\u0003A!WMY;hO\u0016,\u0017\t\u001a3sKN\u001c\b%\u0001\u0005biR\f7\r[3e\u0003%\tG\u000f^1dQ\u0016$\u0007%A\tfq&$8\u000b^1ukN\u0004&o\\7jg\u0016,\"!a>\u0011\r\u0005=\u0015Q[A}!\r\tY\u0010\f\b\u0004\u0003OJ\u0013\u0001\u0004#fEV<7+Z:tS>t\u0007cAA4UM\u0019!Fa\u0001\u0011\t\u0005E$QA\u0005\u0005\u0005\u000f\t\u0019H\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0003\u007f\u0014!\"\u0012=jiN#\u0018\r^;t'\ra#1A\u0015\u0005YerCI\u0001\u0007ESN\u001cwN\u001c8fGR,GmE\u0005:\u0005\u0007\u0011)B!\u0007\u0003 A\u0019!q\u0003\u0017\u000e\u0003)\u0002B!!\u001d\u0003\u001c%!!QDA:\u0005\u001d\u0001&o\u001c3vGR\u0004B!!\u001d\u0003\"%!!1EA:\u00051\u0019VM]5bY&T\u0018M\u00197f)\t\u00119\u0003E\u0002\u0003\u0018e\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXC\u0001B\u0017!\u0011\u0011yC!\u000e\u000e\u0005\tE\"\u0002\u0002B\u001a\u0003\u0007\nA\u0001\\1oO&!!q\u0007B\u0019\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011qV\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0011\tEa\u0012\u0011\t\u0005E$1I\u0005\u0005\u0005\u000b\n\u0019HA\u0002B]fD\u0011B!\u0013>\u0003\u0003\u0005\r!a,\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011y\u0005\u0005\u0004\u0003R\tM#\u0011I\u0007\u0003\u0003\u0003LAA!\u0016\u0002B\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\tyGa\u0017\t\u0013\t%s(!AA\u0002\t\u0005\u0013\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005=\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\t5\u0012a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"A!\u001b\u0011\t\t=\"1N\u0005\u0005\u0005[\u0012\tD\u0001\u0004PE*,7\r\u001e\u0002\n%\u0016\u001cH/\u0019:uK\u0012\u001c\u0012B\fB\u0002\u0005+\u0011IBa\b\u0015\u0005\tU\u0004c\u0001B\f]Q!!\u0011\tB=\u0011%\u0011IEMA\u0001\u0002\u0004\ty\u000b\u0006\u0003\u0002p\tu\u0004\"\u0003B%i\u0005\u0005\t\u0019\u0001B!\u0005)!VM]7j]\u0006$X\rZ\n\n\t\n\r!Q\u0003B\r\u0005?!\"A!\"\u0011\u0007\t]A\t\u0006\u0003\u0003B\t%\u0005\"\u0003B%\u0011\u0006\u0005\t\u0019AAX)\u0011\tyG!$\t\u0013\t%#*!AA\u0002\t\u0005\u0013!\u0003*fgR\f'\u000f^3e\u00031!\u0015n]2p]:,7\r^3e\u0003)!VM]7j]\u0006$X\r\u001a\u0002\u0006'R\fG/Z\n\u0004\u001d\n\r\u0011\u0006\u0002(Q5B\u0014QAU3bIf\u001c\u0012\u0002\u0015B\u0002\u0005?\u0013IBa\b\u0011\u0007\t]a\n\u0006\u0002\u0003$B\u0019!q\u0003)\u0015\t\t\u0005#q\u0015\u0005\n\u0005\u0013\"\u0016\u0011!a\u0001\u0003_#B!a\u001c\u0003,\"I!\u0011\n,\u0002\u0002\u0003\u0007!\u0011\t\u0002\b'R\f'\u000f^3e'%Q&1\u0001BP\u00053\u0011y\"\u0001\u0005eK\n,xmZ3f+\t\u0011)\f\u0005\u0004\u0002N\t]\u0016\u0011\\\u0005\u0005\u0005s\u000b)A\u0001\tDC:\u001cW\r\\1cY\u00164U\u000f^;sK\u0006IA-\u001a2vO\u001e,W\r\t\u000b\u0005\u0005\u007f\u0013\t\rE\u0002\u0003\u0018iCqA!-^\u0001\u0004\u0011),\u0001\u0003d_BLH\u0003\u0002B`\u0005\u000fD\u0011B!-_!\u0003\u0005\rA!.\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!Q\u001a\u0016\u0005\u0005k\u0013ym\u000b\u0002\u0003RB!!1\u001bBo\u001b\t\u0011)N\u0003\u0003\u0003X\ne\u0017!C;oG\",7m[3e\u0015\u0011\u0011Y.a\u001d\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003`\nU'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dKR!!\u0011\tBr\u0011%\u0011IEYA\u0001\u0002\u0004\ty\u000b\u0006\u0003\u0002p\t\u001d\b\"\u0003B%I\u0006\u0005\t\u0019\u0001B!\u0003\u0019)\u0017/^1mgR!\u0011q\u000eBw\u0011%\u0011IeZA\u0001\u0002\u0004\u0011\tEA\u0004Ti>\u0004\b/\u001a3\u0014\u0013A\u0014\u0019Aa(\u0003\u001a\t}AC\u0001B{!\r\u00119\u0002\u001d\u000b\u0005\u0005\u0003\u0012I\u0010C\u0005\u0003JQ\f\t\u00111\u0001\u00020R!\u0011q\u000eB\u007f\u0011%\u0011IE^A\u0001\u0002\u0004\u0011\t%A\u0003SK\u0006$\u00170A\u0004Ti\u0006\u0014H/\u001a3\u0011\u0007\t]\u0011nE\u0003j\u0007\u000f\u0011y\u0002\u0005\u0005\u0004\n\r=!Q\u0017B`\u001b\t\u0019YA\u0003\u0003\u0004\u000e\u0005M\u0014a\u0002:v]RLW.Z\u0005\u0005\u0007#\u0019YAA\tBEN$(/Y2u\rVt7\r^5p]F\"\"aa\u0001\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\t\t}6\u0011\u0004\u0005\b\u0005cc\u0007\u0019\u0001B[\u0003\u001d)h.\u00199qYf$Baa\b\u0004&A1\u0011\u0011OB\u0011\u0005kKAaa\t\u0002t\t1q\n\u001d;j_:D\u0011ba\nn\u0003\u0003\u0005\rAa0\u0002\u0007a$\u0003'A\u0004Ti>\u0004\b/\u001a3\u0015\u0019\r52\u0011GB\u001a\u0007k\u00199d!\u000f\u0015\t\u0005m5q\u0006\u0005\b\u0003\u0017S\b9AAG\u0011\u001d\t9D\u001fa\u0001\u0003wAq!!\u0013{\u0001\u0004\tY\u0005C\u0004\u0002\\i\u0004\r!!\u0018\t\u000f\u00055$\u00101\u0001\u0002p!9\u0011\u0011\u0010>A\u0002\u0005m\u0014\u0001\u00024pe.$B!!7\u0004@!91\u0011I>A\u0002\r\r\u0013!\u00014\u0011\r\u0005E4QIAm\u0013\u0011\u00199%a\u001d\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0014a\u0004;p\u0003R$\u0018m\u00195SKF,Xm\u001d;\u0015\r\r53QPBA!\u0011\u0019yea\u001e\u000f\t\rE3\u0011\u000f\b\u0005\u0007'\u001aiG\u0004\u0003\u0004V\r-d\u0002BB,\u0007SrAa!\u0017\u0004h9!11LB3\u001d\u0011\u0019ifa\u0019\u000e\u0005\r}#\u0002BB1\u0003s\ta\u0001\u0010:p_Rt\u0014BAA\u0019\u0013\u0011\ti#a\f\n\t\u0005%\u00121F\u0005\u0005\u0003K\t9#\u0003\u0003\u0002\"\u0005\r\u0012\u0002BB8\u0003?\t\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0007g\u001a)(\u0001\u0005NKN\u001c\u0018mZ3t\u0015\u0011\u0019y'a\b\n\t\re41\u0010\u0002\b%\u0016\fX/Z:u\u0015\u0011\u0019\u0019h!\u001e\t\u000f\r}D\u00101\u0001\u00020\u0006\u00191/Z9\t\u000f\r\rE\u00101\u0001\u0002h\u00069\u0011\r\u001a3sKN\u001c\u0018A\u00024bS2,G\r\u0006\u0004\u0004\n\u000e=51\u0013\t\u0005\u0007\u001f\u001aY)\u0003\u0003\u0004\u000e\u000em$\u0001\u0003*fgB|gn]3\t\u000f\rEU\u00101\u0001\u0004N\u00059!/Z9vKN$\bbBBK{\u0002\u00071qS\u0001\b[\u0016\u001c8/Y4f!\u0011\u0019Ij!)\u000f\t\rm5Q\u0014\t\u0005\u0007;\n\u0019(\u0003\u0003\u0004 \u0006M\u0014A\u0002)sK\u0012,g-\u0003\u0003\u00038\r\r&\u0002BBP\u0003g\nQb\u001d5pk2$'+Z:uCJ$H\u0003BA8\u0007SCqaa+\u007f\u0001\u0004\u0019i%A\teSN\u001cwN\u001c8fGR\u0014V-];fgR\f!#\u001a=jiN#\u0018\r^;t!J|W.[:fA\u0005QA-\u001a2vON#\u0018\r^3\u0016\u0005\rM\u0006CBA4\u0007k\u001bI,\u0003\u0003\u00048\u0006\u0005!\u0001D*z]\u000eD'o\u001c8ju\u0016$\u0007cAA~\u001d\u0006YA-\u001a2vON#\u0018\r^3!\u00031\u0019WO\u001d:f]R\u001cF/\u0019;f+\t\u0019I,A\thKR$UMY;hK\u0016\fE\r\u001a:fgN,\"a!2\u0011\r\u0005=5qYAt\u0013\u0011\u0019I-a!\u0003\r\u0019+H/\u001e:f\u0003\u0015\u0019H/\u0019:u)\t\tI.\u0001\u0006fq&$8\u000b^1ukN,\"aa5\u0011\r\u0005=5qYA}\u0003\u0015\u0019Gn\\:f\u0003=!\u0017n\u001d9bi\u000eD'+Z9vKN$H\u0003BAm\u00077Dqa!%\u001d\u0001\u0004\u0019i%\u0001\u0007tK:$'+Z:q_:\u001cX\r\u0006\u0003\u0002Z\u000e\u0005\bbBBr;\u0001\u00071\u0011R\u0001\te\u0016\u001c\bo\u001c8tK\u0006I1/\u001a8e\u000bZ,g\u000e\u001e\u000b\u0005\u00033\u001cI\u000fC\u0004\u0004lz\u0001\ra!<\u0002\u000b\u00154XM\u001c;\u0011\t\r=8q\u001f\b\u0005\u0007c\u001c\u00190\u0004\u0002\u0004v%!1Q_B;\u0003\u0019)e/\u001a8ug&!1\u0011`B~\u0005)!UMY;h\u000bZ,g\u000e\u001e\u0006\u0005\u0007k\u001c)(\u0001\u0003oC6,WCABL\u00039\u0019\u0017M\\2fYB\u0013x.\\5tKN$B!!7\u0005\u0006!9Aq\u0001\u0011A\u0002\u0011%\u0011!B2bkN,\u0007\u0003\u0002C\u0006\t+qA\u0001\"\u0004\u0005\u00129!1Q\fC\b\u0013\t\tY!\u0003\u0003\u0005\u0014\u0005M\u0014a\u00029bG.\fw-Z\u0005\u0005\t/!IBA\u0005UQJ|w/\u00192mK*!A1CA:\u0003!a\u0015n\u001d;f]\u0016\u0014\bcAAfE\tAA*[:uK:,'oE\u0003#\u0005\u0007!\u0019\u0003\u0005\u0003\u0002N\u0011\u0015\u0012\u0002\u0002C\u0014\u0003\u000b\u0011\u0001\u0003R3ck\u001e<W-\u001a'jgR,g.\u001a:\u0015\u0005\u0011u\u0011aC8o\u0019&\u001cH/\u001a8j]\u001e$B!!7\u00050!911\u0011\u0013A\u0002\u0005\u001d\u0018aA8viR!\u0011\u0011\u001cC\u001b\u0011\u001d!9$\na\u0001\u0007/\u000bA\u0001\\5oK\u0006\u0019QM\u001d:\u0015\t\u0005eGQ\b\u0005\b\to1\u0003\u0019ABL\u0003)!Xm\u001d;SKN,H\u000e\u001e\u000b\u0005\u00033$\u0019\u0005C\u0004\u0005F\u001d\u0002\r\u0001b\u0012\u0002\t\u0011\fG/\u0019\t\u0005\t\u0013\"y%\u0004\u0002\u0005L)!AQJA\u0003\u0003\u001d!Xm\u001d;j]\u001eLA\u0001\"\u0015\u0005L\t\u0001B+Z:u'VLG/Z*v[6\f'/_\u0001\u0016gV\u0004XM\u001d\u0013eSN\u0004\u0018\r^2i%\u0016\fX/Z:u)\u0011\tI\u000eb\u0016\t\u0013\t%\u0003&!AA\u0002\u0011e\u0003\u0003\u0002C.\u0007oj!aa\u001f\n\t\r]\u00171\u0007")
public final class DebugSession
extends ProtocolServer {
    private volatile DebugSession$Listener$ Listener$module;
    private final Socket socket;
    private final DebuggeeRunner runner;
    private final Logger logger;
    private final LoggingAdapter loggingAdapter;
    private final boolean autoClose;
    private final Duration gracePeriod;
    private final ExecutionContext executionContext;
    private final Set<Object> launchedRequests;
    private final Promise<BoxedUnit> terminatedEvent;
    private final Promise<InetSocketAddress> ch$epfl$scala$debugadapter$internal$DebugSession$$debuggeeAddress;
    private final Promise<BoxedUnit> attached;
    private final Promise<ExitStatus> exitStatusPromise;
    private final Synchronized<State> debugState;

    public static DebugSession apply(Socket socket, DebuggeeRunner debuggeeRunner, Logger logger, boolean bl, Duration duration, ExecutionContext executionContext) {
        return DebugSession$.MODULE$.apply(socket, debuggeeRunner, logger, bl, duration, executionContext);
    }

    private DebugSession$Listener$ Listener() {
        if (this.Listener$module == null) {
            this.Listener$lzycompute$1();
        }
        return this.Listener$module;
    }

    private /* synthetic */ void super$dispatchRequest(Messages.Request x$1) {
        super.dispatchRequest(x$1);
    }

    private Set<Object> launchedRequests() {
        return this.launchedRequests;
    }

    private Promise<BoxedUnit> terminatedEvent() {
        return this.terminatedEvent;
    }

    public Promise<InetSocketAddress> ch$epfl$scala$debugadapter$internal$DebugSession$$debuggeeAddress() {
        return this.ch$epfl$scala$debugadapter$internal$DebugSession$$debuggeeAddress;
    }

    private Promise<BoxedUnit> attached() {
        return this.attached;
    }

    private Promise<ExitStatus> exitStatusPromise() {
        return this.exitStatusPromise;
    }

    private Synchronized<State> debugState() {
        return this.debugState;
    }

    public State currentState() {
        return this.debugState().value();
    }

    public Future<InetSocketAddress> getDebugeeAddress() {
        return this.ch$epfl$scala$debugadapter$internal$DebugSession$$debuggeeAddress().future();
    }

    public void start() {
        this.debugState().transform((Function1<State, State>)(Function1 & Serializable & scala.Serializable)x0$1 -> {
            State state = x0$1;
            if (DebugSession$Ready$.MODULE$.equals(state)) {
                DebugSession$.MODULE$.ch$epfl$scala$debugadapter$internal$DebugSession$$fork((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.run());
                CancelableFuture<BoxedUnit> debuggee = $this.runner.run(this.Listener());
                debuggee.future().onComplete((Function1 & Serializable & scala.Serializable)result -> {
                    result.failed().foreach((Function1 & Serializable & scala.Serializable)cause -> {
                        this.cancelPromises(cause);
                        return BoxedUnit.UNIT;
                    });
                    return this.terminatedEvent().future().map((Function1 & Serializable & scala.Serializable)x$1 -> {
                        DebugSession.$anonfun$start$5(this, x$1);
                        return BoxedUnit.UNIT;
                    }, $this.executionContext);
                }, $this.executionContext);
                return new Started(debuggee);
            }
            return state;
        });
    }

    public Future<ExitStatus> exitStatus() {
        return this.exitStatusPromise().future();
    }

    public void close() {
        super.stop();
        this.loggingAdapter.onClosingSession();
        this.debugState().transform((Function1<State, State>)(Function1 & Serializable & scala.Serializable)x0$1 -> {
            State state = x0$1;
            if (state instanceof Started) {
                Object object;
                Started started = (Started)state;
                CancelableFuture<BoxedUnit> debuggee = started.debuggee();
                this.cancelPromises(new CancellationException("Debug session closed"));
                debuggee.cancel();
                try {
                    object = Await$.MODULE$.result((Awaitable)this.terminatedEvent().future(), $this.gracePeriod);
                }
                catch (TimeoutException timeoutException) {
                    $this.logger.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(65).append("Communication with debuggee ").append(this.name()).append(" is frozen: missing terminated event.").toString());
                    object = BoxedUnit.UNIT;
                }
                return DebugSession$Stopped$.MODULE$;
            }
            return DebugSession$Stopped$.MODULE$;
        });
        this.logger.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("closing connection with debugger ").append(this.name()).toString());
        this.socket.close();
        this.exitStatusPromise().trySuccess((Object)DebugSession$Terminated$.MODULE$);
    }

    public void dispatchRequest(Messages.Request request) {
        int requestId = request.seq;
        String string = request.command;
        if ("launch".equals(string)) {
            this.launchedRequests().add((Object)BoxesRunTime.boxToInteger((int)requestId));
            Scheduler$.MODULE$.timeout(this.ch$epfl$scala$debugadapter$internal$DebugSession$$debuggeeAddress(), this.gracePeriod).future().onComplete((Function1 & Serializable & scala.Serializable)x0$1 -> {
                DebugSession.$anonfun$dispatchRequest$1(this, requestId, request, x0$1);
                return BoxedUnit.UNIT;
            }, this.executionContext);
            return;
        }
        if ("configurationDone".equals(string)) {
            this.attached().future().onComplete((Function1 & Serializable & scala.Serializable)x0$2 -> {
                DebugSession.$anonfun$dispatchRequest$2(this, request, x0$2);
                return BoxedUnit.UNIT;
            }, this.executionContext);
            return;
        }
        if ("disconnect".equals(string)) {
            this.debugState().transform((Function1<State, State>)(Function1 & Serializable & scala.Serializable)x0$3 -> {
                State state = x0$3;
                if (state instanceof Started) {
                    Started started = (Started)state;
                    CancelableFuture<BoxedUnit> debuggee = started.debuggee();
                    this.cancelPromises(new CancellationException("Client disconnected"));
                    this.exitStatusPromise().trySuccess((Object)(DebugSession$.MODULE$.ch$epfl$scala$debugadapter$internal$DebugSession$$shouldRestart(request) ? DebugSession$Restarted$.MODULE$ : DebugSession$Disconnected$.MODULE$));
                    this.super$dispatchRequest(request);
                    debuggee.cancel();
                    return DebugSession$Stopped$.MODULE$;
                }
                Messages.Response ack = new Messages.Response(request$1.seq, request$1.command, true);
                this.sendResponse(ack);
                return DebugSession$Stopped$.MODULE$;
            });
            return;
        }
        super.dispatchRequest(request);
    }

    public void sendResponse(Messages.Response response) {
        int requestId = response.request_seq;
        boolean bl = false;
        String string = null;
        String string2 = response.command;
        if ("attach".equals(string2)) {
            bl = true;
            string = string2;
            if (this.launchedRequests().apply((Object)BoxesRunTime.boxToInteger((int)requestId))) {
                response.command = Requests.Command.LAUNCH.getName();
                this.attached().success((Object)BoxedUnit.UNIT);
                super.sendResponse(response);
                return;
            }
        }
        if (bl) {
            this.attached().success((Object)BoxedUnit.UNIT);
            super.sendResponse(response);
            return;
        }
        super.sendResponse(response);
    }

    public void sendEvent(Events.DebugEvent event) {
        try {
            super.sendEvent(event);
        }
        finally {
            String string = event.type;
            String string2 = "terminated";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                this.terminatedEvent().trySuccess((Object)BoxedUnit.UNIT);
            }
        }
    }

    private String name() {
        return this.runner.name();
    }

    private void cancelPromises(Throwable cause) {
        this.ch$epfl$scala$debugadapter$internal$DebugSession$$debuggeeAddress().tryFailure(cause);
        this.attached().tryFailure(cause);
    }

    private final void Listener$lzycompute$1() {
        DebugSession debugSession = this;
        synchronized (debugSession) {
            if (this.Listener$module == null) {
                this.Listener$module = new DebugSession$Listener$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$start$5(DebugSession $this, BoxedUnit x$1) {
        if ($this.autoClose) {
            $this.exitStatusPromise().trySuccess((Object)DebugSession$Terminated$.MODULE$);
            $this.close();
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$dispatchRequest$1(DebugSession $this, int requestId$1, Messages.Request request$1, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            InetSocketAddress address = (InetSocketAddress)success.value();
            $this.super$dispatchRequest(DebugSession$.MODULE$.ch$epfl$scala$debugadapter$internal$DebugSession$$toAttachRequest(requestId$1, address));
            return;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            String cause = new StringBuilder(34).append("Could not start debuggee ").append($this.name()).append(" due to: ").append(exception.getMessage()).toString();
            $this.sendResponse(DebugSession$.MODULE$.ch$epfl$scala$debugadapter$internal$DebugSession$$failed(request$1, cause));
            $this.attached().tryFailure((Throwable)new IllegalStateException(cause));
            return;
        }
        throw new MatchError((Object)try_);
    }

    public static final /* synthetic */ void $anonfun$dispatchRequest$2(DebugSession $this, Messages.Request request$1, Try x0$2) {
        Try try_ = x0$2;
        if (try_ instanceof Success) {
            $this.super$dispatchRequest(request$1);
            return;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            $this.sendResponse(DebugSession$.MODULE$.ch$epfl$scala$debugadapter$internal$DebugSession$$failed(request$1, exception.getMessage()));
            return;
        }
        throw new MatchError((Object)try_);
    }

    public DebugSession(Socket socket, DebuggeeRunner runner, IProviderContext context, Logger logger, LoggingAdapter loggingAdapter, boolean autoClose, Duration gracePeriod, ExecutionContext executionContext) {
        this.socket = socket;
        this.runner = runner;
        this.logger = logger;
        this.loggingAdapter = loggingAdapter;
        this.autoClose = autoClose;
        this.gracePeriod = gracePeriod;
        this.executionContext = executionContext;
        super(socket.getInputStream(), socket.getOutputStream(), context, loggingAdapter.factory());
        this.launchedRequests = Set$.MODULE$.empty();
        this.terminatedEvent = Promise$.MODULE$.apply();
        this.ch$epfl$scala$debugadapter$internal$DebugSession$$debuggeeAddress = Promise$.MODULE$.apply();
        this.attached = Promise$.MODULE$.apply();
        this.exitStatusPromise = Promise$.MODULE$.apply();
        this.debugState = new Synchronized<DebugSession$Ready$>(DebugSession$Ready$.MODULE$);
    }

    public static interface ExitStatus {
    }

    public static final class Started
    implements State,
    Product,
    scala.Serializable {
        private final CancelableFuture<BoxedUnit> debuggee;

        public CancelableFuture<BoxedUnit> debuggee() {
            return this.debuggee;
        }

        public Started copy(CancelableFuture<BoxedUnit> debuggee) {
            return new Started(debuggee);
        }

        public CancelableFuture<BoxedUnit> copy$default$1() {
            return this.debuggee();
        }

        public String productPrefix() {
            return "Started";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.debuggee();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Started;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Started)) return false;
            boolean bl = true;
            if (!bl) return false;
            Started started = (Started)x$1;
            CancelableFuture<BoxedUnit> cancelableFuture = this.debuggee();
            CancelableFuture<BoxedUnit> cancelableFuture2 = started.debuggee();
            if (cancelableFuture != null) {
                if (!cancelableFuture.equals(cancelableFuture2)) return false;
                return true;
            }
            if (cancelableFuture2 == null) return true;
            return false;
        }

        public Started(CancelableFuture<BoxedUnit> debuggee) {
            this.debuggee = debuggee;
            Product.$init$((Product)this);
        }
    }

    public static interface State {
    }
}

