package ch.epfl.scala.debugadapter

import java.nio.file.Path

trait DebuggeeRunner {
  def name: String
  def run(listener: DebuggeeListener): CancelableFuture[Unit]
  def classPathEntries: Seq[ClassPathEntry]
  def scalaVersion: String
  def classPath: Seq[Path] = classPathEntries.map(_.absolutePath)
  def javaRuntime: Option[JavaRuntime]
  def evaluationClassLoader: Option[ClassLoader]
}
