/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.scala.debugadapter.internal.evaluator;

import ch.epfl.scala.debugadapter.Logger;
import ch.epfl.scala.debugadapter.internal.evaluator.CompiledExpression;
import ch.epfl.scala.debugadapter.internal.evaluator.ExpressionCompiler;
import ch.epfl.scala.debugadapter.internal.evaluator.JdiArray;
import ch.epfl.scala.debugadapter.internal.evaluator.JdiArray$;
import ch.epfl.scala.debugadapter.internal.evaluator.JdiClassLoader;
import ch.epfl.scala.debugadapter.internal.evaluator.JdiClassLoader$;
import ch.epfl.scala.debugadapter.internal.evaluator.JdiObject;
import ch.epfl.scala.debugadapter.internal.evaluator.JdiPrimitive$;
import ch.epfl.scala.debugadapter.internal.evaluator.MethodInvocationFailed;
import ch.epfl.scala.debugadapter.internal.evaluator.Safe;
import ch.epfl.scala.debugadapter.internal.evaluator.Safe$;
import ch.epfl.scala.debugadapter.internal.evaluator.package$;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.Field;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.LongValue;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StackFrame;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005%f!B\t\u0013\u0001Qq\u0002\u0002\u0003\u0013\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0014\t\u0011)\u0002!\u0011!Q\u0001\n-B\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\u0006g\u0001!\t\u0001\u000e\u0005\u0006s\u0001!\tA\u000f\u0005\u0006I\u0002!\t!\u001a\u0005\u0006]\u0002!Ia\u001c\u0005\u0006k\u0002!IA\u001e\u0005\u0007\u007f\u0002!I!!\u0001\t\u000f\u0005\u001d\u0002\u0001\"\u0003\u0002*!9\u0011\u0011\n\u0001\u0005\n\u0005-\u0003bBA2\u0001\u0011%\u0011Q\r\u0005\n\u0003_\u0002!\u0019!C\u0005\u0003cB\u0001\"!%\u0001A\u0003%\u00111\u000f\u0005\b\u0003'\u0003A\u0011BAK\u0011\u001d\tY\n\u0001C\u0005\u0003;\u00131#\u0012=qe\u0016\u001c8/[8o\u000bZ\fG.^1u_JT!a\u0005\u000b\u0002\u0013\u00154\u0018\r\\;bi>\u0014(BA\u000b\u0017\u0003!Ig\u000e^3s]\u0006d'BA\f\u0019\u00031!WMY;hC\u0012\f\u0007\u000f^3s\u0015\tI\"$A\u0003tG\u0006d\u0017M\u0003\u0002\u001c9\u0005!Q\r\u001d4m\u0015\u0005i\u0012AA2i'\t\u0001q\u0004\u0005\u0002!E5\t\u0011EC\u0001\u001a\u0013\t\u0019\u0013E\u0001\u0004B]f\u0014VMZ\u0001\tG>l\u0007/\u001b7fe\u000e\u0001\u0001CA\u0014)\u001b\u0005\u0011\u0012BA\u0015\u0013\u0005I)\u0005\u0010\u001d:fgNLwN\\\"p[BLG.\u001a:\u0002\r1|wmZ3s!\taS&D\u0001\u0017\u0013\tqcC\u0001\u0004M_\u001e<WM]\u0001\ti\u0016\u001cH/T8eKB\u0011\u0001%M\u0005\u0003e\u0005\u0012qAQ8pY\u0016\fg.\u0001\u0004=S:LGO\u0010\u000b\u0005kY:\u0004\b\u0005\u0002(\u0001!)A\u0005\u0002a\u0001M!)!\u0006\u0002a\u0001W!)q\u0006\u0002a\u0001a\u000591m\\7qS2,G#B\u001eE#N{\u0006c\u0001\u001f@\u00036\tQH\u0003\u0002?C\u0005!Q\u000f^5m\u0013\t\u0001UHA\u0002Uef\u0004\"a\n\"\n\u0005\r\u0013\"AE\"p[BLG.\u001a3FqB\u0014Xm]:j_:DQ!R\u0003A\u0002\u0019\u000bQb]8ve\u000e,7i\u001c8uK:$\bCA$O\u001d\tAE\n\u0005\u0002JC5\t!J\u0003\u0002LK\u00051AH]8pizJ!!T\u0011\u0002\rA\u0013X\rZ3g\u0013\ty\u0005K\u0001\u0004TiJLgn\u001a\u0006\u0003\u001b\u0006BQAU\u0003A\u0002\u0019\u000b!\"\u001a=qe\u0016\u001c8/[8o\u0011\u0015!V\u00011\u0001V\u0003\u0019!\bN]3bIB\u0011a+X\u0007\u0002/*\u0011\u0001,W\u0001\u0004U\u0012L'B\u0001.\\\u0003\r\u0019XO\u001c\u0006\u00029\u0006\u00191m\\7\n\u0005y;&a\u0004+ie\u0016\fGMU3gKJ,gnY3\t\u000b\u0001,\u0001\u0019A1\u0002\u000b\u0011,\u0007\u000f\u001e5\u0011\u0005\u0001\u0012\u0017BA2\"\u0005\rIe\u000e^\u0001\tKZ\fG.^1uKR!aM\u001b7n!\rath\u001a\t\u0003-\"L!![,\u0003\u000bY\u000bG.^3\t\u000b-4\u0001\u0019A!\u0002%\r|W\u000e]5mK\u0012,\u0005\u0010\u001d:fgNLwN\u001c\u0005\u0006)\u001a\u0001\r!\u0016\u0005\u0006A\u001a\u0001\r!Y\u0001\u0010M&tGm\u00117bgNdu.\u00193feR\u0019\u0001o\u001d;\u0011\u0005\u001d\n\u0018B\u0001:\u0013\u00059QE-[\"mCN\u001cHj\\1eKJDQ\u0001V\u0004A\u0002UCQ\u0001Y\u0004A\u0002\u0005\f!#\u001a<bYV\fG/Z#yaJ,7o]5p]R\u0011qO\u001f\t\u0004Oa<\u0017BA=\u0013\u0005\u0011\u0019\u0016MZ3\t\u000bmD\u0001\u0019\u0001?\u0002%\u0015D\bO]3tg&|g.\u00138ti\u0006t7-\u001a\t\u0003OuL!A \n\u0003\u0013)#\u0017n\u00142kK\u000e$\u0018\u0001G2sK\u0006$X-\u0012=qe\u0016\u001c8/[8o\u0013:\u001cH/\u00198dKRA\u00111AA\u0003\u0003\u0013\tY\u0001E\u0002(qrDa!a\u0002\n\u0001\u0004\u0001\u0018aC2mCN\u001cHj\\1eKJDQa[\u0005A\u0002\u0005Cq!!\u0004\n\u0001\u0004\ty!\u0001\u0003be\u001e\u001c\bCBA\t\u00037\t\tC\u0004\u0003\u0002\u0014\u0005]abA%\u0002\u0016%\t\u0011$C\u0002\u0002\u001a\u0005\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u001e\u0005}!\u0001\u0002'jgRT1!!\u0007\"!\r1\u00161E\u0005\u0004\u0003K9&aD(cU\u0016\u001cGOU3gKJ,gnY3\u0002+\u0015DHO]1diZ\u000bG.^3t\u0003:$g*Y7fgR1\u00111FA\u001f\u0003\u000f\u0002Ba\n=\u0002.A9\u0001%a\f\u00024\u0005m\u0012bAA\u0019C\t1A+\u001e9mKJ\u0002b!!\u0005\u0002\u001c\u0005U\u0002c\u0001,\u00028%\u0019\u0011\u0011H,\u0003\u001fM#(/\u001b8h%\u00164WM]3oG\u0016\u0004R!!\u0005\u0002\u001c\u001dDq!a\u0010\u000b\u0001\u0004\t\t%A\u0003ge\u0006lW\rE\u0002W\u0003\u0007J1!!\u0012X\u0005)\u0019F/Y2l\rJ\fW.\u001a\u0005\u0007\u0003\u000fQ\u0001\u0019\u00019\u0002\u001fU\u0004H-\u0019;f-\u0006\u0014\u0018.\u00192mKN$\u0002\"!\u0014\u0002V\u0005}\u0013\u0011\r\t\u0005Oa\fy\u0005E\u0002!\u0003#J1!a\u0015\"\u0005\u0011)f.\u001b;\t\u000f\u0005]3\u00021\u0001\u0002Z\u0005ia/\u0019:jC\ndW-\u0011:sCf\u00042aJA.\u0013\r\tiF\u0005\u0002\t\u0015\u0012L\u0017I\u001d:bs\")Ak\u0003a\u0001+\")\u0001m\u0003a\u0001C\u0006q!m\u001c=JMB\u0013\u0018.\\5uSZ,GcB<\u0002h\u0005-\u0014Q\u000e\u0005\u0007\u0003Sb\u0001\u0019A4\u0002\u000bY\fG.^3\t\r\u0005\u001dA\u00021\u0001q\u0011\u0015!F\u00021\u0001V\u00031)hNY8y\u001b\u0016$\bn\u001c3t+\t\t\u0019\b\u0005\u0005\u0002v\u0005}\u00141QAB\u001b\t\t9H\u0003\u0003\u0002z\u0005m\u0014!C5n[V$\u0018M\u00197f\u0015\r\ti(I\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAA\u0003o\u00121!T1q!\u0011\t))a$\u000e\u0005\u0005\u001d%\u0002BAE\u0003\u0017\u000bA\u0001\\1oO*\u0011\u0011QR\u0001\u0005U\u00064\u0018-C\u0002P\u0003\u000f\u000bQ\"\u001e8c_blU\r\u001e5pIN\u0004\u0013\u0001E;oE>D\u0018J\u001a)sS6LG/\u001b<f)\u00159\u0018qSAM\u0011\u0019\tIg\u0004a\u0001O\")Ak\u0004a\u0001+\u0006Y\u0011n\u001d)sS6LG/\u001b<f)\r\u0001\u0014q\u0014\u0005\b\u0003C\u0003\u0002\u0019AAR\u0003!1\u0018M]5bE2,\u0007c\u0001,\u0002&&\u0019\u0011qU,\u0003\u001b1{7-\u00197WCJL\u0017M\u00197f\u0001")
public class ExpressionEvaluator {
    private final ExpressionCompiler compiler;
    private final Logger logger;
    private final boolean testMode;
    private final Map<String, String> unboxMethods;

    public Try<CompiledExpression> compile(String sourceContent, String expression, ThreadReference thread, int depth) {
        String className;
        this.logger.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Compiling expression '").append(expression).append("'").toString());
        Location location = thread.frame(depth).location();
        int line = location.lineNumber();
        String fqcn = location.declaringType().name();
        String string = className = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(fqcn)).split('.'))).last();
        String string2 = fqcn;
        String packageName = !(string != null ? !string.equals(string2) : string2 != null) ? "" : new StringOps(Predef$.MODULE$.augmentString(fqcn)).stripSuffix(new StringBuilder(1).append(".").append(className).toString());
        String randomId = UUID.randomUUID().toString().replace("-", "");
        Path outDir = Files.createTempDirectory(new StringBuilder(20).append("scala-debug-adapter-").append(randomId).toString(), new FileAttribute[0]);
        String expressionClassName = new StringBuilder(10).append("Expression").append(randomId).toString();
        String fileName = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(location.sourcePath())).split('/'))).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(x$1)).split('\\'))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).last();
        Path sourceFile = Files.createFile(outDir.resolve(fileName), new FileAttribute[0]);
        Files.write(sourceFile, sourceContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        String expressionFqcn = packageName.isEmpty() ? expressionClassName : new StringBuilder(1).append(packageName).append(".").append(expressionClassName).toString();
        JdiClassLoader classLoader = this.findClassLoader(thread, depth);
        Safe compiledExpression = this.extractValuesAndNames(thread.frame(depth), classLoader).withFilter((Function1<Tuple2<List<StringReference>, List<Value>>, Object>)(Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ExpressionEvaluator.$anonfun$compile$3(check$ifrefutable$1))).map((Function1 & Serializable & scala.Serializable)x$4 -> {
            Tuple2 tuple2 = x$4;
            if (tuple2 != null) {
                List names = (List)tuple2._1();
                Set localNames = ((TraversableOnce)names.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.value(), List$.MODULE$.canBuildFrom())).toSet();
                Try<BoxedUnit> compilation = $this.compiler.compile(outDir, expressionClassName, sourceFile, line, expression, (Set<String>)localNames, packageName, $this.testMode);
                return new Tuple3((Object)tuple2, (Object)localNames, compilation);
            }
            throw new MatchError((Object)tuple2);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$5 -> {
            Tuple3 tuple3 = x$5;
            if (tuple3 != null) {
                Tuple2 tuple2 = (Tuple2)tuple3._1();
                Try compilation = (Try)tuple3._3();
                if (tuple2 != null) {
                    return Safe$.MODULE$.lift(compilation).map((Function1 & Serializable & scala.Serializable)_ -> new CompiledExpression(outDir, expressionFqcn));
                }
            }
            throw new MatchError((Object)tuple3);
        });
        return compiledExpression.getResult();
    }

    public Try<Value> evaluate(CompiledExpression compiledExpression, ThreadReference thread, int depth) {
        JdiClassLoader classLoader = this.findClassLoader(thread, depth);
        Safe evaluatedValue = this.extractValuesAndNames(thread.frame(depth), classLoader).withFilter((Function1<Tuple2<List<StringReference>, List<Value>>, Object>)(Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)ExpressionEvaluator.$anonfun$evaluate$1(check$ifrefutable$2))).flatMap((Function1 & Serializable & scala.Serializable)x$9 -> {
            Tuple2 tuple2 = x$9;
            if (tuple2 != null) {
                List names = (List)tuple2._1();
                List values = (List)tuple2._2();
                return JdiArray$.MODULE$.apply("java.lang.String", names.size(), classLoader).flatMap((Function1 & Serializable & scala.Serializable)namesArray -> JdiArray$.MODULE$.apply("java.lang.Object", values.size(), classLoader).map((Function1 & Serializable & scala.Serializable)valuesArray -> {
                    namesArray.setValues((List<Value>)names);
                    BoxedUnit x$6 = BoxedUnit.UNIT;
                    valuesArray.setValues((List<Value>)values);
                    BoxedUnit x$7 = BoxedUnit.UNIT;
                    .colon.colon args2 = new .colon.colon((Object)namesArray.reference(), (List)new .colon.colon((Object)valuesArray.reference(), (List)Nil$.MODULE$));
                    return new Tuple4(valuesArray, (Object)x$6, (Object)x$7, (Object)args2);
                }).flatMap((Function1 & Serializable & scala.Serializable)x$8 -> {
                    Tuple4 tuple4 = x$8;
                    if (tuple4 != null) {
                        JdiArray valuesArray = (JdiArray)tuple4._1();
                        List args2 = (List)tuple4._4();
                        return this.createExpressionInstance(classLoader, compiledExpression, (List<ObjectReference>)args2).flatMap((Function1 & Serializable & scala.Serializable)expressionInstance -> this.evaluateExpression((JdiObject)expressionInstance).flatMap((Function1 & Serializable & scala.Serializable)evaluatedValue -> this.updateVariables(valuesArray, thread, depth).flatMap((Function1 & Serializable & scala.Serializable)_ -> this.unboxIfPrimitive((Value)evaluatedValue, thread).map((Function1 & Serializable & scala.Serializable)unboxedValue -> unboxedValue))));
                    }
                    throw new MatchError((Object)tuple4);
                }));
            }
            throw new MatchError((Object)tuple2);
        });
        return evaluatedValue.getResult();
    }

    private JdiClassLoader findClassLoader(ThreadReference thread, int depth) {
        Option scalaLibClassLoader = ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(thread.virtualMachine().allClasses()).asScala()).find((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)ExpressionEvaluator.$anonfun$findClassLoader$1(c))).flatMap((Function1 & Serializable & scala.Serializable)scalaLibClass -> Option$.MODULE$.apply((Object)scalaLibClass.classLoader()).map((Function1 & Serializable & scala.Serializable)classLoader -> classLoader));
        ClassLoaderReference classLoader = (ClassLoaderReference)Option$.MODULE$.apply((Object)thread.frame(depth).location().method().declaringType().classLoader()).orElse((Function0 & Serializable & scala.Serializable)() -> scalaLibClassLoader).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new Exception("Cannot find the classloader of the Scala library");
        });
        return JdiClassLoader$.MODULE$.apply(classLoader, thread);
    }

    private Safe<Value> evaluateExpression(JdiObject expressionInstance) {
        return expressionInstance.invoke("evaluate", (List<Value>)Nil$.MODULE$).recover(new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof MethodInvocationFailed) {
                    MethodInvocationFailed methodInvocationFailed = (MethodInvocationFailed)A1;
                    ObjectReference exception = methodInvocationFailed.remoteException();
                    return (B1)exception;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return throwable instanceof MethodInvocationFailed;
            }
        });
    }

    private Safe<JdiObject> createExpressionInstance(JdiClassLoader classLoader, CompiledExpression compiledExpression, List<ObjectReference> args2) {
        String expressionClassPath = compiledExpression.classDir().toUri().toString();
        return classLoader.mirrorOf(expressionClassPath).flatMap((Function1 & Serializable & scala.Serializable)classPathValue -> classLoader.loadClass("java.net.URL").flatMap((Function1 & Serializable & scala.Serializable)urlClass -> urlClass.newInstance((List<ObjectReference>)new .colon.colon(classPathValue, (List)Nil$.MODULE$)).flatMap((Function1 & Serializable & scala.Serializable)url -> JdiArray$.MODULE$.apply("java.net.URL", 1, classLoader).map((Function1 & Serializable & scala.Serializable)urls -> {
            urls.setValue(0, url.reference());
            BoxedUnit x$13 = BoxedUnit.UNIT;
            return new Tuple2(urls, (Object)x$13);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$14 -> {
            Tuple2 tuple2 = x$14;
            if (tuple2 != null) {
                JdiArray urls = (JdiArray)tuple2._1();
                return classLoader.loadClass("java.net.URLClassLoader").flatMap((Function1 & Serializable & scala.Serializable)x$10 -> x$10.newInstance((List<ObjectReference>)new .colon.colon((Object)urls.reference(), (List)Nil$.MODULE$))).map((Function1 & Serializable & scala.Serializable)x$11 -> (ClassLoaderReference)x$11.reference()).map((Function1 & Serializable & scala.Serializable)x$12 -> JdiClassLoader$.MODULE$.apply((ClassLoaderReference)x$12, classLoader.thread())).flatMap((Function1 & Serializable & scala.Serializable)urlClassLoader -> urlClassLoader.loadClass(compiledExpression.className()).flatMap((Function1 & Serializable & scala.Serializable)expressionClass -> expressionClass.newInstance(args2).map((Function1 & Serializable & scala.Serializable)expressionInstance -> expressionInstance)));
            }
            throw new MatchError((Object)tuple2);
        }))));
    }

    private Safe<Tuple2<List<StringReference>, List<Value>>> extractValuesAndNames(StackFrame frame, JdiClassLoader classLoader) {
        Option thisObjectOpt = Option$.MODULE$.apply((Object)frame.thisObject());
        return this.extractVariablesFromFrame$1(frame, classLoader).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)ExpressionEvaluator.$anonfun$extractValuesAndNames$9(check$ifrefutable$3))).flatMap((Function1 & Serializable & scala.Serializable)x$24 -> {
            Tuple2 tuple2 = x$24;
            if (tuple2 != null) {
                List variableNames = (List)tuple2._1();
                List variableValues = (List)tuple2._2();
                return ((Safe)thisObjectOpt.filter((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)ExpressionEvaluator.$anonfun$extractValuesAndNames$11(this, x$17))).map((Function1 & Serializable & scala.Serializable)thisObject -> this.extractFields$1((ObjectReference)thisObject, classLoader)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Safe$.MODULE$.lift(new Tuple2((Object)Nil$.MODULE$, (Object)Nil$.MODULE$)))).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)ExpressionEvaluator.$anonfun$extractValuesAndNames$14(check$ifrefutable$4))).map((Function1 & Serializable & scala.Serializable)x$22 -> {
                    Tuple2 tuple2 = x$22;
                    if (tuple2 != null) {
                        Option thisObjectValue = thisObjectOpt.filter((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)ExpressionEvaluator.$anonfun$extractValuesAndNames$16(variableNames, x$18)));
                        return new Tuple2((Object)tuple2, (Object)thisObjectValue);
                    }
                    throw new MatchError((Object)tuple2);
                }).flatMap((Function1 & Serializable & scala.Serializable)x$23 -> {
                    Tuple2 tuple2 = x$23;
                    if (tuple2 != null) {
                        Tuple2 tuple22 = (Tuple2)tuple2._1();
                        Option thisObjectValue = (Option)tuple2._2();
                        if (tuple22 != null) {
                            List fieldNames = (List)tuple22._1();
                            List fieldValues = (List)tuple22._2();
                            return package$.MODULE$.SafeOption(thisObjectValue.map((Function1 & Serializable & scala.Serializable)x$20 -> classLoader.mirrorOf("$this"))).traverse().map((Function1 & Serializable & scala.Serializable)thisObjectName -> {
                                List names = (List)((List)variableNames.$plus$plus((GenTraversableOnce)fieldNames, List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(thisObjectName), List$.MODULE$.canBuildFrom());
                                List values = (List)((List)variableValues.$plus$plus((GenTraversableOnce)fieldValues, List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(thisObjectValue), List$.MODULE$.canBuildFrom());
                                return new Tuple2((Object)names, (Object)values);
                            });
                        }
                    }
                    throw new MatchError((Object)tuple2);
                });
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private Safe<BoxedUnit> updateVariables(JdiArray variableArray, ThreadReference thread, int depth) {
        Safe unboxedValues = package$.MODULE$.SafeList((List)((List)ExpressionEvaluator.localVariables$1(thread, depth).zip(variableArray.getValues(), List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                LocalVariable variable = (LocalVariable)tuple2._1();
                Value value = (Value)tuple2._2();
                if (this.isPrimitive(variable)) {
                    return this.unboxIfPrimitive(value, thread);
                }
                return Safe$.MODULE$.lift(value);
            }
            throw new MatchError((Object)tuple2);
        }, List$.MODULE$.canBuildFrom())).traverse();
        return unboxedValues.map((Function1 & Serializable & scala.Serializable)values -> {
            ExpressionEvaluator.$anonfun$updateVariables$2(thread, depth, values);
            return BoxedUnit.UNIT;
        });
    }

    private Safe<Value> boxIfPrimitive(Value value, JdiClassLoader classLoader, ThreadReference thread) {
        Value value2 = value;
        if (value2 instanceof BooleanValue) {
            BooleanValue booleanValue = (BooleanValue)value2;
            return JdiPrimitive$.MODULE$.box(BoxesRunTime.boxToBoolean((boolean)booleanValue.value()), classLoader, thread);
        }
        if (value2 instanceof CharValue) {
            CharValue charValue = (CharValue)value2;
            return JdiPrimitive$.MODULE$.box(BoxesRunTime.boxToCharacter((char)charValue.value()), classLoader, thread);
        }
        if (value2 instanceof DoubleValue) {
            DoubleValue doubleValue = (DoubleValue)value2;
            return JdiPrimitive$.MODULE$.box(BoxesRunTime.boxToDouble((double)doubleValue.value()), classLoader, thread);
        }
        if (value2 instanceof FloatValue) {
            FloatValue floatValue = (FloatValue)value2;
            return JdiPrimitive$.MODULE$.box(BoxesRunTime.boxToFloat((float)floatValue.value()), classLoader, thread);
        }
        if (value2 instanceof IntegerValue) {
            IntegerValue integerValue = (IntegerValue)value2;
            return JdiPrimitive$.MODULE$.box(BoxesRunTime.boxToInteger((int)integerValue.value()), classLoader, thread);
        }
        if (value2 instanceof LongValue) {
            LongValue longValue = (LongValue)value2;
            return JdiPrimitive$.MODULE$.box(BoxesRunTime.boxToLong((long)longValue.value()), classLoader, thread);
        }
        if (value2 instanceof ShortValue) {
            ShortValue shortValue = (ShortValue)value2;
            return JdiPrimitive$.MODULE$.box(BoxesRunTime.boxToShort((short)shortValue.value()), classLoader, thread);
        }
        return Safe$.MODULE$.lift(value2);
    }

    private Map<String, String> unboxMethods() {
        return this.unboxMethods;
    }

    private Safe<Value> unboxIfPrimitive(Value value, ThreadReference thread) {
        Value value2 = value;
        if (value2 instanceof ObjectReference) {
            ObjectReference objectReference = (ObjectReference)value2;
            String typeName = objectReference.referenceType().name();
            return (Safe)this.unboxMethods().get((Object)typeName).map((Function1 & Serializable & scala.Serializable)methodName -> new JdiObject(objectReference, thread).invoke((String)methodName, (List<Value>)Nil$.MODULE$)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Safe$.MODULE$.lift(value));
        }
        return Safe$.MODULE$.lift(value);
    }

    private boolean isPrimitive(LocalVariable variable) {
        return variable.type() instanceof PrimitiveType;
    }

    public static final /* synthetic */ boolean $anonfun$compile$3(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$evaluate$1(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$findClassLoader$1(ReferenceType c) {
        return c.name().startsWith("scala.runtime");
    }

    private final Safe extractVariablesFromFrame$1(StackFrame frame$1, JdiClassLoader classLoader$3) {
        List variables = ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(frame$1.visibleVariables()).asScala()).toList();
        Safe variableNames = package$.MODULE$.SafeList((List)((List)variables.map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.name(), List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)str -> classLoader$3.mirrorOf((String)str), List$.MODULE$.canBuildFrom())).traverse();
        Safe variableValues = package$.MODULE$.SafeList((List)((List)variables.map((Function1 & Serializable & scala.Serializable)x$1 -> frame$1.getValue((LocalVariable)x$1), List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)value -> this.boxIfPrimitive((Value)value, classLoader$3, classLoader$3.thread()), List$.MODULE$.canBuildFrom())).traverse();
        return Safe$.MODULE$.join(variableNames, variableValues);
    }

    private final Safe extractFields$1(ObjectReference thisObject, JdiClassLoader classLoader$3) {
        List fields = ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(thisObject.referenceType().fields()).asScala()).toList();
        Safe fieldNames = package$.MODULE$.SafeList((List)((List)fields.map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.name(), List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)str -> classLoader$3.mirrorOf((String)str), List$.MODULE$.canBuildFrom())).traverse();
        Safe fieldValues = package$.MODULE$.SafeList((List)((List)fields.map((Function1 & Serializable & scala.Serializable)field -> thisObject.getValue((Field)field), List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)value -> this.boxIfPrimitive((Value)value, classLoader$3, classLoader$3.thread()), List$.MODULE$.canBuildFrom())).traverse();
        return Safe$.MODULE$.join(fieldNames, fieldValues);
    }

    public static final /* synthetic */ boolean $anonfun$extractValuesAndNames$9(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$extractValuesAndNames$11(ExpressionEvaluator $this, ObjectReference x$17) {
        return $this.compiler.scalaVersion().isScala2();
    }

    public static final /* synthetic */ boolean $anonfun$extractValuesAndNames$14(Tuple2 check$ifrefutable$4) {
        Tuple2 tuple2 = check$ifrefutable$4;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$extractValuesAndNames$17(StringReference x$19) {
        String string = x$19.value();
        String string2 = "$this";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$extractValuesAndNames$16(List variableNames$1, ObjectReference x$18) {
        return !variableNames$1.exists((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)ExpressionEvaluator.$anonfun$extractValuesAndNames$17(x$19)));
    }

    private static final List localVariables$1(ThreadReference thread$2, int depth$2) {
        return ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(thread$2.frame(depth$2).visibleVariables()).asScala()).toList();
    }

    public static final /* synthetic */ boolean $anonfun$updateVariables$3(Tuple2 check$ifrefutable$5) {
        Tuple2 tuple2 = check$ifrefutable$5;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$updateVariables$4(ThreadReference thread$2, int depth$2, Tuple2 x$25) {
        Tuple2 tuple2 = x$25;
        if (tuple2 != null) {
            LocalVariable variable = (LocalVariable)tuple2._1();
            Value value = (Value)tuple2._2();
            thread$2.frame(depth$2).setValue(variable, value);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$updateVariables$2(ThreadReference thread$2, int depth$2, List values) {
        ((TraversableLike)ExpressionEvaluator.localVariables$1(thread$2, depth$2).zip((GenIterable)values, List$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$5 -> BoxesRunTime.boxToBoolean((boolean)ExpressionEvaluator.$anonfun$updateVariables$3(check$ifrefutable$5))).foreach((Function1 & Serializable & scala.Serializable)x$25 -> {
            ExpressionEvaluator.$anonfun$updateVariables$4(thread$2, depth$2, x$25);
            return BoxedUnit.UNIT;
        });
    }

    public ExpressionEvaluator(ExpressionCompiler compiler, Logger logger, boolean testMode) {
        this.compiler = compiler;
        this.logger = logger;
        this.testMode = testMode;
        this.unboxMethods = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"java.lang.Boolean"), (Object)"booleanValue"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"java.lang.Byte"), (Object)"byteValue"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"java.lang.Character"), (Object)"charValue"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"java.lang.Double"), (Object)"doubleValue"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"java.lang.Float"), (Object)"floatValue"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"java.lang.Integer"), (Object)"intValue"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"java.lang.Long"), (Object)"longValue"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"java.lang.Short"), (Object)"shortValue")}));
    }
}

