/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.scala.debugadapter.internal.stepfilter;

import ch.epfl.scala.debugadapter.DebugTools;
import ch.epfl.scala.debugadapter.Debuggee;
import ch.epfl.scala.debugadapter.Logger;
import ch.epfl.scala.debugadapter.ScalaVersion;
import ch.epfl.scala.debugadapter.internal.ByteCodes$;
import ch.epfl.scala.debugadapter.internal.SourceLookUpProvider;
import ch.epfl.scala.debugadapter.internal.stepfilter.ScalaStepFilter$;
import ch.epfl.scala.debugadapter.internal.stepfilter.StepFilter;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015d!B\u000e\u001d\u0003\u0003I\u0003\u0002C\u001a\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001b\t\u000ba\u0002A\u0011A\u001d\t\u000bq\u0002a\u0011C\u001f\t\u000b5\u0003A\u0011\t(\t\u000bA\u0003A\u0011B)\t\u000b]\u0003A\u0011\u0002-\t\u000bi\u0003A\u0011B.\t\u000bu\u0003A\u0011\u00020\t\u000b\u0001\u0004A\u0011B1\t\u000b\r\u0004A\u0011\u00023\t\u000b\u0019\u0004A\u0011B4\t\u000b%\u0004A\u0011\u00026\t\u000f1\u0004!\u0019!C\u0005[\"1A\u0010\u0001Q\u0001\n9DQ! \u0001\u0005\nyDq!!\u0001\u0001\t\u0013\t\u0019\u0001C\u0004\u0002\b\u0001!I!!\u0003\t\u000f\u00055\u0001\u0001\"\u0003\u0002\u0010!9\u00111\u0003\u0001\u0005\n\u0005U\u0001bBA\r\u0001\u0011%\u00111\u0004\u0005\b\u0003?\u0001A\u0011BA\u0011\u000f\u001d\t)\u0003\bE\u0001\u0003O1aa\u0007\u000f\t\u0002\u0005%\u0002B\u0002\u001d\u0018\t\u0003\tY\u0003C\u0004\u0002.]!\t!a\f\t\u000f\u0005}s\u0003\"\u0003\u0002b\ty1kY1mCN#X\r\u001d$jYR,'O\u0003\u0002\u001e=\u0005Q1\u000f^3qM&dG/\u001a:\u000b\u0005}\u0001\u0013\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005\u0005\u0012\u0013\u0001\u00043fEV<\u0017\rZ1qi\u0016\u0014(BA\u0012%\u0003\u0015\u00198-\u00197b\u0015\t)c%\u0001\u0003fa\u001ad'\"A\u0014\u0002\u0005\rD7\u0001A\n\u0004\u0001)z\u0003CA\u0016.\u001b\u0005a#\"A\u0012\n\u00059b#AB!osJ+g\r\u0005\u00021c5\tA$\u0003\u000239\tQ1\u000b^3q\r&dG/\u001a:\u0002\u0019M\u001c\u0017\r\\1WKJ\u001c\u0018n\u001c8\u0011\u0005U2T\"\u0001\u0011\n\u0005]\u0002#\u0001D*dC2\fg+\u001a:tS>t\u0017A\u0002\u001fj]&$h\b\u0006\u0002;wA\u0011\u0001\u0007\u0001\u0005\u0006g\t\u0001\r\u0001N\u0001\u0010g.L\u0007oU2bY\u0006lU\r\u001e5pIR\u0011a(\u0011\t\u0003W}J!\u0001\u0011\u0017\u0003\u000f\t{w\u000e\\3b]\")!i\u0001a\u0001\u0007\u00061Q.\u001a;i_\u0012\u0004\"\u0001R&\u000e\u0003\u0015S!AR$\u0002\u0007)$\u0017N\u0003\u0002I\u0013\u0006\u00191/\u001e8\u000b\u0003)\u000b1aY8n\u0013\taUI\u0001\u0004NKRDw\u000eZ\u0001\u000fg\"|W\u000f\u001c3TW&\u0004xJ^3s)\tqt\nC\u0003C\t\u0001\u00071)\u0001\bjg\u0012Kh.Y7jG\u000ec\u0017m]:\u0015\u0005y\u0012\u0006\"B*\u0006\u0001\u0004!\u0016a\u0001;qKB\u0011A)V\u0005\u0003-\u0016\u0013QBU3gKJ,gnY3UsB,\u0017AB5t\u0015\u00064\u0018\r\u0006\u0002?3\")!I\u0002a\u0001\u0007\u0006i\u0011n]\"p]N$(/^2u_J$\"A\u0010/\t\u000b\t;\u0001\u0019A\"\u0002'%\u001c8\u000b^1uS\u000e\u001cuN\\:ueV\u001cGo\u001c:\u0015\u0005yz\u0006\"\u0002\"\t\u0001\u0004\u0019\u0015AD5t\u0003:|gNR;oGRLwN\u001c\u000b\u0003}\tDQAQ\u0005A\u0002\r\u000ba\"[:MS\u001a$X\rZ'fi\"|G\r\u0006\u0002?K\")!I\u0003a\u0001\u0007\u0006y\u0011n]!eCB$X\rZ'fi\"|G\r\u0006\u0002?Q\")!i\u0003a\u0001\u0007\u0006\t\u0012n\u001d'bufLe.\u001b;jC2L'0\u001a:\u0015\u0005yZ\u0007\"\u0002\"\r\u0001\u0004\u0019\u0015!\u00037buf$\u0016\u0010]3t+\u0005q\u0007cA8ws:\u0011\u0001\u000f\u001e\t\u0003c2j\u0011A\u001d\u0006\u0003g\"\na\u0001\u0010:p_Rt\u0014BA;-\u0003\u0019\u0001&/\u001a3fM&\u0011q\u000f\u001f\u0002\u0004'\u0016$(BA;-!\ty'0\u0003\u0002|q\n11\u000b\u001e:j]\u001e\f!\u0002\\1{sRK\b/Z:!\u00031I7\u000fT1{s\u001e+G\u000f^3s)\tqt\u0010C\u0003C\u001f\u0001\u00071)\u0001\bjg\u0012+g-Y;miZ\u000bG.^3\u0015\u0007y\n)\u0001C\u0003C!\u0001\u00071)A\u0006jg\u0006swN\\\"mCN\u001cHc\u0001 \u0002\f!)1+\u0005a\u0001)\u0006a\u0011n\u001d'pG\u0006d7\t\\1tgR\u0019a(!\u0005\t\u000bM\u0013\u0002\u0019\u0001+\u0002\u001b%\u001ch*Z:uK\u0012\u001cE.Y:t)\rq\u0014q\u0003\u0005\u0006'N\u0001\r\u0001V\u0001\u0013SN$&/Y5u\u0013:LG/[1mSj,'\u000fF\u0002?\u0003;AQA\u0011\u000bA\u0002\r\u000bAc]6jaR\u0013\u0018-\u001b;J]&$\u0018.\u00197ju\u0016\u0014Hc\u0001 \u0002$!)!)\u0006a\u0001\u0007\u0006y1kY1mCN#X\r\u001d$jYR,'\u000f\u0005\u00021/M\u0011qC\u000b\u000b\u0003\u0003O\tQ!\u00199qYf$2bLA\u0019\u0003w\t)%!\u0015\u0002\\!9\u00111G\rA\u0002\u0005U\u0012\u0001\u00033fEV<w-Z3\u0011\u0007U\n9$C\u0002\u0002:\u0001\u0012\u0001\u0002R3ck\u001e<W-\u001a\u0005\b\u0003{I\u0002\u0019AA \u0003\u0015!xn\u001c7t!\r)\u0014\u0011I\u0005\u0004\u0003\u0007\u0002#A\u0003#fEV<Gk\\8mg\"9\u0011qI\rA\u0002\u0005%\u0013\u0001D:pkJ\u001cW\rT8pWV\u0003\b\u0003BA&\u0003\u001bj\u0011AH\u0005\u0004\u0003\u001fr\"\u0001F*pkJ\u001cW\rT8pWV\u0003\bK]8wS\u0012,'\u000fC\u0004\u0002Te\u0001\r!!\u0016\u0002\r1|wmZ3s!\r)\u0014qK\u0005\u0004\u00033\u0002#A\u0002'pO\u001e,'\u000f\u0003\u0004\u0002^e\u0001\rAP\u0001\ti\u0016\u001cH/T8eK\u0006Aa-\u00197mE\u0006\u001c7\u000eF\u00020\u0003GBQa\r\u000eA\u0002Q\u0002")
public abstract class ScalaStepFilter
implements StepFilter {
    private final ScalaVersion scalaVersion;
    private final Set<String> lazyTypes;

    public static StepFilter apply(Debuggee debuggee, DebugTools debugTools, SourceLookUpProvider sourceLookUpProvider, Logger logger, boolean bl) {
        return ScalaStepFilter$.MODULE$.apply(debuggee, debugTools, sourceLookUpProvider, logger, bl);
    }

    @Override
    public boolean shouldSkipOut(Location upperLocation, Method method) {
        return StepFilter.shouldSkipOut$(this, upperLocation, method);
    }

    public abstract boolean skipScalaMethod(Method var1);

    @Override
    public boolean shouldSkipOver(Method method) {
        if (method.isBridge()) {
            return true;
        }
        if (this.isDynamicClass(method.declaringType())) {
            return true;
        }
        if (this.isJava(method)) {
            return false;
        }
        if (this.isConstructor(method)) {
            return false;
        }
        if (this.isStaticConstructor(method)) {
            return false;
        }
        if (this.isAdaptedMethod(method)) {
            return true;
        }
        if (this.isAnonFunction(method)) {
            return false;
        }
        if (this.isLiftedMethod(method)) {
            return !this.isLazyInitializer(method) && this.isLazyGetter(method);
        }
        if (this.isAnonClass(method.declaringType())) {
            return false;
        }
        if (this.isLocalClass(method.declaringType())) {
            return false;
        }
        if (this.scalaVersion.isScala2() && this.isNestedClass(method.declaringType())) {
            return false;
        }
        if (this.isDefaultValue(method)) {
            return false;
        }
        if (this.isTraitInitializer(method)) {
            return this.skipTraitInitializer(method);
        }
        return this.skipScalaMethod(method);
    }

    private boolean isDynamicClass(ReferenceType tpe) {
        boolean bl;
        block3: {
            try {
                if (!new StringOps(Predef$.MODULE$.augmentString(tpe.sourceName())).contains((Object)BoxesRunTime.boxToCharacter((char)'.'))) {
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            catch (AbsentInformationException absentInformationException) {
                bl = true;
            }
        }
        return bl;
    }

    private boolean isJava(Method method) {
        return method.declaringType().sourceName().endsWith(".java");
    }

    private boolean isConstructor(Method method) {
        String string = method.name();
        String string2 = "<init>";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private boolean isStaticConstructor(Method method) {
        String string = method.name();
        String string2 = "<clinit>";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private boolean isAnonFunction(Method method) {
        return method.name().matches(".+\\$anonfun\\$\\d+");
    }

    private boolean isLiftedMethod(Method method) {
        return method.name().matches(".+\\$\\d+");
    }

    private boolean isAdaptedMethod(Method method) {
        return method.name().matches(".+\\$adapted(\\$\\d+)?");
    }

    private boolean isLazyInitializer(Method method) {
        return method.name().contains("$lzyINIT") || method.name().contains("$lzycompute$");
    }

    private Set<String> lazyTypes() {
        return this.lazyTypes;
    }

    private boolean isLazyGetter(Method method) {
        Seq seq = ((SeqLike)CollectionConverters$.MODULE$.asScalaBufferConverter(method.argumentTypes()).asScala()).toSeq();
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0) {
            Type argType = (Type)((SeqLike)some.get()).apply(0);
            return this.lazyTypes().contains((Object)argType.name());
        }
        return false;
    }

    private boolean isDefaultValue(Method method) {
        return method.name().contains("$default$");
    }

    private boolean isAnonClass(ReferenceType tpe) {
        return tpe.name().contains("$anon$");
    }

    private boolean isLocalClass(ReferenceType tpe) {
        return tpe.name().matches(".+\\$\\d+");
    }

    private boolean isNestedClass(ReferenceType tpe) {
        return tpe.name().matches(".+\\$\\.+");
    }

    private boolean isTraitInitializer(Method method) {
        String string = method.name();
        String string2 = "$init$";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private boolean skipTraitInitializer(Method method) {
        Seq seq = new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(method.bytecodes())).toSeq();
        GenTraversable genTraversable = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{ByteCodes$.MODULE$.RETURN()}));
        return !(seq != null ? !seq.equals(genTraversable) : genTraversable != null);
    }

    public ScalaStepFilter(ScalaVersion scalaVersion) {
        this.scalaVersion = scalaVersion;
        StepFilter.$init$(this);
        this.lazyTypes = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"scala.runtime.LazyRef", "scala.runtime.LazyBoolean", "scala.runtime.LazyByte", "scala.runtime.LazyChar", "scala.runtime.LazyShort", "scala.runtime.LazyInt", "scala.runtime.LazyLong", "scala.runtime.LazyFloat", "scala.runtime.LazyDouble", "scala.runtime.LazyUnit"}));
    }
}

