/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.scala.debugadapter.internal;

import ch.epfl.scala.debugadapter.Logger;
import ch.epfl.scala.debugadapter.SourceDirectory;
import ch.epfl.scala.debugadapter.SourceEntry;
import ch.epfl.scala.debugadapter.SourceJar;
import ch.epfl.scala.debugadapter.StandaloneSourceFile;
import ch.epfl.scala.debugadapter.internal.IO$;
import ch.epfl.scala.debugadapter.internal.ScalaExtension$;
import ch.epfl.scala.debugadapter.internal.SourceFile;
import java.io.Serializable;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;

public final class SourceEntryLookUp$ {
    public static SourceEntryLookUp$ MODULE$;

    static {
        new SourceEntryLookUp$();
    }

    public Seq<SourceFile> getAllSourceFiles(SourceEntry entry, Logger logger) {
        SourceEntry sourceEntry = entry;
        if (sourceEntry instanceof SourceJar) {
            SourceJar sourceJar = (SourceJar)sourceEntry;
            Path jar = sourceJar.jar();
            return (Seq)ScalaExtension$.MODULE$.TryExtension(IO$.MODULE$.withinJarFile(jar, (Function1 & Serializable & scala.Serializable)fileSystem -> MODULE$.getAllSourceFiles(entry, (FileSystem)fileSystem, fileSystem.getPath("/", new String[0])).toVector())).warnFailure(logger, new StringBuilder(32).append("Cannot list the source files in ").append(entry.name()).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Vector().empty());
        }
        if (sourceEntry instanceof SourceDirectory) {
            SourceDirectory sourceDirectory = (SourceDirectory)sourceEntry;
            Path directory = sourceDirectory.directory();
            return this.getAllSourceFiles(entry, FileSystems.getDefault(), directory).toSeq();
        }
        if (sourceEntry instanceof StandaloneSourceFile) {
            StandaloneSourceFile standaloneSourceFile = (StandaloneSourceFile)sourceEntry;
            Path absolutePath = standaloneSourceFile.absolutePath();
            String relativePath = standaloneSourceFile.relativePath();
            return (Seq)new .colon.colon((Object)new SourceFile(entry, relativePath, absolutePath.toUri()), (List)Nil$.MODULE$);
        }
        throw new MatchError((Object)sourceEntry);
    }

    private Iterator<SourceFile> getAllSourceFiles(SourceEntry entry, FileSystem fileSystem, Path root) {
        if (Files.exists(root, new LinkOption[0])) {
            PathMatcher sourceMatcher = fileSystem.getPathMatcher("glob:**.{scala,java}");
            return ((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter(Files.walk(root, new FileVisitOption[0]).filter(x$1 -> sourceMatcher.matches((Path)x$1)).iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)path -> {
                String relativePath = ((Object)root.relativize((Path)path)).toString().replace('\\', '/');
                return new SourceFile(entry, relativePath, path.toUri());
            });
        }
        return package$.MODULE$.Iterator().empty();
    }

    private SourceEntryLookUp$() {
        MODULE$ = this;
    }
}

