/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.scala.debugadapter.internal;

import ch.epfl.scala.debugadapter.Debuggee;
import ch.epfl.scala.debugadapter.Logger;
import ch.epfl.scala.debugadapter.internal.HotCodeReplaceProvider$;
import ch.epfl.scala.debugadapter.internal.ScalaExtension$;
import ch.epfl.scala.debugadapter.internal.SourceLookUpProvider;
import ch.epfl.scala.debugadapter.internal.StackTraceProvider;
import com.microsoft.java.debug.core.DebugException;
import com.microsoft.java.debug.core.DebugUtility;
import com.microsoft.java.debug.core.IDebugSession;
import com.microsoft.java.debug.core.StackFrameUtility;
import com.microsoft.java.debug.core.adapter.HotCodeReplaceEvent;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IHotCodeReplaceProvider;
import com.microsoft.java.debug.core.adapter.ISourceLookUpProvider;
import com.microsoft.java.debug.core.adapter.IStackTraceProvider;
import com.microsoft.java.debug.core.protocol.Events;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.StepRequest;
import io.reactivex.Observable;
import io.reactivex.disposables.Disposable;
import io.reactivex.subjects.PublishSubject;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\rma\u0001\u0002\u001d:\u0001\u0011C\u0001\u0002\u0018\u0001\u0003\u0002\u0003\u0006I!\u0018\u0005\tC\u0002\u0011\t\u0011)A\u0005E\"AQ\r\u0001B\u0001B\u0003%a\rC\u0003l\u0001\u0011\u0005A\u000eC\u0004s\u0001\u0001\u0007I\u0011B:\t\u000f]\u0004\u0001\u0019!C\u0005q\"1a\u0010\u0001Q!\nQD\u0001b \u0001A\u0002\u0013%\u0011\u0011\u0001\u0005\n\u0003\u0013\u0001\u0001\u0019!C\u0005\u0003\u0017A\u0001\"a\u0004\u0001A\u0003&\u00111\u0001\u0005\n\u0003#\u0001\u0001\u0019!C\u0005\u0003'A\u0011\"!\u000b\u0001\u0001\u0004%I!a\u000b\t\u0011\u0005=\u0002\u0001)Q\u0005\u0003+A\u0011\"!\r\u0001\u0001\u0004%I!a\r\t\u0013\u0005m\u0002\u00011A\u0005\n\u0005u\u0002\u0002CA!\u0001\u0001\u0006K!!\u000e\t\u0013\u0005\r\u0003\u00011A\u0005\n\u0005\u0015\u0003\"CA(\u0001\u0001\u0007I\u0011BA)\u0011!\t)\u0006\u0001Q!\n\u0005\u001d\u0003\"CA,\u0001\t\u0007I\u0011BA-\u0011!\tY\t\u0001Q\u0001\n\u0005m\u0003\"CAG\u0001\t\u0007I\u0011BAH\u0011!\tI\r\u0001Q\u0001\n\u0005E\u0005\"CAf\u0001\t\u0007I\u0011BAg\u0011!\t\t\u000f\u0001Q\u0001\n\u0005=\u0007bBAr\u0001\u0011\u0005\u0013Q\u001d\u0005\b\u0003g\u0004A\u0011IA{\u0011\u001d\t9\u0010\u0001C!\u0003sDqA!\u0005\u0001\t\u0003\u0012\u0019\u0002C\u0004\u0003\u001e\u0001!IAa\b\t\u000f\t-\u0002\u0001\"\u0003\u0003 !9!Q\u0006\u0001\u0005\n\t}\u0001\"\u0003B\u0018\u0001\t\u0007I\u0011\tB\u0019\u0011!\u0011Y\u0004\u0001Q\u0001\n\tM\u0002b\u0002B\u001f\u0001\u0011%!q\b\u0005\b\u0005{\u0001A\u0011\u0002B,\u0011\u001d\u00119\u0007\u0001C\u0005\u0005SBqA!\u001d\u0001\t\u0013\u0011\u0019\bC\u0004\u0003r\u0001!IAa\u001e\t\u000f\t\u0015\u0005\u0001\"\u0003\u0003\b\"9!Q\u0013\u0001\u0005\n\t]\u0005b\u0002BT\u0001\u0011%!\u0011\u0016\u0005\b\u0005c\u0003A\u0011\u0002BZ\u0011\u001d\u0011Y\f\u0001C\u0005\u0005{CqAa1\u0001\t\u0013\u0011)\rC\u0004\u0003L\u0002!IA!4\t\u000f\tE\u0001\u0001\"\u0003\u0003P\"9!1\u001b\u0001\u0005\n\tU\u0007b\u0002Bx\u0001\u0011%!\u0011\u001f\u0005\b\u0005{\u0004A\u0011\u0002B\u0000\u0011\u001d\u0019\u0019\u0001\u0001C\u0005\u0007\u000b9qa!\u0003:\u0011\u0003\u0019YA\u0002\u00049s!\u00051Q\u0002\u0005\u0007WV\"\taa\u0004\t\u000f\rEQ\u0007\"\u0001\u0004\u0014\t1\u0002j\u001c;D_\u0012,'+\u001a9mC\u000e,\u0007K]8wS\u0012,'O\u0003\u0002;w\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002={\u0005aA-\u001a2vO\u0006$\u0017\r\u001d;fe*\u0011ahP\u0001\u0006g\u000e\fG.\u0019\u0006\u0003\u0001\u0006\u000bA!\u001a9gY*\t!)\u0001\u0002dQ\u000e\u00011c\u0001\u0001F\u001bB\u0011aiS\u0007\u0002\u000f*\u0011\u0001*S\u0001\u0005Y\u0006twMC\u0001K\u0003\u0011Q\u0017M^1\n\u00051;%AB(cU\u0016\u001cG\u000f\u0005\u0002O56\tqJ\u0003\u0002Q#\u00069\u0011\rZ1qi\u0016\u0014(B\u0001*T\u0003\u0011\u0019wN]3\u000b\u0005Q+\u0016!\u00023fEV<'B\u0001&W\u0015\t9\u0006,A\u0005nS\u000e\u0014xn]8gi*\t\u0011,A\u0002d_6L!aW(\u0003/%Cu\u000e^\"pI\u0016\u0014V\r\u001d7bG\u0016\u0004&o\u001c<jI\u0016\u0014\u0018\u0001\u00033fEV<w-Z3\u0011\u0005y{V\"A\u001e\n\u0005\u0001\\$\u0001\u0003#fEV<w-Z3\u0002\r1|wmZ3s!\tq6-\u0003\u0002ew\t1Aj\\4hKJ\f\u0001\u0002^3ti6{G-\u001a\t\u0003O&l\u0011\u0001\u001b\u0006\u0002}%\u0011!\u000e\u001b\u0002\b\u0005>|G.Z1o\u0003\u0019a\u0014N\\5u}Q!Qn\u001c9r!\tq\u0007!D\u0001:\u0011\u0015aF\u00011\u0001^\u0011\u0015\tG\u00011\u0001c\u0011\u0015)G\u00011\u0001g\u00031\u0019x.\u001e:dK2{wn[+q+\u0005!\bC\u00018v\u0013\t1\u0018H\u0001\u000bT_V\u00148-\u001a'p_.,\u0006\u000f\u0015:pm&$WM]\u0001\u0011g>,(oY3M_>\\W\u000b]0%KF$\"!\u001f?\u0011\u0005\u001dT\u0018BA>i\u0005\u0011)f.\u001b;\t\u000fu4\u0011\u0011!a\u0001i\u0006\u0019\u0001\u0010J\u0019\u0002\u001bM|WO]2f\u0019>|7.\u00169!\u0003I\u0019H/Y2l)J\f7-\u001a)s_ZLG-\u001a:\u0016\u0005\u0005\r\u0001c\u00018\u0002\u0006%\u0019\u0011qA\u001d\u0003%M#\u0018mY6Ue\u0006\u001cW\r\u0015:pm&$WM]\u0001\u0017gR\f7m\u001b+sC\u000e,\u0007K]8wS\u0012,'o\u0018\u0013fcR\u0019\u00110!\u0004\t\u0011uL\u0011\u0011!a\u0001\u0003\u0007\t1c\u001d;bG.$&/Y2f!J|g/\u001b3fe\u0002\nAb];cg\u000e\u0014\u0018\u000e\u001d;j_:,\"!!\u0006\u0011\t\u0005]\u0011QE\u0007\u0003\u00033QA!a\u0007\u0002\u001e\u0005YA-[:q_N\f'\r\\3t\u0015\u0011\ty\"!\t\u0002\u0013I,\u0017m\u0019;jm\u0016D(BAA\u0012\u0003\tIw.\u0003\u0003\u0002(\u0005e!A\u0003#jgB|7/\u00192mK\u0006\u00012/\u001e2tGJL\u0007\u000f^5p]~#S-\u001d\u000b\u0004s\u00065\u0002\u0002C?\r\u0003\u0003\u0005\r!!\u0006\u0002\u001bM,(m]2sSB$\u0018n\u001c8!\u0003\u001d\u0019wN\u001c;fqR,\"!!\u000e\u0011\u00079\u000b9$C\u0002\u0002:=\u0013A#\u0013#fEV<\u0017\tZ1qi\u0016\u00148i\u001c8uKb$\u0018aC2p]R,\u0007\u0010^0%KF$2!_A \u0011!ix\"!AA\u0002\u0005U\u0012\u0001C2p]R,\u0007\u0010\u001e\u0011\u0002'\r,(O]3oi\u0012+'-^4TKN\u001c\u0018n\u001c8\u0016\u0005\u0005\u001d\u0003\u0003BA%\u0003\u0017j\u0011!U\u0005\u0004\u0003\u001b\n&!D%EK\n,xmU3tg&|g.A\fdkJ\u0014XM\u001c;EK\n,xmU3tg&|gn\u0018\u0013fcR\u0019\u00110a\u0015\t\u0011u\u0014\u0012\u0011!a\u0001\u0003\u000f\nAcY;se\u0016tG\u000fR3ck\u001e\u001cVm]:j_:\u0004\u0013AE2mCN\u001cXm]!dGVlW\u000f\\1u_J,\"!a\u0017\u0011\r\u0005u\u00131NA8\u001b\t\tyF\u0003\u0003\u0002b\u0005\r\u0014AB1u_6L7M\u0003\u0003\u0002f\u0005\u001d\u0014AC2p]\u000e,(O]3oi*\u0019\u0011\u0011N%\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003[\nyFA\bBi>l\u0017n\u0019*fM\u0016\u0014XM\\2f!\u0019\t\t(a \u0002\u0006:!\u00111OA>!\r\t)\b[\u0007\u0003\u0003oR1!!\u001fD\u0003\u0019a$o\\8u}%\u0019\u0011Q\u00105\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t)a!\u0003\u0007M+GOC\u0002\u0002~!\u0004B!!\u001d\u0002\b&!\u0011\u0011RAB\u0005\u0019\u0019FO]5oO\u0006\u00192\r\\1tg\u0016\u001c\u0018iY2v[Vd\u0017\r^8sA\u0005qA\u000f\u001b:fC\u00124%/Y7f\u001b\u0006\u0004XCAAI!!\t\u0019*!(\u0002\"\u0006EVBAAK\u0015\u0011\t9*!'\u0002\u000f5,H/\u00192mK*\u0019\u00111\u00145\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002 \u0006U%aA'baB!\u00111UAW\u001b\t\t)K\u0003\u0003\u0002(\u0006%\u0016a\u00016eS*\u0019\u00111\u0016-\u0002\u0007M,h.\u0003\u0003\u00020\u0006\u0015&a\u0004+ie\u0016\fGMU3gKJ,gnY3\u0011\r\u0005M\u0016QXAb\u001d\u0011\t),!/\u000f\t\u0005U\u0014qW\u0005\u0002}%\u0019\u00111\u00185\u0002\u000fA\f7m[1hK&!\u0011qXAa\u0005\r\u0019V-\u001d\u0006\u0004\u0003wC\u0007\u0003BAR\u0003\u000bLA!a2\u0002&\nQ1\u000b^1dW\u001a\u0013\u0018-\\3\u0002\u001fQD'/Z1e\rJ\fW.Z'ba\u0002\nA\"\u001a<f]R\u001cVO\u00196fGR,\"!a4\u0011\r\u0005E\u0017q[An\u001b\t\t\u0019N\u0003\u0003\u0002V\u0006u\u0011\u0001C:vE*,7\r^:\n\t\u0005e\u00171\u001b\u0002\u000f!V\u0014G.[:i'V\u0014'.Z2u!\rq\u0015Q\\\u0005\u0004\u0003?|%a\u0005%pi\u000e{G-\u001a*fa2\f7-Z#wK:$\u0018!D3wK:$8+\u001e2kK\u000e$\b%\u0001\u0006j]&$\u0018.\u00197ju\u0016$R!_At\u0003SDq!!\r\u001b\u0001\u0004\t)\u0004C\u0004\u0002lj\u0001\r!!<\u0002\u000f=\u0004H/[8ogB9\u0011q^Ay\u0003\u000b+UBAA4\u0013\u0011\ty*a\u001a\u0002\u000b\rdwn]3\u0015\u0003e\f\u0001c\u001c8DY\u0006\u001c8OU3eK\u001aLg.\u001a3\u0015\u0007e\fY\u0010C\u0004\u0002~r\u0001\r!a@\u0002\u0011\r|gn];nKJ\u0004bA!\u0001\u0003\b\t-QB\u0001B\u0002\u0015\u0011\u0011)!a\u001a\u0002\u0011\u0019,hn\u0019;j_:LAA!\u0003\u0003\u0004\tA1i\u001c8tk6,'\u000f\u0005\u0004\u0002p\n5\u0011QQ\u0005\u0005\u0005\u001f\t9G\u0001\u0003MSN$\u0018a\u0004:fI\u00164\u0017N\\3DY\u0006\u001c8/Z:\u0015\u0005\tU\u0001C\u0002B\f\u00053\u0011Y!\u0004\u0002\u0002d%!!1DA2\u0005E\u0019u.\u001c9mKR\f'\r\\3GkR,(/Z\u0001\fS:LG/[1mSj,G-\u0006\u0002\u0003\"A)!1\u0005B\u0014s6\u0011!Q\u0005\u0006\u0004\u0003SB\u0017\u0002\u0002B\u0015\u0005K\u00111\u0001\u0016:z\u0003I\u0019\u0017M\u001c*fI\u00164\u0017N\\3DY\u0006\u001c8/Z:\u0002\u0019\r\fg\u000eU8q\rJ\fW.Z:\u0002\u0017\u001d,G/\u0012<f]RDUOY\u000b\u0003\u0005g\u0001bA!\u000e\u00038\u0005mWBAA\u000f\u0013\u0011\u0011I$!\b\u0003\u0015=\u00137/\u001a:wC\ndW-\u0001\u0007hKR,e/\u001a8u\u0011V\u0014\u0007%\u0001\u0007qk\nd\u0017n\u001d5Fm\u0016tG\u000fF\u0003z\u0005\u0003\u0012\u0019\u0006C\u0004\u0003D\r\u0002\rA!\u0012\u0002\u0007Q\u0004X\r\u0005\u0003\u0003H\t5cb\u0001(\u0003J%\u0019!1J(\u0002'!{GoQ8eKJ+\u0007\u000f\\1dK\u00163XM\u001c;\n\t\t=#\u0011\u000b\u0002\n\u000bZ,g\u000e\u001e+za\u0016T1Aa\u0013P\u0011\u001d\u0011)f\ta\u0001\u0003\u000b\u000bq!\\3tg\u0006<W\rF\u0004z\u00053\u0012YF!\u0018\t\u000f\t\rC\u00051\u0001\u0003F!9!Q\u000b\u0013A\u0002\u0005\u0015\u0005b\u0002B0I\u0001\u0007!\u0011M\u0001\u0005I\u0006$\u0018\rE\u0002h\u0005GJ1A!\u001ai\u0005\u0019\te.\u001f*fM\u0006\u0001Bm\u001c%pi\u000e{G-\u001a*fa2\f7-\u001a\u000b\u0005\u0005C\u0011Y\u0007C\u0004\u0003n\u0015\u0002\rAa\u001c\u0002!\rd\u0017m]:fgR{'+\u001a9mC\u000e,\u0007CBAZ\u0003{\u000b))A\u0006xCJtwJ\u001d+ie><HcA=\u0003v!9!Q\u000b\u0014A\u0002\u0005\u0015E#B=\u0003z\tm\u0004b\u0002B+O\u0001\u0007\u0011Q\u0011\u0005\b\u0005{:\u0003\u0019\u0001B@\u0003\u0005)\u0007\u0003BAZ\u0005\u0003KAAa!\u0002B\nIA\u000b\u001b:po\u0006\u0014G.Z\u0001\u0011CR$X-\u001c9u!>\u0004hI]1nKN$bA!#\u0003\u000e\nE\u0005C\u0002B\u0012\u0005O\u0011Y\t\u0005\u0004\u00024\u0006u\u0016\u0011\u0015\u0005\b\u0005\u001fC\u0003\u0019\u0001BF\u0003A\u0019Xo\u001d9f]\u0012,G\r\u00165sK\u0006$7\u000fC\u0004\u0003\u0014\"\u0002\rAa\u001c\u0002\u0015\rd\u0017m]:OC6,7/\u0001\thKR\feMZ3di\u0016$gI]1nKR1!\u0011\u0014BP\u0005G\u0003Ra\u001aBN\u0003\u0007L1A!(i\u0005\u0019y\u0005\u000f^5p]\"9!\u0011U\u0015A\u0002\u0005\u0005\u0016A\u0002;ie\u0016\fG\rC\u0004\u0003&&\u0002\rAa\u001c\u0002\u001dE,\u0018\r\\5gS\u0016$g*Y7fg\u0006\u00192m\u001c8uC&t7o\u00115b]\u001e,G\rV=qKR)aMa+\u00030\"9!Q\u0016\u0016A\u0002\u0005\r\u0017!\u00024sC6,\u0007b\u0002BSU\u0001\u0007!qN\u0001\u000fO\u0016$8\u000b^1dW\u001a\u0013\u0018-\\3t)\u0019\t\tL!.\u00038\"9!\u0011U\u0016A\u0002\u0005\u0005\u0006B\u0002B]W\u0001\u0007a-A\u0004sK\u001a\u0014Xm\u001d5\u0002'M,\b\u000f]8siN$%o\u001c9U_\u001a\u0013\u0018-\\3\u0015\u000b\u0019\u0014yL!1\t\u000f\t\u0005F\u00061\u0001\u0002\"\"9!Q\u0016\u0017A\u0002\u0005\r\u0017!\u00049paN#\u0018mY6Ge\u0006lW\r\u0006\u0004\u0003\"\t\u001d'\u0011\u001a\u0005\b\u0005Ck\u0003\u0019AAQ\u0011\u001d\u0011i+\fa\u0001\u0003\u0007\f1cZ3u'V\u001c\b/\u001a8eK\u0012$\u0006N]3bIN$\"A!#\u0015\t\t\u0005\"\u0011\u001b\u0005\b\u0005K{\u0003\u0019\u0001B8\u0003=9W\r\u001e+za\u0016\u001cHk\u001c\"zi\u0016\u001cH\u0003\u0002Bl\u0005[\u0004\u0002\"!\u001d\u0003Z\nm'\u0011]\u0005\u0005\u0003?\u000b\u0019\t\u0005\u0003\u0002$\nu\u0017\u0002\u0002Bp\u0003K\u0013QBU3gKJ,gnY3UsB,\u0007#B4\u0003d\n\u001d\u0018b\u0001BsQ\n)\u0011I\u001d:bsB\u0019qM!;\n\u0007\t-\bN\u0001\u0003CsR,\u0007b\u0002BSa\u0001\u0007!qN\u0001\u0012O\u0016$(\nZ5DY\u0006\u001c8OQ=OC6,G\u0003\u0002Bz\u0005s\u0004b!a%\u0003v\nm\u0017\u0002\u0002B|\u0003+\u0013aAQ;gM\u0016\u0014\bb\u0002B~c\u0001\u0007\u0011QQ\u0001\nG2\f7o\u001d(b[\u0016\fqcY8oi\u0006Lgn](cg>dW\r^3NKRDw\u000eZ:\u0015\u0007\u0019\u001c\t\u0001C\u0004\u0003\u0010J\u0002\rAa#\u0002\u001dM$X\r]%oi>$\u0006N]3bIR\u0019\u0011pa\u0002\t\u000f\t\u00056\u00071\u0001\u0002\"\u00061\u0002j\u001c;D_\u0012,'+\u001a9mC\u000e,\u0007K]8wS\u0012,'\u000f\u0005\u0002okM\u0019QG!\u0019\u0015\u0005\r-\u0011!B1qa2LHcB7\u0004\u0016\r]1\u0011\u0004\u0005\u00069^\u0002\r!\u0018\u0005\u0006C^\u0002\rA\u0019\u0005\u0006K^\u0002\rA\u001a")
public class HotCodeReplaceProvider
implements IHotCodeReplaceProvider {
    private final Debuggee debuggee;
    private final Logger logger;
    private final boolean testMode;
    private SourceLookUpProvider sourceLookUp;
    private StackTraceProvider stackTraceProvider;
    private Disposable subscription;
    private IDebugAdapterContext context;
    private IDebugSession currentDebugSession;
    private final AtomicReference<Set<String>> classesAccumulator;
    private final scala.collection.mutable.Map<ThreadReference, Seq<StackFrame>> threadFrameMap;
    private final PublishSubject<HotCodeReplaceEvent> eventSubject;
    private final Observable<HotCodeReplaceEvent> getEventHub;

    public static HotCodeReplaceProvider apply(Debuggee debuggee, Logger logger, boolean bl) {
        return HotCodeReplaceProvider$.MODULE$.apply(debuggee, logger, bl);
    }

    private SourceLookUpProvider sourceLookUp() {
        return this.sourceLookUp;
    }

    private void sourceLookUp_$eq(SourceLookUpProvider x$1) {
        this.sourceLookUp = x$1;
    }

    private StackTraceProvider stackTraceProvider() {
        return this.stackTraceProvider;
    }

    private void stackTraceProvider_$eq(StackTraceProvider x$1) {
        this.stackTraceProvider = x$1;
    }

    private Disposable subscription() {
        return this.subscription;
    }

    private void subscription_$eq(Disposable x$1) {
        this.subscription = x$1;
    }

    private IDebugAdapterContext context() {
        return this.context;
    }

    private void context_$eq(IDebugAdapterContext x$1) {
        this.context = x$1;
    }

    private IDebugSession currentDebugSession() {
        return this.currentDebugSession;
    }

    private void currentDebugSession_$eq(IDebugSession x$1) {
        this.currentDebugSession = x$1;
    }

    private AtomicReference<Set<String>> classesAccumulator() {
        return this.classesAccumulator;
    }

    private scala.collection.mutable.Map<ThreadReference, Seq<StackFrame>> threadFrameMap() {
        return this.threadFrameMap;
    }

    private PublishSubject<HotCodeReplaceEvent> eventSubject() {
        return this.eventSubject;
    }

    public void initialize(IDebugAdapterContext context, Map<String, Object> options) {
        this.context_$eq(context);
        this.currentDebugSession_$eq(context.getDebugSession());
        this.subscription_$eq(this.debuggee.classesToUpdate().subscribe(classes -> this.classesAccumulator().updateAndGet(x$1 -> (Set)x$1.$plus$plus((GenTraversableOnce)classes))));
        this.sourceLookUp_$eq((SourceLookUpProvider)context.getProvider(ISourceLookUpProvider.class));
        this.stackTraceProvider_$eq((StackTraceProvider)context.getProvider(IStackTraceProvider.class));
    }

    public void close() {
        if (this.subscription() != null) {
            this.subscription().dispose();
        }
        this.context_$eq(null);
        this.currentDebugSession_$eq(null);
        this.subscription_$eq(null);
    }

    public void onClassRedefined(Consumer<List<String>> consumer) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public CompletableFuture<List<String>> redefineClasses() {
        Try res = this.initialized().flatMap((Function1 & Serializable & scala.Serializable)_ -> this.canRedefineClasses().map((Function1 & Serializable & scala.Serializable)x$3 -> {
            Seq classesToReplace = ((SetLike)this.classesAccumulator().getAndUpdate(x$2 -> Predef$.MODULE$.Set().empty())).toSeq();
            return new Tuple2(x$3, (Object)classesToReplace);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> {
            Tuple2 tuple2 = x$4;
            if (tuple2 != null) {
                Seq classesToReplace = (Seq)tuple2._2();
                return (classesToReplace.isEmpty() ? new Success((Object)BoxedUnit.UNIT) : this.doHotCodeReplace((Seq<String>)classesToReplace)).map((Function1 & Serializable & scala.Serializable)_ -> {
                    this.sourceLookUp().reload((Seq<String>)classesToReplace);
                    this.stackTraceProvider().reload();
                    return (List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)classesToReplace.filter((Function1 & Serializable & scala.Serializable)className -> BoxesRunTime.boxToBoolean((boolean)this.isClassLoaded$1(className)))).toList()).asJava();
                });
            }
            throw new MatchError((Object)tuple2);
        }));
        return ScalaExtension$.MODULE$.TryExtension(res).toCompletableFuture();
    }

    private Try<BoxedUnit> initialized() {
        if (this.currentDebugSession() == null) {
            return new Failure((Throwable)new DebugException("HotCodeReplaceProvider not initialized"));
        }
        return new Success((Object)BoxedUnit.UNIT);
    }

    private Try<BoxedUnit> canRedefineClasses() {
        if (!this.currentDebugSession().getVM().canRedefineClasses()) {
            return new Failure((Throwable)new DebugException("JVM does not support hot reload classes"));
        }
        return new Success((Object)BoxedUnit.UNIT);
    }

    private Try<BoxedUnit> canPopFrames() {
        if (!this.currentDebugSession().getVM().canPopFrames()) {
            return new Failure((Throwable)new DebugException("JVM does not support popping frames"));
        }
        return new Success((Object)BoxedUnit.UNIT);
    }

    public Observable<HotCodeReplaceEvent> getEventHub() {
        return this.getEventHub;
    }

    public void ch$epfl$scala$debugadapter$internal$HotCodeReplaceProvider$$publishEvent(HotCodeReplaceEvent.EventType tpe, String message) {
        this.eventSubject().onNext((Object)new HotCodeReplaceEvent(tpe, message));
    }

    private void publishEvent(HotCodeReplaceEvent.EventType tpe, String message, Object data) {
        this.eventSubject().onNext((Object)new HotCodeReplaceEvent(tpe, message, data));
    }

    private Try<BoxedUnit> doHotCodeReplace(Seq<String> classesToReplace) {
        if (!this.currentDebugSession().getVM().canRedefineClasses()) {
            String err = "JVM doesn't support hot reload classes";
            this.ch$epfl$scala$debugadapter$internal$HotCodeReplaceProvider$$publishEvent(HotCodeReplaceEvent.EventType.ERROR, err);
            return new Failure((Throwable)new DebugException(err));
        }
        Try res = this.getSuspendedThreads().flatMap((Function1 & Serializable & scala.Serializable)suspendedThreads -> this.canPopFrames().transform((Function1 & Serializable & scala.Serializable)x$5 -> this.attemptPopFrames((Seq<ThreadReference>)suspendedThreads, classesToReplace), (Function1 & Serializable & scala.Serializable)e -> Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.warnOrThrow("Cannot pop frames")).map((Function1 & Serializable & scala.Serializable)x$6 -> (Seq)Nil$.MODULE$)).map((Function1 & Serializable & scala.Serializable)poppedThreads -> {
            this.ch$epfl$scala$debugadapter$internal$HotCodeReplaceProvider$$publishEvent(HotCodeReplaceEvent.EventType.STARTING, "Starting hot code replacement...");
            BoxedUnit x$7 = BoxedUnit.UNIT;
            Try<BoxedUnit> x$8 = this.redefineClasses(classesToReplace);
            return new Tuple3(poppedThreads, (Object)x$7, x$8);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$9 -> {
            Tuple3 tuple3 = x$9;
            if (tuple3 != null) {
                Success success;
                Seq poppedThreads = (Seq)tuple3._1();
                if (this.containsObsoleteMethods((Seq<ThreadReference>)suspendedThreads)) {
                    String err = "JVM contains obsolete methods";
                    this.ch$epfl$scala$debugadapter$internal$HotCodeReplaceProvider$$publishEvent(HotCodeReplaceEvent.EventType.ERROR, err);
                    success = new Failure((Throwable)new DebugException(new StringBuilder(37).append("Failed to complete hot code replace: ").append(err).toString()));
                } else {
                    poppedThreads.foreach((Function1 & Serializable & scala.Serializable)thread -> {
                        this.stepIntoThread(thread);
                        return BoxedUnit.UNIT;
                    });
                    success = new Success((Object)BoxedUnit.UNIT);
                }
                return success.map((Function1 & Serializable & scala.Serializable)res -> {
                    HotCodeReplaceProvider.$anonfun$doHotCodeReplace$9(res);
                    return BoxedUnit.UNIT;
                });
            }
            throw new MatchError((Object)tuple3);
        }));
        this.publishEvent(HotCodeReplaceEvent.EventType.END, "Completed hot code replace", CollectionConverters$.MODULE$.seqAsJavaListConverter(classesToReplace).asJava());
        this.threadFrameMap().clear();
        return res;
    }

    private void warnOrThrow(String message) {
        if (this.testMode) {
            throw new DebugException(message);
        }
        this.logger.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
    }

    public void ch$epfl$scala$debugadapter$internal$HotCodeReplaceProvider$$warnOrThrow(String message, Throwable e) {
        if (this.testMode) {
            throw e;
        }
        this.logger.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(14).append(message).append(" because of ").append(e.getClass().getSimpleName()).append(": ").append(e.getMessage()).toString());
    }

    private Try<Seq<ThreadReference>> attemptPopFrames(Seq<ThreadReference> suspendedThreads, Seq<String> classNames) {
        Seq poppedThreads = (Seq)suspendedThreads.flatMap((Function1 & Serializable & scala.Serializable)thread -> Option$.MODULE$.option2Iterable(this.getAffectedFrame((ThreadReference)thread, classNames).map((Function1 & Serializable & scala.Serializable)frame -> this.popStackFrame((ThreadReference)thread, (StackFrame)frame).map((Function1 & Serializable & scala.Serializable)x$10 -> thread))), Seq$.MODULE$.canBuildFrom());
        return ScalaExtension$.MODULE$.TrySeq(poppedThreads).traverse();
    }

    private Option<StackFrame> getAffectedFrame(ThreadReference thread, Seq<String> qualifiedNames) {
        Seq<StackFrame> frames = this.getStackFrames(thread, false);
        Option affectedFrame = ((IterableLike)frames.zipWithIndex(Seq$.MODULE$.canBuildFrom())).find((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)HotCodeReplaceProvider.$anonfun$getAffectedFrame$1(this, qualifiedNames, x0$1)));
        return affectedFrame.flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                StackFrame frame = (StackFrame)tuple2._1();
                int i = tuple2._2$mcI$sp();
                if (!this.supportsDropToFrame(thread, frame)) {
                    return ((IterableLike)RichInt$.MODULE$.to$extension1(Predef$.MODULE$.intWrapper(i), 0, -1).map((Function1 & Serializable & scala.Serializable)idx -> HotCodeReplaceProvider.$anonfun$getAffectedFrame$3(frames, BoxesRunTime.unboxToInt((Object)idx)), IndexedSeq$.MODULE$.canBuildFrom())).find((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)this.supportsDropToFrame(thread, x$11)));
                }
            }
            if (tuple2 != null) {
                StackFrame frame = (StackFrame)tuple2._1();
                return new Some((Object)frame);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private boolean containsChangedType(StackFrame frame, Seq<String> qualifiedNames) {
        String declaringTypeName = StackFrameUtility.getDeclaringType((StackFrame)frame).name();
        return qualifiedNames.exists((Function1 & Serializable & scala.Serializable)className -> BoxesRunTime.boxToBoolean((boolean)className.startsWith(declaringTypeName)));
    }

    private Seq<StackFrame> getStackFrames(ThreadReference thread, boolean refresh) {
        Object object;
        Option oldValue = this.threadFrameMap().get((Object)thread);
        try {
            object = oldValue.isEmpty() || refresh ? new Some((Object)((SeqLike)CollectionConverters$.MODULE$.asScalaBufferConverter(thread.frames()).asScala()).toSeq()) : oldValue;
        }
        catch (IncompatibleThreadStateException e) {
            this.logger.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Failed to get stack frames: ").append(e.getMessage()).toString());
            object = oldValue;
        }
        Some newValue = object;
        newValue.foreach((Function1 & Serializable & scala.Serializable)x$12 -> {
            HotCodeReplaceProvider.$anonfun$getStackFrames$2(this, thread, x$12);
            return BoxedUnit.UNIT;
        });
        return (Seq)newValue.getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
    }

    private boolean supportsDropToFrame(ThreadReference thread, StackFrame frame) {
        return ((IterableLike)this.getStackFrames(thread, false).takeWhile((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)HotCodeReplaceProvider.$anonfun$supportsDropToFrame$1(frame, x$13)))).forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)HotCodeReplaceProvider.$anonfun$supportsDropToFrame$2(x$1)));
    }

    private Try<BoxedUnit> popStackFrame(ThreadReference thread, StackFrame frame) {
        Try res = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ObjectRef frames = ObjectRef.create(this.getStackFrames(thread, false));
            int desiredSize = ((Seq)frames.elem).indexOf((Object)frame);
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), ((Seq)frames.elem).indexOf((Object)frame)).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$14 -> {
                StackFrameUtility.pop((StackFrame)((StackFrame)((Seq)frames$2.elem).head()));
                frames$2.elem = this.getStackFrames(thread, true);
            });
        });
        return res.recover((PartialFunction)new scala.Serializable(this, thread){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HotCodeReplaceProvider $outer;
            private final ThreadReference thread$4;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof DebugException) {
                    DebugException debugException = (DebugException)A1;
                    this.$outer.ch$epfl$scala$debugadapter$internal$HotCodeReplaceProvider$$warnOrThrow(new StringBuilder(20).append("Cannot pop frame of ").append(this.thread$4.name()).toString(), (Throwable)debugException);
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return throwable instanceof DebugException;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.thread$4 = thread$4;
            }
        });
    }

    private Try<Seq<ThreadReference>> getSuspendedThreads() {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Seq)((SeqLike)CollectionConverters$.MODULE$.asScalaBufferConverter(this.currentDebugSession().getVM().allThreads()).asScala()).toSeq().filter((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)x$15.isSuspended())));
    }

    private Try<BoxedUnit> redefineClasses(Seq<String> qualifiedNames) {
        Map typesToBytes = (Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(this.getTypesToBytes(qualifiedNames)).asJava();
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.currentDebugSession().getVM().redefineClasses(typesToBytes)).recoverWith((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HotCodeReplaceProvider $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof UnsupportedOperationException ? true : (A1 instanceof NoClassDefFoundError ? true : (A1 instanceof VerifyError ? true : (A1 instanceof ClassFormatError ? true : A1 instanceof ClassCircularityError)))) {
                    this.$outer.ch$epfl$scala$debugadapter$internal$HotCodeReplaceProvider$$publishEvent(HotCodeReplaceEvent.EventType.ERROR, A1.getMessage());
                    return (B1)new Failure((Throwable)new DebugException(new StringBuilder(28).append("Failed to redefine classes: ").append(A1.getMessage()).toString()));
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return throwable instanceof UnsupportedOperationException ? true : (throwable instanceof NoClassDefFoundError ? true : (throwable instanceof VerifyError ? true : (throwable instanceof ClassFormatError ? true : throwable instanceof ClassCircularityError)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    private scala.collection.immutable.Map<ReferenceType, byte[]> getTypesToBytes(Seq<String> qualifiedNames) {
        SourceLookUpProvider sourceLookUpProvider = this.sourceLookUp();
        if (sourceLookUpProvider == null) {
            throw new IllegalAccessException("Source lookup is not available");
        }
        return ((TraversableOnce)qualifiedNames.flatMap((Function1 & Serializable & scala.Serializable)className -> (Seq)((TraversableLike)Option$.MODULE$.option2Iterable(sourceLookUpProvider.getClassFile((String)className)).toSeq().map((Function1 & Serializable & scala.Serializable)classFile -> {
            byte[] bytes = classFile.readBytes();
            return new Tuple2(classFile, (Object)bytes);
        }, Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x$16 -> {
            Tuple2 tuple2 = x$16;
            if (tuple2 != null) {
                byte[] bytes = (byte[])tuple2._2();
                return (Buffer)this.getJdiClassByName((String)className).map((Function1 & Serializable & scala.Serializable)cls -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(cls), (Object)bytes), Buffer$.MODULE$.canBuildFrom());
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private Buffer<ReferenceType> getJdiClassByName(String className) {
        Buffer buffer;
        try {
            buffer = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(this.currentDebugSession().getVM().classesByName(className)).asScala();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.ch$epfl$scala$debugadapter$internal$HotCodeReplaceProvider$$warnOrThrow(new StringBuilder(24).append("Cannot get JDI class of ").append(className).toString(), e);
                buffer = (Buffer)Buffer$.MODULE$.empty();
            }
            throw throwable;
        }
        return buffer;
    }

    private boolean containsObsoleteMethods(Seq<ThreadReference> suspendedThreads) {
        return ((IterableLike)suspendedThreads.flatMap((Function1 & Serializable & scala.Serializable)x$17 -> this.getStackFrames((ThreadReference)x$17, true), Seq$.MODULE$.canBuildFrom())).exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)HotCodeReplaceProvider.$anonfun$containsObsoleteMethods$2(x$1)));
    }

    private void stepIntoThread(ThreadReference thread) {
        EventRequestManager eventRequestManager = this.currentDebugSession().getVM().eventRequestManager();
        StepRequest request = DebugUtility.createStepIntoRequest((ThreadReference)thread, (String[])this.context().getStepFilters().skipClasses);
        this.currentDebugSession().getEventHub().stepEvents().filter(debugEvent -> {
            StepRequest stepRequest = request;
            EventRequest eventRequest = debugEvent.event.request();
            return !(stepRequest != null ? !stepRequest.equals(eventRequest) : eventRequest != null);
        }).take(1L).subscribe(debugEvent -> {
            debugEvent.shouldResume = false;
            DebugUtility.deleteEventRequestSafely((EventRequestManager)eventRequestManager, (EventRequest)request);
            this.context().getProtocolServer().sendEvent((Events.DebugEvent)new Events.StoppedEvent("step", thread.uniqueID()));
        });
        request.enable();
        thread.resume();
    }

    private final boolean isClassLoaded$1(String className) {
        return this.getJdiClassByName(className).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$doHotCodeReplace$9(BoxedUnit res) {
    }

    public static final /* synthetic */ boolean $anonfun$getAffectedFrame$1(HotCodeReplaceProvider $this, Seq qualifiedNames$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            StackFrame frame = (StackFrame)tuple2._1();
            return $this.containsChangedType(frame, (Seq<String>)qualifiedNames$1);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ StackFrame $anonfun$getAffectedFrame$3(Seq frames$1, int idx) {
        return (StackFrame)frames$1.apply(idx);
    }

    public static final /* synthetic */ void $anonfun$getStackFrames$2(HotCodeReplaceProvider $this, ThreadReference thread$3, Seq x$12) {
        $this.threadFrameMap().update((Object)thread$3, (Object)x$12);
    }

    public static final /* synthetic */ boolean $anonfun$supportsDropToFrame$1(StackFrame frame$1, StackFrame x$13) {
        StackFrame stackFrame = x$13;
        StackFrame stackFrame2 = frame$1;
        return stackFrame == null ? stackFrame2 != null : !stackFrame.equals(stackFrame2);
    }

    public static final /* synthetic */ boolean $anonfun$supportsDropToFrame$2(StackFrame x$1) {
        return StackFrameUtility.isNative((StackFrame)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$containsObsoleteMethods$2(StackFrame x$1) {
        return StackFrameUtility.isObsolete((StackFrame)x$1);
    }

    public HotCodeReplaceProvider(Debuggee debuggee, Logger logger, boolean testMode) {
        this.debuggee = debuggee;
        this.logger = logger;
        this.testMode = testMode;
        this.sourceLookUp = null;
        this.stackTraceProvider = null;
        this.subscription = null;
        this.context = null;
        this.currentDebugSession = null;
        this.classesAccumulator = new AtomicReference<Set>(Predef$.MODULE$.Set().empty());
        this.threadFrameMap = Map$.MODULE$.empty();
        this.eventSubject = PublishSubject.create();
        this.getEventHub = this.eventSubject();
    }
}

