/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.scala.debugadapter.internal;

import ch.epfl.scala.debugadapter.Debuggee;
import ch.epfl.scala.debugadapter.Logger;
import ch.epfl.scala.debugadapter.internal.HotCodeReplaceProvider$;
import ch.epfl.scala.debugadapter.internal.ScalaExtension$;
import ch.epfl.scala.debugadapter.internal.SourceLookUpProvider;
import ch.epfl.scala.debugadapter.internal.StackTraceProvider;
import com.microsoft.java.debug.core.DebugException;
import com.microsoft.java.debug.core.DebugUtility;
import com.microsoft.java.debug.core.IDebugSession;
import com.microsoft.java.debug.core.StackFrameUtility;
import com.microsoft.java.debug.core.adapter.HotCodeReplaceEvent;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IHotCodeReplaceProvider;
import com.microsoft.java.debug.core.adapter.ISourceLookUpProvider;
import com.microsoft.java.debug.core.adapter.IStackTraceProvider;
import com.microsoft.java.debug.core.protocol.Events;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.StepRequest;
import io.reactivex.Observable;
import io.reactivex.subjects.PublishSubject;
import java.io.Closeable;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\rea\u0001\u0002\u001d:\u0001\u0011C\u0001\u0002\u0018\u0001\u0003\u0002\u0003\u0006I!\u0018\u0005\tC\u0002\u0011\t\u0011)A\u0005E\"AQ\r\u0001B\u0001B\u0003%a\rC\u0003l\u0001\u0011\u0005A\u000eC\u0004s\u0001\u0001\u0007I\u0011B:\t\u000f]\u0004\u0001\u0019!C\u0005q\"1a\u0010\u0001Q!\nQD\u0001b \u0001A\u0002\u0013%\u0011\u0011\u0001\u0005\n\u0003\u0013\u0001\u0001\u0019!C\u0005\u0003\u0017A\u0001\"a\u0004\u0001A\u0003&\u00111\u0001\u0005\n\u0003#\u0001\u0001\u0019!C\u0005\u0003'A\u0011\"!\t\u0001\u0001\u0004%I!a\t\t\u0011\u0005\u001d\u0002\u0001)Q\u0005\u0003+A\u0011\"!\u000b\u0001\u0001\u0004%I!a\u000b\t\u0013\u0005M\u0002\u00011A\u0005\n\u0005U\u0002\u0002CA\u001d\u0001\u0001\u0006K!!\f\t\u0013\u0005m\u0002\u00011A\u0005\n\u0005u\u0002\"CA$\u0001\u0001\u0007I\u0011BA%\u0011!\ti\u0005\u0001Q!\n\u0005}\u0002\"CA(\u0001\t\u0007I\u0011BA)\u0011!\t\u0019\t\u0001Q\u0001\n\u0005M\u0003\"CAC\u0001\t\u0007I\u0011BAD\u0011!\t\t\r\u0001Q\u0001\n\u0005%\u0005\"CAb\u0001\t\u0007I\u0011BAc\u0011!\ty\u000e\u0001Q\u0001\n\u0005\u001d\u0007bBAq\u0001\u0011\u0005\u00131\u001d\u0005\b\u0003c\u0004A\u0011IAz\u0011\u001d\t)\u0010\u0001C!\u0003oDqAa\u0004\u0001\t\u0003\u0012\t\u0002C\u0004\u0003\u001c\u0001!IA!\b\t\u000f\t%\u0002\u0001\"\u0003\u0003\u001e!9!1\u0006\u0001\u0005\n\tu\u0001\"\u0003B\u0017\u0001\t\u0007I\u0011\tB\u0018\u0011!\u0011I\u0004\u0001Q\u0001\n\tE\u0002b\u0002B\u001e\u0001\u0011%!Q\b\u0005\b\u0005w\u0001A\u0011\u0002B+\u0011\u001d\u0011)\u0007\u0001C\u0005\u0005OBqAa\u001c\u0001\t\u0013\u0011\t\bC\u0004\u0003p\u0001!IA!\u001e\t\u000f\t\r\u0005\u0001\"\u0003\u0003\u0006\"9!1\u0013\u0001\u0005\n\tU\u0005b\u0002BS\u0001\u0011%!q\u0015\u0005\b\u0005_\u0003A\u0011\u0002BY\u0011\u001d\u0011I\f\u0001C\u0005\u0005wCqA!1\u0001\t\u0013\u0011\u0019\rC\u0004\u0003J\u0002!IAa3\t\u000f\t=\u0001\u0001\"\u0003\u0003N\"9!\u0011\u001b\u0001\u0005\n\tM\u0007b\u0002Bw\u0001\u0011%!q\u001e\u0005\b\u0005w\u0004A\u0011\u0002B\u007f\u0011\u001d\u0019\t\u0001\u0001C\u0005\u0007\u00079qaa\u0002:\u0011\u0003\u0019IA\u0002\u00049s!\u000511\u0002\u0005\u0007WV\"\ta!\u0004\t\u000f\r=Q\u0007\"\u0001\u0004\u0012\t1\u0002j\u001c;D_\u0012,'+\u001a9mC\u000e,\u0007K]8wS\u0012,'O\u0003\u0002;w\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002={\u0005aA-\u001a2vO\u0006$\u0017\r\u001d;fe*\u0011ahP\u0001\u0006g\u000e\fG.\u0019\u0006\u0003\u0001\u0006\u000bA!\u001a9gY*\t!)\u0001\u0002dQ\u000e\u00011c\u0001\u0001F\u001bB\u0011aiS\u0007\u0002\u000f*\u0011\u0001*S\u0001\u0005Y\u0006twMC\u0001K\u0003\u0011Q\u0017M^1\n\u00051;%AB(cU\u0016\u001cG\u000f\u0005\u0002O56\tqJ\u0003\u0002Q#\u00069\u0011\rZ1qi\u0016\u0014(B\u0001*T\u0003\u0011\u0019wN]3\u000b\u0005Q+\u0016!\u00023fEV<'B\u0001&W\u0015\t9\u0006,A\u0005nS\u000e\u0014xn]8gi*\t\u0011,A\u0002d_6L!aW(\u0003/%Cu\u000e^\"pI\u0016\u0014V\r\u001d7bG\u0016\u0004&o\u001c<jI\u0016\u0014\u0018\u0001\u00033fEV<w-Z3\u0011\u0005y{V\"A\u001e\n\u0005\u0001\\$\u0001\u0003#fEV<w-Z3\u0002\r1|wmZ3s!\tq6-\u0003\u0002ew\t1Aj\\4hKJ\f\u0001\u0002^3ti6{G-\u001a\t\u0003O&l\u0011\u0001\u001b\u0006\u0002}%\u0011!\u000e\u001b\u0002\b\u0005>|G.Z1o\u0003\u0019a\u0014N\\5u}Q!Qn\u001c9r!\tq\u0007!D\u0001:\u0011\u0015aF\u00011\u0001^\u0011\u0015\tG\u00011\u0001c\u0011\u0015)G\u00011\u0001g\u00031\u0019x.\u001e:dK2{wn[+q+\u0005!\bC\u00018v\u0013\t1\u0018H\u0001\u000bT_V\u00148-\u001a'p_.,\u0006\u000f\u0015:pm&$WM]\u0001\u0011g>,(oY3M_>\\W\u000b]0%KF$\"!\u001f?\u0011\u0005\u001dT\u0018BA>i\u0005\u0011)f.\u001b;\t\u000fu4\u0011\u0011!a\u0001i\u0006\u0019\u0001\u0010J\u0019\u0002\u001bM|WO]2f\u0019>|7.\u00169!\u0003I\u0019H/Y2l)J\f7-\u001a)s_ZLG-\u001a:\u0016\u0005\u0005\r\u0001c\u00018\u0002\u0006%\u0019\u0011qA\u001d\u0003%M#\u0018mY6Ue\u0006\u001cW\r\u0015:pm&$WM]\u0001\u0017gR\f7m\u001b+sC\u000e,\u0007K]8wS\u0012,'o\u0018\u0013fcR\u0019\u00110!\u0004\t\u0011uL\u0011\u0011!a\u0001\u0003\u0007\t1c\u001d;bG.$&/Y2f!J|g/\u001b3fe\u0002\nAb];cg\u000e\u0014\u0018\u000e\u001d;j_:,\"!!\u0006\u0011\t\u0005]\u0011QD\u0007\u0003\u00033Q1!a\u0007J\u0003\tIw.\u0003\u0003\u0002 \u0005e!!C\"m_N,\u0017M\u00197f\u0003A\u0019XOY:de&\u0004H/[8o?\u0012*\u0017\u000fF\u0002z\u0003KA\u0001\" \u0007\u0002\u0002\u0003\u0007\u0011QC\u0001\u000egV\u00147o\u0019:jaRLwN\u001c\u0011\u0002\u000f\r|g\u000e^3yiV\u0011\u0011Q\u0006\t\u0004\u001d\u0006=\u0012bAA\u0019\u001f\n!\u0012\nR3ck\u001e\fE-\u00199uKJ\u001cuN\u001c;fqR\f1bY8oi\u0016DHo\u0018\u0013fcR\u0019\u00110a\u000e\t\u0011u|\u0011\u0011!a\u0001\u0003[\t\u0001bY8oi\u0016DH\u000fI\u0001\u0014GV\u0014(/\u001a8u\t\u0016\u0014WoZ*fgNLwN\\\u000b\u0003\u0003\u007f\u0001B!!\u0011\u0002D5\t\u0011+C\u0002\u0002FE\u0013Q\"\u0013#fEV<7+Z:tS>t\u0017aF2veJ,g\u000e\u001e#fEV<7+Z:tS>tw\fJ3r)\rI\u00181\n\u0005\t{J\t\t\u00111\u0001\u0002@\u0005!2-\u001e:sK:$H)\u001a2vON+7o]5p]\u0002\n!c\u00197bgN,7/Q2dk6,H.\u0019;peV\u0011\u00111\u000b\t\u0007\u0003+\n\u0019'a\u001a\u000e\u0005\u0005]#\u0002BA-\u00037\na!\u0019;p[&\u001c'\u0002BA/\u0003?\n!bY8oGV\u0014(/\u001a8u\u0015\r\t\t'S\u0001\u0005kRLG.\u0003\u0003\u0002f\u0005]#aD!u_6L7MU3gKJ,gnY3\u0011\r\u0005%\u0014qOA?\u001d\u0011\tY'a\u001d\u0011\u0007\u00055\u0004.\u0004\u0002\u0002p)\u0019\u0011\u0011O\"\u0002\rq\u0012xn\u001c;?\u0013\r\t)\b[\u0001\u0007!J,G-\u001a4\n\t\u0005e\u00141\u0010\u0002\u0004'\u0016$(bAA;QB!\u0011\u0011NA@\u0013\u0011\t\t)a\u001f\u0003\rM#(/\u001b8h\u0003M\u0019G.Y:tKN\f5mY;nk2\fGo\u001c:!\u00039!\bN]3bI\u001a\u0013\u0018-\\3NCB,\"!!#\u0011\u0011\u0005-\u0015QSAM\u0003Sk!!!$\u000b\t\u0005=\u0015\u0011S\u0001\b[V$\u0018M\u00197f\u0015\r\t\u0019\n[\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAL\u0003\u001b\u00131!T1q!\u0011\tY*!*\u000e\u0005\u0005u%\u0002BAP\u0003C\u000b1A\u001b3j\u0015\r\t\u0019\u000bW\u0001\u0004gVt\u0017\u0002BAT\u0003;\u0013q\u0002\u00165sK\u0006$'+\u001a4fe\u0016t7-\u001a\t\u0007\u0003W\u000b),a/\u000f\t\u00055\u0016\u0011\u0017\b\u0005\u0003[\ny+C\u0001?\u0013\r\t\u0019\f[\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t9,!/\u0003\u0007M+\u0017OC\u0002\u00024\"\u0004B!a'\u0002>&!\u0011qXAO\u0005)\u0019F/Y2l\rJ\fW.Z\u0001\u0010i\"\u0014X-\u00193Ge\u0006lW-T1qA\u0005aQM^3oiN+(M[3diV\u0011\u0011q\u0019\t\u0007\u0003\u0013\f).!7\u000e\u0005\u0005-'\u0002BAg\u0003\u001f\f\u0001b];cU\u0016\u001cGo\u001d\u0006\u0005\u0003#\f\u0019.A\u0005sK\u0006\u001cG/\u001b<fq*\u0011\u00111D\u0005\u0005\u0003/\fYM\u0001\bQk\nd\u0017n\u001d5Tk\nTWm\u0019;\u0011\u00079\u000bY.C\u0002\u0002^>\u00131\u0003S8u\u0007>$WMU3qY\u0006\u001cW-\u0012<f]R\fQ\"\u001a<f]R\u001cVO\u00196fGR\u0004\u0013AC5oSRL\u0017\r\\5{KR)\u00110!:\u0002h\"9\u0011\u0011\u0006\u000eA\u0002\u00055\u0002bBAu5\u0001\u0007\u00111^\u0001\b_B$\u0018n\u001c8t!\u001d\ti/a<\u0002~\u0015k!!a\u0018\n\t\u0005]\u0015qL\u0001\u0006G2|7/\u001a\u000b\u0002s\u0006\u0001rN\\\"mCN\u001c(+\u001a3fM&tW\r\u001a\u000b\u0004s\u0006e\bbBA~9\u0001\u0007\u0011Q`\u0001\tG>t7/^7feB1\u0011q B\u0003\u0005\u0013i!A!\u0001\u000b\t\t\r\u0011qL\u0001\tMVt7\r^5p]&!!q\u0001B\u0001\u0005!\u0019uN\\:v[\u0016\u0014\bCBAw\u0005\u0017\ti(\u0003\u0003\u0003\u000e\u0005}#\u0001\u0002'jgR\fqB]3eK\u001aLg.Z\"mCN\u001cXm\u001d\u000b\u0003\u0005'\u0001bA!\u0006\u0003\u0018\t%QBAA.\u0013\u0011\u0011I\"a\u0017\u0003#\r{W\u000e\u001d7fi\u0006\u0014G.\u001a$viV\u0014X-A\u0006j]&$\u0018.\u00197ju\u0016$WC\u0001B\u0010!\u0015\u0011\tC!\nz\u001b\t\u0011\u0019CC\u0002\u0002b!LAAa\n\u0003$\t\u0019AK]=\u0002%\r\fgNU3eK\u001aLg.Z\"mCN\u001cXm]\u0001\rG\u0006t\u0007k\u001c9Ge\u0006lWm]\u0001\fO\u0016$XI^3oi\"+(-\u0006\u0002\u00032A1!1\u0007B\u001b\u00033l!!a4\n\t\t]\u0012q\u001a\u0002\u000b\u001f\n\u001cXM\u001d<bE2,\u0017\u0001D4fi\u00163XM\u001c;Ik\n\u0004\u0013\u0001\u00049vE2L7\u000f[#wK:$H#B=\u0003@\tE\u0003b\u0002B!G\u0001\u0007!1I\u0001\u0004iB,\u0007\u0003\u0002B#\u0005\u0017r1A\u0014B$\u0013\r\u0011IeT\u0001\u0014\u0011>$8i\u001c3f%\u0016\u0004H.Y2f\u000bZ,g\u000e^\u0005\u0005\u0005\u001b\u0012yEA\u0005Fm\u0016tG\u000fV=qK*\u0019!\u0011J(\t\u000f\tM3\u00051\u0001\u0002~\u00059Q.Z:tC\u001e,GcB=\u0003X\te#1\f\u0005\b\u0005\u0003\"\u0003\u0019\u0001B\"\u0011\u001d\u0011\u0019\u0006\na\u0001\u0003{BqA!\u0018%\u0001\u0004\u0011y&\u0001\u0003eCR\f\u0007cA4\u0003b%\u0019!1\r5\u0003\r\u0005s\u0017PU3g\u0003A!w\u000eS8u\u0007>$WMU3qY\u0006\u001cW\r\u0006\u0003\u0003 \t%\u0004b\u0002B6K\u0001\u0007!QN\u0001\u0011G2\f7o]3t)>\u0014V\r\u001d7bG\u0016\u0004b!a+\u00026\u0006u\u0014aC<be:|%\u000f\u00165s_^$2!\u001fB:\u0011\u001d\u0011\u0019F\na\u0001\u0003{\"R!\u001fB<\u0005sBqAa\u0015(\u0001\u0004\ti\bC\u0004\u0003|\u001d\u0002\rA! \u0002\u0003\u0015\u0004B!a+\u0003\u0000%!!\u0011QA]\u0005%!\u0006N]8xC\ndW-\u0001\tbiR,W\u000e\u001d;Q_B4%/Y7fgR1!q\u0011BF\u0005\u001f\u0003bA!\t\u0003&\t%\u0005CBAV\u0003k\u000bI\nC\u0004\u0003\u000e\"\u0002\rA!#\u0002!M,8\u000f]3oI\u0016$G\u000b\u001b:fC\u0012\u001c\bb\u0002BIQ\u0001\u0007!QN\u0001\u000bG2\f7o\u001d(b[\u0016\u001c\u0018\u0001E4fi\u00063g-Z2uK\u00124%/Y7f)\u0019\u00119J!(\u0003\"B)qM!'\u0002<&\u0019!1\u00145\u0003\r=\u0003H/[8o\u0011\u001d\u0011y*\u000ba\u0001\u00033\u000ba\u0001\u001e5sK\u0006$\u0007b\u0002BRS\u0001\u0007!QN\u0001\u000fcV\fG.\u001b4jK\u0012t\u0015-\\3t\u0003M\u0019wN\u001c;bS:\u001c8\t[1oO\u0016$G+\u001f9f)\u00151'\u0011\u0016BW\u0011\u001d\u0011YK\u000ba\u0001\u0003w\u000bQA\u001a:b[\u0016DqAa)+\u0001\u0004\u0011i'\u0001\bhKR\u001cF/Y2l\rJ\fW.Z:\u0015\r\u0005%&1\u0017B[\u0011\u001d\u0011yj\u000ba\u0001\u00033CaAa.,\u0001\u00041\u0017a\u0002:fMJ,7\u000f[\u0001\u0014gV\u0004\bo\u001c:ug\u0012\u0013x\u000e\u001d+p\rJ\fW.\u001a\u000b\u0006M\nu&q\u0018\u0005\b\u0005?c\u0003\u0019AAM\u0011\u001d\u0011Y\u000b\fa\u0001\u0003w\u000bQ\u0002]8q'R\f7m\u001b$sC6,GC\u0002B\u0010\u0005\u000b\u00149\rC\u0004\u0003 6\u0002\r!!'\t\u000f\t-V\u00061\u0001\u0002<\u0006\u0019r-\u001a;TkN\u0004XM\u001c3fIRC'/Z1egR\u0011!q\u0011\u000b\u0005\u0005?\u0011y\rC\u0004\u0003$>\u0002\rA!\u001c\u0002\u001f\u001d,G\u000fV=qKN$vNQ=uKN$BA!6\u0003lBA\u0011\u0011\u000eBl\u00053\u0014y.\u0003\u0003\u0002\u0018\u0006m\u0004\u0003BAN\u00057LAA!8\u0002\u001e\ni!+\u001a4fe\u0016t7-\u001a+za\u0016\u0004Ra\u001aBq\u0005KL1Aa9i\u0005\u0015\t%O]1z!\r9'q]\u0005\u0004\u0005SD'\u0001\u0002\"zi\u0016DqAa)1\u0001\u0004\u0011i'A\thKRTE-[\"mCN\u001c()\u001f(b[\u0016$BA!=\u0003xB1\u00111\u0012Bz\u00053LAA!>\u0002\u000e\n1!)\u001e4gKJDqA!?2\u0001\u0004\ti(A\u0005dY\u0006\u001c8OT1nK\u000692m\u001c8uC&t7o\u00142t_2,G/Z'fi\"|Gm\u001d\u000b\u0004M\n}\bb\u0002BGe\u0001\u0007!\u0011R\u0001\u000fgR,\u0007/\u00138u_RC'/Z1e)\rI8Q\u0001\u0005\b\u0005?\u001b\u0004\u0019AAM\u0003YAu\u000e^\"pI\u0016\u0014V\r\u001d7bG\u0016\u0004&o\u001c<jI\u0016\u0014\bC\u000186'\r)$q\f\u000b\u0003\u0007\u0013\tQ!\u00199qYf$r!\\B\n\u0007+\u00199\u0002C\u0003]o\u0001\u0007Q\fC\u0003bo\u0001\u0007!\rC\u0003fo\u0001\u0007a\r")
public class HotCodeReplaceProvider
implements IHotCodeReplaceProvider {
    private final Debuggee debuggee;
    private final Logger logger;
    private final boolean testMode;
    private SourceLookUpProvider sourceLookUp;
    private StackTraceProvider stackTraceProvider;
    private Closeable subscription;
    private IDebugAdapterContext context;
    private IDebugSession currentDebugSession;
    private final AtomicReference<Set<String>> classesAccumulator;
    private final scala.collection.mutable.Map<ThreadReference, Seq<StackFrame>> threadFrameMap;
    private final PublishSubject<HotCodeReplaceEvent> eventSubject;
    private final Observable<HotCodeReplaceEvent> getEventHub;

    public static HotCodeReplaceProvider apply(Debuggee debuggee, Logger logger, boolean bl) {
        return HotCodeReplaceProvider$.MODULE$.apply(debuggee, logger, bl);
    }

    private SourceLookUpProvider sourceLookUp() {
        return this.sourceLookUp;
    }

    private void sourceLookUp_$eq(SourceLookUpProvider x$1) {
        this.sourceLookUp = x$1;
    }

    private StackTraceProvider stackTraceProvider() {
        return this.stackTraceProvider;
    }

    private void stackTraceProvider_$eq(StackTraceProvider x$1) {
        this.stackTraceProvider = x$1;
    }

    private Closeable subscription() {
        return this.subscription;
    }

    private void subscription_$eq(Closeable x$1) {
        this.subscription = x$1;
    }

    private IDebugAdapterContext context() {
        return this.context;
    }

    private void context_$eq(IDebugAdapterContext x$1) {
        this.context = x$1;
    }

    private IDebugSession currentDebugSession() {
        return this.currentDebugSession;
    }

    private void currentDebugSession_$eq(IDebugSession x$1) {
        this.currentDebugSession = x$1;
    }

    private AtomicReference<Set<String>> classesAccumulator() {
        return this.classesAccumulator;
    }

    private scala.collection.mutable.Map<ThreadReference, Seq<StackFrame>> threadFrameMap() {
        return this.threadFrameMap;
    }

    private PublishSubject<HotCodeReplaceEvent> eventSubject() {
        return this.eventSubject;
    }

    public void initialize(IDebugAdapterContext context, Map<String, Object> options) {
        this.context_$eq(context);
        this.currentDebugSession_$eq(context.getDebugSession());
        this.subscription_$eq(this.debuggee.observeClassUpdates((Function1<Seq<String>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)classes -> {
            HotCodeReplaceProvider.$anonfun$initialize$1(this, classes);
            return BoxedUnit.UNIT;
        }));
        this.sourceLookUp_$eq((SourceLookUpProvider)context.getProvider(ISourceLookUpProvider.class));
        this.stackTraceProvider_$eq((StackTraceProvider)context.getProvider(IStackTraceProvider.class));
    }

    public void close() {
        if (this.subscription() != null) {
            this.subscription().close();
        }
        this.context_$eq(null);
        this.currentDebugSession_$eq(null);
        this.subscription_$eq(null);
    }

    public void onClassRedefined(Consumer<List<String>> consumer) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public CompletableFuture<List<String>> redefineClasses() {
        Try res = this.initialized().flatMap((Function1 & Serializable & scala.Serializable)_ -> this.canRedefineClasses().map((Function1 & Serializable & scala.Serializable)x$3 -> {
            Seq classesToReplace = ((SetLike)this.classesAccumulator().getAndUpdate(x$2 -> Predef$.MODULE$.Set().empty())).toSeq();
            return new Tuple2(x$3, (Object)classesToReplace);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> {
            Tuple2 tuple2 = x$4;
            if (tuple2 != null) {
                Seq classesToReplace = (Seq)tuple2._2();
                return (classesToReplace.isEmpty() ? new Success((Object)BoxedUnit.UNIT) : this.doHotCodeReplace((Seq<String>)classesToReplace)).map((Function1 & Serializable & scala.Serializable)_ -> {
                    this.sourceLookUp().reload((Seq<String>)classesToReplace);
                    this.stackTraceProvider().reload();
                    return (List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)classesToReplace.filter((Function1 & Serializable & scala.Serializable)className -> BoxesRunTime.boxToBoolean((boolean)this.isClassLoaded$1(className)))).toList()).asJava();
                });
            }
            throw new MatchError((Object)tuple2);
        }));
        return ScalaExtension$.MODULE$.TryExtension(res).toCompletableFuture();
    }

    private Try<BoxedUnit> initialized() {
        if (this.currentDebugSession() == null) {
            return new Failure((Throwable)new DebugException("HotCodeReplaceProvider not initialized"));
        }
        return new Success((Object)BoxedUnit.UNIT);
    }

    private Try<BoxedUnit> canRedefineClasses() {
        if (!this.currentDebugSession().getVM().canRedefineClasses()) {
            return new Failure((Throwable)new DebugException("JVM does not support hot reload classes"));
        }
        return new Success((Object)BoxedUnit.UNIT);
    }

    private Try<BoxedUnit> canPopFrames() {
        if (!this.currentDebugSession().getVM().canPopFrames()) {
            return new Failure((Throwable)new DebugException("JVM does not support popping frames"));
        }
        return new Success((Object)BoxedUnit.UNIT);
    }

    public Observable<HotCodeReplaceEvent> getEventHub() {
        return this.getEventHub;
    }

    public void ch$epfl$scala$debugadapter$internal$HotCodeReplaceProvider$$publishEvent(HotCodeReplaceEvent.EventType tpe, String message) {
        this.eventSubject().onNext((Object)new HotCodeReplaceEvent(tpe, message));
    }

    private void publishEvent(HotCodeReplaceEvent.EventType tpe, String message, Object data) {
        this.eventSubject().onNext((Object)new HotCodeReplaceEvent(tpe, message, data));
    }

    private Try<BoxedUnit> doHotCodeReplace(Seq<String> classesToReplace) {
        if (!this.currentDebugSession().getVM().canRedefineClasses()) {
            String err = "JVM doesn't support hot reload classes";
            this.ch$epfl$scala$debugadapter$internal$HotCodeReplaceProvider$$publishEvent(HotCodeReplaceEvent.EventType.ERROR, err);
            return new Failure((Throwable)new DebugException(err));
        }
        Try res = this.getSuspendedThreads().flatMap((Function1 & Serializable & scala.Serializable)suspendedThreads -> this.canPopFrames().transform((Function1 & Serializable & scala.Serializable)x$5 -> this.attemptPopFrames((Seq<ThreadReference>)suspendedThreads, classesToReplace), (Function1 & Serializable & scala.Serializable)e -> Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.warnOrThrow("Cannot pop frames")).map((Function1 & Serializable & scala.Serializable)x$6 -> (Seq)Nil$.MODULE$)).map((Function1 & Serializable & scala.Serializable)poppedThreads -> {
            this.ch$epfl$scala$debugadapter$internal$HotCodeReplaceProvider$$publishEvent(HotCodeReplaceEvent.EventType.STARTING, "Starting hot code replacement...");
            BoxedUnit x$7 = BoxedUnit.UNIT;
            Try<BoxedUnit> x$8 = this.redefineClasses(classesToReplace);
            return new Tuple3(poppedThreads, (Object)x$7, x$8);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$9 -> {
            Tuple3 tuple3 = x$9;
            if (tuple3 != null) {
                Success success;
                Seq poppedThreads = (Seq)tuple3._1();
                if (this.containsObsoleteMethods((Seq<ThreadReference>)suspendedThreads)) {
                    String err = "JVM contains obsolete methods";
                    this.ch$epfl$scala$debugadapter$internal$HotCodeReplaceProvider$$publishEvent(HotCodeReplaceEvent.EventType.ERROR, err);
                    success = new Failure((Throwable)new DebugException(new StringBuilder(37).append("Failed to complete hot code replace: ").append(err).toString()));
                } else {
                    poppedThreads.foreach((Function1 & Serializable & scala.Serializable)thread -> {
                        this.stepIntoThread(thread);
                        return BoxedUnit.UNIT;
                    });
                    success = new Success((Object)BoxedUnit.UNIT);
                }
                return success.map((Function1 & Serializable & scala.Serializable)res -> {
                    HotCodeReplaceProvider.$anonfun$doHotCodeReplace$9(res);
                    return BoxedUnit.UNIT;
                });
            }
            throw new MatchError((Object)tuple3);
        }));
        this.publishEvent(HotCodeReplaceEvent.EventType.END, "Completed hot code replace", CollectionConverters$.MODULE$.seqAsJavaListConverter(classesToReplace).asJava());
        this.threadFrameMap().clear();
        return res;
    }

    private void warnOrThrow(String message) {
        if (this.testMode) {
            throw new DebugException(message);
        }
        this.logger.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
    }

    public void ch$epfl$scala$debugadapter$internal$HotCodeReplaceProvider$$warnOrThrow(String message, Throwable e) {
        if (this.testMode) {
            throw e;
        }
        this.logger.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(14).append(message).append(" because of ").append(e.getClass().getSimpleName()).append(": ").append(e.getMessage()).toString());
    }

    private Try<Seq<ThreadReference>> attemptPopFrames(Seq<ThreadReference> suspendedThreads, Seq<String> classNames) {
        Seq poppedThreads = (Seq)suspendedThreads.flatMap((Function1 & Serializable & scala.Serializable)thread -> Option$.MODULE$.option2Iterable(this.getAffectedFrame((ThreadReference)thread, classNames).map((Function1 & Serializable & scala.Serializable)frame -> this.popStackFrame((ThreadReference)thread, (StackFrame)frame).map((Function1 & Serializable & scala.Serializable)x$10 -> thread))), Seq$.MODULE$.canBuildFrom());
        return ScalaExtension$.MODULE$.TrySeq(poppedThreads).traverse();
    }

    private Option<StackFrame> getAffectedFrame(ThreadReference thread, Seq<String> qualifiedNames) {
        Seq<StackFrame> frames = this.getStackFrames(thread, false);
        Option affectedFrame = ((IterableLike)frames.zipWithIndex(Seq$.MODULE$.canBuildFrom())).find((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)HotCodeReplaceProvider.$anonfun$getAffectedFrame$1(this, qualifiedNames, x0$1)));
        return affectedFrame.flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                StackFrame frame = (StackFrame)tuple2._1();
                int i = tuple2._2$mcI$sp();
                if (!this.supportsDropToFrame(thread, frame)) {
                    return ((IterableLike)RichInt$.MODULE$.to$extension1(Predef$.MODULE$.intWrapper(i), 0, -1).map((Function1 & Serializable & scala.Serializable)idx -> HotCodeReplaceProvider.$anonfun$getAffectedFrame$3(frames, BoxesRunTime.unboxToInt((Object)idx)), IndexedSeq$.MODULE$.canBuildFrom())).find((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)this.supportsDropToFrame(thread, x$11)));
                }
            }
            if (tuple2 != null) {
                StackFrame frame = (StackFrame)tuple2._1();
                return new Some((Object)frame);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private boolean containsChangedType(StackFrame frame, Seq<String> qualifiedNames) {
        String declaringTypeName = StackFrameUtility.getDeclaringType((StackFrame)frame).name();
        return qualifiedNames.exists((Function1 & Serializable & scala.Serializable)className -> BoxesRunTime.boxToBoolean((boolean)className.startsWith(declaringTypeName)));
    }

    private Seq<StackFrame> getStackFrames(ThreadReference thread, boolean refresh) {
        Object object;
        Option oldValue = this.threadFrameMap().get((Object)thread);
        try {
            object = oldValue.isEmpty() || refresh ? new Some((Object)((SeqLike)CollectionConverters$.MODULE$.asScalaBufferConverter(thread.frames()).asScala()).toSeq()) : oldValue;
        }
        catch (IncompatibleThreadStateException e) {
            this.logger.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Failed to get stack frames: ").append(e.getMessage()).toString());
            object = oldValue;
        }
        Some newValue = object;
        newValue.foreach((Function1 & Serializable & scala.Serializable)x$12 -> {
            HotCodeReplaceProvider.$anonfun$getStackFrames$2(this, thread, x$12);
            return BoxedUnit.UNIT;
        });
        return (Seq)newValue.getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
    }

    private boolean supportsDropToFrame(ThreadReference thread, StackFrame frame) {
        return ((IterableLike)this.getStackFrames(thread, false).takeWhile((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)HotCodeReplaceProvider.$anonfun$supportsDropToFrame$1(frame, x$13)))).forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)HotCodeReplaceProvider.$anonfun$supportsDropToFrame$2(x$1)));
    }

    private Try<BoxedUnit> popStackFrame(ThreadReference thread, StackFrame frame) {
        Try res = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ObjectRef frames = ObjectRef.create(this.getStackFrames(thread, false));
            int desiredSize = ((Seq)frames.elem).indexOf((Object)frame);
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), ((Seq)frames.elem).indexOf((Object)frame)).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$14 -> {
                StackFrameUtility.pop((StackFrame)((StackFrame)((Seq)frames$2.elem).head()));
                frames$2.elem = this.getStackFrames(thread, true);
            });
        });
        return res.recover((PartialFunction)new scala.Serializable(this, thread){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HotCodeReplaceProvider $outer;
            private final ThreadReference thread$4;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof DebugException) {
                    DebugException debugException = (DebugException)A1;
                    this.$outer.ch$epfl$scala$debugadapter$internal$HotCodeReplaceProvider$$warnOrThrow(new StringBuilder(20).append("Cannot pop frame of ").append(this.thread$4.name()).toString(), (Throwable)debugException);
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return throwable instanceof DebugException;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.thread$4 = thread$4;
            }
        });
    }

    private Try<Seq<ThreadReference>> getSuspendedThreads() {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Seq)((SeqLike)CollectionConverters$.MODULE$.asScalaBufferConverter(this.currentDebugSession().getVM().allThreads()).asScala()).toSeq().filter((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)x$15.isSuspended())));
    }

    private Try<BoxedUnit> redefineClasses(Seq<String> qualifiedNames) {
        Map typesToBytes = (Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(this.getTypesToBytes(qualifiedNames)).asJava();
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.currentDebugSession().getVM().redefineClasses(typesToBytes)).recoverWith((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HotCodeReplaceProvider $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof UnsupportedOperationException ? true : (A1 instanceof NoClassDefFoundError ? true : (A1 instanceof VerifyError ? true : (A1 instanceof ClassFormatError ? true : A1 instanceof ClassCircularityError)))) {
                    this.$outer.ch$epfl$scala$debugadapter$internal$HotCodeReplaceProvider$$publishEvent(HotCodeReplaceEvent.EventType.ERROR, A1.getMessage());
                    return (B1)new Failure((Throwable)new DebugException(new StringBuilder(28).append("Failed to redefine classes: ").append(A1.getMessage()).toString()));
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return throwable instanceof UnsupportedOperationException ? true : (throwable instanceof NoClassDefFoundError ? true : (throwable instanceof VerifyError ? true : (throwable instanceof ClassFormatError ? true : throwable instanceof ClassCircularityError)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    private scala.collection.immutable.Map<ReferenceType, byte[]> getTypesToBytes(Seq<String> qualifiedNames) {
        SourceLookUpProvider sourceLookUpProvider = this.sourceLookUp();
        if (sourceLookUpProvider == null) {
            throw new IllegalAccessException("Source lookup is not available");
        }
        return ((TraversableOnce)qualifiedNames.flatMap((Function1 & Serializable & scala.Serializable)className -> (Seq)((TraversableLike)Option$.MODULE$.option2Iterable(sourceLookUpProvider.getClassFile((String)className)).toSeq().map((Function1 & Serializable & scala.Serializable)classFile -> {
            byte[] bytes = classFile.readBytes();
            return new Tuple2(classFile, (Object)bytes);
        }, Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x$16 -> {
            Tuple2 tuple2 = x$16;
            if (tuple2 != null) {
                byte[] bytes = (byte[])tuple2._2();
                return (Buffer)this.getJdiClassByName((String)className).map((Function1 & Serializable & scala.Serializable)cls -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(cls), (Object)bytes), Buffer$.MODULE$.canBuildFrom());
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private Buffer<ReferenceType> getJdiClassByName(String className) {
        Buffer buffer;
        try {
            buffer = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(this.currentDebugSession().getVM().classesByName(className)).asScala();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.ch$epfl$scala$debugadapter$internal$HotCodeReplaceProvider$$warnOrThrow(new StringBuilder(24).append("Cannot get JDI class of ").append(className).toString(), e);
                buffer = (Buffer)Buffer$.MODULE$.empty();
            }
            throw throwable;
        }
        return buffer;
    }

    private boolean containsObsoleteMethods(Seq<ThreadReference> suspendedThreads) {
        return ((IterableLike)suspendedThreads.flatMap((Function1 & Serializable & scala.Serializable)x$17 -> this.getStackFrames((ThreadReference)x$17, true), Seq$.MODULE$.canBuildFrom())).exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)HotCodeReplaceProvider.$anonfun$containsObsoleteMethods$2(x$1)));
    }

    private void stepIntoThread(ThreadReference thread) {
        EventRequestManager eventRequestManager = this.currentDebugSession().getVM().eventRequestManager();
        StepRequest request = DebugUtility.createStepIntoRequest((ThreadReference)thread, (String[])this.context().getStepFilters().skipClasses);
        this.currentDebugSession().getEventHub().stepEvents().filter(debugEvent -> {
            StepRequest stepRequest = request;
            EventRequest eventRequest = debugEvent.event.request();
            return !(stepRequest != null ? !stepRequest.equals(eventRequest) : eventRequest != null);
        }).take(1L).subscribe(debugEvent -> {
            debugEvent.shouldResume = false;
            DebugUtility.deleteEventRequestSafely((EventRequestManager)eventRequestManager, (EventRequest)request);
            this.context().getProtocolServer().sendEvent((Events.DebugEvent)new Events.StoppedEvent("step", thread.uniqueID()));
        });
        request.enable();
        thread.resume();
    }

    public static final /* synthetic */ void $anonfun$initialize$1(HotCodeReplaceProvider $this, Seq classes) {
        $this.classesAccumulator().updateAndGet(x$1 -> (Set)x$1.$plus$plus((GenTraversableOnce)classes));
    }

    private final boolean isClassLoaded$1(String className) {
        return this.getJdiClassByName(className).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$doHotCodeReplace$9(BoxedUnit res) {
    }

    public static final /* synthetic */ boolean $anonfun$getAffectedFrame$1(HotCodeReplaceProvider $this, Seq qualifiedNames$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            StackFrame frame = (StackFrame)tuple2._1();
            return $this.containsChangedType(frame, (Seq<String>)qualifiedNames$1);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ StackFrame $anonfun$getAffectedFrame$3(Seq frames$1, int idx) {
        return (StackFrame)frames$1.apply(idx);
    }

    public static final /* synthetic */ void $anonfun$getStackFrames$2(HotCodeReplaceProvider $this, ThreadReference thread$3, Seq x$12) {
        $this.threadFrameMap().update((Object)thread$3, (Object)x$12);
    }

    public static final /* synthetic */ boolean $anonfun$supportsDropToFrame$1(StackFrame frame$1, StackFrame x$13) {
        StackFrame stackFrame = x$13;
        StackFrame stackFrame2 = frame$1;
        return stackFrame == null ? stackFrame2 != null : !stackFrame.equals(stackFrame2);
    }

    public static final /* synthetic */ boolean $anonfun$supportsDropToFrame$2(StackFrame x$1) {
        return StackFrameUtility.isNative((StackFrame)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$containsObsoleteMethods$2(StackFrame x$1) {
        return StackFrameUtility.isObsolete((StackFrame)x$1);
    }

    public HotCodeReplaceProvider(Debuggee debuggee, Logger logger, boolean testMode) {
        this.debuggee = debuggee;
        this.logger = logger;
        this.testMode = testMode;
        this.sourceLookUp = null;
        this.stackTraceProvider = null;
        this.subscription = null;
        this.context = null;
        this.currentDebugSession = null;
        this.classesAccumulator = new AtomicReference<Set>(Predef$.MODULE$.Set().empty());
        this.threadFrameMap = Map$.MODULE$.empty();
        this.eventSubject = PublishSubject.create();
        this.getEventHub = this.eventSubject();
    }
}

