/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.scala.debugadapter.internal.evaluator;

import ch.epfl.scala.debugadapter.Logger;
import ch.epfl.scala.debugadapter.internal.evaluator.CompiledExpression;
import ch.epfl.scala.debugadapter.internal.evaluator.ExpressionCompiler;
import ch.epfl.scala.debugadapter.internal.evaluator.JdiArray;
import ch.epfl.scala.debugadapter.internal.evaluator.JdiClassLoader;
import ch.epfl.scala.debugadapter.internal.evaluator.JdiFrame;
import ch.epfl.scala.debugadapter.internal.evaluator.JdiNull$;
import ch.epfl.scala.debugadapter.internal.evaluator.JdiObject;
import ch.epfl.scala.debugadapter.internal.evaluator.JdiString;
import ch.epfl.scala.debugadapter.internal.evaluator.JdiValue;
import ch.epfl.scala.debugadapter.internal.evaluator.Safe;
import ch.epfl.scala.debugadapter.internal.evaluator.Safe$;
import ch.epfl.scala.debugadapter.internal.evaluator.package$;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.Value;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005mc!\u0002\b\u0010\u0001EY\u0002\u0002C\u0011\u0001\u0005\u0003\u0005\u000b\u0011B\u0012\t\u00119\u0002!\u0011!Q\u0001\n=B\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\to\u0001\u0011\t\u0011)A\u0005q!AA\b\u0001B\u0001B\u0003%Q\bC\u0003A\u0001\u0011\u0005\u0011\tC\u0003I\u0001\u0011\u0005\u0011\nC\u0003`\u0001\u0011\u0005\u0001\rC\u0003I\u0001\u0011%1\rC\u0003s\u0001\u0011%1\u000f\u0003\u0004\u0000\u0001\u0011%\u0011\u0011\u0001\u0005\b\u0003S\u0001A\u0011BA\u0016\u0011\u001d\t)\u0005\u0001C\u0005\u0003\u000f\u0012abU2bY\u0006,e/\u00197vCR|'O\u0003\u0002\u0011#\u0005IQM^1mk\u0006$xN\u001d\u0006\u0003%M\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003)U\tA\u0002Z3ck\u001e\fG-\u00199uKJT!AF\f\u0002\u000bM\u001c\u0017\r\\1\u000b\u0005aI\u0012\u0001B3qM2T\u0011AG\u0001\u0003G\"\u001c\"\u0001\u0001\u000f\u0011\u0005uyR\"\u0001\u0010\u000b\u0003YI!\u0001\t\u0010\u0003\r\u0005s\u0017PU3g\u00035\u0019x.\u001e:dK\u000e{g\u000e^3oi\u000e\u0001\u0001C\u0001\u0013,\u001d\t)\u0013\u0006\u0005\u0002'=5\tqE\u0003\u0002)E\u00051AH]8pizJ!A\u000b\u0010\u0002\rA\u0013X\rZ3g\u0013\taSF\u0001\u0004TiJLgn\u001a\u0006\u0003Uy\tQA\u001a:b[\u0016\u0004\"\u0001M\u0019\u000e\u0003=I!AM\b\u0003\u0011)#\u0017N\u0012:b[\u0016\f\u0001bY8na&dWM\u001d\t\u0003aUJ!AN\b\u0003%\u0015C\bO]3tg&|gnQ8na&dWM]\u0001\u0007Y><w-\u001a:\u0011\u0005eRT\"A\n\n\u0005m\u001a\"A\u0002'pO\u001e,'/\u0001\u0005uKN$Xj\u001c3f!\tib(\u0003\u0002@=\t9!i\\8mK\u0006t\u0017A\u0002\u001fj]&$h\b\u0006\u0004C\u0007\u0012+ei\u0012\t\u0003a\u0001AQ!\t\u0004A\u0002\rBQA\f\u0004A\u0002=BQa\r\u0004A\u0002QBQa\u000e\u0004A\u0002aBQ\u0001\u0010\u0004A\u0002u\n\u0001\"\u001a<bYV\fG/\u001a\u000b\u0003\u0015j\u00032a\u0013(Q\u001b\u0005a%BA'\u001f\u0003\u0011)H/\u001b7\n\u0005=c%a\u0001+ssB\u0011\u0011\u000bW\u0007\u0002%*\u00111\u000bV\u0001\u0004U\u0012L'BA+W\u0003\r\u0019XO\u001c\u0006\u0002/\u0006\u00191m\\7\n\u0005e\u0013&!\u0002,bYV,\u0007\"B.\b\u0001\u0004a\u0016AC3yaJ,7o]5p]B\u0011\u0001'X\u0005\u0003=>\u0011!cQ8na&dW\rZ#yaJ,7o]5p]\u000691m\\7qS2,GCA1c!\rYe\n\u0018\u0005\u00067\"\u0001\ra\t\u000b\u0004\u0015\u0012\u0004\b\"B3\n\u0001\u00041\u0017\u0001C2mCN\u001cH)\u001b:\u0011\u0005\u001dtW\"\u00015\u000b\u0005%T\u0017\u0001\u00024jY\u0016T!a\u001b7\u0002\u00079LwNC\u0001n\u0003\u0011Q\u0017M^1\n\u0005=D'\u0001\u0002)bi\"DQ!]\u0005A\u0002\r\n\u0011b\u00197bgNt\u0015-\\3\u0002%\u00154\u0018\r\\;bi\u0016,\u0005\u0010\u001d:fgNLwN\u001c\u000b\u0003ij\u00042\u0001M;x\u0013\t1xB\u0001\u0003TC\u001a,\u0007C\u0001\u0019y\u0013\tIxB\u0001\u0005KI&4\u0016\r\\;f\u0011\u0015Y(\u00021\u0001}\u0003I)\u0007\u0010\u001d:fgNLwN\\%ogR\fgnY3\u0011\u0005Aj\u0018B\u0001@\u0010\u0005%QE-[(cU\u0016\u001cG/\u0001\rde\u0016\fG/Z#yaJ,7o]5p]&s7\u000f^1oG\u0016$\"\"a\u0001\u0002\u0006\u0005=\u0011\u0011CA\n!\r\u0001T\u000f \u0005\b\u0003\u000fY\u0001\u0019AA\u0005\u0003-\u0019G.Y:t\u0019>\fG-\u001a:\u0011\u0007A\nY!C\u0002\u0002\u000e=\u0011aB\u00133j\u00072\f7o\u001d'pC\u0012,'\u000fC\u0003f\u0017\u0001\u0007a\rC\u0003r\u0017\u0001\u00071\u0005C\u0004\u0002\u0016-\u0001\r!a\u0006\u0002\t\u0005\u0014xm\u001d\t\u0006\u00033\t\u0019\u0003 \b\u0005\u00037\tyBD\u0002'\u0003;I\u0011AF\u0005\u0004\u0003Cq\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003K\t9C\u0001\u0003MSN$(bAA\u0011=\u0005)R\r\u001f;sC\u000e$h+\u00197vKN\fe\u000e\u001a(b[\u0016\u001cH\u0003BA\u0017\u0003\u0007\u0002B\u0001M;\u00020A9Q$!\r\u00026\u0005\u0005\u0013bAA\u001a=\t1A+\u001e9mKJ\u0002b!!\u0007\u00028\u0005m\u0012\u0002BA\u001d\u0003O\u00111aU3r!\r\u0001\u0014QH\u0005\u0004\u0003\u007fy!!\u0003&eSN#(/\u001b8h!\u0015\tI\"a\u000ex\u0011\u001d\t9\u0001\u0004a\u0001\u0003\u0013\tq\"\u001e9eCR,g+\u0019:jC\ndWm\u001d\u000b\u0005\u0003\u0013\n\t\u0006\u0005\u00031k\u0006-\u0003cA\u000f\u0002N%\u0019\u0011q\n\u0010\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003'j\u0001\u0019AA+\u000351\u0018M]5bE2,\u0017I\u001d:bsB\u0019\u0001'a\u0016\n\u0007\u0005esB\u0001\u0005KI&\f%O]1z\u0001")
public class ScalaEvaluator {
    private final String sourceContent;
    private final JdiFrame frame;
    private final ExpressionCompiler compiler;
    private final Logger logger;
    private final boolean testMode;

    public Try<Value> evaluate(CompiledExpression expression) {
        return this.evaluate(expression.classDir(), expression.className());
    }

    public Try<CompiledExpression> compile(String expression) {
        String className;
        this.logger.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Compiling expression '").append(expression).append("'").toString());
        Location location = this.frame.current().location();
        int line = location.lineNumber();
        String fqcn = location.declaringType().name();
        String string = className = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(fqcn)).split('.'))).last();
        String string2 = fqcn;
        String packageName = !(string != null ? !string.equals(string2) : string2 != null) ? "" : new StringOps(Predef$.MODULE$.augmentString(fqcn)).stripSuffix(new StringBuilder(1).append(".").append(className).toString());
        String randomId = UUID.randomUUID().toString().replace("-", "");
        Path outDir = Files.createTempDirectory(new StringBuilder(20).append("scala-debug-adapter-").append(randomId).toString(), new FileAttribute[0]);
        String expressionClassName = new StringBuilder(10).append("Expression").append(randomId).toString();
        String fileName = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(location.sourcePath())).split('/'))).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(x$1)).split('\\'))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).last();
        Path sourceFile = Files.createFile(outDir.resolve(fileName), new FileAttribute[0]);
        Files.write(sourceFile, this.sourceContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        String expressionFqcn = packageName.isEmpty() ? expressionClassName : new StringBuilder(1).append(packageName).append(".").append(expressionClassName).toString();
        Safe compiledExpression = this.frame.classLoader().flatMap((Function1 & Serializable & scala.Serializable)classLoader -> this.extractValuesAndNames((JdiClassLoader)classLoader).withFilter((Function1<Tuple2<Seq<JdiString>, Seq<JdiValue>>, Object>)(Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ScalaEvaluator.$anonfun$compile$4(check$ifrefutable$1))).map((Function1 & Serializable & scala.Serializable)x$4 -> {
            Tuple2 tuple2 = x$4;
            if (tuple2 != null) {
                Seq names = (Seq)tuple2._1();
                Set localNames = ((TraversableOnce)names.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.stringValue(), Seq$.MODULE$.canBuildFrom())).toSet();
                return new Tuple2((Object)tuple2, (Object)localNames);
            }
            throw new MatchError((Object)tuple2);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$5 -> {
            Tuple2 tuple2 = x$5;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                Set localNames = (Set)tuple2._2();
                if (tuple22 != null) {
                    return package$.MODULE$.TryToSafe($this.compiler.compile(outDir, expressionClassName, sourceFile, line, expression, (Set<String>)localNames, packageName, $this.testMode)).toSafe().map((Function1 & Serializable & scala.Serializable)_ -> new CompiledExpression(outDir, expressionFqcn));
                }
            }
            throw new MatchError((Object)tuple2);
        }));
        return compiledExpression.getResult();
    }

    private Try<Value> evaluate(Path classDir, String className) {
        Safe evaluatedValue = this.frame.classLoader().flatMap((Function1 & Serializable & scala.Serializable)classLoader -> this.extractValuesAndNames((JdiClassLoader)classLoader).withFilter((Function1<Tuple2<Seq<JdiString>, Seq<JdiValue>>, Object>)(Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)ScalaEvaluator.$anonfun$evaluate$2(check$ifrefutable$2))).flatMap((Function1 & Serializable & scala.Serializable)x$7 -> {
            Tuple2 tuple2 = x$7;
            if (tuple2 != null) {
                Seq names = (Seq)tuple2._1();
                Seq values = (Seq)tuple2._2();
                return classLoader.createArray("java.lang.String", (Seq<JdiValue>)names).flatMap((Function1 & Serializable & scala.Serializable)namesArray -> classLoader.createArray("java.lang.Object", (Seq<JdiValue>)values).map((Function1 & Serializable & scala.Serializable)valuesArray -> {
                    JdiObject thisObject = (JdiObject)$this.frame.thisObject().getOrElse((Function0 & Serializable & scala.Serializable)() -> JdiNull$.MODULE$);
                    .colon.colon args2 = new .colon.colon((Object)thisObject, (List)new .colon.colon(namesArray, (List)new .colon.colon(valuesArray, (List)Nil$.MODULE$)));
                    return new Tuple3(valuesArray, (Object)thisObject, (Object)args2);
                }).flatMap((Function1 & Serializable & scala.Serializable)x$6 -> {
                    Tuple3 tuple3 = x$6;
                    if (tuple3 != null) {
                        JdiArray valuesArray = (JdiArray)tuple3._1();
                        List args2 = (List)tuple3._3();
                        return this.createExpressionInstance((JdiClassLoader)classLoader, classDir, className, (List<JdiObject>)args2).flatMap((Function1 & Serializable & scala.Serializable)expressionInstance -> this.evaluateExpression((JdiObject)expressionInstance).flatMap((Function1 & Serializable & scala.Serializable)evaluatedValue -> this.updateVariables(valuesArray).flatMap((Function1 & Serializable & scala.Serializable)_ -> evaluatedValue.unboxIfPrimitive().map((Function1 & Serializable & scala.Serializable)unboxedValue -> unboxedValue.value()))));
                    }
                    throw new MatchError((Object)tuple3);
                }));
            }
            throw new MatchError((Object)tuple2);
        }));
        return evaluatedValue.getResult();
    }

    private Safe<JdiValue> evaluateExpression(JdiObject expressionInstance) {
        return expressionInstance.invoke("evaluate", (Seq<JdiValue>)Nil$.MODULE$);
    }

    private Safe<JdiObject> createExpressionInstance(JdiClassLoader classLoader, Path classDir, String className, List<JdiObject> args2) {
        String expressionClassPath = classDir.toUri().toString();
        return classLoader.createChildLoader(classDir).flatMap((Function1 & Serializable & scala.Serializable)expressionClassLoader -> expressionClassLoader.loadClass(className).flatMap((Function1 & Serializable & scala.Serializable)expressionClass -> expressionClass.newInstance((Seq<JdiValue>)args2).map((Function1 & Serializable & scala.Serializable)expressionInstance -> expressionInstance)));
    }

    private Safe<Tuple2<Seq<JdiString>, Seq<JdiValue>>> extractValuesAndNames(JdiClassLoader classLoader) {
        return this.extractVariablesFromFrame$1(classLoader).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)ScalaEvaluator.$anonfun$extractValuesAndNames$12(check$ifrefutable$3))).flatMap((Function1 & Serializable & scala.Serializable)x$15 -> {
            Tuple2 tuple2 = x$15;
            if (tuple2 != null) {
                Seq variableNames = (Seq)tuple2._1();
                Seq variableValues = (Seq)tuple2._2();
                return ((Safe)$this.frame.thisObject().filter((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)ScalaEvaluator.$anonfun$extractValuesAndNames$14(this, x$13))).map((Function1 & Serializable & scala.Serializable)thisObject -> ScalaEvaluator.extractThisAndFields$1(thisObject, classLoader)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Safe$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new Tuple2((Object)Nil$.MODULE$, (Object)Nil$.MODULE$)))).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)ScalaEvaluator.$anonfun$extractValuesAndNames$18(check$ifrefutable$4))).map((Function1 & Serializable & scala.Serializable)x$14 -> {
                    Tuple2 tuple2 = x$14;
                    if (tuple2 != null) {
                        Seq fieldNames = (Seq)tuple2._1();
                        Seq fieldValues = (Seq)tuple2._2();
                        Seq names = (Seq)variableNames.$plus$plus((GenTraversableOnce)fieldNames, Seq$.MODULE$.canBuildFrom());
                        Seq values = (Seq)variableValues.$plus$plus((GenTraversableOnce)fieldValues, Seq$.MODULE$.canBuildFrom());
                        return new Tuple2((Object)names, (Object)values);
                    }
                    throw new MatchError((Object)tuple2);
                });
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private Safe<BoxedUnit> updateVariables(JdiArray variableArray) {
        return package$.MODULE$.SafeSeq((Seq)((TraversableLike)this.frame.variables().zip(variableArray.getValues(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                LocalVariable variable = (LocalVariable)tuple2._1();
                JdiValue value = (JdiValue)tuple2._2();
                if (variable.type() instanceof PrimitiveType) {
                    return value.unboxIfPrimitive();
                }
            }
            if (tuple2 != null) {
                JdiValue value = (JdiValue)tuple2._2();
                return Safe$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> value);
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom())).traverse().map((Function1 & Serializable & scala.Serializable)values -> {
            ScalaEvaluator.$anonfun$updateVariables$3(this, values);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$compile$4(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$evaluate$2(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        return tuple2 != null;
    }

    private final Safe extractVariablesFromFrame$1(JdiClassLoader classLoader$2) {
        Seq localVariables = (Seq)this.frame.variablesAndValues().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                LocalVariable variable = (LocalVariable)tuple2._1();
                JdiValue value = (JdiValue)tuple2._2();
                return new Tuple2((Object)variable.name(), (Object)value);
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
        return package$.MODULE$.SafeSeq(((SeqLike)localVariables.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String name2 = (String)tuple2._1();
                JdiValue value = (JdiValue)tuple2._2();
                return classLoader$2.mirrorOf(name2).flatMap((Function1 & Serializable & scala.Serializable)name -> classLoader$2.boxIfPrimitive(value).map((Function1 & Serializable & scala.Serializable)value -> new Tuple2(name, value)));
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom())).toSeq()).traverse().map((Function1 & Serializable & scala.Serializable)xs -> new Tuple2(xs.map((Function1 & Serializable & scala.Serializable)x$8 -> (JdiString)x$8._1(), Seq$.MODULE$.canBuildFrom()), xs.map((Function1 & Serializable & scala.Serializable)x$9 -> (JdiValue)x$9._2(), Seq$.MODULE$.canBuildFrom())));
    }

    private static final Safe extractThisAndFields$1(JdiObject thisObject, JdiClassLoader classLoader$2) {
        Tuple2 tuple2 = new Tuple2((Object)"$this", (Object)thisObject);
        Seq thisAndFieds = (Seq)thisObject.fields().$plus$colon((Object)tuple2, Seq$.MODULE$.canBuildFrom());
        Safe names = package$.MODULE$.SafeSeq((Seq)((TraversableLike)thisAndFieds.map((Function1 & Serializable & scala.Serializable)x$11 -> (String)x$11._1(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)str -> classLoader$2.mirrorOf((String)str), Seq$.MODULE$.canBuildFrom())).traverse();
        Safe values = package$.MODULE$.SafeSeq((Seq)((TraversableLike)thisAndFieds.map((Function1 & Serializable & scala.Serializable)x$12 -> (JdiValue)x$12._2(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)value -> classLoader$2.boxIfPrimitive((JdiValue)value), Seq$.MODULE$.canBuildFrom())).traverse();
        return Safe$.MODULE$.join(names, values);
    }

    public static final /* synthetic */ boolean $anonfun$extractValuesAndNames$12(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$extractValuesAndNames$14(ScalaEvaluator $this, JdiObject x$13) {
        return $this.compiler.scalaVersion().isScala2();
    }

    public static final /* synthetic */ boolean $anonfun$extractValuesAndNames$18(Tuple2 check$ifrefutable$4) {
        Tuple2 tuple2 = check$ifrefutable$4;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$updateVariables$4(ScalaEvaluator $this, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            LocalVariable variable = (LocalVariable)tuple2._1();
            JdiValue value = (JdiValue)tuple2._2();
            $this.frame.setVariable(variable, value);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$updateVariables$3(ScalaEvaluator $this, Seq values) {
        ((IterableLike)$this.frame.variables().zip((GenIterable)values, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            ScalaEvaluator.$anonfun$updateVariables$4($this, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    public ScalaEvaluator(String sourceContent, JdiFrame frame, ExpressionCompiler compiler, Logger logger, boolean testMode) {
        this.sourceContent = sourceContent;
        this.frame = frame;
        this.compiler = compiler;
        this.logger = logger;
        this.testMode = testMode;
    }
}

