/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.scala.debugadapter.internal.stacktrace;

import ch.epfl.scala.debugadapter.Debuggee;
import ch.epfl.scala.debugadapter.Java8;
import ch.epfl.scala.debugadapter.Java9OrAbove;
import ch.epfl.scala.debugadapter.JavaRuntime;
import ch.epfl.scala.debugadapter.Logger;
import ch.epfl.scala.debugadapter.internal.stacktrace.Scala3DecoderBridge;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.function.Consumer;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;

public final class Scala3DecoderBridge$ {
    public static Scala3DecoderBridge$ MODULE$;

    static {
        new Scala3DecoderBridge$();
    }

    public Scala3DecoderBridge apply(Debuggee debuggee, ClassLoader classLoader, Logger logger, boolean testMode) {
        String className = "ch.epfl.scala.debugadapter.internal.stacktrace.Scala3DecoderBridge";
        Class<?> cls = classLoader.loadClass(className);
        Object instance = this.newInstance(debuggee, cls, logger, testMode);
        Method decodeMethod = cls.getMethod("decode", Object.class);
        return new Scala3DecoderBridge(instance, decodeMethod);
    }

    private Object newInstance(Debuggee debuggee, Class<?> decoderClass, Logger logger, boolean testMode) {
        Seq javaRuntimeJars = (Seq)Option$.MODULE$.option2Iterable(debuggee.javaRuntime()).toSeq().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            JavaRuntime javaRuntime = x0$1;
            if (javaRuntime instanceof Java8) {
                Java8 java8 = (Java8)javaRuntime;
                Seq<Path> classJars = java8.classJars();
                return classJars;
            }
            if (javaRuntime instanceof Java9OrAbove) {
                Java9OrAbove java9OrAbove = (Java9OrAbove)javaRuntime;
                return (Seq)java9OrAbove.classSystems().flatMap((Function1 & Serializable & scala.Serializable)javaFs -> ((TraversableOnce)CollectionConverters$.MODULE$.asScalaIteratorConverter(Files.list(javaFs.fileSystem().getPath("/modules", new String[0])).iterator()).asScala()).toSeq(), Seq$.MODULE$.canBuildFrom());
            }
            throw new MatchError((Object)javaRuntime);
        }, Seq$.MODULE$.canBuildFrom());
        Path[] debuggeeClasspath = (Path[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])debuggee.classPath().toArray(ClassTag$.MODULE$.apply(Path.class)))).$plus$plus((GenTraversableOnce)javaRuntimeJars, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class)));
        Consumer<String> warnLogger = msg -> logger.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> msg);
        Constructor<?> ctr = decoderClass.getConstructor(Path[].class, Consumer.class, Boolean.TYPE);
        return ctr.newInstance(debuggeeClasspath, warnLogger, Predef$.MODULE$.boolean2Boolean(testMode));
    }

    private Scala3DecoderBridge$() {
        MODULE$ = this;
    }
}

