/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.scala.debugadapter.internal.scalasig;

import ch.epfl.scala.debugadapter.internal.scalasig.ScalaSigPrinter$StringFixes$;
import java.io.Serializable;
import java.util.regex.Pattern;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class ScalaSigPrinter$ {
    public static final ScalaSigPrinter$ MODULE$ = new ScalaSigPrinter$();
    private static final Set<String> keywordList = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"true", "false", "null", "abstract", "case", "catch", "class", "def", "do", "else", "extends", "final", "finally", "for", "forSome", "if", "implicit", "import", "lazy", "match", "new", "object", "override", "package", "private", "protected", "return", "sealed", "super", "this", "throw", "trait", "try", "type", "val", "var", "while", "with", "yield"}));
    private static final String compiledCodeBody = " = { /* compiled code */ }";
    private static final String ch$epfl$scala$debugadapter$internal$scalasig$ScalaSigPrinter$$setterSuffix = "_$eq";
    private static final Pattern ch$epfl$scala$debugadapter$internal$scalasig$ScalaSigPrinter$$placeholderPattern = Pattern.compile("_\\$(\\d)+");
    private static final String ch$epfl$scala$debugadapter$internal$scalasig$ScalaSigPrinter$$defaultParamMarker = "$default$";

    public Set<String> keywordList() {
        return keywordList;
    }

    public String compiledCodeBody() {
        return compiledCodeBody;
    }

    public String processName(String name) {
        String[] parts = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(ScalaSigPrinter$StringFixes$.MODULE$.stripPrivatePrefix$extension(this.ch$epfl$scala$debugadapter$internal$scalasig$ScalaSigPrinter$$StringFixes(name))), '.');
        for (int idx = 0; idx < parts.length; ++idx) {
            parts[idx] = this.processSimpleName(parts[idx]);
        }
        return Predef$.MODULE$.wrapRefArray((Object[])parts).mkString(".");
    }

    private String processSimpleName(String name) {
        return ScalaSigPrinter$StringFixes$.MODULE$.escapeNonIdentifiers$extension(this.ch$epfl$scala$debugadapter$internal$scalasig$ScalaSigPrinter$$StringFixes(ScalaSigPrinter$StringFixes$.MODULE$.fixExistentialTypeParamName$extension(this.ch$epfl$scala$debugadapter$internal$scalasig$ScalaSigPrinter$$StringFixes(ScalaSigPrinter$StringFixes$.MODULE$.fixPlaceholderNames$extension(this.ch$epfl$scala$debugadapter$internal$scalasig$ScalaSigPrinter$$StringFixes(ScalaSigPrinter$StringFixes$.MODULE$.decode$extension(this.ch$epfl$scala$debugadapter$internal$scalasig$ScalaSigPrinter$$StringFixes(name))))))));
    }

    public boolean ch$epfl$scala$debugadapter$internal$scalasig$ScalaSigPrinter$$isSetterFor(String setterName, String methodName) {
        boolean correctLength = setterName.length() == methodName.length() + this.ch$epfl$scala$debugadapter$internal$scalasig$ScalaSigPrinter$$setterSuffix().length();
        return correctLength && setterName.startsWith(methodName) && setterName.endsWith(this.ch$epfl$scala$debugadapter$internal$scalasig$ScalaSigPrinter$$setterSuffix());
    }

    public String ch$epfl$scala$debugadapter$internal$scalasig$ScalaSigPrinter$$setterSuffix() {
        return ch$epfl$scala$debugadapter$internal$scalasig$ScalaSigPrinter$$setterSuffix;
    }

    public Pattern ch$epfl$scala$debugadapter$internal$scalasig$ScalaSigPrinter$$placeholderPattern() {
        return ch$epfl$scala$debugadapter$internal$scalasig$ScalaSigPrinter$$placeholderPattern;
    }

    public String ch$epfl$scala$debugadapter$internal$scalasig$ScalaSigPrinter$$defaultParamMarker() {
        return ch$epfl$scala$debugadapter$internal$scalasig$ScalaSigPrinter$$defaultParamMarker;
    }

    public String ch$epfl$scala$debugadapter$internal$scalasig$ScalaSigPrinter$$StringFixes(String str) {
        return str;
    }

    public boolean ch$epfl$scala$debugadapter$internal$scalasig$ScalaSigPrinter$$isIdentifier(String id) {
        if (id.isEmpty() || ScalaSigPrinter$.hasCommentStart$1(id)) {
            return false;
        }
        if (ScalaSigPrinter$.isIdentifierStart$1(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(id), 0))) {
            int lastIdCharIdx = ScalaSigPrinter$.lastIdentifierCharIdx$1(id);
            if (lastIdCharIdx < 0 || lastIdCharIdx == id.length() - 1) {
                return true;
            }
            if (id.charAt(lastIdCharIdx) != '_') {
                return false;
            }
            return StringOps$.MODULE$.forall$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(id), lastIdCharIdx + 1)), (Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)ScalaSigPrinter$.isOperatorPart$1(BoxesRunTime.unboxToChar((Object)c))));
        }
        if (ScalaSigPrinter$.isOperatorPart$1(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(id), 0))) {
            return StringOps$.MODULE$.forall$extension(Predef$.MODULE$.augmentString(id), (Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)ScalaSigPrinter$.isOperatorPart$1(BoxesRunTime.unboxToChar((Object)c))));
        }
        return false;
    }

    public String quote(String s, boolean canUseMultiline) {
        if (canUseMultiline && (s.contains("\n") || s.contains("\r"))) {
            return new StringBuilder(6).append("\"\"\"").append(s).append("\"\"\"").toString();
        }
        return new StringBuilder(2).append("\"").append(s).append("\"").toString();
    }

    public boolean quote$default$2() {
        return true;
    }

    private static final boolean isIdentifierStart$1(char c) {
        return c == '_' || c == '$' || Character.isUnicodeIdentifierStart(c);
    }

    private static final boolean isIdentifierPart$1(char c) {
        return c == '$' || Character.isUnicodeIdentifierPart(c);
    }

    private static final boolean isSpecial$1(char c) {
        int chtp = Character.getType(c);
        return chtp == 25 || chtp == 28;
    }

    private static final boolean isOperatorPart$1(char c) {
        char c2 = c;
        switch (c2) {
            case '!': 
            case '#': 
            case '%': 
            case '&': 
            case '*': 
            case '+': 
            case '-': 
            case '/': 
            case ':': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '@': 
            case '\\': 
            case '^': 
            case '|': 
            case '~': {
                return true;
            }
        }
        return ScalaSigPrinter$.isSpecial$1(c);
    }

    private static final boolean hasCommentStart$1(String s) {
        return s.contains("//") || s.contains("/*");
    }

    private static final int lastIdentifierCharIdx$1(String s) {
        int idx = -1;
        while (idx + 1 < s.length() && ScalaSigPrinter$.isIdentifierPart$1(s.charAt(idx + 1))) {
            ++idx;
        }
        return idx;
    }

    private ScalaSigPrinter$() {
    }
}

