/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.scala.debugadapter.internal.evaluator;

import ch.epfl.scala.debugadapter.ClassEntry;
import ch.epfl.scala.debugadapter.Logger;
import ch.epfl.scala.debugadapter.internal.evaluator.CompiledExpression;
import ch.epfl.scala.debugadapter.internal.evaluator.ExpressionCompiler;
import ch.epfl.scala.debugadapter.internal.evaluator.FrameReference;
import ch.epfl.scala.debugadapter.internal.evaluator.JdiArray;
import ch.epfl.scala.debugadapter.internal.evaluator.JdiArray$;
import ch.epfl.scala.debugadapter.internal.evaluator.JdiClassLoader;
import ch.epfl.scala.debugadapter.internal.evaluator.JdiClassLoader$;
import ch.epfl.scala.debugadapter.internal.evaluator.JdiObject;
import ch.epfl.scala.debugadapter.internal.evaluator.JdiPrimitive$;
import ch.epfl.scala.debugadapter.internal.evaluator.MethodInvocationFailed;
import ch.epfl.scala.debugadapter.internal.evaluator.Safe;
import ch.epfl.scala.debugadapter.internal.evaluator.Safe$;
import ch.epfl.scala.debugadapter.internal.evaluator.package$;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.Field;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.LongValue;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StackFrame;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005}f!\u0002\n\u0014\u0001Uy\u0002\u0002C\u0013\u0001\u0005\u0003\u0005\u000b\u0011B\u0014\t\u0011-\u0002!\u0011!Q\u0001\n1B\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\ti\u0001\u0011\t\u0011)A\u0005k!)\u0001\b\u0001C\u0001s!)q\b\u0001C\u0001\u0001\")1\f\u0001C\u00019\")q\b\u0001C\u0005[\")Q\u0010\u0001C\u0005}\"9\u0011q\u0002\u0001\u0005\n\u0005E\u0001bBA \u0001\u0011%\u0011\u0011\t\u0005\b\u0003?\u0002A\u0011BA1\u0011\u001d\t9\b\u0001C\u0005\u0003sB\u0011\"!!\u0001\u0005\u0004%I!a!\t\u0011\u0005}\u0005\u0001)A\u0005\u0003\u000bCq!!)\u0001\t\u0013\t\u0019\u000bC\u0004\u00022\u0002!I!a-\u0003\u001dM\u001b\u0017\r\\1Fm\u0006dW/\u0019;pe*\u0011A#F\u0001\nKZ\fG.^1u_JT!AF\f\u0002\u0011%tG/\u001a:oC2T!\u0001G\r\u0002\u0019\u0011,'-^4bI\u0006\u0004H/\u001a:\u000b\u0005iY\u0012!B:dC2\f'B\u0001\u000f\u001e\u0003\u0011)\u0007O\u001a7\u000b\u0003y\t!a\u00195\u0014\u0005\u0001\u0001\u0003CA\u0011$\u001b\u0005\u0011#\"\u0001\u000e\n\u0005\u0011\u0012#AB!osJ+g-A\u0003f]R\u0014\u0018p\u0001\u0001\u0011\u0005!JS\"A\f\n\u0005):\"AC\"mCN\u001cXI\u001c;ss\u0006A1m\\7qS2,'\u000f\u0005\u0002.]5\t1#\u0003\u00020'\t\u0011R\t\u001f9sKN\u001c\u0018n\u001c8D_6\u0004\u0018\u000e\\3s\u0003\u0019awnZ4feB\u0011\u0001FM\u0005\u0003g]\u0011a\u0001T8hO\u0016\u0014\u0018\u0001\u0003;fgRlu\u000eZ3\u0011\u0005\u00052\u0014BA\u001c#\u0005\u001d\u0011un\u001c7fC:\fa\u0001P5oSRtD#\u0002\u001e<yur\u0004CA\u0017\u0001\u0011\u0015)S\u00011\u0001(\u0011\u0015YS\u00011\u0001-\u0011\u0015\u0001T\u00011\u00012\u0011\u0015!T\u00011\u00016\u0003!)g/\u00197vCR,GcA!R-B\u0019!)R$\u000e\u0003\rS!\u0001\u0012\u0012\u0002\tU$\u0018\u000e\\\u0005\u0003\r\u000e\u00131\u0001\u0016:z!\tAu*D\u0001J\u0015\tQ5*A\u0002kI&T!\u0001T'\u0002\u0007M,hNC\u0001O\u0003\r\u0019w.\\\u0005\u0003!&\u0013QAV1mk\u0016DQA\u0015\u0004A\u0002M\u000b!\"\u001a=qe\u0016\u001c8/[8o!\tiC+\u0003\u0002V'\t\u00112i\\7qS2,G-\u0012=qe\u0016\u001c8/[8o\u0011\u00159f\u00011\u0001Y\u0003\u00151'/Y7f!\ti\u0013,\u0003\u0002['\tqaI]1nKJ+g-\u001a:f]\u000e,\u0017aB2p[BLG.\u001a\u000b\u0005;z[G\u000eE\u0002C\u000bNCQaX\u0004A\u0002\u0001\fQb]8ve\u000e,7i\u001c8uK:$\bCA1i\u001d\t\u0011g\r\u0005\u0002dE5\tAM\u0003\u0002fM\u00051AH]8pizJ!a\u001a\u0012\u0002\rA\u0013X\rZ3g\u0013\tI'N\u0001\u0004TiJLgn\u001a\u0006\u0003O\nBQAU\u0004A\u0002\u0001DQaV\u0004A\u0002a#B!\u00118{y\")q\u000e\u0003a\u0001a\u0006A1\r\\1tg\u0012K'\u000f\u0005\u0002rq6\t!O\u0003\u0002ti\u0006!a-\u001b7f\u0015\t)h/A\u0002oS>T\u0011a^\u0001\u0005U\u00064\u0018-\u0003\u0002ze\n!\u0001+\u0019;i\u0011\u0015Y\b\u00021\u0001a\u0003%\u0019G.Y:t\u001d\u0006lW\rC\u0003X\u0011\u0001\u0007\u0001,\u0001\nfm\u0006dW/\u0019;f\u000bb\u0004(/Z:tS>tGcA@\u0002\u0006A!Q&!\u0001H\u0013\r\t\u0019a\u0005\u0002\u0005'\u00064W\rC\u0004\u0002\b%\u0001\r!!\u0003\u0002%\u0015D\bO]3tg&|g.\u00138ti\u0006t7-\u001a\t\u0004[\u0005-\u0011bAA\u0007'\tI!\nZ5PE*,7\r^\u0001\u0019GJ,\u0017\r^3FqB\u0014Xm]:j_:Len\u001d;b]\u000e,GCCA\n\u0003+\ty\"!\t\u0002$A)Q&!\u0001\u0002\n!9\u0011q\u0003\u0006A\u0002\u0005e\u0011aC2mCN\u001cHj\\1eKJ\u00042!LA\u000e\u0013\r\tib\u0005\u0002\u000f\u0015\u0012L7\t\\1tg2{\u0017\rZ3s\u0011\u0015y'\u00021\u0001q\u0011\u0015Y(\u00021\u0001a\u0011\u001d\t)C\u0003a\u0001\u0003O\tA!\u0019:hgB1\u0011\u0011FA\u001a\u0003sqA!a\u000b\u000209\u00191-!\f\n\u0003iI1!!\r#\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u000e\u00028\t!A*[:u\u0015\r\t\tD\t\t\u0004\u0011\u0006m\u0012bAA\u001f\u0013\nyqJ\u00196fGR\u0014VMZ3sK:\u001cW-A\u000bfqR\u0014\u0018m\u0019;WC2,Xm]!oI:\u000bW.Z:\u0015\r\u0005\r\u0013\u0011LA/!\u0015i\u0013\u0011AA#!\u001d\t\u0013qIA&\u0003/J1!!\u0013#\u0005\u0019!V\u000f\u001d7feA1\u0011\u0011FA'\u0003#JA!a\u0014\u00028\t\u00191+Z9\u0011\u0007!\u000b\u0019&C\u0002\u0002V%\u0013qb\u0015;sS:<'+\u001a4fe\u0016t7-\u001a\t\u0006\u0003S\tie\u0012\u0005\u0007\u00037Z\u0001\u0019\u0001-\u0002\u0011\u0019\u0014\u0018-\\3SK\u001aDq!a\u0006\f\u0001\u0004\tI\"A\bva\u0012\fG/\u001a,be&\f'\r\\3t)\u0019\t\u0019'a\u001b\u0002vA)Q&!\u0001\u0002fA\u0019\u0011%a\u001a\n\u0007\u0005%$E\u0001\u0003V]&$\bbBA7\u0019\u0001\u0007\u0011qN\u0001\u000em\u0006\u0014\u0018.\u00192mK\u0006\u0013(/Y=\u0011\u00075\n\t(C\u0002\u0002tM\u0011\u0001B\u00133j\u0003J\u0014\u0018-\u001f\u0005\u0006/2\u0001\r\u0001W\u0001\u000fE>D\u0018J\u001a)sS6LG/\u001b<f)\u0015y\u00181PA@\u0011\u0019\ti(\u0004a\u0001\u000f\u0006)a/\u00197vK\"9\u0011qC\u0007A\u0002\u0005e\u0011\u0001D;oE>DX*\u001a;i_\u0012\u001cXCAAC!!\t9)!%\u0002\u0016\u0006UUBAAE\u0015\u0011\tY)!$\u0002\u0013%lW.\u001e;bE2,'bAAHE\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005M\u0015\u0011\u0012\u0002\u0004\u001b\u0006\u0004\b\u0003BAL\u0003;k!!!'\u000b\u0007\u0005me/\u0001\u0003mC:<\u0017bA5\u0002\u001a\u0006iQO\u001c2pq6+G\u000f[8eg\u0002\n\u0001#\u001e8c_bLe\r\u0015:j[&$\u0018N^3\u0015\u000b}\f)+a*\t\r\u0005u\u0004\u00031\u0001H\u0011\u001d\tI\u000b\u0005a\u0001\u0003W\u000ba\u0001\u001e5sK\u0006$\u0007c\u0001%\u0002.&\u0019\u0011qV%\u0003\u001fQC'/Z1e%\u00164WM]3oG\u0016\f1\"[:Qe&l\u0017\u000e^5wKR\u0019Q'!.\t\u000f\u0005]\u0016\u00031\u0001\u0002:\u0006Aa/\u0019:jC\ndW\rE\u0002I\u0003wK1!!0J\u00055aunY1m-\u0006\u0014\u0018.\u00192mK\u0002")
public class ScalaEvaluator {
    private final ExpressionCompiler compiler;
    private final Logger logger;
    private final boolean testMode;
    private final Map<String, String> unboxMethods;

    public Try<Value> evaluate(CompiledExpression expression, FrameReference frame) {
        CompiledExpression compiledExpression = expression;
        if (compiledExpression == null) {
            throw new MatchError((Object)compiledExpression);
        }
        Path classDir = compiledExpression.classDir();
        String className = compiledExpression.className();
        Tuple2 tuple2 = new Tuple2((Object)classDir, (Object)className);
        Path classDir2 = (Path)tuple2._1();
        String className2 = (String)tuple2._2();
        return this.evaluate(classDir2, className2, frame);
    }

    public Try<CompiledExpression> compile(String sourceContent, String expression, FrameReference frame) {
        String className;
        this.logger.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(23).append("Compiling expression '").append(expression).append("'").toString());
        Location location = frame.current().location();
        int line = location.lineNumber();
        String fqcn = location.declaringType().name();
        String string = className = (String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(fqcn), '.')));
        String string2 = fqcn;
        String packageName = !(string != null ? !string.equals(string2) : string2 != null) ? "" : StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(fqcn), new StringBuilder(1).append(".").append(className).toString());
        String randomId = UUID.randomUUID().toString().replace("-", "");
        Path outDir = Files.createTempDirectory(new StringBuilder(20).append("scala-debug-adapter-").append(randomId).toString(), new FileAttribute[0]);
        String expressionClassName = new StringBuilder(10).append("Expression").append(randomId).toString();
        String fileName = (String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(location.sourcePath()), '/')), (Function1 & Serializable)x$2 -> StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(x$2), '\\'), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(String.class))));
        Path sourceFile = Files.createFile(outDir.resolve(fileName), new FileAttribute[0]);
        Files.write(sourceFile, sourceContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        String expressionFqcn = packageName.isEmpty() ? expressionClassName : new StringBuilder(1).append(packageName).append(".").append(expressionClassName).toString();
        Safe compiledExpression = JdiClassLoader$.MODULE$.fromFrame(frame).flatMap((Function1 & Serializable)classLoader -> this.extractValuesAndNames(frame, (JdiClassLoader)classLoader).withFilter((Function1<Tuple2<Seq<StringReference>, Seq<Value>>, Object>)(Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ScalaEvaluator.$anonfun$compile$5(check$ifrefutable$1))).map((Function1 & Serializable)x$5 -> {
            Tuple2 tuple2 = x$5;
            if (tuple2 != null) {
                Seq names = (Seq)tuple2._1();
                Set localNames = ((IterableOnceOps)names.map((Function1 & Serializable)x$3 -> x$3.value())).toSet();
                return new Tuple2((Object)tuple2, (Object)localNames);
            }
            throw new MatchError((Object)tuple2);
        }).flatMap((Function1 & Serializable)x$7 -> {
            Tuple2 tuple2 = x$7;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                Set localNames = (Set)tuple2._2();
                if (tuple22 != null) {
                    return Safe$.MODULE$.apply($this.compiler.compile(outDir, expressionClassName, sourceFile, line, expression, (Set<String>)localNames, packageName, $this.testMode)).map((Function1 & Serializable)x$6 -> {
                        BoxedUnit boxedUnit = x$6;
                        return new CompiledExpression(outDir, expressionFqcn);
                    });
                }
            }
            throw new MatchError((Object)tuple2);
        }));
        return compiledExpression.getResult();
    }

    private Try<Value> evaluate(Path classDir, String className, FrameReference frame) {
        Safe evaluatedValue = JdiClassLoader$.MODULE$.fromFrame(frame).flatMap((Function1 & Serializable)classLoader -> this.extractValuesAndNames(frame, (JdiClassLoader)classLoader).withFilter((Function1<Tuple2<Seq<StringReference>, Seq<Value>>, Object>)(Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)ScalaEvaluator.$anonfun$evaluate$2(check$ifrefutable$2))).flatMap((Function1 & Serializable)x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 != null) {
                Seq names = (Seq)tuple2._1();
                Seq values = (Seq)tuple2._2();
                return JdiArray$.MODULE$.apply("java.lang.String", names.size(), (JdiClassLoader)classLoader).flatMap((Function1 & Serializable)namesArray -> JdiArray$.MODULE$.apply("java.lang.Object", values.size(), (JdiClassLoader)classLoader).map((Function1 & Serializable)valuesArray -> {
                    namesArray.setValues((Seq<Value>)names);
                    BoxedUnit x$8 = BoxedUnit.UNIT;
                    valuesArray.setValues((Seq<Value>)values);
                    BoxedUnit x$9 = BoxedUnit.UNIT;
                    .colon.colon args2 = new .colon.colon((Object)namesArray.reference(), (List)new .colon.colon((Object)valuesArray.reference(), (List)Nil$.MODULE$));
                    return new Tuple4(valuesArray, (Object)x$8, (Object)x$9, (Object)args2);
                }).flatMap((Function1 & Serializable)x$11 -> {
                    Tuple4 tuple4 = x$11;
                    if (tuple4 != null) {
                        JdiArray valuesArray = (JdiArray)tuple4._1();
                        List args2 = (List)tuple4._4();
                        return this.createExpressionInstance((JdiClassLoader)classLoader, classDir, className, (List<ObjectReference>)args2).flatMap((Function1 & Serializable)expressionInstance -> this.evaluateExpression((JdiObject)expressionInstance).flatMap((Function1 & Serializable)evaluatedValue -> this.updateVariables(valuesArray, frame).flatMap((Function1 & Serializable)x$10 -> {
                            BoxedUnit boxedUnit = x$10;
                            return this.unboxIfPrimitive((Value)evaluatedValue, frame.thread()).map((Function1 & Serializable)unboxedValue -> unboxedValue);
                        })));
                    }
                    throw new MatchError((Object)tuple4);
                }));
            }
            throw new MatchError((Object)tuple2);
        }));
        return evaluatedValue.getResult();
    }

    private Safe<Value> evaluateExpression(JdiObject expressionInstance) {
        return expressionInstance.invoke("evaluate", (List<Value>)Nil$.MODULE$).recover(new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof MethodInvocationFailed) {
                    MethodInvocationFailed methodInvocationFailed = (MethodInvocationFailed)A1;
                    ObjectReference exception = methodInvocationFailed.remoteException();
                    return (B1)exception;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return throwable instanceof MethodInvocationFailed;
            }
        });
    }

    private Safe<JdiObject> createExpressionInstance(JdiClassLoader classLoader, Path classDir, String className, List<ObjectReference> args2) {
        String expressionClassPath = classDir.toUri().toString();
        return classLoader.mirrorOf(expressionClassPath).flatMap((Function1 & Serializable)classPathValue -> classLoader.loadClass("java.net.URL").flatMap((Function1 & Serializable)urlClass -> urlClass.newInstance((List<ObjectReference>)new .colon.colon(classPathValue, (List)Nil$.MODULE$)).flatMap((Function1 & Serializable)url -> JdiArray$.MODULE$.apply("java.net.URL", 1, classLoader).map((Function1 & Serializable)urls -> {
            urls.setValue(0, url.reference());
            BoxedUnit x$16 = BoxedUnit.UNIT;
            return new Tuple2(urls, (Object)x$16);
        }).flatMap((Function1 & Serializable)x$17 -> {
            Tuple2 tuple2 = x$17;
            if (tuple2 != null) {
                JdiArray urls = (JdiArray)tuple2._1();
                return classLoader.loadClass("java.net.URLClassLoader").flatMap((Function1 & Serializable)x$13 -> x$13.newInstance((List<ObjectReference>)new .colon.colon((Object)urls.reference(), (List)Nil$.MODULE$))).map((Function1 & Serializable)x$14 -> (ClassLoaderReference)x$14.reference()).map((Function1 & Serializable)x$15 -> JdiClassLoader$.MODULE$.apply((ClassLoaderReference)x$15, classLoader.thread())).flatMap((Function1 & Serializable)urlClassLoader -> urlClassLoader.loadClass(className).flatMap((Function1 & Serializable)expressionClass -> expressionClass.newInstance(args2).map((Function1 & Serializable)expressionInstance -> expressionInstance)));
            }
            throw new MatchError((Object)tuple2);
        }))));
    }

    private Safe<Tuple2<Seq<StringReference>, Seq<Value>>> extractValuesAndNames(FrameReference frameRef, JdiClassLoader classLoader) {
        StackFrame frame = frameRef.current();
        Option thisObjectOpt = Option$.MODULE$.apply((Object)frame.thisObject());
        return this.extractVariablesFromFrame$1(frame, thisObjectOpt, classLoader).withFilter((Function1 & Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)ScalaEvaluator.$anonfun$extractValuesAndNames$15(check$ifrefutable$3))).flatMap((Function1 & Serializable)x$25 -> {
            Tuple2 tuple2 = x$25;
            if (tuple2 != null) {
                Seq variableNames = (Seq)tuple2._1();
                Seq variableValues = (Seq)tuple2._2();
                return ((Safe)thisObjectOpt.filter((Function1 & Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)ScalaEvaluator.$anonfun$extractValuesAndNames$17(this, x$23))).map((Function1 & Serializable)thisObject -> this.extractFields$1((ObjectReference)thisObject, classLoader)).getOrElse((Function0 & Serializable)() -> Safe$.MODULE$.apply((Function0 & Serializable)() -> new Tuple2((Object)Nil$.MODULE$, (Object)Nil$.MODULE$)))).withFilter((Function1 & Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)ScalaEvaluator.$anonfun$extractValuesAndNames$21(check$ifrefutable$4))).map((Function1 & Serializable)x$24 -> {
                    Tuple2 tuple2 = x$24;
                    if (tuple2 != null) {
                        Seq fieldNames = (Seq)tuple2._1();
                        Seq fieldValues = (Seq)tuple2._2();
                        Seq names = (Seq)variableNames.$plus$plus((IterableOnce)fieldNames);
                        Seq values = (Seq)variableValues.$plus$plus((IterableOnce)fieldValues);
                        return new Tuple2((Object)names, (Object)values);
                    }
                    throw new MatchError((Object)tuple2);
                });
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private Safe<BoxedUnit> updateVariables(JdiArray variableArray, FrameReference frame) {
        Safe unboxedValues = package$.MODULE$.SafeSeq(((List)ScalaEvaluator.localVariables$2(frame).zip(variableArray.getValues())).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                LocalVariable variable = (LocalVariable)tuple2._1();
                Value value = (Value)tuple2._2();
                if (this.isPrimitive(variable)) {
                    return this.unboxIfPrimitive(value, frame.thread());
                }
                return Safe$.MODULE$.apply((Function0 & Serializable)() -> value);
            }
            throw new MatchError((Object)tuple2);
        })).traverse();
        return unboxedValues.map((Function1 & Serializable)values -> {
            ScalaEvaluator.$anonfun$updateVariables$3(frame, values);
            return BoxedUnit.UNIT;
        });
    }

    private Safe<Value> boxIfPrimitive(Value value, JdiClassLoader classLoader) {
        ThreadReference thread = classLoader.thread();
        Value value2 = value;
        if (value2 instanceof BooleanValue) {
            BooleanValue booleanValue = (BooleanValue)value2;
            return JdiPrimitive$.MODULE$.box(BoxesRunTime.boxToBoolean((boolean)booleanValue.value()), classLoader, thread);
        }
        if (value2 instanceof CharValue) {
            CharValue charValue = (CharValue)value2;
            return JdiPrimitive$.MODULE$.box(BoxesRunTime.boxToCharacter((char)charValue.value()), classLoader, thread);
        }
        if (value2 instanceof DoubleValue) {
            DoubleValue doubleValue = (DoubleValue)value2;
            return JdiPrimitive$.MODULE$.box(BoxesRunTime.boxToDouble((double)doubleValue.value()), classLoader, thread);
        }
        if (value2 instanceof FloatValue) {
            FloatValue floatValue = (FloatValue)value2;
            return JdiPrimitive$.MODULE$.box(BoxesRunTime.boxToFloat((float)floatValue.value()), classLoader, thread);
        }
        if (value2 instanceof IntegerValue) {
            IntegerValue integerValue = (IntegerValue)value2;
            return JdiPrimitive$.MODULE$.box(BoxesRunTime.boxToInteger((int)integerValue.value()), classLoader, thread);
        }
        if (value2 instanceof LongValue) {
            LongValue longValue = (LongValue)value2;
            return JdiPrimitive$.MODULE$.box(BoxesRunTime.boxToLong((long)longValue.value()), classLoader, thread);
        }
        if (value2 instanceof ShortValue) {
            ShortValue shortValue = (ShortValue)value2;
            return JdiPrimitive$.MODULE$.box(BoxesRunTime.boxToShort((short)shortValue.value()), classLoader, thread);
        }
        return Safe$.MODULE$.apply((Function0 & Serializable)() -> value2);
    }

    private Map<String, String> unboxMethods() {
        return this.unboxMethods;
    }

    private Safe<Value> unboxIfPrimitive(Value value, ThreadReference thread) {
        Value value2 = value;
        if (value2 instanceof ObjectReference) {
            ObjectReference objectReference = (ObjectReference)value2;
            String typeName = objectReference.referenceType().name();
            return (Safe)this.unboxMethods().get((Object)typeName).map((Function1 & Serializable)methodName -> new JdiObject(objectReference, thread).invoke((String)methodName, (List<Value>)Nil$.MODULE$)).getOrElse((Function0 & Serializable)() -> Safe$.MODULE$.apply((Function0 & Serializable)() -> value));
        }
        return Safe$.MODULE$.apply((Function0 & Serializable)() -> value);
    }

    private boolean isPrimitive(LocalVariable variable) {
        return variable.type() instanceof PrimitiveType;
    }

    public static final /* synthetic */ boolean $anonfun$compile$5(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$evaluate$2(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$extractValuesAndNames$3(Tuple2 x$19) {
        Object object = x$19._1();
        String string = "$this";
        return !(object != null ? !object.equals(string) : string != null);
    }

    public static final /* synthetic */ boolean $anonfun$extractValuesAndNames$2(Seq localVariables$1, ObjectReference x$18) {
        return !localVariables$1.exists((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)ScalaEvaluator.$anonfun$extractValuesAndNames$3(x$19)));
    }

    private final Safe extractVariablesFromFrame$1(StackFrame frame$3, Option thisObjectOpt$1, JdiClassLoader classLoader$3) {
        Seq localVariables = (Seq)CollectionConverters$.MODULE$.ListHasAsScala(frame$3.visibleVariables()).asScala().toSeq().map((Function1 & Serializable)v -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)v.name()), (Object)frame$3.getValue((LocalVariable)v)));
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"$this");
        Option thisObject = thisObjectOpt$1.filter((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)ScalaEvaluator.$anonfun$extractValuesAndNames$2(localVariables, x$18))).map((Function1 & Serializable)y -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, y));
        return package$.MODULE$.SafeSeq((Seq)((IterableOps)localVariables.$plus$plus((IterableOnce)thisObject)).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String name2 = (String)tuple2._1();
                Value value = (Value)tuple2._2();
                return classLoader$3.mirrorOf(name2).flatMap((Function1 & Serializable)name -> this.boxIfPrimitive(value, classLoader$3).map((Function1 & Serializable)value -> new Tuple2(name, value)));
            }
            throw new MatchError((Object)tuple2);
        })).traverse().map((Function1 & Serializable)xs -> new Tuple2(xs.map((Function1 & Serializable)x$20 -> (StringReference)x$20._1()), xs.map((Function1 & Serializable)x$21 -> (Value)x$21._2())));
    }

    private final Safe extractFields$1(ObjectReference thisObject, JdiClassLoader classLoader$3) {
        List fields = CollectionConverters$.MODULE$.ListHasAsScala(thisObject.referenceType().fields()).asScala().toList();
        Safe fieldNames = package$.MODULE$.SafeSeq(fields.map((Function1 & Serializable)x$22 -> x$22.name()).map((Function1 & Serializable)str -> classLoader$3.mirrorOf((String)str))).traverse();
        Safe fieldValues = package$.MODULE$.SafeSeq(fields.map((Function1 & Serializable)field -> thisObject.getValue((Field)field)).map((Function1 & Serializable)value -> this.boxIfPrimitive((Value)value, classLoader$3))).traverse();
        return Safe$.MODULE$.join(fieldNames, fieldValues);
    }

    public static final /* synthetic */ boolean $anonfun$extractValuesAndNames$15(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$extractValuesAndNames$17(ScalaEvaluator $this, ObjectReference x$23) {
        return $this.compiler.scalaVersion().isScala2();
    }

    public static final /* synthetic */ boolean $anonfun$extractValuesAndNames$21(Tuple2 check$ifrefutable$4) {
        Tuple2 tuple2 = check$ifrefutable$4;
        return tuple2 != null;
    }

    private static final List localVariables$2(FrameReference frame$4) {
        return CollectionConverters$.MODULE$.ListHasAsScala(frame$4.current().visibleVariables()).asScala().toList();
    }

    public static final /* synthetic */ boolean $anonfun$updateVariables$4(Tuple2 check$ifrefutable$5) {
        Tuple2 tuple2 = check$ifrefutable$5;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$updateVariables$5(FrameReference frame$4, Tuple2 x$26) {
        Tuple2 tuple2 = x$26;
        if (tuple2 != null) {
            LocalVariable variable = (LocalVariable)tuple2._1();
            Value value = (Value)tuple2._2();
            frame$4.current().setValue(variable, value);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$updateVariables$3(FrameReference frame$4, Seq values) {
        ((IterableOps)ScalaEvaluator.localVariables$2(frame$4).zip((IterableOnce)values)).withFilter((Function1 & Serializable)check$ifrefutable$5 -> BoxesRunTime.boxToBoolean((boolean)ScalaEvaluator.$anonfun$updateVariables$4(check$ifrefutable$5))).foreach((Function1 & Serializable)x$26 -> {
            ScalaEvaluator.$anonfun$updateVariables$5(frame$4, x$26);
            return BoxedUnit.UNIT;
        });
    }

    public ScalaEvaluator(ClassEntry entry, ExpressionCompiler compiler, Logger logger, boolean testMode) {
        this.compiler = compiler;
        this.logger = logger;
        this.testMode = testMode;
        this.unboxMethods = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"java.lang.Boolean"), (Object)"booleanValue"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"java.lang.Byte"), (Object)"byteValue"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"java.lang.Character"), (Object)"charValue"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"java.lang.Double"), (Object)"doubleValue"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"java.lang.Float"), (Object)"floatValue"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"java.lang.Integer"), (Object)"intValue"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"java.lang.Long"), (Object)"longValue"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"java.lang.Short"), (Object)"shortValue")}));
    }
}

