/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.scala.debugadapter.internal.evaluator;

import ch.epfl.scala.debugadapter.ClassEntry;
import ch.epfl.scala.debugadapter.Logger;
import ch.epfl.scala.debugadapter.internal.evaluator.CompiledExpression;
import ch.epfl.scala.debugadapter.internal.evaluator.ExpressionCompiler;
import ch.epfl.scala.debugadapter.internal.evaluator.JdiArray;
import ch.epfl.scala.debugadapter.internal.evaluator.JdiClassLoader;
import ch.epfl.scala.debugadapter.internal.evaluator.JdiFrame;
import ch.epfl.scala.debugadapter.internal.evaluator.JdiObject;
import ch.epfl.scala.debugadapter.internal.evaluator.JdiString;
import ch.epfl.scala.debugadapter.internal.evaluator.JdiValue;
import ch.epfl.scala.debugadapter.internal.evaluator.MethodInvocationFailed;
import ch.epfl.scala.debugadapter.internal.evaluator.Safe;
import ch.epfl.scala.debugadapter.internal.evaluator.Safe$;
import ch.epfl.scala.debugadapter.internal.evaluator.package$;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.Value;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u00055d!B\u0007\u000f\u0001AQ\u0002\u0002\u0003\u0011\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0012\t\u0011\u0019\u0002!\u0011!Q\u0001\n\u001dB\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\t_\u0001\u0011\t\u0011)A\u0005a!)1\u0007\u0001C\u0001i!)!\b\u0001C\u0001w!)a\u000b\u0001C\u0001/\")!\b\u0001C\u0005Q\")\u0001\u0010\u0001C\u0005s\"9\u00111\u0002\u0001\u0005\n\u00055\u0001bBA\u001b\u0001\u0011%\u0011q\u0007\u0005\b\u0003+\u0002A\u0011BA,\u00059\u00196-\u00197b\u000bZ\fG.^1u_JT!a\u0004\t\u0002\u0013\u00154\u0018\r\\;bi>\u0014(BA\t\u0013\u0003!Ig\u000e^3s]\u0006d'BA\n\u0015\u00031!WMY;hC\u0012\f\u0007\u000f^3s\u0015\t)b#A\u0003tG\u0006d\u0017M\u0003\u0002\u00181\u0005!Q\r\u001d4m\u0015\u0005I\u0012AA2i'\t\u00011\u0004\u0005\u0002\u001d=5\tQDC\u0001\u0016\u0013\tyRD\u0001\u0004B]f\u0014VMZ\u0001\u0006K:$(/_\u0002\u0001!\t\u0019C%D\u0001\u0013\u0013\t)#C\u0001\u0006DY\u0006\u001c8/\u00128uef\f\u0001bY8na&dWM\u001d\t\u0003Q%j\u0011AD\u0005\u0003U9\u0011!#\u0012=qe\u0016\u001c8/[8o\u0007>l\u0007/\u001b7fe\u00061An\\4hKJ\u0004\"aI\u0017\n\u00059\u0012\"A\u0002'pO\u001e,'/\u0001\u0005uKN$Xj\u001c3f!\ta\u0012'\u0003\u00023;\t9!i\\8mK\u0006t\u0017A\u0002\u001fj]&$h\bF\u00036m]B\u0014\b\u0005\u0002)\u0001!)\u0001%\u0002a\u0001E!)a%\u0002a\u0001O!)1&\u0002a\u0001Y!)q&\u0002a\u0001a\u0005AQM^1mk\u0006$X\rF\u0002=\u0019F\u00032!\u0010!C\u001b\u0005q$BA \u001e\u0003\u0011)H/\u001b7\n\u0005\u0005s$a\u0001+ssB\u00111IS\u0007\u0002\t*\u0011QIR\u0001\u0004U\u0012L'BA$I\u0003\r\u0019XO\u001c\u0006\u0002\u0013\u0006\u00191m\\7\n\u0005-#%!\u0002,bYV,\u0007\"B'\u0007\u0001\u0004q\u0015AC3yaJ,7o]5p]B\u0011\u0001fT\u0005\u0003!:\u0011!cQ8na&dW\rZ#yaJ,7o]5p]\")!K\u0002a\u0001'\u0006)aM]1nKB\u0011\u0001\u0006V\u0005\u0003+:\u0011\u0001B\u00133j\rJ\fW.Z\u0001\bG>l\u0007/\u001b7f)\u0011A\u0016LZ4\u0011\u0007u\u0002e\nC\u0003[\u000f\u0001\u00071,A\u0007t_V\u00148-Z\"p]R,g\u000e\u001e\t\u00039\u000et!!X1\u0011\u0005ykR\"A0\u000b\u0005\u0001\f\u0013A\u0002\u001fs_>$h(\u0003\u0002c;\u00051\u0001K]3eK\u001aL!\u0001Z3\u0003\rM#(/\u001b8h\u0015\t\u0011W\u0004C\u0003N\u000f\u0001\u00071\fC\u0003S\u000f\u0001\u00071\u000b\u0006\u0003=SV<\b\"\u00026\t\u0001\u0004Y\u0017\u0001C2mCN\u001cH)\u001b:\u0011\u00051\u001cX\"A7\u000b\u00059|\u0017\u0001\u00024jY\u0016T!\u0001]9\u0002\u00079LwNC\u0001s\u0003\u0011Q\u0017M^1\n\u0005Ql'\u0001\u0002)bi\"DQA\u001e\u0005A\u0002m\u000b\u0011b\u00197bgNt\u0015-\\3\t\u000bIC\u0001\u0019A*\u0002%\u00154\u0018\r\\;bi\u0016,\u0005\u0010\u001d:fgNLwN\u001c\u000b\u0004u\u0006\u0005\u0001c\u0001\u0015|{&\u0011AP\u0004\u0002\u0005'\u00064W\r\u0005\u0002)}&\u0011qP\u0004\u0002\t\u0015\u0012Lg+\u00197vK\"9\u00111A\u0005A\u0002\u0005\u0015\u0011AE3yaJ,7o]5p]&s7\u000f^1oG\u0016\u00042\u0001KA\u0004\u0013\r\tIA\u0004\u0002\n\u0015\u0012LwJ\u00196fGR\f\u0001d\u0019:fCR,W\t\u001f9sKN\u001c\u0018n\u001c8J]N$\u0018M\\2f))\ty!!\u0005\u0002\u001c\u0005u\u0011q\u0004\t\u0005Qm\f)\u0001C\u0004\u0002\u0014)\u0001\r!!\u0006\u0002\u0017\rd\u0017m]:M_\u0006$WM\u001d\t\u0004Q\u0005]\u0011bAA\r\u001d\tq!\nZ5DY\u0006\u001c8\u000fT8bI\u0016\u0014\b\"\u00026\u000b\u0001\u0004Y\u0007\"\u0002<\u000b\u0001\u0004Y\u0006bBA\u0011\u0015\u0001\u0007\u00111E\u0001\u0005CJ<7\u000f\u0005\u0004\u0002&\u0005=\u0012Q\u0001\b\u0005\u0003O\tYCD\u0002_\u0003SI\u0011!F\u0005\u0004\u0003[i\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003c\t\u0019D\u0001\u0003MSN$(bAA\u0017;\u0005)R\r\u001f;sC\u000e$h+\u00197vKN\fe\u000e\u001a(b[\u0016\u001cHCBA\u001d\u0003\u001f\n\u0019\u0006\u0005\u0003)w\u0006m\u0002c\u0002\u000f\u0002>\u0005\u0005\u0013QJ\u0005\u0004\u0003\u007fi\"A\u0002+va2,'\u0007\u0005\u0004\u0002&\u0005\r\u0013qI\u0005\u0005\u0003\u000b\n\u0019DA\u0002TKF\u00042\u0001KA%\u0013\r\tYE\u0004\u0002\n\u0015\u0012L7\u000b\u001e:j]\u001e\u0004R!!\n\u0002DuDa!!\u0015\f\u0001\u0004\u0019\u0016\u0001\u00034sC6,'+\u001a4\t\u000f\u0005M1\u00021\u0001\u0002\u0016\u0005yQ\u000f\u001d3bi\u00164\u0016M]5bE2,7\u000f\u0006\u0004\u0002Z\u0005\u0005\u00141\u000e\t\u0005Qm\fY\u0006E\u0002\u001d\u0003;J1!a\u0018\u001e\u0005\u0011)f.\u001b;\t\u000f\u0005\rD\u00021\u0001\u0002f\u0005ia/\u0019:jC\ndW-\u0011:sCf\u00042\u0001KA4\u0013\r\tIG\u0004\u0002\t\u0015\u0012L\u0017I\u001d:bs\")!\u000b\u0004a\u0001'\u0002")
public class ScalaEvaluator {
    private final ExpressionCompiler compiler;
    private final Logger logger;
    private final boolean testMode;

    public Try<Value> evaluate(CompiledExpression expression, JdiFrame frame) {
        CompiledExpression compiledExpression = expression;
        if (compiledExpression == null) {
            throw new MatchError((Object)compiledExpression);
        }
        Path classDir = compiledExpression.classDir();
        String className = compiledExpression.className();
        Tuple2 tuple2 = new Tuple2((Object)classDir, (Object)className);
        Path classDir2 = (Path)tuple2._1();
        String className2 = (String)tuple2._2();
        return this.evaluate(classDir2, className2, frame);
    }

    public Try<CompiledExpression> compile(String sourceContent, String expression, JdiFrame frame) {
        String className;
        this.logger.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(23).append("Compiling expression '").append(expression).append("'").toString());
        Location location = frame.current().location();
        int line = location.lineNumber();
        String fqcn = location.declaringType().name();
        String string = className = (String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(fqcn), '.')));
        String string2 = fqcn;
        String packageName = !(string != null ? !string.equals(string2) : string2 != null) ? "" : StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(fqcn), new StringBuilder(1).append(".").append(className).toString());
        String randomId = UUID.randomUUID().toString().replace("-", "");
        Path outDir = Files.createTempDirectory(new StringBuilder(20).append("scala-debug-adapter-").append(randomId).toString(), new FileAttribute[0]);
        String expressionClassName = new StringBuilder(10).append("Expression").append(randomId).toString();
        String fileName = (String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(location.sourcePath()), '/')), (Function1 & Serializable)x$2 -> StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(x$2), '\\'), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(String.class))));
        Path sourceFile = Files.createFile(outDir.resolve(fileName), new FileAttribute[0]);
        Files.write(sourceFile, sourceContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        String expressionFqcn = packageName.isEmpty() ? expressionClassName : new StringBuilder(1).append(packageName).append(".").append(expressionClassName).toString();
        Safe compiledExpression = frame.classLoader().flatMap((Function1 & Serializable)classLoader -> this.extractValuesAndNames(frame, (JdiClassLoader)classLoader).withFilter((Function1<Tuple2<Seq<JdiString>, Seq<JdiValue>>, Object>)(Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ScalaEvaluator.$anonfun$compile$5(check$ifrefutable$1))).map((Function1 & Serializable)x$5 -> {
            Tuple2 tuple2 = x$5;
            if (tuple2 != null) {
                Seq names = (Seq)tuple2._1();
                Set localNames = ((IterableOnceOps)names.map((Function1 & Serializable)x$3 -> x$3.stringValue())).toSet();
                return new Tuple2((Object)tuple2, (Object)localNames);
            }
            throw new MatchError((Object)tuple2);
        }).flatMap((Function1 & Serializable)x$7 -> {
            Tuple2 tuple2 = x$7;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                Set localNames = (Set)tuple2._2();
                if (tuple22 != null) {
                    return package$.MODULE$.TryToSafe($this.compiler.compile(outDir, expressionClassName, sourceFile, line, expression, (Set<String>)localNames, packageName, $this.testMode)).toSafe().map((Function1 & Serializable)x$6 -> {
                        BoxedUnit boxedUnit = x$6;
                        return new CompiledExpression(outDir, expressionFqcn);
                    });
                }
            }
            throw new MatchError((Object)tuple2);
        }));
        return compiledExpression.getResult();
    }

    private Try<Value> evaluate(Path classDir, String className, JdiFrame frame) {
        Safe evaluatedValue = frame.classLoader().flatMap((Function1 & Serializable)classLoader -> this.extractValuesAndNames(frame, (JdiClassLoader)classLoader).withFilter((Function1<Tuple2<Seq<JdiString>, Seq<JdiValue>>, Object>)(Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)ScalaEvaluator.$anonfun$evaluate$2(check$ifrefutable$2))).flatMap((Function1 & Serializable)x$10 -> {
            Tuple2 tuple2 = x$10;
            if (tuple2 != null) {
                Seq names = (Seq)tuple2._1();
                Seq values = (Seq)tuple2._2();
                return classLoader.createArray("java.lang.String", (Seq<JdiValue>)names).flatMap((Function1 & Serializable)namesArray -> classLoader.createArray("java.lang.Object", (Seq<JdiValue>)values).map((Function1 & Serializable)valuesArray -> {
                    .colon.colon args2 = new .colon.colon(namesArray, (List)new .colon.colon(valuesArray, (List)Nil$.MODULE$));
                    return new Tuple2(valuesArray, (Object)args2);
                }).flatMap((Function1 & Serializable)x$9 -> {
                    Tuple2 tuple2 = x$9;
                    if (tuple2 != null) {
                        JdiArray valuesArray = (JdiArray)tuple2._1();
                        List args2 = (List)tuple2._2();
                        return this.createExpressionInstance((JdiClassLoader)classLoader, classDir, className, (List<JdiObject>)args2).flatMap((Function1 & Serializable)expressionInstance -> this.evaluateExpression((JdiObject)expressionInstance).flatMap((Function1 & Serializable)evaluatedValue -> this.updateVariables(valuesArray, frame).flatMap((Function1 & Serializable)x$8 -> {
                            BoxedUnit boxedUnit = x$8;
                            return evaluatedValue.unboxIfPrimitive().map((Function1 & Serializable)unboxedValue -> unboxedValue.value());
                        })));
                    }
                    throw new MatchError((Object)tuple2);
                }));
            }
            throw new MatchError((Object)tuple2);
        }));
        return evaluatedValue.getResult();
    }

    private Safe<JdiValue> evaluateExpression(JdiObject expressionInstance) {
        return expressionInstance.invoke("evaluate", (Seq<JdiValue>)Nil$.MODULE$).recover(new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof MethodInvocationFailed) {
                    MethodInvocationFailed methodInvocationFailed = (MethodInvocationFailed)A1;
                    JdiObject exception = methodInvocationFailed.remoteException();
                    return (B1)exception;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return throwable instanceof MethodInvocationFailed;
            }
        });
    }

    private Safe<JdiObject> createExpressionInstance(JdiClassLoader classLoader, Path classDir, String className, List<JdiObject> args2) {
        String expressionClassPath = classDir.toUri().toString();
        return classLoader.createChildLoader(classDir).flatMap((Function1 & Serializable)expressionClassLoader -> expressionClassLoader.loadClass(className).flatMap((Function1 & Serializable)expressionClass -> expressionClass.newInstance((Seq<JdiValue>)args2).map((Function1 & Serializable)expressionInstance -> expressionInstance)));
    }

    private Safe<Tuple2<Seq<JdiString>, Seq<JdiValue>>> extractValuesAndNames(JdiFrame frameRef, JdiClassLoader classLoader) {
        return ScalaEvaluator.extractVariablesFromFrame$1(frameRef, classLoader).withFilter((Function1 & Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)ScalaEvaluator.$anonfun$extractValuesAndNames$14(check$ifrefutable$3))).flatMap((Function1 & Serializable)x$18 -> {
            Tuple2 tuple2 = x$18;
            if (tuple2 != null) {
                Seq variableNames = (Seq)tuple2._1();
                Seq variableValues = (Seq)tuple2._2();
                return ((Safe)frameRef.thisObject().filter((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)ScalaEvaluator.$anonfun$extractValuesAndNames$16(this, x$16))).map((Function1 & Serializable)thisObject -> ScalaEvaluator.extractFields$1(thisObject, classLoader)).getOrElse((Function0 & Serializable)() -> Safe$.MODULE$.apply((Function0 & Serializable)() -> new Tuple2((Object)Nil$.MODULE$, (Object)Nil$.MODULE$)))).withFilter((Function1 & Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)ScalaEvaluator.$anonfun$extractValuesAndNames$20(check$ifrefutable$4))).map((Function1 & Serializable)x$17 -> {
                    Tuple2 tuple2 = x$17;
                    if (tuple2 != null) {
                        Seq fieldNames = (Seq)tuple2._1();
                        Seq fieldValues = (Seq)tuple2._2();
                        Seq names = (Seq)variableNames.$plus$plus((IterableOnce)fieldNames);
                        Seq values = (Seq)variableValues.$plus$plus((IterableOnce)fieldValues);
                        return new Tuple2((Object)names, (Object)values);
                    }
                    throw new MatchError((Object)tuple2);
                });
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private Safe<BoxedUnit> updateVariables(JdiArray variableArray, JdiFrame frame) {
        return package$.MODULE$.SafeSeq((Seq)((IterableOps)frame.variables().zip(variableArray.getValues())).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                LocalVariable variable = (LocalVariable)tuple2._1();
                JdiValue value = (JdiValue)tuple2._2();
                if (variable.type() instanceof PrimitiveType) {
                    return value.unboxIfPrimitive();
                }
            }
            if (tuple2 != null) {
                JdiValue value = (JdiValue)tuple2._2();
                return Safe$.MODULE$.apply((Function0 & Serializable)() -> value);
            }
            throw new MatchError((Object)tuple2);
        })).traverse().map((Function1 & Serializable)values -> {
            ScalaEvaluator.$anonfun$updateVariables$3(frame, values);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$compile$5(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$evaluate$2(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$extractValuesAndNames$2(Seq localVariables$1, JdiObject x$11) {
        return !localVariables$1.contains((Object)"$this");
    }

    private static final Safe extractVariablesFromFrame$1(JdiFrame frameRef$1, JdiClassLoader classLoader$2) {
        Seq localVariables = (Seq)frameRef$1.variablesAndValues().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                LocalVariable variable = (LocalVariable)tuple2._1();
                JdiValue value = (JdiValue)tuple2._2();
                return new Tuple2((Object)variable.name(), (Object)value);
            }
            throw new MatchError((Object)tuple2);
        });
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"$this");
        Option thisObject = frameRef$1.thisObject().filter((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)ScalaEvaluator.$anonfun$extractValuesAndNames$2(localVariables, x$11))).map((Function1 & Serializable)y -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, y));
        return package$.MODULE$.SafeSeq(((Seq)((IterableOps)localVariables.$plus$plus((IterableOnce)thisObject)).map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String name2 = (String)tuple2._1();
                JdiValue value = (JdiValue)tuple2._2();
                return classLoader$2.mirrorOf(name2).flatMap((Function1 & Serializable)name -> classLoader$2.boxIfPrimitive(value).map((Function1 & Serializable)value -> new Tuple2(name, value)));
            }
            throw new MatchError((Object)tuple2);
        })).toSeq()).traverse().map((Function1 & Serializable)xs -> new Tuple2(xs.map((Function1 & Serializable)x$12 -> (JdiString)x$12._1()), xs.map((Function1 & Serializable)x$13 -> (JdiValue)x$13._2())));
    }

    private static final Safe extractFields$1(JdiObject thisObject, JdiClassLoader classLoader$2) {
        Seq<Tuple2<String, JdiValue>> fields = thisObject.fields();
        Safe names = package$.MODULE$.SafeSeq((Seq)((IterableOps)fields.map((Function1 & Serializable)x$14 -> (String)x$14._1())).map((Function1 & Serializable)str -> classLoader$2.mirrorOf((String)str))).traverse();
        Safe values = package$.MODULE$.SafeSeq((Seq)((IterableOps)fields.map((Function1 & Serializable)x$15 -> (JdiValue)x$15._2())).map((Function1 & Serializable)value -> classLoader$2.boxIfPrimitive((JdiValue)value))).traverse();
        return Safe$.MODULE$.join(names, values);
    }

    public static final /* synthetic */ boolean $anonfun$extractValuesAndNames$14(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$extractValuesAndNames$16(ScalaEvaluator $this, JdiObject x$16) {
        return $this.compiler.scalaVersion().isScala2();
    }

    public static final /* synthetic */ boolean $anonfun$extractValuesAndNames$20(Tuple2 check$ifrefutable$4) {
        Tuple2 tuple2 = check$ifrefutable$4;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$updateVariables$4(JdiFrame frame$3, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            LocalVariable variable = (LocalVariable)tuple2._1();
            JdiValue value = (JdiValue)tuple2._2();
            frame$3.setVariable(variable, value);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$updateVariables$3(JdiFrame frame$3, Seq values) {
        ((IterableOnceOps)frame$3.variables().zip((IterableOnce)values)).foreach((Function1 & Serializable)x0$2 -> {
            ScalaEvaluator.$anonfun$updateVariables$4(frame$3, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    public ScalaEvaluator(ClassEntry entry, ExpressionCompiler compiler, Logger logger, boolean testMode) {
        this.compiler = compiler;
        this.logger = logger;
        this.testMode = testMode;
    }
}

