/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.scala.debugadapter.internal;

import ch.epfl.scala.debugadapter.ClassEntry;
import ch.epfl.scala.debugadapter.ClassSystem;
import ch.epfl.scala.debugadapter.Logger;
import ch.epfl.scala.debugadapter.SourceDirectory;
import ch.epfl.scala.debugadapter.SourceEntry;
import ch.epfl.scala.debugadapter.SourceJar;
import ch.epfl.scala.debugadapter.StandaloneSourceFile;
import ch.epfl.scala.debugadapter.internal.ClassEntryLookUp;
import ch.epfl.scala.debugadapter.internal.ClassFile;
import ch.epfl.scala.debugadapter.internal.IO$;
import ch.epfl.scala.debugadapter.internal.ScalaExtension$;
import ch.epfl.scala.debugadapter.internal.SourceEntryLookUp;
import ch.epfl.scala.debugadapter.internal.SourceEntryLookUp$;
import ch.epfl.scala.debugadapter.internal.SourceFile;
import ch.epfl.scala.debugadapter.internal.SourceFileKey;
import ch.epfl.scala.debugadapter.internal.SourceFileKey$;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;
import scala.util.matching.Regex$;

public final class ClassEntryLookUp$ {
    public static final ClassEntryLookUp$ MODULE$ = new ClassEntryLookUp$();

    public ClassEntryLookUp apply(ClassEntry entry, Logger logger) {
        Seq sourceLookUps = (Seq)entry.sourceEntries().flatMap((Function1 & Serializable)x$10 -> SourceEntryLookUp$.MODULE$.apply((SourceEntry)x$10, logger));
        return this.apply(entry, (Seq<SourceEntryLookUp>)sourceLookUps, logger);
    }

    public ClassEntryLookUp apply(ClassEntry entry, Seq<SourceEntryLookUp> sourceLookUps, Logger logger) {
        Seq classFiles = (Seq)entry.classSystems().flatMap((Function1 & Serializable)classSystem -> (Vector)ScalaExtension$.MODULE$.TryExtension(classSystem.within((Function2 & Serializable)(fileSystem, root) -> MODULE$.readAllClassFiles((ClassSystem)classSystem, (FileSystem)fileSystem, (Path)root))).warnFailure(logger, new StringBuilder(31).append("Cannot list the class files in ").append(classSystem.name()).toString()).getOrElse((Function0 & Serializable)() -> package$.MODULE$.Vector().empty()));
        Map classNameToClassFile = ((IterableOnceOps)classFiles.map((Function1 & Serializable)c -> new Tuple2((Object)c.fullyQualifiedName(), c))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Map sourceFileToRoot = ((IterableOnceOps)sourceLookUps.flatMap((Function1 & Serializable)l -> (Seq)l.sourceFiles().map((Function1 & Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(f), (Object)l.root())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Map sourceUriToSourceFile = ((IterableOnceOps)((IterableOps)sourceLookUps.flatMap((Function1 & Serializable)x$11 -> x$11.sourceFiles())).map((Function1 & Serializable)f -> new Tuple2((Object)SourceFileKey$.MODULE$.apply(f.uri()), f))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Map sourceNameToSourceFile = ((IterableOps)sourceLookUps.flatMap((Function1 & Serializable)x$12 -> x$12.sourceFiles())).groupBy((Function1 & Serializable)f -> f.fileName());
        scala.collection.mutable.Map classNameToSourceFile = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        scala.collection.mutable.Map sourceUriToClassFiles = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        Buffer orphanClassFiles = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Buffer missingSourceFileClassFiles = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        classFiles.foreach((Function1 & Serializable)classFile -> {
            Option option;
            List list = ((IterableOnceOps)classFile.sourceName().flatMap((Function1 & Serializable)key -> sourceNameToSourceFile.get(key)).getOrElse((Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().empty())).toList();
            if (Nil$.MODULE$.equals(list)) {
                return missingSourceFileClassFiles.append(classFile);
            }
            if (list instanceof .colon.colon) {
                .colon.colon colon2 = (.colon.colon)list;
                SourceFile sourceFile = (SourceFile)colon2.head();
                List list2 = colon2.next$access$1();
                if (Nil$.MODULE$.equals(list2)) {
                    ClassEntryLookUp$.recordSourceFile$1(sourceFile, classNameToSourceFile, classFile, sourceUriToClassFiles);
                    return BoxedUnit.UNIT;
                }
            }
            if ((option = list.find((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)ClassEntryLookUp$.$anonfun$apply$16(classFile, f)))) instanceof Some) {
                Some some = (Some)option;
                SourceFile sourceFile = (SourceFile)some.value();
                ClassEntryLookUp$.recordSourceFile$1(sourceFile, classNameToSourceFile, classFile, sourceUriToClassFiles);
                return BoxedUnit.UNIT;
            }
            if (None$.MODULE$.equals(option)) {
                Option option2 = list.filter((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)ClassEntryLookUp$.$anonfun$apply$17(x$13))).find((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)ClassEntryLookUp$.$anonfun$apply$18(classFile, f)));
                if (option2 instanceof Some) {
                    Some some = (Some)option2;
                    SourceFile sourceFile = (SourceFile)some.value();
                    ClassEntryLookUp$.recordSourceFile$1(sourceFile, classNameToSourceFile, classFile, sourceUriToClassFiles);
                    return BoxedUnit.UNIT;
                }
                if (None$.MODULE$.equals(option2)) {
                    List list3 = list.filter((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)ClassEntryLookUp$.MODULE$.findPackage(f, (Path)sourceFileToRoot.apply((Object)f), classFile.fullPackage(), logger)));
                    if (list3 instanceof .colon.colon) {
                        .colon.colon colon3 = (.colon.colon)list3;
                        SourceFile sourceFile = (SourceFile)colon3.head();
                        List list4 = colon3.next$access$1();
                        if (Nil$.MODULE$.equals(list4)) {
                            ClassEntryLookUp$.recordSourceFile$1(sourceFile, classNameToSourceFile, classFile, sourceUriToClassFiles);
                            return BoxedUnit.UNIT;
                        }
                    }
                    return orphanClassFiles.append(classFile);
                }
                throw new MatchError((Object)option2);
            }
            throw new MatchError((Object)option);
        });
        if (orphanClassFiles.size() > 0) {
            logger.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(29).append("Found ").append(orphanClassFiles.size()).append(" orphan class files in ").append(entry.name()).toString());
        }
        sourceLookUps.foreach((Function1 & Serializable)x$14 -> {
            x$14.close();
            return BoxedUnit.UNIT;
        });
        return new ClassEntryLookUp(entry, (Map<String, ClassFile>)classNameToClassFile, (Map<SourceFileKey, SourceFile>)sourceUriToSourceFile, (Map<SourceFileKey, Seq<ClassFile>>)sourceUriToClassFiles.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Map<String, SourceFile>)classNameToSourceFile.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Seq<ClassFile>)missingSourceFileClassFiles.toSeq(), (Seq<ClassFile>)orphanClassFiles.toSeq(), logger);
    }

    private Vector<ClassFile> readAllClassFiles(ClassSystem classSystem, FileSystem fileSystem, Path root) {
        if (Files.exists(root, new LinkOption[0])) {
            PathMatcher classMatcher = fileSystem.getPathMatcher("glob:**.class");
            return CollectionConverters$.MODULE$.IteratorHasAsScala(Files.walk(root, new FileVisitOption[0]).filter(x$1 -> classMatcher.matches((Path)x$1)).iterator()).asScala().map((Function1 & Serializable)path -> MODULE$.readClassFile(classSystem, root, (Path)path)).toVector();
        }
        return package$.MODULE$.Vector().empty();
    }

    private ClassFile readClassFile(ClassSystem classSystem, Path root, Path path) {
        ClassFile classFile;
        BooleanRef isValueClass = BooleanRef.create((boolean)false);
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            ClassReader reader = new ClassReader(inputStream);
            String fullyQualifiedName = reader.getClassName().replace('/', '.');
            ObjectRef sourceName = ObjectRef.create((Object)Option$.MODULE$.empty());
            ClassVisitor visitor = new ClassVisitor(sourceName, isValueClass){
                private final ObjectRef sourceName$1;
                private final BooleanRef isValueClass$1;

                public void visitSource(String source, String debug) {
                    this.sourceName$1.elem = Option$.MODULE$.apply((Object)source);
                }

                public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                    block0: {
                        if (!this.isStatic(access) || !name.endsWith("$extension")) break block0;
                        this.isValueClass$1.elem = true;
                    }
                    return super.visitMethod(access, name, descriptor, signature, exceptions);
                }

                private boolean isStatic(int access) {
                    return (access & 8) != 0;
                }
                {
                    this.sourceName$1 = sourceName$1;
                    this.isValueClass$1 = isValueClass$1;
                    super(589824);
                }
            };
            reader.accept(visitor, 0);
            Path relativePath = root.relativize(path);
            classFile = new ClassFile(fullyQualifiedName, (Option<String>)((Option)sourceName.elem), ((Object)relativePath).toString(), isValueClass.elem, classSystem);
        }
        return classFile;
    }

    private boolean findPackage(SourceFile sourceFile, Path root, String fullPackage, Logger logger) {
        Seq nestedPackages = (Seq)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(fullPackage), '.')), (Object)package$.MODULE$.Seq().empty(), (Function2 & Serializable)(nestedParts, newPart) -> (Seq)((SeqOps)nestedParts.map((Function1 & Serializable)outer -> new StringBuilder(1).append((String)outer).append(".").append((String)newPart).toString())).$colon$plus(newPart));
        Option<String> sourceContent = this.readSourceContent(sourceFile, root, logger);
        return nestedPackages.exists((Function1 & Serializable)string -> BoxesRunTime.boxToBoolean((boolean)ClassEntryLookUp$.$anonfun$findPackage$3(sourceContent, string)));
    }

    public Option<String> ch$epfl$scala$debugadapter$internal$ClassEntryLookUp$$readSourceContent(SourceFile sourceFile, Logger logger) {
        return ScalaExtension$.MODULE$.TryExtension(this.withinSourceEntry(sourceFile.entry(), (Function1 & Serializable)x$16 -> MODULE$.readSourceContent(sourceFile, (Path)x$16, logger))).warnFailure(logger, new StringBuilder(23).append("Cannot read content of ").append(sourceFile.uri()).toString()).flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private Option<String> readSourceContent(SourceFile sourceFile, Path root, Logger logger) {
        return ScalaExtension$.MODULE$.TryExtension(Try$.MODULE$.apply((Function0 & Serializable)() -> {
            Path sourcePath = root.resolve(sourceFile.relativePath());
            return new String(Files.readAllBytes(sourcePath));
        })).warnFailure(logger, new StringBuilder(23).append("Cannot read content of ").append(sourceFile.uri()).toString());
    }

    private <T> Try<T> withinSourceEntry(SourceEntry sourceEntry, Function1<Path, T> f) {
        SourceEntry sourceEntry2 = sourceEntry;
        if (sourceEntry2 instanceof SourceJar) {
            SourceJar sourceJar = (SourceJar)sourceEntry2;
            Path jar = sourceJar.jar();
            return IO$.MODULE$.withinJarFile(jar, (Function1 & Serializable)fs -> f.apply((Object)fs.getPath("/", new String[0])));
        }
        if (sourceEntry2 instanceof SourceDirectory) {
            SourceDirectory sourceDirectory = (SourceDirectory)sourceEntry2;
            Path dir = sourceDirectory.directory();
            return Try$.MODULE$.apply((Function0 & Serializable)() -> f.apply((Object)dir));
        }
        if (sourceEntry2 instanceof StandaloneSourceFile) {
            StandaloneSourceFile standaloneSourceFile = (StandaloneSourceFile)sourceEntry2;
            Path absolutePath = standaloneSourceFile.absolutePath();
            return Try$.MODULE$.apply((Function0 & Serializable)() -> f.apply((Object)absolutePath.getParent()));
        }
        throw new MatchError((Object)sourceEntry2);
    }

    private static final void recordSourceFile$1(SourceFile sourceFile, scala.collection.mutable.Map classNameToSourceFile$1, ClassFile classFile$2, scala.collection.mutable.Map sourceUriToClassFiles$1) {
        classNameToSourceFile$1.put((Object)classFile$2.fullyQualifiedName(), (Object)sourceFile);
        sourceUriToClassFiles$1.update((Object)SourceFileKey$.MODULE$.apply(sourceFile.uri()), ((SeqOps)sourceUriToClassFiles$1.getOrElse((Object)SourceFileKey$.MODULE$.apply(sourceFile.uri()), (Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().empty())).$colon$plus((Object)classFile$2));
    }

    public static final /* synthetic */ boolean $anonfun$apply$16(ClassFile classFile$2, SourceFile f) {
        String string = f.folderPath();
        String string2 = classFile$2.folderPath();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$apply$17(SourceFile x$13) {
        return x$13.folderPath().contains("src/");
    }

    public static final /* synthetic */ boolean $anonfun$apply$18(ClassFile classFile$2, SourceFile f) {
        Object object = ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])f.folderPath().split("src/")));
        String string = classFile$2.fullPackageAsPath();
        return !(object != null ? !object.equals(string) : string != null);
    }

    public static final /* synthetic */ boolean $anonfun$findPackage$4(Regex matcher$1, String x$15) {
        return matcher$1.findFirstIn((CharSequence)x$15).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$findPackage$3(Option sourceContent$1, String string) {
        String quotedPackage = Regex$.MODULE$.quote(string);
        Regex matcher = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(new StringBuilder(34).append("package\\s+(object\\s+)?").append(quotedPackage).append("(\\{|:|;|\\s+)").toString()));
        return sourceContent$1.exists((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)ClassEntryLookUp$.$anonfun$findPackage$4(matcher, x$15)));
    }

    private ClassEntryLookUp$() {
    }
}

