/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.scala.debugadapter.internal.evaluator;

import ch.epfl.scala.debugadapter.Logger;
import ch.epfl.scala.debugadapter.internal.evaluator.JdiFrame;
import ch.epfl.scala.debugadapter.internal.evaluator.JdiValue$;
import ch.epfl.scala.debugadapter.internal.evaluator.LocalValue;
import ch.epfl.scala.debugadapter.internal.evaluator.NameTransformer$;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Value;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005E4A\u0001C\u0005\u0001-!AA\u0004\u0001B\u0001B\u0003%Q\u0004\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003#\u0011\u0015)\u0003\u0001\"\u0001'\u0011\u0015Y\u0003\u0001\"\u0001-\u0011\u0015)\u0005\u0001\"\u0001G\u0011\u0015Q\u0006\u0001\"\u0003\\\u0011\u0015y\u0006\u0001\"\u0003a\u0005=\u0019\u0016.\u001c9mK\u00163\u0018\r\\;bi>\u0014(B\u0001\u0006\f\u0003%)g/\u00197vCR|'O\u0003\u0002\r\u001b\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\u000f\u001f\u0005aA-\u001a2vO\u0006$\u0017\r\u001d;fe*\u0011\u0001#E\u0001\u0006g\u000e\fG.\u0019\u0006\u0003%M\tA!\u001a9gY*\tA#\u0001\u0002dQ\u000e\u00011C\u0001\u0001\u0018!\tA\"$D\u0001\u001a\u0015\u0005\u0001\u0012BA\u000e\u001a\u0005\u0019\te.\u001f*fM\u00061An\\4hKJ\u0004\"AH\u0010\u000e\u00035I!\u0001I\u0007\u0003\r1{wmZ3s\u0003!!Xm\u001d;N_\u0012,\u0007C\u0001\r$\u0013\t!\u0013DA\u0004C_>dW-\u00198\u0002\rqJg.\u001b;?)\r9\u0013F\u000b\t\u0003Q\u0001i\u0011!\u0003\u0005\u00069\r\u0001\r!\b\u0005\u0006C\r\u0001\rAI\u0001\baJ,\u0007/\u0019:f)\ri3\u0007\u0011\t\u000419\u0002\u0014BA\u0018\u001a\u0005\u0019y\u0005\u000f^5p]B\u0011\u0001&M\u0005\u0003e%\u0011!\u0002T8dC24\u0016\r\\;f\u0011\u0015!D\u00011\u00016\u0003))\u0007\u0010\u001d:fgNLwN\u001c\t\u0003mur!aN\u001e\u0011\u0005aJR\"A\u001d\u000b\u0005i*\u0012A\u0002\u001fs_>$h(\u0003\u0002=3\u00051\u0001K]3eK\u001aL!AP \u0003\rM#(/\u001b8h\u0015\ta\u0014\u0004C\u0003B\t\u0001\u0007!)A\u0003ge\u0006lW\r\u0005\u0002)\u0007&\u0011A)\u0003\u0002\t\u0015\u0012LgI]1nK\u0006AQM^1mk\u0006$X\rF\u0002H/f\u00032\u0001S&N\u001b\u0005I%B\u0001&\u001a\u0003\u0011)H/\u001b7\n\u00051K%a\u0001+ssB\u0011a*V\u0007\u0002\u001f*\u0011\u0001+U\u0001\u0004U\u0012L'B\u0001*T\u0003\r\u0019XO\u001c\u0006\u0002)\u0006\u00191m\\7\n\u0005Y{%!\u0002,bYV,\u0007\"\u0002-\u0006\u0001\u0004\u0001\u0014A\u00037pG\u0006dg+\u00197vK\")\u0011)\u0002a\u0001\u0005\u0006y\u0011n\u001d'pG\u0006dg+\u0019:jC\ndW\rF\u0002#9vCQ!\u0011\u0004A\u0002\tCQA\u0018\u0004A\u0002U\nAA\\1nK\u0006YA\u000f\u001b:po>\u0013x+\u0019:o)\r\tGM\u001a\t\u00031\tL!aY\r\u0003\tUs\u0017\u000e\u001e\u0005\u0006K\u001e\u0001\r!N\u0001\u0004[N<\u0007\"B4\b\u0001\u0004A\u0017!\u0003;ie><\u0018M\u00197f!\tIgN\u0004\u0002kY:\u0011\u0001h[\u0005\u0002!%\u0011Q.G\u0001\ba\u0006\u001c7.Y4f\u0013\ty\u0007OA\u0005UQJ|w/\u00192mK*\u0011Q.\u0007")
public class SimpleEvaluator {
    private final Logger logger;
    private final boolean testMode;

    public Option<LocalValue> prepare(String expression, JdiFrame frame) {
        String encodedExpression = NameTransformer$.MODULE$.encode(expression);
        if (this.isLocalVariable(frame, encodedExpression)) {
            return new Some((Object)new LocalValue(encodedExpression));
        }
        return None$.MODULE$;
    }

    public Try<Value> evaluate(LocalValue localValue, JdiFrame frame) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            StackFrame currentFrame = frame.current();
            LocalVariable variable = currentFrame.visibleVariableByName(localValue.name());
            Value rawValue = currentFrame.getValue(variable);
            return JdiValue$.MODULE$.apply(rawValue, frame.thread()).derefIfRef().value();
        });
    }

    private boolean isLocalVariable(JdiFrame frame, String name) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> CollectionConverters$.MODULE$.ListHasAsScala(frame.current().visibleVariables()).asScala().toList());
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            List localVariables = (List)success.value();
            return localVariables.find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SimpleEvaluator.$anonfun$isLocalVariable$2(name, x$1))).exists((Function1 & Serializable)v -> BoxesRunTime.boxToBoolean((boolean)SimpleEvaluator.$anonfun$isLocalVariable$3(v)));
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            this.throwOrWarn("Cannot get local variables", exception);
            return false;
        }
        throw new MatchError((Object)try_);
    }

    private void throwOrWarn(String msg, Throwable throwable) {
        String message = new StringBuilder(11).append(msg).append(" because ").append(throwable.getClass().getSimpleName()).append(": ").append(throwable.getMessage()).toString();
        if (this.testMode) {
            throw new Exception(message, throwable);
        }
        this.logger.warn((Function0<String>)(Function0 & Serializable)() -> message);
    }

    public static final /* synthetic */ boolean $anonfun$isLocalVariable$2(String name$1, LocalVariable x$1) {
        String string = x$1.name();
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$isLocalVariable$3(LocalVariable v) {
        if (!v.isArgument()) return true;
        String string = v.typeName();
        String string2 = "scala.Function0";
        if (string == null) {
            if (string2 == null) return false;
            return true;
        } else if (string.equals(string2)) return false;
        return true;
    }

    public SimpleEvaluator(Logger logger, boolean testMode) {
        this.logger = logger;
        this.testMode = testMode;
    }
}

