/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.scala.debugadapter.internal;

import ch.epfl.scala.debugadapter.Logger;
import ch.epfl.scala.debugadapter.SourceDirectory;
import ch.epfl.scala.debugadapter.SourceEntry;
import ch.epfl.scala.debugadapter.SourceJar;
import ch.epfl.scala.debugadapter.StandaloneSourceFile;
import ch.epfl.scala.debugadapter.internal.IO$;
import ch.epfl.scala.debugadapter.internal.ScalaExtension$;
import ch.epfl.scala.debugadapter.internal.SourceEntryLookUp;
import ch.epfl.scala.debugadapter.internal.SourceFile;
import java.io.Serializable;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;

public final class SourceEntryLookUp$
implements Serializable {
    public static final SourceEntryLookUp$ MODULE$ = new SourceEntryLookUp$();

    public Option<SourceEntryLookUp> apply(SourceEntry entry, Logger logger) {
        SourceEntry sourceEntry = entry;
        if (sourceEntry instanceof SourceJar) {
            SourceJar sourceJar = (SourceJar)sourceEntry;
            Path jar = sourceJar.jar();
            return ScalaExtension$.MODULE$.TryExtension(IO$.MODULE$.getJarFileSystem(jar).map((Function1 & Serializable)fs -> {
                Path root = fs.getPath("/", new String[0]);
                Vector sourceFiles = MODULE$.getAllSourceFiles(entry, (FileSystem)fs, root).toVector();
                return new SourceEntryLookUp(entry, (Seq<SourceFile>)sourceFiles, (FileSystem)fs, root);
            })).warnFailure(logger, new StringBuilder(32).append("Cannot list the source files in ").append(entry.name()).toString());
        }
        if (sourceEntry instanceof SourceDirectory) {
            SourceDirectory sourceDirectory = (SourceDirectory)sourceEntry;
            Path directory = sourceDirectory.directory();
            FileSystem fs2 = FileSystems.getDefault();
            Vector sourceFiles = this.getAllSourceFiles(entry, fs2, directory).toVector();
            return new Some((Object)new SourceEntryLookUp(entry, (Seq<SourceFile>)sourceFiles, fs2, directory));
        }
        if (sourceEntry instanceof StandaloneSourceFile) {
            StandaloneSourceFile standaloneSourceFile = (StandaloneSourceFile)sourceEntry;
            Path absolutePath = standaloneSourceFile.absolutePath();
            String relativePath = standaloneSourceFile.relativePath();
            FileSystem fs3 = FileSystems.getDefault();
            SourceFile sourceFile = new SourceFile(entry, relativePath, absolutePath.toUri());
            Path root = fs3.getPath(sourceFile.folderPath(), new String[0]);
            return new Some((Object)new SourceEntryLookUp(entry, (Seq<SourceFile>)new .colon.colon((Object)sourceFile, (List)Nil$.MODULE$), FileSystems.getDefault(), root));
        }
        throw new MatchError((Object)sourceEntry);
    }

    private Iterator<SourceFile> getAllSourceFiles(SourceEntry entry, FileSystem fileSystem, Path root) {
        if (Files.exists(root, new LinkOption[0])) {
            PathMatcher sourceMatcher = fileSystem.getPathMatcher("glob:**.{scala,java}");
            return CollectionConverters$.MODULE$.IteratorHasAsScala(Files.walk(root, new FileVisitOption[0]).filter(x$1 -> sourceMatcher.matches((Path)x$1)).iterator()).asScala().map((Function1 & Serializable)path -> {
                String relativePath = ((Object)root.relativize((Path)path)).toString().replace('\\', '/');
                return new SourceFile(entry, relativePath, path.toUri());
            });
        }
        return package$.MODULE$.Iterator().empty();
    }

    public SourceEntryLookUp apply(SourceEntry entry, Seq<SourceFile> sourceFiles, FileSystem fileSystem, Path root) {
        return new SourceEntryLookUp(entry, sourceFiles, fileSystem, root);
    }

    public Option<Tuple4<SourceEntry, Seq<SourceFile>, FileSystem, Path>> unapply(SourceEntryLookUp x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple4((Object)x$0.entry(), x$0.sourceFiles(), (Object)x$0.fileSystem(), (Object)x$0.root()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SourceEntryLookUp$.class);
    }

    private SourceEntryLookUp$() {
    }
}

