/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.scala.debugadapter.internal.stacktrace;

import ch.epfl.scala.debugadapter.Debuggee;
import ch.epfl.scala.debugadapter.Logger;
import ch.epfl.scala.debugadapter.ScalaVersion;
import ch.epfl.scala.debugadapter.internal.ByteCode$;
import ch.epfl.scala.debugadapter.internal.DebugTools;
import ch.epfl.scala.debugadapter.internal.stacktrace.ScalaDecoder$;
import ch.epfl.scala.debugadapter.internal.stacktrace.StepFilter;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import java.io.Serializable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005ef!B\u0012%\u0003\u0003\t\u0004\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001f\t\u0011\u0001\u0003!\u0011!Q\u0001\n\u0005CQ\u0001\u0012\u0001\u0005\u0002\u0015CQ!\u0013\u0001\u0007\u0012)CQa\u0016\u0001\u0005\u0012aCQ\u0001\u001b\u0001\u0005\n%DQ\u0001\u001f\u0001\u0005\u0002eDQA\u001f\u0001\u0005BmDQ! \u0001\u0005\u0002yDq!!\u0001\u0001\t\u0013\t\u0019\u0001C\u0004\u0002\b\u0001!I!!\u0003\t\u000f\u0005=\u0001\u0001\"\u0003\u0002\u0012!9\u0011Q\u0004\u0001\u0005\n\u0005}\u0001bBA\u0012\u0001\u0011%\u0011Q\u0005\u0005\b\u0003S\u0001A\u0011BA\u0016\u0011\u001d\ty\u0003\u0001C\u0005\u0003cAq!!\u000e\u0001\t\u0013\t9\u0004C\u0004\u0002<\u0001!I!!\u0010\t\u000f\u0005\u0005\u0003\u0001\"\u0003\u0002D!I\u0011q\t\u0001C\u0002\u0013%\u0011\u0011\n\u0005\t\u0003#\u0002\u0001\u0015!\u0003\u0002L!9\u00111\u000b\u0001\u0005\n\u0005U\u0003bBA-\u0001\u0011%\u00111\f\u0005\b\u0003?\u0002A\u0011BA1\u0011\u001d\t)\u0007\u0001C\u0005\u0003OBq!a\u001b\u0001\t\u0013\ti\u0007C\u0004\u0002r\u0001!I!a\u001d\t\u000f\u0005]\u0004\u0001\"\u0003\u0002z!9\u0011Q\u0010\u0001\u0005\n\u0005}taBABI!\u0005\u0011Q\u0011\u0004\u0007G\u0011B\t!a\"\t\r\u0011{B\u0011AAE\u0011\u001d\tYi\bC\u0001\u0003\u001bCq!!- \t\u0013\t\u0019L\u0001\u0007TG\u0006d\u0017\rR3d_\u0012,'O\u0003\u0002&M\u0005Q1\u000f^1dWR\u0014\u0018mY3\u000b\u0005\u001dB\u0013\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005%R\u0013\u0001\u00043fEV<\u0017\rZ1qi\u0016\u0014(BA\u0016-\u0003\u0015\u00198-\u00197b\u0015\tic&\u0001\u0003fa\u001ad'\"A\u0018\u0002\u0005\rD7\u0001A\n\u0004\u0001I:\u0004CA\u001a6\u001b\u0005!$\"A\u0016\n\u0005Y\"$AB!osJ+g\r\u0005\u00029s5\tA%\u0003\u0002;I\tQ1\u000b^3q\r&dG/\u001a:\u0002\u0019M\u001c\u0017\r\\1WKJ\u001c\u0018n\u001c8\u0011\u0005urT\"\u0001\u0015\n\u0005}B#\u0001D*dC2\fg+\u001a:tS>t\u0017\u0001\u0003;fgRlu\u000eZ3\u0011\u0005M\u0012\u0015BA\"5\u0005\u001d\u0011un\u001c7fC:\fa\u0001P5oSRtDc\u0001$H\u0011B\u0011\u0001\b\u0001\u0005\u0006w\r\u0001\r\u0001\u0010\u0005\u0006\u0001\u000e\u0001\r!Q\u0001\ng.L\u0007oU2bY\u0006$\"!Q&\t\u000b1#\u0001\u0019A'\u0002\r5,G\u000f[8e!\tqU+D\u0001P\u0015\t\u0001\u0016+A\u0002kI&T!AU*\u0002\u0007M,hNC\u0001U\u0003\r\u0019w.\\\u0005\u0003->\u0013a!T3uQ>$\u0017a\u00034pe6\fGoU2bY\u0006$\"!W4\u0011\u0007MRF,\u0003\u0002\\i\t1q\n\u001d;j_:\u0004\"!\u00183\u000f\u0005y\u0013\u0007CA05\u001b\u0005\u0001'BA11\u0003\u0019a$o\\8u}%\u00111\rN\u0001\u0007!J,G-\u001a4\n\u0005\u00154'AB*ue&twM\u0003\u0002di!)A*\u0002a\u0001\u001b\u0006YA\u000f\u001b:po>\u0013x+\u0019:o)\tQW\u000e\u0005\u00024W&\u0011A\u000e\u000e\u0002\u0005+:LG\u000fC\u0003o\r\u0001\u0007q.A\u0005fq\u000e,\u0007\u000f^5p]B\u0011\u0001/\u001e\b\u0003cNt!a\u0018:\n\u0003-J!\u0001\u001e\u001b\u0002\u000fA\f7m[1hK&\u0011ao\u001e\u0002\n)\"\u0014xn^1cY\u0016T!\u0001\u001e\u001b\u0002\rI,Gn\\1e)\u0005Q\u0017AD:i_VdGmU6ja>3XM\u001d\u000b\u0003\u0003rDQ\u0001\u0014\u0005A\u00025\u000baAZ8s[\u0006$HCA-\u0000\u0011\u0015a\u0015\u00021\u0001N\u0003)1wN]7bi*\u000bg/\u0019\u000b\u00049\u0006\u0015\u0001\"\u0002'\u000b\u0001\u0004i\u0015\u0001D5t'R\fG/[2NC&tGcA!\u0002\f!1\u0011QB\u0006A\u00025\u000b\u0011!\\\u0001\u000fSN$\u0015P\\1nS\u000e\u001cE.Y:t)\r\t\u00151\u0003\u0005\b\u0003+a\u0001\u0019AA\f\u0003\r!\b/\u001a\t\u0004\u001d\u0006e\u0011bAA\u000e\u001f\ni!+\u001a4fe\u0016t7-\u001a+za\u0016\fa![:KCZ\fGcA!\u0002\"!)A*\u0004a\u0001\u001b\u0006i\u0011n]\"p]N$(/^2u_J$2!QA\u0014\u0011\u0015ae\u00021\u0001N\u0003MI7o\u0015;bi&\u001c7i\u001c8tiJ,8\r^8s)\r\t\u0015Q\u0006\u0005\u0006\u0019>\u0001\r!T\u0001\u000fSN\fen\u001c8Gk:\u001cG/[8o)\r\t\u00151\u0007\u0005\u0006\u0019B\u0001\r!T\u0001\u000fSNd\u0015N\u001a;fI6+G\u000f[8e)\r\t\u0015\u0011\b\u0005\u0006\u0019F\u0001\r!T\u0001\u0010SN\fE-\u00199uK\u0012lU\r\u001e5pIR\u0019\u0011)a\u0010\t\u000b1\u0013\u0002\u0019A'\u0002#%\u001cH*\u0019>z\u0013:LG/[1mSj,'\u000fF\u0002B\u0003\u000bBQ\u0001T\nA\u00025\u000b\u0011\u0002\\1{sRK\b/Z:\u0016\u0005\u0005-\u0003\u0003B/\u0002NqK1!a\u0014g\u0005\r\u0019V\r^\u0001\u000bY\u0006T\u0018\u0010V=qKN\u0004\u0013\u0001D5t\u0019\u0006T\u0018pR3ui\u0016\u0014HcA!\u0002X!)AJ\u0006a\u0001\u001b\u0006q\u0011n\u001d#fM\u0006,H\u000e\u001e,bYV,GcA!\u0002^!)Aj\u0006a\u0001\u001b\u0006Y\u0011n]!o_:\u001cE.Y:t)\r\t\u00151\r\u0005\b\u0003+A\u0002\u0019AA\f\u00031I7\u000fT8dC2\u001cE.Y:t)\r\t\u0015\u0011\u000e\u0005\b\u0003+I\u0002\u0019AA\f\u00035I7OT3ti\u0016$7\t\\1tgR\u0019\u0011)a\u001c\t\u000f\u0005U!\u00041\u0001\u0002\u0018\u0005\u0011\u0012n\u001d+sC&$\u0018J\\5uS\u0006d\u0017N_3s)\r\t\u0015Q\u000f\u0005\u0006\u0019n\u0001\r!T\u0001\u0015g.L\u0007\u000f\u0016:bSRLe.\u001b;jC2L'0\u001a:\u0015\u0007\u0005\u000bY\bC\u0003M9\u0001\u0007Q*A\tjgB\u0013\u0018N^1uK\u0006\u001b7-Z:t_J$2!QAA\u0011\u0015aU\u00041\u0001N\u00031\u00196-\u00197b\t\u0016\u001cw\u000eZ3s!\tAtd\u0005\u0002 eQ\u0011\u0011QQ\u0001\u0006CB\u0004H.\u001f\u000b\n\r\u0006=\u0015\u0011TAS\u0003_Cq!!%\"\u0001\u0004\t\u0019*\u0001\u0005eK\n,xmZ3f!\ri\u0014QS\u0005\u0004\u0003/C#\u0001\u0003#fEV<w-Z3\t\u000f\u0005m\u0015\u00051\u0001\u0002\u001e\u0006)Ao\\8mgB!\u0011qTAQ\u001b\u00051\u0013bAARM\tQA)\u001a2vOR{w\u000e\\:\t\u000f\u0005\u001d\u0016\u00051\u0001\u0002*\u00061An\\4hKJ\u00042!PAV\u0013\r\ti\u000b\u000b\u0002\u0007\u0019><w-\u001a:\t\u000b\u0001\u000b\u0003\u0019A!\u0002\u0011\u0019\fG\u000e\u001c2bG.$RARA[\u0003oCQa\u000f\u0012A\u0002qBQ\u0001\u0011\u0012A\u0002\u0005\u0003")
public abstract class ScalaDecoder
implements StepFilter {
    private final ScalaVersion scalaVersion;
    private final boolean testMode;
    private final Set<String> lazyTypes;

    public static ScalaDecoder apply(Debuggee debuggee, DebugTools tools, Logger logger, boolean testMode) {
        return ScalaDecoder$.MODULE$.apply(debuggee, tools, logger, testMode);
    }

    @Override
    public boolean shouldSkipOut(Location upperLocation, Method method) {
        return StepFilter.shouldSkipOut$(this, upperLocation, method);
    }

    public abstract boolean skipScala(Method var1);

    public Option<String> formatScala(Method method) {
        return new Some((Object)this.formatJava(method));
    }

    private void throwOrWarn(Throwable exception) {
        if (this.testMode) {
            throw exception;
        }
        exception.getMessage();
    }

    public void reload() {
    }

    @Override
    public boolean shouldSkipOver(Method method) {
        boolean bl;
        if (method.isBridge()) {
            return true;
        }
        if (this.isDynamicClass(method.declaringType())) {
            return true;
        }
        if (this.isJava(method)) {
            return false;
        }
        if (this.isConstructor(method)) {
            return false;
        }
        if (this.isStaticConstructor(method)) {
            return false;
        }
        if (this.isAdaptedMethod(method)) {
            return true;
        }
        if (this.isAnonFunction(method)) {
            return false;
        }
        if (this.scalaVersion.isScala2() && this.isPrivateAccessor(method)) {
            return true;
        }
        if (this.isLiftedMethod(method)) {
            return !this.isLazyInitializer(method) && this.isLazyGetter(method);
        }
        if (this.isAnonClass(method.declaringType())) {
            return false;
        }
        if (this.isLocalClass(method.declaringType())) {
            return false;
        }
        if (this.scalaVersion.isScala2() && this.isNestedClass(method.declaringType())) {
            return false;
        }
        if (this.isDefaultValue(method)) {
            return false;
        }
        if (this.isTraitInitializer(method)) {
            return this.skipTraitInitializer(method);
        }
        try {
            bl = this.skipScala(method);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.throwOrWarn(e);
                bl = false;
            }
            throw throwable;
        }
        return bl;
    }

    public Option<String> format(Method method) {
        Some some;
        if (method.isBridge()) {
            return None$.MODULE$;
        }
        if (this.isDynamicClass(method.declaringType())) {
            return None$.MODULE$;
        }
        if (this.isJava(method)) {
            return new Some((Object)this.formatJava(method));
        }
        if (this.isStaticMain(method)) {
            return None$.MODULE$;
        }
        if (this.isStaticConstructor(method)) {
            return new Some((Object)this.formatJava(method));
        }
        if (this.isAdaptedMethod(method)) {
            return None$.MODULE$;
        }
        if (this.scalaVersion.isScala2() && this.isNestedClass(method.declaringType())) {
            return new Some((Object)this.formatJava(method));
        }
        try {
            some = this.formatScala(method);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.throwOrWarn(e);
                some = new Some((Object)this.formatJava(method));
            }
            throw throwable;
        }
        return some;
    }

    private String formatJava(Method method) {
        String declaringType = (String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])method.declaringType().name().split("\\.")));
        String argumentTypes = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(method.argumentTypeNames()).asScala().map((Function1 & Serializable)arg -> (String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])arg.split("\\."))))).mkString(",");
        String returnType = (String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])method.returnTypeName().split("\\.")));
        return new StringBuilder(5).append(declaringType).append(".").append(method.name()).append("(").append(argumentTypes).append("): ").append(returnType).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isStaticMain(Method m) {
        if (!m.isStatic()) return false;
        String string = m.name();
        String string2 = "main";
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    private boolean isDynamicClass(ReferenceType tpe) {
        boolean bl;
        block3: {
            try {
                if (!StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(tpe.sourceName()), '.')) {
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            catch (AbsentInformationException absentInformationException) {
                bl = true;
            }
        }
        return bl;
    }

    private boolean isJava(Method method) {
        return method.declaringType().sourceName().endsWith(".java");
    }

    private boolean isConstructor(Method method) {
        String string = method.name();
        String string2 = "<init>";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private boolean isStaticConstructor(Method method) {
        String string = method.name();
        String string2 = "<clinit>";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private boolean isAnonFunction(Method method) {
        return method.name().matches(".+\\$anonfun\\$\\d+");
    }

    private boolean isLiftedMethod(Method method) {
        return method.name().matches(".+\\$\\d+");
    }

    private boolean isAdaptedMethod(Method method) {
        return method.name().matches(".+\\$adapted(\\$\\d+)?");
    }

    private boolean isLazyInitializer(Method method) {
        return method.name().contains("$lzyINIT") || method.name().contains("$lzycompute$");
    }

    private Set<String> lazyTypes() {
        return this.lazyTypes;
    }

    private boolean isLazyGetter(Method method) {
        SeqOps seqOps;
        Seq seq = CollectionConverters$.MODULE$.ListHasAsScala(method.argumentTypes()).asScala().toSeq();
        if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) {
            Type argType = (Type)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            return this.lazyTypes().contains((Object)argType.name());
        }
        return false;
    }

    private boolean isDefaultValue(Method method) {
        return method.name().contains("$default$");
    }

    private boolean isAnonClass(ReferenceType tpe) {
        return tpe.name().contains("$anon$");
    }

    private boolean isLocalClass(ReferenceType tpe) {
        return tpe.name().matches(".+\\$\\d+\\$?");
    }

    private boolean isNestedClass(ReferenceType tpe) {
        return tpe.name().matches(".+\\$\\.+");
    }

    private boolean isTraitInitializer(Method method) {
        String string = method.name();
        String string2 = "$init$";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private boolean skipTraitInitializer(Method method) {
        Seq seq = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.byteArrayOps(method.bytecodes()));
        SeqOps seqOps = package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapByteArray(new byte[]{ByteCode$.MODULE$.RETURN()}));
        return !(seq != null ? !seq.equals(seqOps) : seqOps != null);
    }

    private boolean isPrivateAccessor(Method method) {
        return method.name().matches(".+\\$access\\$\\d+");
    }

    public ScalaDecoder(ScalaVersion scalaVersion, boolean testMode) {
        this.scalaVersion = scalaVersion;
        this.testMode = testMode;
        StepFilter.$init$(this);
        this.lazyTypes = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"scala.runtime.LazyRef", "scala.runtime.LazyBoolean", "scala.runtime.LazyByte", "scala.runtime.LazyChar", "scala.runtime.LazyShort", "scala.runtime.LazyInt", "scala.runtime.LazyLong", "scala.runtime.LazyFloat", "scala.runtime.LazyDouble", "scala.runtime.LazyUnit"}));
    }
}

